/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.ProjectViewNestingRulesProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.util.containers.SortedList;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@State(name="ProjectViewFileNesting", storages={@Storage(value="ui.lnf.xml")}, category=SettingsCategory.UI)
public class ProjectViewFileNestingService
implements PersistentStateComponent<MyState>,
ModificationTracker {
    private static final Logger LOG = Logger.getInstance(ProjectViewFileNestingService.class);
    private static final ExtensionPointName<ProjectViewNestingRulesProvider> EP_NAME = ExtensionPointName.create("com.intellij.projectViewNestingRulesProvider");
    private MyState myState = new MyState();
    private long myModCount;

    @NotNull
    public static ProjectViewFileNestingService getInstance() {
        ProjectViewFileNestingService projectViewFileNestingService = ApplicationManager.getApplication().getService(ProjectViewFileNestingService.class);
        if (projectViewFileNestingService == null) {
            ProjectViewFileNestingService.$$$reportNull$$$0(0);
        }
        return projectViewFileNestingService;
    }

    @NotNull
    static List<NestingRule> loadDefaultNestingRules() {
        ArrayList<NestingRule> result2 = new ArrayList<NestingRule>();
        ProjectViewNestingRulesProvider.Consumer consumer = (parentFileSuffix, childFileSuffix) -> {
            LOG.assertTrue(!parentFileSuffix.isEmpty() && !childFileSuffix.isEmpty(), "file suffix must not be empty");
            LOG.assertTrue(!parentFileSuffix.equals(childFileSuffix), "parent and child suffixes must be different: " + parentFileSuffix);
            result2.add(new NestingRule(parentFileSuffix, childFileSuffix));
        };
        for (ProjectViewNestingRulesProvider provider2 : EP_NAME.getExtensions()) {
            provider2.addFileNestingRules(consumer);
        }
        ArrayList<NestingRule> arrayList = result2;
        if (arrayList == null) {
            ProjectViewFileNestingService.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    public MyState getState() {
        return this.myState;
    }

    @Override
    public void loadState(@NotNull MyState state) {
        if (state == null) {
            ProjectViewFileNestingService.$$$reportNull$$$0(2);
        }
        this.myState = state;
        ++this.myModCount;
    }

    @NotNull
    public List<NestingRule> getRules() {
        List<NestingRule> list2 = this.myState.myRules;
        if (list2 == null) {
            ProjectViewFileNestingService.$$$reportNull$$$0(3);
        }
        return list2;
    }

    public void setRules(@NotNull List<? extends NestingRule> rules) {
        if (rules == null) {
            ProjectViewFileNestingService.$$$reportNull$$$0(4);
        }
        this.myState.myRules.clear();
        this.myState.myRules.addAll(rules);
        ++this.myModCount;
    }

    @Override
    public long getModificationCount() {
        return this.myModCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/ProjectViewFileNestingService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDefaultNestingRules";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewFileNestingService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRules";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setRules";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NestingRule {
        @NotNull
        private String myParentFileSuffix;
        @NotNull
        private String myChildFileSuffix;

        public NestingRule() {
            this("", "");
        }

        public NestingRule(@NotNull String parentFileSuffix, @NotNull String childFileSuffix) {
            if (parentFileSuffix == null) {
                NestingRule.$$$reportNull$$$0(0);
            }
            if (childFileSuffix == null) {
                NestingRule.$$$reportNull$$$0(1);
            }
            this.myParentFileSuffix = parentFileSuffix;
            this.myChildFileSuffix = childFileSuffix;
        }

        @Attribute(value="parent-file-suffix")
        @NotNull
        public String getParentFileSuffix() {
            String string2 = this.myParentFileSuffix;
            if (string2 == null) {
                NestingRule.$$$reportNull$$$0(2);
            }
            return string2;
        }

        public void setParentFileSuffix(@NotNull String parentFileSuffix) {
            if (parentFileSuffix == null) {
                NestingRule.$$$reportNull$$$0(3);
            }
            this.myParentFileSuffix = parentFileSuffix;
        }

        @Attribute(value="child-file-suffix")
        @NotNull
        public String getChildFileSuffix() {
            String string2 = this.myChildFileSuffix;
            if (string2 == null) {
                NestingRule.$$$reportNull$$$0(4);
            }
            return string2;
        }

        public void setChildFileSuffix(@NotNull String childFileSuffix) {
            if (childFileSuffix == null) {
                NestingRule.$$$reportNull$$$0(5);
            }
            this.myChildFileSuffix = childFileSuffix;
        }

        public String toString() {
            return this.myParentFileSuffix + "->" + this.myChildFileSuffix;
        }

        public boolean equals(Object o) {
            return o instanceof NestingRule && this.myParentFileSuffix.equals(((NestingRule)o).myParentFileSuffix) && this.myChildFileSuffix.equals(((NestingRule)o).myChildFileSuffix);
        }

        public int hashCode() {
            return this.myParentFileSuffix.hashCode() + 239 * this.myChildFileSuffix.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentFileSuffix";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childFileSuffix";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/projectView/impl/ProjectViewFileNestingService$NestingRule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewFileNestingService$NestingRule";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParentFileSuffix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildFileSuffix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setParentFileSuffix";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setChildFileSuffix";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class MyState {
        @XCollection(propertyElementName="nesting-rules")
        public List<NestingRule> myRules = new SortedList<NestingRule>(Comparator.comparing(o -> o.getParentFileSuffix()));

        public MyState() {
            this.myRules.addAll(ProjectViewFileNestingService.loadDefaultNestingRules());
        }
    }
}

