/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.impl.ModuleGroupsTree;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class ModuleGroup {
    public static final DataKey<ModuleGroup[]> ARRAY_DATA_KEY = DataKey.create((String)"moduleGroup.array");
    private final List<String> myGroupPath;

    public ModuleGroup(@NotNull List<String> groupPath) {
        if (groupPath == null) {
            ModuleGroup.$$$reportNull$$$0(0);
        }
        this.myGroupPath = groupPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleGroup)) {
            return false;
        }
        return this.myGroupPath.equals(((ModuleGroup)o).myGroupPath);
    }

    public int hashCode() {
        return this.myGroupPath.hashCode();
    }

    public String @NotNull [] getGroupPath() {
        String[] stringArray = ArrayUtilRt.toStringArray(this.myGroupPath);
        if (stringArray == null) {
            ModuleGroup.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    @NotNull
    public List<String> getGroupPathList() {
        List<String> list2 = this.myGroupPath;
        if (list2 == null) {
            ModuleGroup.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    public Collection<Module> modulesInGroup(@NotNull Project project2, boolean recursively) {
        if (project2 == null) {
            ModuleGroup.$$$reportNull$$$0(3);
        }
        Collection<Module> collection = this.modulesInGroup(ModuleGrouper.instanceFor(project2), recursively);
        if (collection == null) {
            ModuleGroup.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public Collection<Module> modulesInGroup(@NotNull Project project2) {
        if (project2 == null) {
            ModuleGroup.$$$reportNull$$$0(5);
        }
        Collection<Module> collection = ModuleGroupsTree.getModuleGroupTree(project2).getModulesInGroup(this);
        if (collection == null) {
            ModuleGroup.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    public Collection<Module> modulesInGroup(@NotNull ModuleGrouper grouper, boolean recursively) {
        if (grouper == null) {
            ModuleGroup.$$$reportNull$$$0(7);
        }
        ArrayList<Module> result2 = new ArrayList<Module>();
        Set<List<String>> moduleAsGroupsPaths = ContainerUtil.map2Set(grouper.getAllModules(), module -> grouper.getModuleAsGroupPath((Module)module));
        for (Module module2 : grouper.getAllModules()) {
            List<String> group = grouper.getGroupPath(module2);
            if (!this.myGroupPath.equals(group) && (!ModuleGroup.isChild(this.myGroupPath, group) || !recursively && !ModuleGroup.isUnderGroupWithSameNameAsSomeModule(this.myGroupPath, group, moduleAsGroupsPaths))) continue;
            result2.add(module2);
        }
        ArrayList<Module> arrayList = result2;
        if (arrayList == null) {
            ModuleGroup.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static boolean isUnderGroupWithSameNameAsSomeModule(@NotNull List<String> parent, @NotNull List<String> descendant, @NotNull Set<List<String>> moduleNamesAsGroups) {
        if (parent == null) {
            ModuleGroup.$$$reportNull$$$0(9);
        }
        if (descendant == null) {
            ModuleGroup.$$$reportNull$$$0(10);
        }
        if (moduleNamesAsGroups == null) {
            ModuleGroup.$$$reportNull$$$0(11);
        }
        return descendant.size() > parent.size() && moduleNamesAsGroups.contains(descendant.subList(0, parent.size() + 1));
    }

    @NotNull
    public Collection<ModuleGroup> childGroups(@NotNull Project project2) {
        if (project2 == null) {
            ModuleGroup.$$$reportNull$$$0(12);
        }
        Collection<ModuleGroup> collection = ModuleGroupsTree.getModuleGroupTree(project2).getChildGroups(this);
        if (collection == null) {
            ModuleGroup.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @NotNull
    public Collection<ModuleGroup> childGroups(@NotNull ModuleGrouper grouper) {
        if (grouper == null) {
            ModuleGroup.$$$reportNull$$$0(14);
        }
        HashSet<ModuleGroup> result2 = new HashSet<ModuleGroup>();
        Set<List> moduleAsGroupsPaths = ContainerUtil.map2Set(grouper.getAllModules(), module -> grouper.getModuleAsGroupPath((Module)module));
        for (Module module2 : grouper.getAllModules()) {
            List<String> directChild;
            List<String> group = grouper.getGroupPath(module2);
            if (!ModuleGroup.isChild(this.myGroupPath, group) || moduleAsGroupsPaths.contains(directChild = ContainerUtil.append(this.myGroupPath, group.get(this.myGroupPath.size())))) continue;
            result2.add(new ModuleGroup(directChild));
        }
        HashSet<ModuleGroup> hashSet = result2;
        if (hashSet == null) {
            ModuleGroup.$$$reportNull$$$0(15);
        }
        return hashSet;
    }

    private static boolean isChild(@NotNull List<String> parent, @NotNull List<String> descendant) {
        if (parent == null) {
            ModuleGroup.$$$reportNull$$$0(16);
        }
        if (descendant == null) {
            ModuleGroup.$$$reportNull$$$0(17);
        }
        return descendant.size() > parent.size() && descendant.subList(0, parent.size()).equals(parent);
    }

    @NotNull
    @NlsSafe
    public String presentableText() {
        String string2 = "'" + this.myGroupPath.get(this.myGroupPath.size() - 1) + "'";
        if (string2 == null) {
            ModuleGroup.$$$reportNull$$$0(18);
        }
        return string2;
    }

    @NotNull
    @NlsSafe
    public String getQualifiedName() {
        String string2 = StringUtil.join(this.myGroupPath, ".");
        if (string2 == null) {
            ModuleGroup.$$$reportNull$$$0(19);
        }
        return string2;
    }

    @NlsSafe
    public String toString() {
        return this.myGroupPath.get(this.myGroupPath.size() - 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 15: 
            case 18: 
            case 19: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 15: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupPath";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 15: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/ModuleGroup";
                break;
            }
            case 3: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouper";
                break;
            }
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descendant";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNamesAsGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/ModuleGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPathList";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "modulesInGroup";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "childGroups";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "presentableText";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 15: 
            case 18: 
            case 19: {
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "modulesInGroup";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isUnderGroupWithSameNameAsSomeModule";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "childGroups";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isChild";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 15: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

