/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.NodeSortSettings;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Comparator;
import org.jetbrains.annotations.Nullable;

public class GroupByTypeComparator
implements Comparator<NodeDescriptor<?>> {
    private final Project project;
    private String myPaneId;
    private boolean myForceSortByType;

    public GroupByTypeComparator(@Nullable Project project2, String paneId) {
        this.project = project2;
        this.myPaneId = paneId;
    }

    public GroupByTypeComparator(boolean forceSortByType) {
        this.myForceSortByType = forceSortByType;
        this.project = null;
    }

    @Override
    public int compare(NodeDescriptor descriptor1, NodeDescriptor descriptor2) {
        Collection children2;
        if (!this.isSortByType() && descriptor1 instanceof ProjectViewNode && ((ProjectViewNode)descriptor1).isSortByFirstChild() && !(children2 = ((ProjectViewNode)descriptor1).getChildren()).isEmpty()) {
            descriptor1 = (NodeDescriptor)children2.iterator().next();
            descriptor1.update();
        }
        if (!this.isSortByType() && descriptor2 instanceof ProjectViewNode && ((ProjectViewNode)descriptor2).isSortByFirstChild() && !(children2 = ((ProjectViewNode)descriptor2).getChildren()).isEmpty()) {
            descriptor2 = (NodeDescriptor)children2.iterator().next();
            descriptor2.update();
        }
        if (descriptor1 instanceof ProjectViewNode && descriptor2 instanceof ProjectViewNode) {
            Comparable typeSortKey2;
            Comparable typeSortKey1;
            Object key2;
            Object key1;
            int result2;
            ProjectViewNode node1 = (ProjectViewNode)descriptor1;
            ProjectViewNode node2 = (ProjectViewNode)descriptor2;
            NodeSortSettings settings = new NodeSortSettings(this.isManualOrder(), this.isFoldersAlwaysOnTop(), this.isSortByType());
            int sortResult = node1.getSortOrder(settings).compareTo(node2.getSortOrder(settings));
            if (sortResult != 0) {
                return sortResult;
            }
            if (settings.isManualOrder() && (result2 = GroupByTypeComparator.compare(key1 = node1.getManualOrderKey(), key2 = node2.getManualOrderKey())) != 0) {
                return result2;
            }
            if (settings.isFoldersAlwaysOnTop()) {
                int typeWeight1 = node1.getTypeSortWeight(settings.isSortByType());
                int typeWeight2 = node2.getTypeSortWeight(settings.isSortByType());
                if (typeWeight1 != 0 && typeWeight2 == 0) {
                    return -1;
                }
                if (typeWeight1 == 0 && typeWeight2 != 0) {
                    return 1;
                }
                if (typeWeight1 != 0 && typeWeight2 != typeWeight1) {
                    return typeWeight1 - typeWeight2;
                }
            }
            if (settings.isSortByType()) {
                typeSortKey1 = node1.getTypeSortKey();
                result2 = GroupByTypeComparator.compare(typeSortKey1, typeSortKey2 = node2.getTypeSortKey());
                if (result2 != 0) {
                    return result2;
                }
            } else {
                typeSortKey1 = node1.getSortKey();
                typeSortKey2 = node2.getSortKey();
                if (typeSortKey1 != null && typeSortKey2 != null && (result2 = GroupByTypeComparator.compare(typeSortKey1, typeSortKey2)) != 0) {
                    return result2;
                }
            }
            if (this.isAbbreviateQualifiedNames()) {
                key1 = node1.getQualifiedNameSortKey();
                key2 = node2.getQualifiedNameSortKey();
                if (key1 != null && key2 != null) {
                    return StringUtil.naturalCompare((String)key1, (String)key2);
                }
            }
        }
        if (descriptor1 == null) {
            return -1;
        }
        if (descriptor2 == null) {
            return 1;
        }
        return AlphaComparator.INSTANCE.compare(descriptor1, descriptor2);
    }

    protected boolean isManualOrder() {
        if (this.project == null) {
            return true;
        }
        return ProjectView.getInstance(this.project).isManualOrder(this.myPaneId);
    }

    protected boolean isSortByType() {
        if (this.project == null) {
            return this.myForceSortByType;
        }
        return ProjectView.getInstance(this.project).isSortByType(this.myPaneId);
    }

    protected boolean isAbbreviateQualifiedNames() {
        return this.project != null && ProjectView.getInstance(this.project).isAbbreviatePackageNames(this.myPaneId);
    }

    protected boolean isFoldersAlwaysOnTop() {
        return this.project == null || ProjectView.getInstance(this.project).isFoldersAlwaysOnTop(this.myPaneId);
    }

    private static int compare(Comparable<?> key1, Comparable<?> key2) {
        if (key1 == null && key2 == null) {
            return 0;
        }
        if (key1 == null) {
            return 1;
        }
        if (key2 == null) {
            return -1;
        }
        if (key1 instanceof String && key2 instanceof String) {
            return StringUtil.naturalCompare((String)((Object)key1), (String)((Object)key2));
        }
        try {
            return key1.compareTo(key2);
        }
        catch (ClassCastException ignored) {
            return key1.getClass().getName().compareTo(key2.getClass().getName());
        }
    }
}

