/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.highlighter.ModuleFileType;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ImportModuleFromImlFileAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(ImportModuleFromImlFileAction.class);

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ImportModuleFromImlFileAction.$$$reportNull$$$0(0);
        }
        VirtualFile[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Project project2 = ImportModuleFromImlFileAction.getEventProject((AnActionEvent)e);
        if (files2 == null || project2 == null) {
            return;
        }
        try {
            ModifiableModuleModel model2 = ModuleManager.getInstance(project2).getModifiableModel();
            for (VirtualFile file2 : files2) {
                model2.loadModule(file2.getPath());
            }
            WriteAction.run(() -> model2.commit());
        }
        catch (Exception ex) {
            LOG.info(ex);
            Messages.showErrorDialog((Project)project2, (String)LangBundle.message("dialog.message.cannot.import.module", ex.getMessage()), (String)CommonBundle.getErrorTitle());
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ImportModuleFromImlFileAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ImportModuleFromImlFileAction.$$$reportNull$$$0(2);
        }
        List<VirtualFile> modules2 = ImportModuleFromImlFileAction.getModuleNames(e);
        Presentation presentation2 = e.getPresentation();
        boolean visible = !modules2.isEmpty();
        presentation2.setEnabledAndVisible(visible);
        String text2 = modules2.size() > 1 ? LangBundle.message("action.import.modules.text", modules2.size()) : (modules2.size() == 1 ? LangBundle.message("action.import.module.text", modules2.get(0).getNameWithoutExtension()) : this.getTemplatePresentation().getText());
        presentation2.setText(text2);
    }

    private static List<VirtualFile> getModuleNames(@NotNull AnActionEvent e) {
        if (e == null) {
            ImportModuleFromImlFileAction.$$$reportNull$$$0(3);
        }
        VirtualFile[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Project project2 = ImportModuleFromImlFileAction.getEventProject((AnActionEvent)e);
        if (project2 == null || files2 == null || files2.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> modulesFiles = new ArrayList<VirtualFile>();
        for (VirtualFile file2 : files2) {
            if (!FileTypeRegistry.getInstance().isFileOfType(file2, ModuleFileType.INSTANCE)) {
                return Collections.emptyList();
            }
            modulesFiles.add(file2);
        }
        ModuleManager moduleManager = ModuleManager.getInstance(project2);
        for (Module module : moduleManager.getModules()) {
            modulesFiles.remove(module.getModuleFile());
        }
        return modulesFiles;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/actions/ImportModuleFromImlFileAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/actions/ImportModuleFromImlFileAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getModuleNames";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

