/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.icons.AllIcons;
import com.intellij.ide.navigationToolbar.NavBarModel;
import com.intellij.ide.navigationToolbar.NavBarModelExtension;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.structureView.StructureViewBundle;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IconUtil;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NavBarPresentation {
    private final Project project;

    public NavBarPresentation(Project project2) {
        this.project = project2;
    }

    private static SimpleTextAttributes getErrorAttributes() {
        SimpleTextAttributes schemeAttributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)EditorColorsManager.getInstance().getSchemeForCurrentUITheme().getAttributes(CodeInsightColors.ERRORS_ATTRIBUTES));
        return SimpleTextAttributes.merge((SimpleTextAttributes)new SimpleTextAttributes(8192, schemeAttributes.getFgColor()), (SimpleTextAttributes)schemeAttributes);
    }

    @Nullable
    public Icon getIcon(Object object) {
        if (!NavBarModel.isValid(object)) {
            return null;
        }
        for (NavBarModelExtension modelExtension : NavBarModelExtension.EP_NAME.getExtensionList()) {
            Icon icon2 = modelExtension.getIcon(object);
            if (icon2 == null) continue;
            return icon2;
        }
        if (object instanceof Project) {
            return AllIcons.Nodes.Project;
        }
        if (object instanceof Module) {
            return ModuleType.get((Module)((Module)object)).getIcon();
        }
        try {
            if (object instanceof PsiElement) {
                Icon icon3 = ReadAction.compute(() -> ((PsiElement)object).isValid() ? ((PsiElement)object).getIcon(0) : null);
                if (icon3 != null && (icon3.getIconHeight() > 32 || icon3.getIconWidth() > 32)) {
                    icon3 = IconUtil.cropIcon((Icon)icon3, (int)32, (int)32);
                }
                return icon3;
            }
        }
        catch (IndexNotReadyException e) {
            return null;
        }
        if (object instanceof JdkOrderEntry) {
            Sdk jdk = ((JdkOrderEntry)object).getJdk();
            if (jdk == null) {
                return null;
            }
            SdkTypeId sdkType = jdk.getSdkType();
            return ((SdkType)sdkType).getIcon();
        }
        if (object instanceof LibraryOrderEntry) {
            return AllIcons.Nodes.PpLibFolder;
        }
        if (object instanceof ModuleOrderEntry) {
            return ModuleType.get((Module)((ModuleOrderEntry)object).getModule()).getIcon();
        }
        return null;
    }

    @NotNull
    @Nls
    String getPresentableText(Object object, boolean forPopup) {
        String text2 = NavBarPresentation.calcPresentableText(object, forPopup);
        Object object2 = text2.length() > 50 ? text2.substring(0, 47) + "..." : text2;
        if (object2 == null) {
            NavBarPresentation.$$$reportNull$$$0(0);
        }
        return object2;
    }

    @NotNull
    @Nls
    public static String calcPresentableText(Object object, boolean forPopup) {
        if (!NavBarModel.isValid(object)) {
            String string2 = StructureViewBundle.message((String)"node.structureview.invalid", (Object[])new Object[0]);
            if (string2 == null) {
                NavBarPresentation.$$$reportNull$$$0(1);
            }
            return string2;
        }
        for (NavBarModelExtension modelExtension : NavBarModelExtension.EP_NAME.getExtensionList()) {
            String text2 = modelExtension.getPresentableText(object, forPopup);
            if (text2 == null) continue;
            String string3 = text2;
            if (string3 == null) {
                NavBarPresentation.$$$reportNull$$$0(2);
            }
            return string3;
        }
        String string4 = object.toString();
        if (string4 == null) {
            NavBarPresentation.$$$reportNull$$$0(3);
        }
        return string4;
    }

    SimpleTextAttributes getTextAttributes(Object object, boolean selected) {
        if (!NavBarModel.isValid(object)) {
            return SimpleTextAttributes.REGULAR_ATTRIBUTES;
        }
        if (object instanceof PsiElement) {
            VirtualFile vDir;
            if (!ReadAction.compute(() -> ((PsiElement)object).isValid()).booleanValue()) {
                return SimpleTextAttributes.GRAYED_ATTRIBUTES;
            }
            PsiFile psiFile = ((PsiElement)object).getContainingFile();
            if (psiFile != null) {
                VirtualFile virtualFile2 = psiFile.getVirtualFile();
                int style = virtualFile2 != null && WolfTheProblemSolver.getInstance(this.project).isProblemFile(virtualFile2) ? NavBarPresentation.getErrorAttributes().getStyle() : 0;
                Color color = selected ? null : FileStatusManager.getInstance((Project)this.project).getStatus(virtualFile2).getColor();
                return new SimpleTextAttributes(null, color, NavBarPresentation.getErrorAttributes().getWaveColor(), style);
            }
            if (object instanceof PsiDirectory && ((vDir = ((PsiDirectory)object).getVirtualFile()).getParent() == null || ProjectRootsUtil.isModuleContentRoot(vDir, this.project))) {
                return SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            }
            if (NavBarPresentation.wolfHasProblemFilesBeneath((PsiElement)object)) {
                return NavBarPresentation.getErrorAttributes();
            }
        } else if (object instanceof Module) {
            if (WolfTheProblemSolver.getInstance(this.project).hasProblemFilesBeneath((Module)object)) {
                return NavBarPresentation.getErrorAttributes();
            }
        } else if (object instanceof Project) {
            Project project2 = (Project)object;
            Module[] modules2 = ReadAction.compute(() -> ModuleManager.getInstance(project2).getModules());
            WolfTheProblemSolver problemSolver = WolfTheProblemSolver.getInstance(project2);
            for (Module module : modules2) {
                if (!problemSolver.hasProblemFilesBeneath(module)) continue;
                return NavBarPresentation.getErrorAttributes();
            }
        }
        return SimpleTextAttributes.REGULAR_ATTRIBUTES;
    }

    boolean isModule(Object object) {
        if (NavBarModel.isValid(object) && object instanceof PsiDirectory && ReadAction.compute(() -> ((PsiElement)object).isValid()).booleanValue()) {
            VirtualFile vDir = ((PsiDirectory)object).getVirtualFile();
            return vDir.getParent() == null || ProjectRootsUtil.isModuleContentRoot(vDir, this.project);
        }
        return false;
    }

    public static boolean wolfHasProblemFilesBeneath(@NotNull PsiElement scope) {
        if (scope == null) {
            NavBarPresentation.$$$reportNull$$$0(4);
        }
        return WolfTheProblemSolver.getInstance(scope.getProject()).hasProblemFilesBeneath(virtualFile2 -> {
            if (scope instanceof PsiDirectory) {
                PsiDirectory directory = (PsiDirectory)scope;
                if (!VfsUtilCore.isAncestor(directory.getVirtualFile(), virtualFile2, false)) {
                    return false;
                }
                return ModuleUtilCore.findModuleForFile(virtualFile2, scope.getProject()) == ModuleUtilCore.findModuleForPsiElement(scope);
            }
            if (scope instanceof PsiDirectoryContainer) {
                PsiDirectory[] psiDirectories;
                for (PsiDirectory directory : psiDirectories = ((PsiDirectoryContainer)scope).getDirectories()) {
                    if (!VfsUtilCore.isAncestor(directory.getVirtualFile(), virtualFile2, false)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/navigationToolbar/NavBarPresentation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "calcPresentableText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/navigationToolbar/NavBarPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "wolfHasProblemFilesBeneath";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

