/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.navigationToolbar.NavBarModel;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.navigationToolbar.NavBarPresentation;
import com.intellij.ide.navigationToolbar.ui.NavBarUI;
import com.intellij.ide.util.treeView.TreeAnchorizer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.IconManager;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NavBarItem
extends SimpleColoredComponent
implements DataProvider,
Disposable {
    @Nls
    private final String myText;
    private final SimpleTextAttributes myAttributes;
    private final int myIndex;
    private final Icon myIcon;
    private final NavBarPanel myPanel;
    private final Object myObject;
    private final boolean isPopupElement;
    private final NavBarUI myUI;
    private boolean mouseHovered;
    private final boolean myIsModule;
    public static final Icon CHEVRON_ICON = AllIcons.General.ChevronRight;
    private static final Icon MODULE_ICON = IconManager.getInstance().getIcon("expui/nodes/module8x8.svg", AllIcons.class);

    public NavBarItem(NavBarPanel panel2, Object object, int idx, Disposable parent) {
        this(panel2, object, idx, parent, false);
    }

    public NavBarItem(NavBarPanel panel2, Object object, int idx, Disposable parent, boolean inPopup) {
        this.myPanel = panel2;
        this.myUI = panel2.getNavBarUI();
        this.myObject = object == null ? null : TreeAnchorizer.getService().createAnchor(object);
        this.myIndex = idx;
        boolean bl = this.isPopupElement = idx == -1;
        if (object != null) {
            NavBarPresentation presentation2 = this.myPanel.getPresentation();
            this.myText = presentation2.getPresentableText(object, inPopup);
            this.myAttributes = presentation2.getTextAttributes(object, false);
            this.myIsModule = presentation2.isModule(object);
            this.myIcon = ExperimentalUI.isNewUI() && this.myIsModule && !inPopup ? MODULE_ICON : presentation2.getIcon(object);
        } else {
            this.myText = IdeBundle.message((String)"navigation.bar.item.sample", (Object[])new Object[0]);
            this.myIcon = PlatformIcons.FOLDER_ICON;
            this.myAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            this.myIsModule = false;
        }
        Disposer.register(parent == null ? panel2 : parent, this);
        this.setOpaque(false);
        this.setIpad(this.myUI.getElementIpad(this.isPopupElement));
        if (ExperimentalUI.isNewUI()) {
            this.setIconTextGap(JBUIScale.scale(4));
        }
        if (!this.isPopupElement) {
            this.setMyBorder(null);
            this.setBorder(null);
            this.setPaintFocusBorder(false);
            this.setIconOpaque(false);
            if (this.myPanel.allowNavItemsFocus()) {
                this.setFocusTraversalKeysEnabled(false);
                this.setFocusable(true);
                this.addKeyListener(new KeyHandler());
                this.addFocusListener(new FocusHandler());
            }
        } else {
            this.setIconOpaque(true);
            this.setFocusBorderAroundIcon(true);
        }
        Font font = this.getFont();
        this.setFont(RelativeFont.NORMAL.fromResource("NavBar.fontSizeOffset", 0).derive(font));
        this.update();
    }

    public NavBarItem(NavBarPanel panel2, Object object, Disposable parent, boolean inPopup) {
        this(panel2, object, -1, parent, inPopup);
    }

    public Object getObject() {
        return this.myObject == null ? null : SlowOperations.allowSlowOperations(() -> TreeAnchorizer.getService().retrieveElement(this.myObject));
    }

    public SimpleTextAttributes getAttributes() {
        return this.myAttributes;
    }

    @NotNull
    public String getText() {
        String string2 = this.myText;
        if (string2 == null) {
            NavBarItem.$$$reportNull$$$0(0);
        }
        return string2;
    }

    public Font getFont() {
        return this.myUI == null ? super.getFont() : this.myUI.getElementFont(this);
    }

    void update() {
        Color fg;
        this.clear();
        this.setIcon(this.myIcon);
        boolean focused = this.isFocusedOrPopupElement();
        boolean selected = this.isSelected();
        this.setBackground(this.myUI.getBackground(selected, focused));
        Color bg = this.getBackground();
        if (ExperimentalUI.isNewUI()) {
            fg = this.isMouseHover() ? JBUI.CurrentTheme.StatusBar.Breadcrumbs.HOVER_FOREGROUND : (selected && focused ? JBUI.CurrentTheme.StatusBar.Breadcrumbs.SELECTION_FOREGROUND : (selected && this.myPanel.isNodePopupActive() && !this.isPopupElement() ? JBUI.CurrentTheme.StatusBar.Breadcrumbs.SELECTION_INACTIVE_FOREGROUND : (this.isInFloatingMode() ? JBUI.CurrentTheme.StatusBar.Breadcrumbs.FLOATING_FOREGROUND : (this.isPopupElement() ? JBUI.CurrentTheme.List.foreground(selected, focused) : JBUI.CurrentTheme.StatusBar.Breadcrumbs.FOREGROUND))));
        } else {
            fg = this.myUI.getForeground(selected, focused, this.isInactive());
            if (fg == null) {
                fg = this.myAttributes.getFgColor();
            }
        }
        int style = this.myAttributes.getStyle();
        if (ExperimentalUI.isNewUI()) {
            style = 0;
        }
        this.append(this.myText, new SimpleTextAttributes(bg, fg, ExperimentalUI.isNewUI() ? null : this.myAttributes.getWaveColor(), style));
    }

    public boolean isInactive() {
        NavBarModel model2 = this.myPanel.getModel();
        return model2.getSelectedIndex() < this.myIndex && model2.getSelectedIndex() != -1 && !this.myPanel.isUpdating();
    }

    public boolean isPopupElement() {
        return this.isPopupElement;
    }

    protected void doPaint(Graphics2D g) {
        if (this.isPopupElement) {
            super.doPaint(g);
        } else {
            this.myUI.doPaintNavBarItem(g, this, this.myPanel);
        }
    }

    public int doPaintText(Graphics2D g, int offset) {
        return super.doPaintText(g, offset, false);
    }

    public boolean isLastElement() {
        return this.myIndex == this.myPanel.getModel().size() - 1;
    }

    public boolean isFirstElement() {
        return this.myIndex == 0;
    }

    public void setOpaque(boolean isOpaque) {
        super.setOpaque(false);
    }

    @NotNull
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        Dimension offsets2 = this.myUI.getOffsets(this);
        int width = size.width + offsets2.width;
        if (ExperimentalUI.isNewUI() && !this.isFirstElement() && !this.isPopupElement) {
            width += CHEVRON_ICON.getIconWidth() + JBUI.CurrentTheme.StatusBar.Breadcrumbs.CHEVRON_INSET.get();
        }
        if (!this.needPaintIcon() && this.myIcon != null) {
            width -= this.myIcon.getIconWidth() + (ExperimentalUI.isNewUI() ? this.getIconTextGap() : 0);
        }
        return new Dimension(width, size.height + offsets2.height);
    }

    @DirtyUI
    public boolean needPaintIcon() {
        if (Registry.is("navBar.show.icons") || this.isPopupElement || this.isLastElement() || ExperimentalUI.isNewUI() && this.myIsModule) {
            return true;
        }
        Object object = this.getObject();
        return object instanceof PsiElement && ((PsiElement)object).isValid() && ((PsiElement)object).getContainingFile() != null;
    }

    public int getVerticalIconOffset() {
        return this.myIsModule && ExperimentalUI.isNewUI() ? JBUI.scale(1) : 0;
    }

    @NotNull
    public Dimension getMinimumSize() {
        Dimension dimension = this.getPreferredSize();
        if (dimension == null) {
            NavBarItem.$$$reportNull$$$0(1);
        }
        return dimension;
    }

    private boolean isFocusedOrPopupElement() {
        return this.isFocused() || this.isPopupElement;
    }

    public boolean isFocused() {
        if (this.myPanel.allowNavItemsFocus()) {
            return UIUtil.isFocusAncestor(this.myPanel) && !this.myPanel.isNodePopupActive();
        }
        return this.myPanel.hasFocus() && !this.myPanel.isNodePopupActive();
    }

    public boolean isSelected() {
        NavBarModel model2 = this.myPanel.getModel();
        return this.isPopupElement ? this.myPanel.isSelectedInPopup(this.getObject()) : model2.getSelectedIndex() == this.myIndex;
    }

    protected boolean shouldDrawBackground() {
        return this.isSelected() && this.isFocusedOrPopupElement();
    }

    @Override
    public void dispose() {
    }

    public boolean isNextSelected() {
        return this.myIndex == this.myPanel.getModel().getSelectedIndex() - 1;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            NavBarItem.$$$reportNull$$$0(2);
        }
        return this.myPanel.getDataImpl(dataId, (JComponent)((Object)this), () -> JBIterable.of(this.getObject()));
    }

    public int getIndex() {
        return this.myIndex;
    }

    public void setMouseHover(boolean hovered2) {
        this.mouseHovered = hovered2;
        this.update();
    }

    public boolean isMouseHover() {
        return this.mouseHovered;
    }

    public boolean isInFloatingMode() {
        return this.myPanel.isInFloatingMode();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleNavBarItem();
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/navigationToolbar/NavBarItem";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinimumSize";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/navigationToolbar/NavBarItem";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            NavBarItem.this.myPanel.fireNavBarItemFocusGained(e);
        }

        @Override
        public void focusLost(FocusEvent e) {
            NavBarItem.this.myPanel.fireNavBarItemFocusLost(e);
        }
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 9 && e.getSource() instanceof NavBarItem) {
                e.consume();
                this.jumpToNextComponent(!e.isShiftDown());
            }
        }

        void jumpToNextComponent(boolean next) {
            NavBarItem focusBase = null;
            List<NavBarItem> items = NavBarItem.this.myPanel.getItems();
            if (items.size() > 0) {
                focusBase = next ? items.get(items.size() - 1) : items.get(0);
            }
            if (focusBase != null) {
                if (next) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent((Component)((Object)focusBase));
                } else {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent((Component)((Object)focusBase));
                }
            }
        }
    }

    protected class AccessibleNavBarItem
    extends SimpleColoredComponent.AccessibleSimpleColoredComponent
    implements AccessibleAction {
        protected AccessibleNavBarItem() {
            super((SimpleColoredComponent)NavBarItem.this);
        }

        public AccessibleRole getAccessibleRole() {
            if (!NavBarItem.this.isPopupElement()) {
                return AccessibleRole.PUSH_BUTTON;
            }
            return super.getAccessibleRole();
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public int getAccessibleActionCount() {
            return !NavBarItem.this.isPopupElement() ? 1 : 0;
        }

        @Override
        public String getAccessibleActionDescription(int i) {
            if (i == 0 && !NavBarItem.this.isPopupElement()) {
                return UIManager.getString("AbstractButton.clickText");
            }
            return null;
        }

        @Override
        public boolean doAccessibleAction(int i) {
            if (i == 0 && !NavBarItem.this.isPopupElement()) {
                NavBarItem.this.myPanel.getModel().setSelectedIndex(NavBarItem.this.myIndex);
            }
            return false;
        }
    }
}

