/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.navigationToolbar.AbstractNavBarModelExtension;
import com.intellij.ide.scratch.RootType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiFileSystemItemProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultNavBarExtension
extends AbstractNavBarModelExtension {
    @Override
    @Nullable
    public String getPresentableText(Object object) {
        if (object instanceof Project) {
            return ((Project)object).getName();
        }
        if (object instanceof Module) {
            return ((Module)object).getName();
        }
        if (object instanceof PsiFile) {
            VirtualFile file2 = ((PsiFile)object).getVirtualFile();
            return file2 != null ? file2.getPresentableName() : ((PsiFile)object).getName();
        }
        if (object instanceof PsiDirectory) {
            return ((PsiDirectory)object).getVirtualFile().getName();
        }
        if (object instanceof JdkOrderEntry) {
            return ((JdkOrderEntry)object).getJdkName();
        }
        if (object instanceof LibraryOrderEntry) {
            String libraryName = ((LibraryOrderEntry)object).getLibraryName();
            return libraryName != null ? libraryName : CodeInsightBundle.message("package.dependencies.library.node.text", new Object[0]);
        }
        if (object instanceof ModuleOrderEntry) {
            ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)object;
            return moduleOrderEntry.getModuleName();
        }
        return null;
    }

    @Override
    public PsiElement adjustElement(@NotNull PsiElement psiElement) {
        PsiFile containingFile;
        if (psiElement == null) {
            DefaultNavBarExtension.$$$reportNull$$$0(0);
        }
        if ((containingFile = psiElement.getContainingFile()) != null) {
            return containingFile;
        }
        return psiElement;
    }

    @Override
    public boolean processChildren(Object object, Object rootElement, Processor<Object> processor) {
        if (object instanceof Project) {
            return DefaultNavBarExtension.processChildren((Project)object, processor);
        }
        if (object instanceof Module) {
            return DefaultNavBarExtension.processChildren((Module)object, processor);
        }
        if (object instanceof PsiDirectoryContainer) {
            PsiDirectory[] psiDirectories;
            PsiDirectoryContainer psiPackage = (PsiDirectoryContainer)object;
            for (PsiDirectory psiDirectory : psiDirectories = ReadAction.compute(() -> rootElement instanceof Module ? psiPackage.getDirectories(GlobalSearchScope.moduleScope((Module)rootElement)) : psiPackage.getDirectories())) {
                if (DefaultNavBarExtension.processChildren(psiDirectory, rootElement, processor)) continue;
                return false;
            }
            return true;
        }
        if (object instanceof PsiDirectory) {
            return DefaultNavBarExtension.processChildren((PsiDirectory)object, rootElement, processor);
        }
        if (object instanceof PsiFileSystemItem) {
            return DefaultNavBarExtension.processChildren((PsiFileSystemItem)object, processor);
        }
        return true;
    }

    private static boolean processChildren(Project object, Processor<Object> processor) {
        return ReadAction.compute(() -> {
            for (Module module : ModuleManager.getInstance(object).getModules()) {
                if (ModuleType.isInternal((Module)module) || processor.process(module)) continue;
                return false;
            }
            return true;
        });
    }

    private static boolean processChildren(Module module, Processor<Object> processor) {
        VirtualFile[] roots2;
        PsiManager psiManager = PsiManager.getInstance(module.getProject());
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
        for (VirtualFile root : roots2 = moduleRootManager.getContentRoots()) {
            PsiDirectory psiDirectory = ReadAction.compute(() -> psiManager.findDirectory(root));
            if (psiDirectory == null || processor.process(psiDirectory)) continue;
            return false;
        }
        return true;
    }

    private static boolean processChildren(PsiDirectory directory, @Nullable Object rootElement, Processor<Object> processor) {
        return ReadAction.compute(() -> {
            Project project2 = directory.getProject();
            RootType scratchRootType = RootType.forFile(PsiUtilCore.getVirtualFile(directory));
            ModuleFileIndex moduleFileIndex = rootElement instanceof Module ? ModuleRootManager.getInstance((Module)rootElement).getFileIndex() : null;
            return directory.processChildren(child -> {
                VirtualFile childFile = PsiUtilCore.getVirtualFile(child);
                if (childFile != null && scratchRootType != null && scratchRootType.isIgnored(project2, childFile)) {
                    return true;
                }
                if (childFile != null && moduleFileIndex != null && !moduleFileIndex.isInContent(childFile)) {
                    return true;
                }
                return processor.process(child);
            });
        });
    }

    private static boolean processChildren(PsiFileSystemItem object, final Processor<Object> processor) {
        return ReadAction.compute(() -> object.processChildren(new PsiFileSystemItemProcessor(){

            @Override
            public boolean acceptItem(@NotNull String name2, boolean isDirectory) {
                if (name2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return true;
            }

            @Override
            public boolean execute(@NotNull PsiFileSystemItem element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return processor.process(element2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/navigationToolbar/DefaultNavBarExtension$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptItem";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "execute";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }));
    }

    @Override
    @Nullable
    public PsiElement getParent(PsiElement psiElement) {
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile != null) {
            PsiDirectory containingDirectory = containingFile.getContainingDirectory();
            if (containingDirectory != null) {
                return containingDirectory;
            }
        } else {
            if (psiElement instanceof PsiDirectory) {
                PsiDirectory psiDirectory = (PsiDirectory)psiElement;
                Project project2 = psiElement.getProject();
                PsiDirectory parentDirectory = psiDirectory.getParentDirectory();
                if (parentDirectory == null) {
                    VirtualFile jar = VfsUtil.getLocalFile(psiDirectory.getVirtualFile());
                    if (ProjectRootManager.getInstance(project2).getFileIndex().isInContent(jar)) {
                        parentDirectory = PsiManager.getInstance(project2).findDirectory(jar.getParent());
                    }
                }
                return parentDirectory;
            }
            if (psiElement instanceof PsiFileSystemItem) {
                PsiDirectory parentDirectory;
                VirtualFile virtualFile2 = ((PsiFileSystemItem)psiElement).getVirtualFile();
                if (virtualFile2 == null) {
                    return null;
                }
                PsiManager psiManager = psiElement.getManager();
                PsiFileSystemItem resultElement = virtualFile2.isDirectory() ? psiManager.findDirectory(virtualFile2) : psiManager.findFile(virtualFile2);
                if (resultElement == null) {
                    return null;
                }
                VirtualFile parentVFile = virtualFile2.getParent();
                if (parentVFile != null && (parentDirectory = psiManager.findDirectory(parentVFile)) != null) {
                    return parentDirectory;
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/ide/navigationToolbar/DefaultNavBarExtension", "adjustElement"));
    }
}

