/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.ActivityTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ModuleStructureComponent;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.StructureViewWrapper;
import com.intellij.ide.structureView.impl.StructureViewComposite;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.lang.LangBundle;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.util.BitUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StructureViewWrapperImpl
implements StructureViewWrapper,
Disposable {
    public static final Topic<Runnable> STRUCTURE_CHANGED = new Topic<Runnable>("structure view changed", Runnable.class, Topic.BroadcastDirection.NONE);
    @ApiStatus.Experimental
    public static final DataKey<Optional<VirtualFile>> STRUCTURE_VIEW_TARGET_FILE_KEY = DataKey.create((String)"STRUCTURE_VIEW_TARGET_FILE_KEY");
    private static final Logger LOG = Logger.getInstance(StructureViewWrapperImpl.class);
    private static final DataKey<StructureViewWrapper> WRAPPER_DATA_KEY = DataKey.create((String)"WRAPPER_DATA_KEY");
    private static final int REFRESH_TIME = 100;
    private static final int REBUILD_TIME = 100;
    private final Project myProject;
    private final ToolWindow myToolWindow;
    private VirtualFile myFile;
    private StructureView myStructureView;
    private FileEditor myFileEditor;
    private ModuleStructureComponent myModuleStructureComponent;
    private JPanel[] myPanels;
    private final MergingUpdateQueue myUpdateQueue;
    private Runnable myPendingSelection;
    private boolean myFirstRun;
    private int myActivityCount;

    public StructureViewWrapperImpl(@NotNull Project project2, @NotNull ToolWindow toolWindow) {
        if (project2 == null) {
            StructureViewWrapperImpl.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            StructureViewWrapperImpl.$$$reportNull$$$0(1);
        }
        this.myPanels = new JPanel[0];
        this.myFirstRun = true;
        this.myProject = project2;
        this.myToolWindow = toolWindow;
        JComponent component2 = toolWindow.getComponent();
        if (ProjectManagerImpl.isLight((Project)project2)) {
            LOG.error("StructureViewWrapperImpl must be not created for light project.");
        }
        this.myUpdateQueue = new MergingUpdateQueue("StructureView", 100, false, component2, (Disposable)this, component2).usePassThroughInUnitTestMode();
        this.myUpdateQueue.setRestartTimerOnAdd(true);
        final Timer timer = TimerUtil.createNamedTimer("StructureView", 100, event -> {
            if (!component2.isShowing()) {
                return;
            }
            int count2 = ActivityTracker.getInstance().getCount();
            if (count2 == this.myActivityCount) {
                return;
            }
            ModalityState state = ModalityState.stateForComponent(component2);
            if (ModalityState.current().dominates(state)) {
                return;
            }
            boolean successful = StructureViewWrapperImpl.loggedRun("check if update needed", this::checkUpdate);
            if (successful) {
                this.myActivityCount = count2;
            }
        });
        LOG.debug("timer to check if update needed: add");
        timer.start();
        Disposer.register(this, new Disposable(){

            @Override
            public void dispose() {
                LOG.debug("timer to check if update needed: remove");
                timer.stop();
            }
        });
        component2.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (BitUtil.isSet(e.getChangeFlags(), 2L)) {
                    boolean visible = StructureViewWrapperImpl.this.myToolWindow.isVisible();
                    LOG.debug("displayability changed: " + visible);
                    if (visible) {
                        StructureViewWrapperImpl.loggedRun("update file", () -> StructureViewWrapperImpl.this.checkUpdate());
                        StructureViewWrapperImpl.this.scheduleRebuild();
                    } else if (!StructureViewWrapperImpl.this.myProject.isDisposed()) {
                        StructureViewWrapperImpl.this.myFile = null;
                        StructureViewWrapperImpl.loggedRun("clear a structure on hide", StructureViewWrapperImpl.this::rebuild);
                    }
                }
            }
        });
        if (component2.isShowing()) {
            StructureViewWrapperImpl.loggedRun("initial structure rebuild", this::checkUpdate);
            this.scheduleRebuild();
        }
        this.myToolWindow.getContentManager().addContentManagerListener(new ContentManagerListener(){

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (StructureViewWrapperImpl.this.myStructureView instanceof StructureViewComposite) {
                    StructureViewComposite.StructureViewDescriptor[] views;
                    for (StructureViewComposite.StructureViewDescriptor view : views = ((StructureViewComposite)StructureViewWrapperImpl.this.myStructureView).getStructureViews()) {
                        if (!view.title.equals(event.getContent().getTabName())) continue;
                        StructureViewWrapperImpl.this.updateHeaderActions(view.structureView);
                        break;
                    }
                }
                if (ExperimentalUI.isNewUI() && StructureViewWrapperImpl.this.myStructureView instanceof StructureViewComponent) {
                    DefaultActionGroup additional = ((StructureViewComponent)StructureViewWrapperImpl.this.myStructureView).getDotsActions();
                    StructureViewWrapperImpl.this.myToolWindow.setAdditionalGearActions((ActionGroup)additional);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/impl/StructureViewWrapperImpl$3", "selectionChanged"));
            }
        });
        Disposer.register((Disposable)this.myToolWindow.getContentManager(), this);
        PsiStructureViewFactory.EP_NAME.addChangeListener(this::clearCaches, this);
        StructureViewBuilder.EP_NAME.addChangeListener(this::clearCaches, this);
        ApplicationManager.getApplication().getMessageBus().connect(this).subscribe(STRUCTURE_CHANGED, this::clearCaches);
    }

    private void clearCaches() {
        StructureViewComponent.clearStructureViewState(this.myProject);
        if (this.myStructureView != null) {
            this.myStructureView.disableStoreState();
        }
        this.rebuild();
    }

    private void checkUpdate() {
        if (this.myProject.isDisposed()) {
            return;
        }
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        boolean insideToolwindow = SwingUtilities.isDescendingFrom(this.myToolWindow.getComponent(), owner);
        if (insideToolwindow) {
            LOG.debug("inside structure view");
        }
        if (!this.myFirstRun && (insideToolwindow || JBPopupFactory.getInstance().isPopupActive())) {
            return;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext(owner);
        if (WRAPPER_DATA_KEY.getData(dataContext) == this) {
            return;
        }
        if (CommonDataKeys.PROJECT.getData(dataContext) != this.myProject) {
            return;
        }
        if (insideToolwindow) {
            if (this.myFirstRun) {
                this.setFileFromSelectionHistory();
                this.myFirstRun = false;
            }
        } else {
            DataContext asyncDataContext = Utils.wrapDataContext((DataContext)dataContext);
            ReadAction.nonBlocking(() -> StructureViewWrapperImpl.getTargetVirtualFile(asyncDataContext)).coalesceBy(this, owner).finishOnUiThread(ModalityState.defaultModalityState(), file2 -> {
                if (file2 != null) {
                    this.setFile((VirtualFile)file2);
                } else if (this.myFirstRun) {
                    this.setFileFromSelectionHistory();
                } else {
                    this.setFile(null);
                }
                this.myFirstRun = false;
            }).submit(AppExecutorUtil.getAppExecutorService());
        }
    }

    @Nullable
    private static VirtualFile getTargetVirtualFile(@NotNull DataContext asyncDataContext) {
        Optional explicitlySpecifiedFile;
        if (asyncDataContext == null) {
            StructureViewWrapperImpl.$$$reportNull$$$0(2);
        }
        if ((explicitlySpecifiedFile = (Optional)STRUCTURE_VIEW_TARGET_FILE_KEY.getData(asyncDataContext)) != null) {
            return explicitlySpecifiedFile.orElse(null);
        }
        VirtualFile[] commonFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(asyncDataContext);
        return commonFiles != null && commonFiles.length == 1 ? commonFiles[0] : null;
    }

    private void setFileFromSelectionHistory() {
        FileEditorManagerImpl editorManager = (FileEditorManagerImpl)FileEditorManager.getInstance(this.myProject);
        List history = editorManager.getSelectionHistory();
        if (!history.isEmpty()) {
            this.setFile((VirtualFile)((Pair)history.get(0)).getFirst());
        }
    }

    private void setFile(@Nullable VirtualFile file2) {
        boolean forceRebuild;
        boolean bl = forceRebuild = !Comparing.equal(file2, this.myFile);
        if (!forceRebuild && this.myStructureView != null) {
            StructureViewModel model2 = this.myStructureView.getTreeModel();
            StructureViewTreeElement treeElement = model2.getRoot();
            Object value = treeElement.getValue();
            if (value == null || value instanceof PsiElement && !((PsiElement)value).isValid() || this.myStructureView instanceof StructureViewComposite && ((StructureViewComposite)this.myStructureView).isOutdated()) {
                forceRebuild = true;
            } else if (file2 != null) {
                boolean bl2 = forceRebuild = FileEditorManager.getInstance(this.myProject).getSelectedEditor(file2) != this.myFileEditor;
            }
        }
        if (forceRebuild) {
            this.myFile = file2;
            LOG.debug("show structure for file: ", file2);
            this.scheduleRebuild();
        }
    }

    @Override
    public void dispose() {
    }

    public boolean selectCurrentElement(FileEditor fileEditor, VirtualFile file2, boolean requestFocus) {
        Runnable runnable = () -> {
            if (!Comparing.equal(this.myFileEditor, fileEditor)) {
                this.myFile = file2;
                LOG.debug("replace file on selection: ", file2);
                StructureViewWrapperImpl.loggedRun("rebuild a structure immediately: ", this::rebuild);
            }
            if (this.myStructureView != null) {
                this.myStructureView.navigateToSelectedElement(requestFocus);
            }
        };
        if (this.isStructureViewShowing()) {
            if (this.myUpdateQueue.isEmpty()) {
                runnable.run();
            } else {
                this.myPendingSelection = runnable;
            }
        } else {
            this.myPendingSelection = runnable;
        }
        return true;
    }

    private void scheduleRebuild() {
        if (!this.myToolWindow.isVisible()) {
            return;
        }
        LOG.debug("request to rebuild a structure");
        this.myUpdateQueue.queue(new Update("rebuild"){

            public void run() {
                if (StructureViewWrapperImpl.this.myProject.isDisposed()) {
                    return;
                }
                if (!ApplicationManager.getApplication().isDispatchThread()) {
                    LOG.error("EDT-based MergingUpdateQueue on background thread");
                }
                StructureViewWrapperImpl.loggedRun("rebuild a structure: ", StructureViewWrapperImpl.this::rebuild);
            }
        });
    }

    public void rebuild() {
        VirtualFile[] selectedFiles;
        if (this.myProject.isDisposed()) {
            return;
        }
        JComponent container = this.myToolWindow.getComponent();
        boolean wasFocused = UIUtil.isFocusAncestor(container);
        if (this.myStructureView != null) {
            this.myStructureView.storeState();
            Disposer.dispose((Disposable)this.myStructureView);
            this.myStructureView = null;
            this.myFileEditor = null;
        }
        if (this.myModuleStructureComponent != null) {
            Disposer.dispose(this.myModuleStructureComponent);
            this.myModuleStructureComponent = null;
        }
        ContentManager contentManager = this.myToolWindow.getContentManager();
        contentManager.removeAllContents(true);
        if (!this.isStructureViewShowing()) {
            return;
        }
        VirtualFile file2 = this.myFile;
        if (file2 == null && (selectedFiles = FileEditorManager.getInstance(this.myProject).getSelectedFiles()).length > 0) {
            file2 = selectedFiles[0];
        }
        String[] names = new String[]{""};
        if (file2 != null && file2.isValid()) {
            if (file2.isDirectory()) {
                Module module;
                if (ProjectRootsUtil.isModuleContentRoot(file2, this.myProject) && (module = ModuleUtilCore.findModuleForFile(file2, this.myProject)) != null && !ModuleType.isInternal((Module)module)) {
                    this.myModuleStructureComponent = new ModuleStructureComponent(module);
                    this.createSinglePanel(this.myModuleStructureComponent.getComponent());
                    Disposer.register(this, this.myModuleStructureComponent);
                }
            } else {
                StructureViewBuilder structureViewBuilder;
                FileEditor editor2 = FileEditorManager.getInstance(this.myProject).getSelectedEditor(file2);
                StructureViewBuilder structureViewBuilder2 = structureViewBuilder = editor2 != null && editor2.isValid() ? editor2.getStructureViewBuilder() : this.createStructureViewBuilder(file2);
                if (structureViewBuilder != null) {
                    this.myStructureView = structureViewBuilder.createStructureView(editor2, this.myProject);
                    this.myFileEditor = editor2;
                    Disposer.register(this, (Disposable)this.myStructureView);
                    if (this.myStructureView instanceof StructureViewComposite) {
                        StructureViewComposite composite2 = (StructureViewComposite)this.myStructureView;
                        StructureViewComposite.StructureViewDescriptor[] views = composite2.getStructureViews();
                        this.myPanels = new JPanel[views.length];
                        names = new String[views.length];
                        for (int i = 0; i < this.myPanels.length; ++i) {
                            this.myPanels[i] = this.createContentPanel(views[i].structureView.getComponent());
                            names[i] = views[i].title;
                        }
                    } else {
                        this.createSinglePanel(this.myStructureView.getComponent());
                    }
                    this.myStructureView.restoreState();
                    this.myStructureView.centerSelectedRow();
                }
            }
        }
        this.updateHeaderActions(this.myStructureView);
        if (this.myModuleStructureComponent == null && this.myStructureView == null) {
            JBPanelWithEmptyText panel2 = new JBPanelWithEmptyText(){

                public Color getBackground() {
                    return UIUtil.getTreeBackground();
                }
            };
            panel2.getEmptyText().setText(LangBundle.message("panel.empty.text.no.structure", new Object[0]));
            this.createSinglePanel((JComponent)panel2);
        }
        for (int i = 0; i < this.myPanels.length; ++i) {
            Content content2 = ContentFactory.getInstance().createContent((JComponent)this.myPanels[i], names[i], false);
            contentManager.addContent(content2);
            if (i != 0 || this.myStructureView == null) continue;
            Disposer.register((Disposable)content2, (Disposable)this.myStructureView);
        }
        if (this.myPendingSelection != null) {
            Runnable selection = this.myPendingSelection;
            this.myPendingSelection = null;
            selection.run();
        }
        if (wasFocused) {
            Component component2;
            FocusTraversalPolicy policy = container.getFocusTraversalPolicy();
            Component component3 = component2 = policy == null ? null : policy.getDefaultComponent(container);
            if (component2 != null) {
                IdeFocusManager.getInstance((Project)this.myProject).requestFocusInProject(component2, this.myProject);
            }
        }
    }

    private void updateHeaderActions(@Nullable StructureView structureView) {
        List<Object> titleActions = structureView instanceof StructureViewComponent ? (ExperimentalUI.isNewUI() ? List.of(((StructureViewComponent)structureView).getViewActions()) : ((StructureViewComponent)structureView).addExpandCollapseActions()) : Collections.emptyList();
        this.myToolWindow.setTitleActions(titleActions);
    }

    private void createSinglePanel(JComponent component2) {
        this.myPanels = new JPanel[1];
        this.myPanels[0] = this.createContentPanel(component2);
    }

    private ContentPanel createContentPanel(JComponent component2) {
        ContentPanel panel2 = new ContentPanel();
        panel2.setBackground(UIUtil.getTreeBackground());
        panel2.add((Component)component2, "Center");
        return panel2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private StructureViewBuilder createStructureViewBuilder(@NotNull VirtualFile file2) {
        FileEditorProvider provider2;
        if (file2 == null) {
            StructureViewWrapperImpl.$$$reportNull$$$0(3);
        }
        if (file2.getLength() > (long)PersistentFSConstants.getMaxIntellisenseFileSize()) {
            return null;
        }
        FileEditorProvider[] providers2 = FileEditorProviderManager.getInstance().getProviders(this.myProject, file2);
        FileEditorProvider fileEditorProvider = provider2 = providers2.length == 0 ? null : providers2[0];
        if (provider2 == null) {
            return null;
        }
        if (provider2 instanceof TextEditorProvider) {
            return StructureViewBuilder.PROVIDER.getStructureViewBuilder(file2.getFileType(), file2, this.myProject);
        }
        FileEditor editor2 = provider2.createEditor(this.myProject, file2);
        try {
            StructureViewBuilder structureViewBuilder = editor2.getStructureViewBuilder();
            return structureViewBuilder;
        }
        finally {
            Disposer.dispose((Disposable)editor2);
        }
    }

    private boolean isStructureViewShowing() {
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)this.myProject);
        ToolWindow toolWindow = windowManager.getToolWindow("Structure");
        return toolWindow != null && toolWindow.isVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loggedRun(@NotNull String message2, @NotNull Runnable task2) {
        if (message2 == null) {
            StructureViewWrapperImpl.$$$reportNull$$$0(4);
        }
        if (task2 == null) {
            StructureViewWrapperImpl.$$$reportNull$$$0(5);
        }
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace(message2 + ": started");
            }
            task2.run();
            boolean bl = true;
            return bl;
        }
        catch (ProcessCanceledException exception) {
            LOG.debug(message2, ": canceled");
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable) {
            LOG.warn(message2, throwable);
            boolean bl = false;
            return bl;
        }
        finally {
            if (LOG.isTraceEnabled()) {
                LOG.trace(message2 + ": finished");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asyncDataContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/impl/StructureViewWrapperImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTargetVirtualFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createStructureViewBuilder";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "loggedRun";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ContentPanel
    extends JPanel
    implements DataProvider {
        ContentPanel() {
            super(new BorderLayout());
        }

        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                ContentPanel.$$$reportNull$$$0(0);
            }
            if (WRAPPER_DATA_KEY.is(dataId)) {
                return StructureViewWrapperImpl.this;
            }
            if (QuickActionProvider.KEY.is(dataId)) {
                return StructureViewWrapperImpl.this.myStructureView instanceof QuickActionProvider ? StructureViewWrapperImpl.this.myStructureView : null;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/ide/impl/StructureViewWrapperImpl$ContentPanel", "getData"));
        }
    }
}

