/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.actions;

import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbUnawareHider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BrowseHierarchyActionBase
extends AnAction {
    private static final Logger LOG = Logger.getInstance(BrowseHierarchyActionBase.class);
    private final LanguageExtension<HierarchyProvider> myExtension;

    protected BrowseHierarchyActionBase(@NotNull LanguageExtension<HierarchyProvider> extension2) {
        if (extension2 == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(0);
        }
        this.myExtension = extension2;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(2);
        }
        DataContext dataContext = e.getDataContext();
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        PsiDocumentManager.getInstance(project2).commitAllDocuments();
        HierarchyProvider provider2 = this.getProvider(e);
        if (provider2 == null) {
            return;
        }
        PsiElement target2 = provider2.getTarget(dataContext);
        if (target2 == null) {
            return;
        }
        BrowseHierarchyActionBase.createAndAddToPanel(project2, provider2, target2);
    }

    @NotNull
    public static HierarchyBrowser createAndAddToPanel(@NotNull Project project2, @NotNull HierarchyProvider provider2, @NotNull PsiElement target2) {
        Content content2;
        if (project2 == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(3);
        }
        if (provider2 == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(4);
        }
        if (target2 == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(5);
        }
        HierarchyBrowser hierarchyBrowser = provider2.createHierarchyBrowser(target2);
        HierarchyBrowserManager hierarchyBrowserManager = HierarchyBrowserManager.getInstance(project2);
        ContentManager contentManager = hierarchyBrowserManager.getContentManager();
        Content selectedContent = contentManager.getSelectedContent();
        JComponent browserComponent = hierarchyBrowser.getComponent();
        if (!DumbService.isDumbAware(hierarchyBrowser)) {
            browserComponent = DumbService.getInstance(project2).wrapGently(browserComponent, project2);
        }
        if (selectedContent != null && !selectedContent.isPinned()) {
            content2 = selectedContent;
            JComponent component2 = content2.getComponent();
            if (component2 instanceof DumbUnawareHider) {
                component2 = ((DumbUnawareHider)component2).getContent();
            }
            if (component2 instanceof Disposable) {
                Disposer.dispose((Disposable)((Object)component2));
            }
            content2.setComponent(browserComponent);
        } else {
            content2 = ContentFactory.getInstance().createContent(browserComponent, null, true);
            contentManager.addContent(content2);
        }
        content2.setHelpId("reference.toolWindows.hierarchy");
        contentManager.setSelectedContent(content2);
        hierarchyBrowser.setContent(content2);
        Runnable runnable = () -> {
            if (hierarchyBrowser instanceof HierarchyBrowserBase && ((HierarchyBrowserBase)hierarchyBrowser).isDisposed()) {
                return;
            }
            provider2.browserActivated(hierarchyBrowser);
        };
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow("Hierarchy");
        toolWindow.activate(runnable);
        if (hierarchyBrowser instanceof Disposable) {
            Disposer.register((Disposable)toolWindow.getContentManager(), (Disposable)((Object)hierarchyBrowser));
        }
        HierarchyBrowser hierarchyBrowser2 = hierarchyBrowser;
        if (hierarchyBrowser2 == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(6);
        }
        return hierarchyBrowser2;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(7);
        }
        if (!this.myExtension.hasAnyExtensions()) {
            e.getPresentation().setVisible(false);
        } else {
            boolean enabled = this.isEnabled(e);
            if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
                e.getPresentation().setVisible(enabled);
            } else {
                e.getPresentation().setVisible(true);
            }
            e.getPresentation().setEnabled(enabled);
        }
    }

    private boolean isEnabled(AnActionEvent e) {
        HierarchyProvider provider2 = this.getProvider(e);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using provider " + provider2);
        }
        if (provider2 == null) {
            return false;
        }
        PsiElement target2 = provider2.getTarget(e.getDataContext());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Target: " + target2);
        }
        return target2 != null;
    }

    @Nullable
    private HierarchyProvider getProvider(@NotNull AnActionEvent e) {
        if (e == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(8);
        }
        return BrowseHierarchyActionBase.findProvider(this.myExtension, (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT), (PsiFile)e.getData(CommonDataKeys.PSI_FILE), e.getDataContext());
    }

    @Nullable
    public static HierarchyProvider findProvider(@NotNull LanguageExtension<HierarchyProvider> extension2, @Nullable PsiElement psiElement, @Nullable PsiFile psiFile, @NotNull DataContext dataContext) {
        HierarchyProvider provider2;
        if (extension2 == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(9);
        }
        if (dataContext == null) {
            BrowseHierarchyActionBase.$$$reportNull$$$0(10);
        }
        if ((provider2 = BrowseHierarchyActionBase.findBestHierarchyProvider(extension2, psiElement, dataContext)) == null) {
            return BrowseHierarchyActionBase.findBestHierarchyProvider(extension2, psiFile, dataContext);
        }
        return provider2;
    }

    @Nullable
    public static HierarchyProvider findBestHierarchyProvider(LanguageExtension<HierarchyProvider> extension2, @Nullable PsiElement element2, DataContext dataContext) {
        if (element2 == null) {
            return null;
        }
        List<HierarchyProvider> providers2 = extension2.allForLanguage(element2.getLanguage());
        for (HierarchyProvider provider2 : providers2) {
            PsiElement target2 = provider2.getTarget(dataContext);
            if (target2 == null) continue;
            return provider2;
        }
        return ContainerUtil.getFirstItem(providers2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/hierarchy/actions/BrowseHierarchyActionBase";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/hierarchy/actions/BrowseHierarchyActionBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndAddToPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createAndAddToPanel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProvider";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findProvider";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

