/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ToolWindowEmptyStateAction;
import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.LanguageCallHierarchy;
import com.intellij.ide.hierarchy.LanguageMethodHierarchy;
import com.intellij.ide.hierarchy.LanguageTypeHierarchy;
import com.intellij.ide.hierarchy.actions.ActivateHierarchyToolWindowAction;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.StatusText;
import java.awt.event.ActionListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/ide/hierarchy/actions/ActivateHierarchyToolWindowAction;", "Lcom/intellij/ide/actions/ToolWindowEmptyStateAction;", "()V", "ensureToolWindowCreated", "", "project", "Lcom/intellij/openapi/project/Project;", "setupEmptyText", "text", "Lcom/intellij/util/ui/StatusText;", "intellij.platform.lang.impl"})
public final class ActivateHierarchyToolWindowAction
extends ToolWindowEmptyStateAction {
    protected void setupEmptyText(@NotNull Project project2, @NotNull StatusText text2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        text2.clear();
        text2.appendLine(LangBundle.message("hierarchy.empty.text", new Object[0]));
        if (LanguageTypeHierarchy.INSTANCE.hasAnyExtensions()) {
            text2.appendLine(LangBundle.message("hierarchy.empty.text.type", KeymapUtil.getShortcutText((String)"TypeHierarchy")));
        }
        if (LanguageCallHierarchy.INSTANCE.hasAnyExtensions()) {
            text2.appendLine(LangBundle.message("hierarchy.empty.text.call", KeymapUtil.getShortcutText((String)"CallHierarchy")));
        }
        if (LanguageMethodHierarchy.INSTANCE.hasAnyExtensions()) {
            text2.appendLine(LangBundle.message("hierarchy.empty.text.method", KeymapUtil.getShortcutText((String)"MethodHierarchy")));
        }
        text2.appendLine("");
        text2.appendLine(AllIcons.General.ContextHelp, LangBundle.message("hierarchy.empty.text.help", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, (ActionListener)setupEmptyText.1.INSTANCE);
    }

    protected void ensureToolWindowCreated(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        HierarchyBrowserManager.getInstance(project2);
    }

    public ActivateHierarchyToolWindowAction() {
        super("Hierarchy", AllIcons.Toolwindows.ToolWindowHierarchy);
    }
}

