/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.FileTemplatesScheme;
import com.intellij.ide.fileTemplates.InternalTemplateBean;
import com.intellij.ide.fileTemplates.impl.BundledFileTemplate;
import com.intellij.ide.fileTemplates.impl.ExportableFileTemplateSettings;
import com.intellij.ide.fileTemplates.impl.FTManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.ide.fileTemplates.impl.FileTemplateSettings;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.Strings;
import com.intellij.project.ProjectKt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@com.intellij.openapi.components.State(name="FileTemplateManagerImpl", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class FileTemplateManagerImpl
extends FileTemplateManager
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(FileTemplateManagerImpl.class);
    private final State state;
    private final ExportableFileTemplateSettings defaultSettings;
    private final Project project;
    private final FileTemplatesScheme myProjectScheme;
    private FileTemplatesScheme scheme;
    private boolean myInitialized;
    private Date myTestDate;

    public static FileTemplateManagerImpl getInstanceImpl(@NotNull Project project2) {
        if (project2 == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(0);
        }
        return (FileTemplateManagerImpl)FileTemplateManagerImpl.getInstance((Project)project2);
    }

    FileTemplateManagerImpl(final @NotNull Project project2) {
        if (project2 == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(1);
        }
        this.state = new State();
        this.scheme = FileTemplatesScheme.DEFAULT;
        this.defaultSettings = ApplicationManager.getApplication().getService(ExportableFileTemplateSettings.class);
        this.project = project2;
        this.myProjectScheme = project2.isDefault() ? null : new FileTemplatesScheme(IdeBundle.message((String)"project.scheme", (Object[])new Object[0])){

            @NotNull
            public String getTemplatesDir() {
                String string2 = ProjectKt.getStateStore(project2).getProjectFilePath().getParent().resolve("fileTemplates").toString();
                if (string2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string2;
            }

            @NotNull
            public Project getProject() {
                Project project22 = project2;
                if (project22 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return project22;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTemplatesDir";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getProject";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        project2.getMessageBus().connect().subscribe(DynamicPluginListener.TOPIC, new DynamicPluginListener(){

            @Override
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(0);
                }
                ClassLoader pluginClassLoader = pluginDescriptor.getClassLoader();
                for (FileTemplate template : FileTemplateManagerImpl.this.getAllTemplates()) {
                    if (FileTemplateUtil.findHandler(template).getClass().getClassLoader() != pluginClassLoader) continue;
                    FileTemplateManagerImpl.this.removeTemplate(template);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl$2", "pluginUnloaded"));
            }
        });
    }

    private FileTemplateSettings getSettings() {
        return this.scheme == FileTemplatesScheme.DEFAULT ? this.defaultSettings : this.project.getService(FileTemplateSettings.class);
    }

    @NotNull
    public FileTemplatesScheme getCurrentScheme() {
        FileTemplatesScheme fileTemplatesScheme = this.scheme;
        if (fileTemplatesScheme == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(2);
        }
        return fileTemplatesScheme;
    }

    public void setCurrentScheme(@NotNull FileTemplatesScheme scheme) {
        if (scheme == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(3);
        }
        for (FTManager child : this.getAllManagers()) {
            child.saveTemplates();
        }
        this.setScheme(scheme);
    }

    private void setScheme(@NotNull FileTemplatesScheme scheme) {
        if (scheme == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(4);
        }
        this.scheme = scheme;
        this.myInitialized = true;
    }

    @NotNull
    protected FileTemplateManager checkInitialized() {
        if (!this.myInitialized) {
            this.setScheme(this.scheme);
        }
        FileTemplateManagerImpl fileTemplateManagerImpl = this;
        if (fileTemplateManagerImpl == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(5);
        }
        return fileTemplateManagerImpl;
    }

    @Nullable
    public FileTemplatesScheme getProjectScheme() {
        return this.myProjectScheme;
    }

    public FileTemplate @NotNull [] getTemplates(@NotNull String category) {
        if (category == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(6);
        }
        switch (category) {
            case "Default": {
                FileTemplate[] fileTemplateArray = ArrayUtil.mergeArrays(this.getInternalTemplates(), this.getAllTemplates());
                if (fileTemplateArray == null) {
                    FileTemplateManagerImpl.$$$reportNull$$$0(7);
                }
                return fileTemplateArray;
            }
            case "Includes": {
                FileTemplate[] fileTemplateArray = this.getAllPatterns();
                if (fileTemplateArray == null) {
                    FileTemplateManagerImpl.$$$reportNull$$$0(8);
                }
                return fileTemplateArray;
            }
            case "Code": {
                FileTemplate[] fileTemplateArray = this.getAllCodeTemplates();
                if (fileTemplateArray == null) {
                    FileTemplateManagerImpl.$$$reportNull$$$0(9);
                }
                return fileTemplateArray;
            }
            case "J2EE": {
                FileTemplate[] fileTemplateArray = this.getAllJ2eeTemplates();
                if (fileTemplateArray == null) {
                    FileTemplateManagerImpl.$$$reportNull$$$0(10);
                }
                return fileTemplateArray;
            }
        }
        throw new IllegalArgumentException("Unknown category: " + category);
    }

    public FileTemplate @NotNull [] getAllTemplates() {
        FileTemplate[] fileTemplateArray = this.getSettings().getDefaultTemplatesManager().getAllTemplates(false).toArray(FileTemplate.EMPTY_ARRAY);
        if (fileTemplateArray == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(11);
        }
        return fileTemplateArray;
    }

    public FileTemplate getTemplate(@NotNull String templateName) {
        if (templateName == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(12);
        }
        return this.getSettings().getDefaultTemplatesManager().findTemplateByName(templateName);
    }

    @NotNull
    public FileTemplate addTemplate(@NotNull String name2, @NotNull String extension2) {
        if (name2 == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(13);
        }
        if (extension2 == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(14);
        }
        FileTemplateBase fileTemplateBase = this.getSettings().getDefaultTemplatesManager().addTemplate(name2, extension2);
        if (fileTemplateBase == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(15);
        }
        return fileTemplateBase;
    }

    public void removeTemplate(@NotNull FileTemplate template) {
        if (template == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(16);
        }
        String qName = ((FileTemplateBase)template).getQualifiedName();
        for (FTManager manager : this.getAllManagers()) {
            manager.removeTemplate(qName);
        }
    }

    @NotNull
    public Properties getDefaultProperties() {
        @NonNls Properties props = new Properties();
        Calendar calendar = Calendar.getInstance();
        Date date = this.myTestDate == null ? calendar.getTime() : this.myTestDate;
        SimpleDateFormat sdfMonthNameShort = new SimpleDateFormat("MMM");
        SimpleDateFormat sdfMonthNameFull = new SimpleDateFormat("MMMM");
        SimpleDateFormat sdfDayNameShort = new SimpleDateFormat("EEE");
        SimpleDateFormat sdfDayNameFull = new SimpleDateFormat("EEEE");
        SimpleDateFormat sdfYearFull = new SimpleDateFormat("yyyy");
        props.setProperty("DATE", DateFormatUtil.formatDate(date));
        props.setProperty("TIME", DateFormatUtil.formatTime(date));
        props.setProperty("YEAR", sdfYearFull.format(date));
        props.setProperty("MONTH", FileTemplateManagerImpl.getCalendarValue(calendar, 2));
        props.setProperty("MONTH_NAME_SHORT", sdfMonthNameShort.format(date));
        props.setProperty("MONTH_NAME_FULL", sdfMonthNameFull.format(date));
        props.setProperty("DAY", FileTemplateManagerImpl.getCalendarValue(calendar, 5));
        props.setProperty("DAY_NAME_SHORT", sdfDayNameShort.format(date));
        props.setProperty("DAY_NAME_FULL", sdfDayNameFull.format(date));
        props.setProperty("HOUR", FileTemplateManagerImpl.getCalendarValue(calendar, 11));
        props.setProperty("MINUTE", FileTemplateManagerImpl.getCalendarValue(calendar, 12));
        props.setProperty("SECOND", FileTemplateManagerImpl.getCalendarValue(calendar, 13));
        props.setProperty("USER", SystemProperties.getUserName());
        props.setProperty("PRODUCT_NAME", ApplicationNamesInfo.getInstance().getFullProductName());
        props.setProperty("DS", "$");
        props.setProperty("PROJECT_NAME", this.project.getName());
        Properties properties = props;
        if (properties == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(17);
        }
        return properties;
    }

    @NotNull
    private static String getCalendarValue(Calendar calendar, int field) {
        String result2;
        int val = calendar.get(field);
        if (field == 2) {
            ++val;
        }
        if ((result2 = Integer.toString(val)).length() == 1) {
            String string2 = "0" + result2;
            if (string2 == null) {
                FileTemplateManagerImpl.$$$reportNull$$$0(18);
            }
            return string2;
        }
        String string3 = result2;
        if (string3 == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(19);
        }
        return string3;
    }

    @NotNull
    public Collection<String> getRecentNames() {
        this.validateRecentNames();
        Collection<String> collection = this.state.getRecentNames();
        if (collection == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(20);
        }
        return collection;
    }

    public void addRecentName(@NotNull @NonNls String name2) {
        if (name2 == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(21);
        }
        this.state.addName(name2);
    }

    private void validateRecentNames() {
        Collection<FileTemplateBase> allTemplates = this.getSettings().getDefaultTemplatesManager().getAllTemplates(false);
        ArrayList<String> allNames = new ArrayList<String>(allTemplates.size());
        for (FileTemplate fileTemplate : allTemplates) {
            allNames.add(fileTemplate.getName());
        }
        this.state.validateNames(allNames);
    }

    public FileTemplate @NotNull [] getInternalTemplates() {
        ArrayList result2 = new ArrayList(InternalTemplateBean.EP_NAME.getPoint().size());
        InternalTemplateBean.EP_NAME.processWithPluginDescriptor((bean, pluginDescriptor) -> {
            try {
                result2.add(this.getInternalTemplate(bean.name));
            }
            catch (Exception e) {
                LOG.error("Can't find template " + bean.name, new PluginException(e, pluginDescriptor.getPluginId()));
            }
        });
        FileTemplate[] fileTemplateArray = result2.toArray(FileTemplate.EMPTY_ARRAY);
        if (fileTemplateArray == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(22);
        }
        return fileTemplateArray;
    }

    @NotNull
    public FileTemplate getInternalTemplate(@NotNull @NonNls String templateName) {
        FileTemplateBase template;
        if (templateName == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(23);
        }
        if ((template = (FileTemplateBase)this.findInternalTemplate(templateName)) == null) {
            template = (FileTemplateBase)this.getJ2eeTemplate(templateName);
            template.setReformatCode(true);
        }
        FileTemplateBase fileTemplateBase = template;
        if (fileTemplateBase == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(24);
        }
        return fileTemplateBase;
    }

    public FileTemplate findInternalTemplate(@NotNull @NonNls String templateName) {
        FileTemplateBase template;
        if (templateName == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(25);
        }
        if ((template = this.getSettings().getInternalTemplatesManager().findTemplateByName(templateName)) == null) {
            template = this.getSettings().getDefaultTemplatesManager().findTemplateByName(templateName);
        }
        return template;
    }

    @NotNull
    public String internalTemplateToSubject(@NotNull @NonNls String templateName) {
        if (templateName == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(26);
        }
        for (InternalTemplateBean bean : InternalTemplateBean.EP_NAME.getExtensionList()) {
            if (!bean.name.equals(templateName) || bean.subject == null) continue;
            String string2 = bean.subject;
            if (string2 == null) {
                FileTemplateManagerImpl.$$$reportNull$$$0(27);
            }
            return string2;
        }
        String string3 = Strings.toLowerCase(templateName);
        if (string3 == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(28);
        }
        return string3;
    }

    @NotNull
    public FileTemplate getCodeTemplate(@NotNull @NonNls String templateName) {
        if (templateName == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(29);
        }
        return FileTemplateManagerImpl.getTemplateFromManager(templateName, this.getSettings().getCodeTemplatesManager());
    }

    @NotNull
    public FileTemplate getJ2eeTemplate(@NotNull @NonNls String templateName) {
        if (templateName == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(30);
        }
        return FileTemplateManagerImpl.getTemplateFromManager(templateName, this.getSettings().getJ2eeTemplatesManager());
    }

    @NotNull
    private static FileTemplate getTemplateFromManager(@NotNull String templateName, @NotNull FTManager ftManager) {
        FileTemplateBase template;
        if (templateName == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(31);
        }
        if (ftManager == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(32);
        }
        if ((template = ftManager.getTemplate(templateName)) != null) {
            FileTemplateBase fileTemplateBase = template;
            if (fileTemplateBase == null) {
                FileTemplateManagerImpl.$$$reportNull$$$0(33);
            }
            return fileTemplateBase;
        }
        template = ftManager.findTemplateByName(templateName);
        if (template != null) {
            FileTemplateBase fileTemplateBase = template;
            if (fileTemplateBase == null) {
                FileTemplateManagerImpl.$$$reportNull$$$0(34);
            }
            return fileTemplateBase;
        }
        throw new IllegalStateException("Template not found: " + templateName);
    }

    @NotNull
    public FileTemplate getDefaultTemplate(@NotNull String name2) {
        if (name2 == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(35);
        }
        String templateQName = FileTemplateManagerImpl.getQualifiedName(name2);
        for (FTManager manager : this.getSettings().getAllManagers()) {
            FileTemplateBase template = manager.getTemplate(templateQName);
            if (template == null) continue;
            if (template instanceof BundledFileTemplate) {
                template = ((BundledFileTemplate)template).clone();
                ((BundledFileTemplate)template).revertToDefaults();
            }
            FileTemplateBase fileTemplateBase = template;
            if (fileTemplateBase == null) {
                FileTemplateManagerImpl.$$$reportNull$$$0(36);
            }
            return fileTemplateBase;
        }
        String message2 = "Default template not found: " + name2;
        LOG.error(message2);
        throw new RuntimeException(message2);
    }

    @NotNull
    private static String getQualifiedName(@NotNull String name2) {
        if (name2 == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(37);
        }
        String string2 = FileTypeManagerEx.getInstanceEx().getExtension(name2).isEmpty() ? FileTemplateBase.getQualifiedName(name2, "java") : name2;
        if (string2 == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(38);
        }
        return string2;
    }

    public FileTemplate @NotNull [] getAllPatterns() {
        Collection<FileTemplateBase> allTemplates = this.getSettings().getPatternsManager().getAllTemplates(false);
        FileTemplate[] fileTemplateArray = allTemplates.toArray(FileTemplate.EMPTY_ARRAY);
        if (fileTemplateArray == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(39);
        }
        return fileTemplateArray;
    }

    public FileTemplate getPattern(@NotNull String name2) {
        if (name2 == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(40);
        }
        return this.getSettings().getPatternsManager().findTemplateByName(name2);
    }

    public FileTemplate @NotNull [] getAllCodeTemplates() {
        Collection<FileTemplateBase> templates = this.getSettings().getCodeTemplatesManager().getAllTemplates(false);
        FileTemplate[] fileTemplateArray = templates.toArray(FileTemplate.EMPTY_ARRAY);
        if (fileTemplateArray == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(41);
        }
        return fileTemplateArray;
    }

    public FileTemplate @NotNull [] getAllJ2eeTemplates() {
        Collection<FileTemplateBase> templates = this.getSettings().getJ2eeTemplatesManager().getAllTemplates(false);
        FileTemplate[] fileTemplateArray = templates.toArray(FileTemplate.EMPTY_ARRAY);
        if (fileTemplateArray == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(42);
        }
        return fileTemplateArray;
    }

    public void setTemplates(@NotNull String templatesCategory, @NotNull Collection<? extends FileTemplate> templates) {
        if (templatesCategory == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(43);
        }
        if (templates == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(44);
        }
        for (FTManager manager : this.getAllManagers()) {
            if (!templatesCategory.equals(manager.getName())) continue;
            manager.updateTemplates(templates);
            break;
        }
    }

    public void saveAllTemplates() {
        for (FTManager manager : this.getAllManagers()) {
            manager.saveTemplates();
        }
    }

    public Supplier<String> getDefaultTemplateDescription() {
        return this.defaultSettings.getDefaultTemplateDescription();
    }

    Supplier<String> getDefaultIncludeDescription() {
        return this.defaultSettings.getDefaultIncludeDescription();
    }

    @TestOnly
    public void setTestDate(Date testDate) {
        this.myTestDate = testDate;
    }

    @Override
    @NotNull
    public State getState() {
        this.state.SCHEME = this.scheme.getName();
        State state = this.state;
        if (state == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(45);
        }
        return state;
    }

    @Override
    public void loadState(@NotNull State state) {
        if (state == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(46);
        }
        XmlSerializerUtil.copyBean(state, this.state);
        FileTemplatesScheme scheme = this.myProjectScheme != null && this.myProjectScheme.getName().equals(state.SCHEME) ? this.myProjectScheme : FileTemplatesScheme.DEFAULT;
        this.setScheme(scheme);
    }

    private Collection<FTManager> getAllManagers() {
        return this.getSettings().getAllManagers();
    }

    @TestOnly
    public void setDefaultFileIncludeTemplateTextTemporarilyForTest(final String simpleName, final String text2, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(47);
        }
        FTManager defaultTemplatesManager = this.getSettings().getPatternsManager();
        final String qName = FileTemplateManagerImpl.getQualifiedName(simpleName);
        FileTemplateBase oldTemplate = defaultTemplatesManager.getTemplate(qName);
        Map<String, FileTemplateBase> templates = defaultTemplatesManager.getTemplates();
        templates.put(qName, new FileTemplateBase(){

            @NotNull
            public String getName() {
                String string2 = simpleName;
                if (string2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string2;
            }

            public void setName(@NotNull String name2) {
                if (name2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                throw new AbstractMethodError();
            }

            public boolean isDefault() {
                return true;
            }

            @NotNull
            public String getDescription() {
                throw new AbstractMethodError();
            }

            @NotNull
            public String getExtension() {
                String string2 = qName.substring(simpleName.length());
                if (string2 == null) {
                    3.$$$reportNull$$$0(2);
                }
                return string2;
            }

            public void setExtension(@NotNull String extension2) {
                if (extension2 == null) {
                    3.$$$reportNull$$$0(3);
                }
                throw new AbstractMethodError();
            }

            @Override
            @NotNull
            protected String getDefaultText() {
                String string2 = text2;
                if (string2 == null) {
                    3.$$$reportNull$$$0(4);
                }
                return string2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 3: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl$3";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getExtension";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDefaultText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "setName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "setExtension";
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                    case 1: 
                    case 3: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        Disposer.register(parentDisposable, () -> templates.put(qName, oldTemplate));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 45: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 12: 
            case 23: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 13: 
            case 21: 
            case 35: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ftManager";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templatesCategory";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templates";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentScheme";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "checkInitialized";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplates";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTemplates";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "addTemplate";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProperties";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCalendarValue";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentNames";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalTemplates";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalTemplate";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "internalTemplateToSubject";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateFromManager";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTemplate";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPatterns";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCodeTemplates";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllJ2eeTemplates";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 45: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentScheme";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setScheme";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTemplates";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTemplate";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addTemplate";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeTemplate";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addRecentName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getInternalTemplate";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findInternalTemplate";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "internalTemplateToSubject";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getCodeTemplate";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getJ2eeTemplate";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateFromManager";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTemplate";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getPattern";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "setTemplates";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultFileIncludeTemplateTextTemporarilyForTest";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 45: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class State {
        @OptionTag(value="RECENT_TEMPLATES")
        public final List<String> recentTemplates = new ArrayList<String>();
        public String SCHEME = FileTemplatesScheme.DEFAULT.getName();

        private void addName(@NotNull @NonNls String name2) {
            if (name2 == null) {
                State.$$$reportNull$$$0(0);
            }
            this.recentTemplates.remove(name2);
            this.recentTemplates.add(name2);
        }

        @NotNull
        private Collection<String> getRecentNames() {
            int size = this.recentTemplates.size();
            int resultSize = Math.min(25, size);
            List<String> list2 = this.recentTemplates.subList(size - resultSize, size);
            if (list2 == null) {
                State.$$$reportNull$$$0(1);
            }
            return list2;
        }

        private void validateNames(List<String> validNames) {
            this.recentTemplates.retainAll(validNames);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl$State";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl$State";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRecentNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addName";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

