/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.bookmark.BookmarksListener;
import com.intellij.ide.favoritesTreeView.AbstractUrlFavoriteAdapter;
import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.FavoriteTreeNodeDescriptor;
import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesListener;
import com.intellij.ide.favoritesTreeView.FavoritesViewSettings;
import com.intellij.ide.favoritesTreeView.TaskDefaultFavoriteListProvider;
import com.intellij.ide.favoritesTreeView.actions.AddToFavoritesAction;
import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.ide.projectView.impl.DirectoryUrl;
import com.intellij.ide.projectView.impl.LibraryModuleGroupUrl;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ModuleGroupUrl;
import com.intellij.ide.projectView.impl.ModuleUrl;
import com.intellij.ide.projectView.impl.NamedLibraryUrl;
import com.intellij.ide.projectView.impl.PsiFileUrl;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.TreeItem;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@State(name="FavoritesManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$"), @Storage(value="$WORKSPACE_FILE$", deprecated=true)})
public final class FavoritesManager
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(FavoritesManager.class);
    private final Map<String, List<TreeItem<Pair<AbstractUrl, String>>>> myName2FavoritesRoots;
    private final List<String> myFavoritesRootsOrder;
    private final Map<String, String> myDescriptions;
    private final Project myProject;
    private final List<FavoritesListener> myListeners;
    private final FavoritesViewSettings myViewSettings;
    private Map<String, FavoritesListProvider> myProviders;
    @NonNls
    private static final String CLASS_NAME = "klass";
    @NonNls
    private static final String FAVORITES_ROOT = "favorite_root";
    @NonNls
    private static final String ELEMENT_FAVORITES_LIST = "favorites_list";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    private static final ArrayList<AbstractUrl> ourAbstractUrlProviders = new ArrayList();
    @NonNls
    private static final String ATTRIBUTE_TYPE = "type";
    @NonNls
    private static final String ATTRIBUTE_URL = "url";
    @NonNls
    private static final String ATTRIBUTE_MODULE = "module";

    public static FavoritesManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            FavoritesManager.$$$reportNull$$$0(0);
        }
        return project2.getService(FavoritesManager.class);
    }

    public FavoritesManager(@NotNull Project project2) {
        if (project2 == null) {
            FavoritesManager.$$$reportNull$$$0(1);
        }
        this.myName2FavoritesRoots = new TreeMap<String, List<TreeItem<Pair<AbstractUrl, String>>>>();
        this.myFavoritesRootsOrder = new ArrayList<String>();
        this.myDescriptions = new HashMap<String, String>();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myViewSettings = new FavoritesViewSettings();
        this.myProject = project2;
        FavoritesListProvider.EP_NAME.getPoint(this.myProject).addChangeListener(() -> {
            this.myProviders = null;
            this.rootsChanged();
        }, this.myProject);
    }

    @NotNull
    private Map<String, FavoritesListProvider> getProviders() {
        if (this.myProviders != null) {
            Map<String, FavoritesListProvider> map2 = this.myProviders;
            if (map2 == null) {
                FavoritesManager.$$$reportNull$$$0(2);
            }
            return map2;
        }
        this.myProviders = new HashMap<String, FavoritesListProvider>();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            FavoritesListProvider[] providers2;
            for (FavoritesListProvider provider2 : providers2 = FavoritesListProvider.EP_NAME.getExtensions(this.myProject)) {
                this.myProviders.put(provider2.getListName(this.myProject), provider2);
            }
            MyRootsChangeAdapter myPsiTreeChangeAdapter = new MyRootsChangeAdapter();
            PsiManager.getInstance(this.myProject).addPsiTreeChangeListener(myPsiTreeChangeAdapter, this.myProject);
            if (this.myName2FavoritesRoots.isEmpty()) {
                this.myDescriptions.put(this.myProject.getName(), "auto-added");
                this.createNewList(this.myProject.getName());
            }
        }
        Map<String, FavoritesListProvider> map3 = this.myProviders;
        if (map3 == null) {
            FavoritesManager.$$$reportNull$$$0(3);
        }
        return map3;
    }

    private void rootsChanged() {
        for (FavoritesListener listener2 : this.myListeners) {
            listener2.rootsChanged();
        }
    }

    private void listAdded(@NotNull String listName) {
        if (listName == null) {
            FavoritesManager.$$$reportNull$$$0(4);
        }
        for (FavoritesListener listener2 : this.myListeners) {
            listener2.listAdded(listName);
        }
    }

    private void listRemoved(@NotNull String listName) {
        if (listName == null) {
            FavoritesManager.$$$reportNull$$$0(5);
        }
        for (FavoritesListener listener2 : this.myListeners) {
            listener2.listRemoved(listName);
        }
    }

    public void renameList(final Project project2, @NotNull String listName) {
        String newName2;
        if (listName == null) {
            FavoritesManager.$$$reportNull$$$0(6);
        }
        if ((newName2 = Messages.showInputDialog((Project)project2, (String)IdeBundle.message((String)"prompt.input.favorites.list.new.name", (Object[])new Object[]{listName}), (String)IdeBundle.message((String)"title.rename.favorites.list", (Object[])new Object[0]), (Icon)Messages.getInformationIcon(), (String)listName, (InputValidator)new InputValidator(){

            @Override
            public boolean checkInput(String inputString) {
                return inputString != null && inputString.trim().length() > 0;
            }

            @Override
            public boolean canClose(String inputString) {
                if (FavoritesManager.this.myName2FavoritesRoots.containsKey(inputString = inputString.trim()) || FavoritesManager.this.getProviders().containsKey(inputString)) {
                    Messages.showErrorDialog((Project)project2, (String)IdeBundle.message((String)"error.favorites.list.already.exists", (Object[])new Object[]{inputString.trim()}), (String)IdeBundle.message((String)"title.unable.to.add.favorites.list", (Object[])new Object[0]));
                    return false;
                }
                return !inputString.isEmpty();
            }
        })) != null && this.renameFavoritesList(listName, newName2)) {
            this.rootsChanged();
        }
    }

    public void addFavoritesListener(final FavoritesListener listener2, @NotNull Disposable parent) {
        if (parent == null) {
            FavoritesManager.$$$reportNull$$$0(7);
        }
        this.myListeners.add(listener2);
        listener2.rootsChanged();
        Disposer.register(parent, new Disposable(){

            @Override
            public void dispose() {
                FavoritesManager.this.myListeners.remove(listener2);
            }
        });
    }

    List<AbstractTreeNode<?>> createRootNodes() {
        ArrayList result2 = new ArrayList();
        for (String listName : this.myFavoritesRootsOrder) {
            result2.add(new FavoritesListNode(this.myProject, listName, this.myDescriptions.get(listName)));
        }
        ArrayList<FavoritesListProvider> providers2 = new ArrayList<FavoritesListProvider>(this.getProviders().values());
        Collections.sort(providers2);
        for (FavoritesListProvider provider2 : providers2) {
            result2.add(provider2.createFavoriteListNode(this.myProject));
        }
        return result2;
    }

    @NotNull
    public List<String> getAvailableFavoritesListNames() {
        return new ArrayList<String>(this.myFavoritesRootsOrder);
    }

    public synchronized void createNewList(@NotNull String listName) {
        if (listName == null) {
            FavoritesManager.$$$reportNull$$$0(8);
        }
        this.myName2FavoritesRoots.put(listName, new ArrayList());
        this.myFavoritesRootsOrder.add(listName);
        this.listAdded(listName);
    }

    @Deprecated
    public synchronized void fireListeners(@NotNull String listName) {
        if (listName == null) {
            FavoritesManager.$$$reportNull$$$0(9);
        }
        this.myProject.getMessageBus().syncPublisher(BookmarksListener.TOPIC).structureChanged(null);
        this.rootsChanged();
    }

    @NotNull
    public FavoritesViewSettings getViewSettings() {
        FavoritesViewSettings favoritesViewSettings = this.myViewSettings;
        if (favoritesViewSettings == null) {
            FavoritesManager.$$$reportNull$$$0(10);
        }
        return favoritesViewSettings;
    }

    public synchronized void removeFavoritesList(@NotNull String name2) {
        if (name2 == null) {
            FavoritesManager.$$$reportNull$$$0(11);
        }
        this.myName2FavoritesRoots.remove(name2);
        this.myFavoritesRootsOrder.remove(name2);
        this.myDescriptions.remove(name2);
        this.listRemoved(name2);
    }

    @NotNull
    public List<TreeItem<Pair<AbstractUrl, String>>> getFavoritesListRootUrls(@NotNull String name2) {
        ArrayList<TreeItem<Pair<AbstractUrl, String>>> pairs;
        if (name2 == null) {
            FavoritesManager.$$$reportNull$$$0(12);
        }
        ArrayList<TreeItem<Pair<AbstractUrl, String>>> arrayList = (pairs = this.myName2FavoritesRoots.get(name2)) == null ? new ArrayList<TreeItem<Pair<AbstractUrl, String>>>() : pairs;
        if (arrayList == null) {
            FavoritesManager.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    public synchronized boolean addRoots(@NotNull String name2, Module moduleContext, @NotNull Object elements) {
        Collection<AbstractTreeNode<?>> nodes;
        if (name2 == null) {
            FavoritesManager.$$$reportNull$$$0(14);
        }
        if (elements == null) {
            FavoritesManager.$$$reportNull$$$0(15);
        }
        return !(nodes = AddToFavoritesAction.createNodes(this.myProject, moduleContext, elements, true, this.getViewSettings())).isEmpty() && this.addRoots(name2, nodes);
    }

    @Nullable
    public synchronized Comparator<FavoriteTreeNodeDescriptor> getCustomComparator(@NotNull String name2) {
        if (name2 == null) {
            FavoritesManager.$$$reportNull$$$0(16);
        }
        return this.getProviders().get(name2);
    }

    private Pair<AbstractUrl, String> createPairForNode(AbstractTreeNode node2) {
        String className = node2.getClass().getName();
        Object value = node2.getValue();
        AbstractUrl url = FavoritesManager.createUrlByElement(value, this.myProject);
        if (url == null) {
            return null;
        }
        return Pair.create(url, className);
    }

    public boolean addRoots(String name2, Collection<? extends AbstractTreeNode<?>> nodes) {
        List<TreeItem<Pair<AbstractUrl, String>>> list2 = this.getFavoritesListRootUrls(name2);
        HashSet<AbstractUrl> set2 = new HashSet<AbstractUrl>(ContainerUtil.map(list2, item -> (AbstractUrl)((Pair)item.getData()).getFirst()));
        for (AbstractTreeNode<?> node2 : nodes) {
            Pair<AbstractUrl, String> pair = this.createPairForNode(node2);
            if (pair == null || set2.contains(pair.getFirst())) continue;
            TreeItem<Pair<AbstractUrl, String>> treeItem = new TreeItem<Pair<AbstractUrl, String>>(pair);
            list2.add(treeItem);
            set2.add(pair.getFirst());
            this.appendChildNodes(node2, treeItem);
        }
        this.rootsChanged();
        return true;
    }

    public boolean canAddRoots(@NotNull String name2, @NotNull Collection<? extends AbstractTreeNode<?>> nodes) {
        if (name2 == null) {
            FavoritesManager.$$$reportNull$$$0(17);
        }
        if (nodes == null) {
            FavoritesManager.$$$reportNull$$$0(18);
        }
        List<TreeItem<Pair<AbstractUrl, String>>> list2 = this.getFavoritesListRootUrls(name2);
        HashSet<AbstractUrl> set2 = new HashSet<AbstractUrl>(ContainerUtil.map(list2, item -> (AbstractUrl)((Pair)item.getData()).getFirst()));
        for (AbstractTreeNode<?> node2 : nodes) {
            Pair<AbstractUrl, String> pair = this.createPairForNode(node2);
            if (pair == null || set2.contains(pair.getFirst())) continue;
            return true;
        }
        return false;
    }

    private void appendChildNodes(AbstractTreeNode node2, TreeItem<Pair<AbstractUrl, String>> treeItem) {
        Collection children2 = node2.getChildren();
        for (AbstractTreeNode child : children2) {
            TreeItem<Pair<AbstractUrl, String>> childTreeItem = new TreeItem<Pair<AbstractUrl, String>>(this.createPairForNode(child));
            treeItem.addChild(childTreeItem);
            this.appendChildNodes(child, childTreeItem);
        }
    }

    private <T> boolean findListToRemoveFrom(@NotNull String name2, @NotNull List<T> elements, Function<? super T, ? extends AbstractUrl> convertor) {
        if (name2 == null) {
            FavoritesManager.$$$reportNull$$$0(19);
        }
        if (elements == null) {
            FavoritesManager.$$$reportNull$$$0(20);
        }
        List<TreeItem<Pair<AbstractUrl, String>>> list2 = this.getFavoritesListRootUrls(name2);
        if (elements.size() > 1) {
            List<T> sublist = elements.subList(0, elements.size() - 1);
            for (T obj : sublist) {
                AbstractUrl abstractUrl = convertor.apply(obj);
                TreeItem<Pair<AbstractUrl, String>> item = FavoritesManager.findNextItem(abstractUrl, list2);
                if (item == null || item.getChildren() == null) {
                    return false;
                }
                list2 = item.getChildren();
            }
        }
        TreeItem found2 = null;
        AbstractUrl url = convertor.apply(elements.get(elements.size() - 1));
        if (url == null) {
            return false;
        }
        for (TreeItem treeItem : list2) {
            if (!url.equals(((Pair)treeItem.getData()).getFirst())) continue;
            found2 = treeItem;
            break;
        }
        if (found2 != null) {
            list2.remove(found2);
            this.rootsChanged();
            return true;
        }
        return false;
    }

    public synchronized boolean removeRoot(@NotNull String name2, @NotNull List<? extends AbstractTreeNode<?>> elements) {
        if (name2 == null) {
            FavoritesManager.$$$reportNull$$$0(21);
        }
        if (elements == null) {
            FavoritesManager.$$$reportNull$$$0(22);
        }
        Function<AbstractTreeNode, AbstractUrl> convertor = obj -> FavoritesManager.createUrlByElement(obj.getValue(), this.myProject);
        boolean result2 = true;
        for (AbstractTreeNode<?> element2 : elements) {
            List<AbstractTreeNode<?>> path2 = TaskDefaultFavoriteListProvider.getPathToUsualNode(element2);
            result2 &= this.findListToRemoveFrom(name2, path2.subList(1, path2.size()), convertor);
        }
        return result2;
    }

    private static TreeItem<Pair<AbstractUrl, String>> findNextItem(AbstractUrl url, Collection<? extends TreeItem<Pair<AbstractUrl, String>>> list2) {
        for (TreeItem<Pair<AbstractUrl, String>> treeItem : list2) {
            if (!url.equals(treeItem.getData().getFirst())) continue;
            return treeItem;
        }
        return null;
    }

    private boolean renameFavoritesList(@NotNull String oldName, @NotNull String newName2) {
        if (oldName == null) {
            FavoritesManager.$$$reportNull$$$0(23);
        }
        if (newName2 == null) {
            FavoritesManager.$$$reportNull$$$0(24);
        }
        List<TreeItem<Pair<AbstractUrl, String>>> list2 = this.myName2FavoritesRoots.remove(oldName);
        int index = this.myFavoritesRootsOrder.indexOf(oldName);
        if (index != -1 && newName2.length() > 0) {
            this.myFavoritesRootsOrder.remove(oldName);
            this.myFavoritesRootsOrder.remove(newName2);
            this.myFavoritesRootsOrder.add(index, newName2);
        }
        if (list2 != null && newName2.length() > 0) {
            this.myName2FavoritesRoots.put(newName2, list2);
            String description = this.myDescriptions.remove(oldName);
            if (description != null) {
                this.myDescriptions.put(newName2, description);
            }
            this.rootsChanged();
            return true;
        }
        return false;
    }

    public void setOrder(@NotNull String nameToOrder, String anchorName, boolean above) {
        if (nameToOrder == null) {
            FavoritesManager.$$$reportNull$$$0(25);
        }
        if (!this.canReorder(nameToOrder, anchorName, above)) {
            return;
        }
        int index = this.myFavoritesRootsOrder.indexOf(anchorName);
        int toRemove2 = this.myFavoritesRootsOrder.indexOf(nameToOrder);
        this.myFavoritesRootsOrder.add(above ? index : index + 1, nameToOrder);
        this.myFavoritesRootsOrder.remove(toRemove2 > index ? toRemove2 + 1 : toRemove2);
        this.rootsChanged();
    }

    public boolean canReorder(String nameToOrder, String anchorName, boolean above) {
        int index = this.myFavoritesRootsOrder.indexOf(anchorName);
        int toReorder = this.myFavoritesRootsOrder.indexOf(nameToOrder);
        if (index == -1 || toReorder == -1 || index == toReorder) {
            return false;
        }
        if (toReorder == index - 1 && above) {
            return false;
        }
        return toReorder != index + 1 || above;
    }

    @Nullable
    public FavoritesListProvider getListProvider(@Nullable String name2) {
        return this.getProviders().get(name2);
    }

    @Override
    public void loadState(@NotNull Element element2) {
        if (element2 == null) {
            FavoritesManager.$$$reportNull$$$0(26);
        }
        this.myName2FavoritesRoots.clear();
        for (Element list2 : element2.getChildren(ELEMENT_FAVORITES_LIST)) {
            String name2 = list2.getAttributeValue(ATTRIBUTE_NAME);
            List<TreeItem<Pair<AbstractUrl, String>>> roots2 = FavoritesManager.readRoots(list2, this.myProject);
            this.myName2FavoritesRoots.put(name2, roots2);
            this.myFavoritesRootsOrder.add(name2);
        }
        DefaultJDOMExternalizer.readExternal(this, element2);
    }

    @Override
    public void noStateLoaded() {
        LOG.info("no state loaded for old favorites");
    }

    private static List<TreeItem<Pair<AbstractUrl, String>>> readRoots(Element list2, Project project2) {
        ArrayList<TreeItem<Pair<AbstractUrl, String>>> result2 = new ArrayList<TreeItem<Pair<AbstractUrl, String>>>();
        FavoritesManager.readFavoritesOneLevel(list2, project2, result2);
        return result2;
    }

    private static void readFavoritesOneLevel(Element list2, Project project2, Collection<? super TreeItem<Pair<AbstractUrl, String>>> result2) {
        for (Element favorite : list2.getChildren(FAVORITES_ROOT)) {
            String className = favorite.getAttributeValue(CLASS_NAME);
            AbstractUrl abstractUrl = FavoritesManager.readUrlFromElement(favorite, project2);
            if (abstractUrl == null) continue;
            TreeItem<Pair<AbstractUrl, String>> treeItem = new TreeItem<Pair<AbstractUrl, String>>(Pair.create(abstractUrl, className));
            result2.add(treeItem);
            FavoritesManager.readFavoritesOneLevel(favorite, project2, treeItem.getChildren());
        }
    }

    @Nullable
    private static AbstractUrl readUrlFromElement(Element element2, Project project2) {
        String type = element2.getAttributeValue(ATTRIBUTE_TYPE);
        String urlValue = element2.getAttributeValue(ATTRIBUTE_URL);
        String moduleName = element2.getAttributeValue(ATTRIBUTE_MODULE);
        for (FavoriteNodeProvider nodeProvider : FavoriteNodeProvider.EP_NAME.getExtensions(project2)) {
            if (!nodeProvider.getFavoriteTypeId().equals(type)) continue;
            return new AbstractUrlFavoriteAdapter(urlValue, moduleName, nodeProvider);
        }
        for (AbstractUrl urlProvider : ourAbstractUrlProviders) {
            AbstractUrl url = urlProvider.createUrl(type, moduleName, urlValue);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public Element getState() {
        Element element2 = new Element("state");
        for (String name2 : this.myFavoritesRootsOrder) {
            Element list2 = new Element(ELEMENT_FAVORITES_LIST);
            list2.setAttribute(ATTRIBUTE_NAME, name2);
            FavoritesManager.writeRoots(list2, (Collection<? extends TreeItem<Pair<AbstractUrl, String>>>)this.myName2FavoritesRoots.get(name2));
            element2.addContent(list2);
        }
        DefaultJDOMExternalizer.writeExternal(this, element2);
        return element2;
    }

    @Nullable
    public static AbstractUrl createUrlByElement(Object element2, Project project2) {
        if (element2 instanceof SmartPsiElementPointer) {
            element2 = ((SmartPsiElementPointer)element2).getElement();
        }
        for (FavoriteNodeProvider nodeProvider : FavoriteNodeProvider.EP_NAME.getExtensions(project2)) {
            String url = nodeProvider.getElementUrl(element2);
            if (url == null) continue;
            return new AbstractUrlFavoriteAdapter(url, nodeProvider.getElementModuleName(element2), nodeProvider);
        }
        for (AbstractUrl urlProvider : ourAbstractUrlProviders) {
            AbstractUrl url = urlProvider.createUrlByElement(element2);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    private static void writeRoots(Element element2, Collection<? extends TreeItem<Pair<AbstractUrl, String>>> roots2) {
        for (TreeItem<Pair<AbstractUrl, String>> treeItem : roots2) {
            AbstractUrl url = treeItem.getData().getFirst();
            if (url == null) continue;
            Element list2 = new Element(FAVORITES_ROOT);
            url.write(list2);
            list2.setAttribute(CLASS_NAME, treeItem.getData().getSecond());
            element2.addContent(list2);
            List<TreeItem<Pair<AbstractUrl, String>>> children2 = treeItem.getChildren();
            if (children2 == null || children2.isEmpty()) continue;
            FavoritesManager.writeRoots(list2, children2);
        }
    }

    public String getFavoriteListName(@Nullable String currentSubId, @NotNull VirtualFile vFile) {
        if (vFile == null) {
            FavoritesManager.$$$reportNull$$$0(27);
        }
        if (currentSubId != null && this.contains(currentSubId, vFile)) {
            return currentSubId;
        }
        for (String listName : this.myName2FavoritesRoots.keySet()) {
            if (!this.contains(listName, vFile)) continue;
            return listName;
        }
        return null;
    }

    public boolean contains(@NotNull String name2, @NotNull VirtualFile vFile) {
        if (name2 == null) {
            FavoritesManager.$$$reportNull$$$0(28);
        }
        if (vFile == null) {
            FavoritesManager.$$$reportNull$$$0(29);
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(this.myProject).getFileIndex();
        HashSet find2 = new HashSet();
        ContentIterator contentIterator = fileOrDir -> {
            if (fileOrDir.getPath().equals(vFile.getPath())) {
                find2.add(Boolean.TRUE);
            }
            return true;
        };
        List<TreeItem<Pair<AbstractUrl, String>>> urls = this.getFavoritesListRootUrls(name2);
        for (TreeItem treeItem : urls) {
            NamedLibraryElement namedLibraryElement;
            VirtualFile[] files2;
            Object[] path2;
            AbstractUrl abstractUrl = (AbstractUrl)((Pair)treeItem.getData()).getFirst();
            if (abstractUrl == null || (path2 = abstractUrl.createPath(this.myProject)) == null || path2.length < 1 || path2[0] == null) continue;
            Object element2 = path2[path2.length - 1];
            if (element2 instanceof SmartPsiElementPointer) {
                VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile(((SmartPsiElementPointer)element2).getElement());
                if (virtualFile2 == null) continue;
                if (vFile.getPath().equals(virtualFile2.getPath())) {
                    return true;
                }
                if (!virtualFile2.isDirectory()) continue;
                projectFileIndex.iterateContentUnderDirectory(virtualFile2, contentIterator);
            }
            if (element2 instanceof PsiElement) {
                VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile((PsiElement)element2);
                if (virtualFile2 == null) continue;
                if (vFile.getPath().equals(virtualFile2.getPath())) {
                    return true;
                }
                if (!virtualFile2.isDirectory()) continue;
                projectFileIndex.iterateContentUnderDirectory(virtualFile2, contentIterator);
            }
            if (element2 instanceof Module) {
                ModuleRootManager.getInstance((Module)element2).getFileIndex().iterateContent(contentIterator);
            }
            if (element2 instanceof LibraryGroupElement) {
                boolean inLibrary;
                boolean bl = inLibrary = ModuleRootManager.getInstance(((LibraryGroupElement)element2).getModule()).getFileIndex().isInContent(vFile) && projectFileIndex.isInLibraryClasses(vFile);
                if (inLibrary) {
                    return true;
                }
            }
            if (element2 instanceof NamedLibraryElement && ArrayUtil.find(files2 = (namedLibraryElement = (NamedLibraryElement)element2).getOrderEntry().getRootFiles(OrderRootType.CLASSES), vFile) > -1) {
                return true;
            }
            if (element2 instanceof ModuleGroup) {
                ModuleGroup group = (ModuleGroup)element2;
                Collection<Module> modules2 = group.modulesInGroup(this.myProject, true);
                for (Module module : modules2) {
                    ModuleRootManager.getInstance(module).getFileIndex().iterateContent(contentIterator);
                }
            }
            for (FavoriteNodeProvider provider2 : FavoriteNodeProvider.EP_NAME.getExtensions(this.myProject)) {
                if (!provider2.elementContainsFile(element2, vFile)) continue;
                return true;
            }
            if (find2.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static void iterateTreeItems(Collection<? extends TreeItem<Pair<AbstractUrl, String>>> coll, Consumer<? super TreeItem<Pair<AbstractUrl, String>>> consumer) {
        ArrayDeque<? extends TreeItem<Pair<AbstractUrl, String>>> queue2 = new ArrayDeque<TreeItem<Pair<AbstractUrl, String>>>(coll);
        while (!queue2.isEmpty()) {
            TreeItem<Pair<AbstractUrl, String>> item = queue2.removeFirst();
            consumer.consume(item);
            List<TreeItem<Pair<AbstractUrl, String>>> children2 = item.getChildren();
            if (children2 == null || children2.isEmpty()) continue;
            queue2.addAll(children2);
        }
    }

    Collection<VirtualFile> getVirtualFiles(String listName, boolean recursively) {
        if (this.getListProvider(listName) != null) {
            return Collections.emptyList();
        }
        SmartList<VirtualFile> result2 = new SmartList<VirtualFile>();
        List<TreeItem<Pair<AbstractUrl, String>>> roots2 = this.myName2FavoritesRoots.get(listName);
        if (roots2 == null || roots2.isEmpty()) {
            return result2;
        }
        if (!recursively) {
            for (TreeItem<Pair<AbstractUrl, String>> item2 : roots2) {
                VirtualFile file2 = this.getVirtualFile(item2);
                if (file2 == null) continue;
                result2.add(file2);
            }
        } else {
            FavoritesManager.iterateTreeItems(roots2, item -> {
                VirtualFile file2 = this.getVirtualFile((TreeItem<Pair<AbstractUrl, String>>)item);
                if (file2 != null) {
                    result2.add(file2);
                }
            });
        }
        return result2;
    }

    @Nullable
    private VirtualFile getVirtualFile(TreeItem<Pair<AbstractUrl, String>> item) {
        Pair<AbstractUrl, String> data2 = item.getData();
        Object[] path2 = ((AbstractUrl)data2.first).createPath(this.myProject);
        if (path2 != null && path2.length == 1) {
            VirtualFile virtualFile2;
            if (path2[0] instanceof PsiFile && (virtualFile2 = ((PsiFile)path2[0]).getVirtualFile()) != null && !virtualFile2.isDirectory()) {
                return virtualFile2;
            }
            if (path2[0] instanceof File && (virtualFile2 = VfsUtil.findFileByIoFile((File)path2[0], false)) != null && !virtualFile2.isDirectory()) {
                return virtualFile2;
            }
        }
        return null;
    }

    static {
        ourAbstractUrlProviders.add(new ModuleUrl(null, null));
        ourAbstractUrlProviders.add(new DirectoryUrl(null, null));
        ourAbstractUrlProviders.add(new ModuleGroupUrl(null));
        ourAbstractUrlProviders.add(new PsiFileUrl(null));
        ourAbstractUrlProviders.add(new LibraryModuleGroupUrl(null));
        ourAbstractUrlProviders.add(new NamedLibraryUrl(null, null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/favoritesTreeView/FavoritesManager";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_NAME;
                break;
            }
            case 15: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameToOrder";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/favoritesTreeView/FavoritesManager";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewSettings";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFavoritesListRootUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "listAdded";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "listRemoved";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renameList";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addFavoritesListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createNewList";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fireListeners";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeFavoritesList";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFavoritesListRootUrls";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addRoots";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCustomComparator";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "canAddRoots";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findListToRemoveFrom";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeRoot";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "renameFavoritesList";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setOrder";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getFavoriteListName";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyRootsChangeAdapter
    extends PsiTreeChangeAdapter {
        private MyRootsChangeAdapter() {
        }

        @Override
        public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyRootsChangeAdapter.$$$reportNull$$$0(0);
            }
            PsiElement oldParent = event.getOldParent();
            PsiElement newParent = event.getNewParent();
            PsiElement child = event.getChild();
            if (newParent instanceof PsiDirectory) {
                Module module = ModuleUtilCore.findModuleForPsiElement(newParent);
                if (module == null) {
                    return;
                }
                AbstractUrl childUrl = null;
                if (child instanceof PsiFile) {
                    childUrl = new PsiFileUrl(((PsiDirectory)newParent).getVirtualFile().getUrl() + "/" + ((PsiFile)child).getName());
                } else if (child instanceof PsiDirectory) {
                    childUrl = new DirectoryUrl(((PsiDirectory)newParent).getVirtualFile().getUrl() + "/" + ((PsiDirectory)child).getName(), module.getName());
                }
                for (String listName : FavoritesManager.this.myFavoritesRootsOrder) {
                    List<TreeItem<Pair<AbstractUrl, String>>> roots2 = FavoritesManager.this.myName2FavoritesRoots.get(listName);
                    AbstractUrl finalChildUrl = childUrl;
                    FavoritesManager.iterateTreeItems(roots2, item -> {
                        Pair root = (Pair)item.getData();
                        Object[] path2 = ((AbstractUrl)root.first).createPath(FavoritesManager.this.myProject);
                        if (path2 == null || path2.length < 1 || path2[0] == null) {
                            return;
                        }
                        Object element2 = path2[path2.length - 1];
                        if (element2 == child && finalChildUrl != null) {
                            item.setData(Pair.create(finalChildUrl, (String)root.second));
                        } else if (element2 == oldParent) {
                            item.setData(Pair.create(((AbstractUrl)root.first).createUrlByElement(newParent), (String)root.second));
                        }
                    });
                }
            }
        }

        @Override
        public void beforePropertyChange(@NotNull PsiTreeChangeEvent event) {
            PsiElement psiElement;
            if (event == null) {
                MyRootsChangeAdapter.$$$reportNull$$$0(1);
            }
            if ((event.getPropertyName().equals("fileName") || event.getPropertyName().equals("directoryName")) && ((psiElement = event.getChild()) instanceof PsiFile || psiElement instanceof PsiDirectory)) {
                Module module = ModuleUtilCore.findModuleForPsiElement(psiElement);
                if (module == null) {
                    return;
                }
                String url = ((PsiDirectory)psiElement.getParent()).getVirtualFile().getUrl() + "/" + event.getNewValue();
                AbstractUrl childUrl = psiElement instanceof PsiFile ? new PsiFileUrl(url) : new DirectoryUrl(url, module.getName());
                for (String listName : FavoritesManager.this.myFavoritesRootsOrder) {
                    List<TreeItem<Pair<AbstractUrl, String>>> roots2 = FavoritesManager.this.myName2FavoritesRoots.get(listName);
                    FavoritesManager.iterateTreeItems(roots2, item -> {
                        Pair root = (Pair)item.getData();
                        Object[] path2 = ((AbstractUrl)root.first).createPath(FavoritesManager.this.myProject);
                        if (path2 == null || path2.length < 1 || path2[0] == null) {
                            return;
                        }
                        Object element2 = path2[path2.length - 1];
                        if (element2 == psiElement && psiElement instanceof PsiFile) {
                            item.setData(Pair.create(childUrl, (String)root.second));
                        } else {
                            item.setData(root);
                        }
                    });
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/ide/favoritesTreeView/FavoritesManager$MyRootsChangeAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeChildMovement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforePropertyChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

