/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui;

import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarkOccurrence;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.BookmarksManagerImpl;
import com.intellij.ide.bookmark.providers.FileBookmarkImpl;
import com.intellij.ide.bookmark.providers.LineBookmarkImpl;
import com.intellij.ide.bookmark.ui.BookmarksView;
import com.intellij.ide.bookmark.ui.ExtensionsKt;
import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0002\u0018\u0019B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ide/bookmark/ui/DragAndDropHandler;", "Lcom/intellij/ide/dnd/DnDNativeTarget;", "Lcom/intellij/ide/dnd/DnDTargetChecker;", "Lcom/intellij/ide/dnd/DnDDropHandler$WithResult;", "view", "Lcom/intellij/ide/bookmark/ui/BookmarksView;", "(Lcom/intellij/ide/bookmark/ui/BookmarksView;)V", "getView", "()Lcom/intellij/ide/bookmark/ui/BookmarksView;", "createBean", "Lcom/intellij/ide/dnd/DnDDragStartBean;", "info", "Lcom/intellij/ide/dnd/DnDActionInfo;", "setHighlighting", "", "event", "Lcom/intellij/ide/dnd/DnDEvent;", "bounds", "Ljava/awt/Rectangle;", "setLineHighlighting", "above", "tryDrop", "updateOnly", "update", "AttachedBookmarkGroups", "AttachedBookmarks", "intellij.platform.lang.impl"})
public final class DragAndDropHandler
implements DnDNativeTarget,
DnDTargetChecker,
DnDDropHandler.WithResult {
    @NotNull
    private final BookmarksView view;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final DnDDragStartBean createBean(@NotNull DnDActionInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        List<AbstractTreeNode<?>> list2 = this.view.getSelectedNodes();
        if (list2 == null) {
            return null;
        }
        List<AbstractTreeNode<?>> nodes = list2;
        if (info.isMove()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNullTo$iv$iv2;
            Iterable $this$mapNotNull$iv = nodes;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                BookmarkOccurrence bookmarkOccurrence;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                AbstractTreeNode it = (AbstractTreeNode)element$iv$iv;
                boolean bl2 = false;
                AbstractTreeNode abstractTreeNode = it;
                Intrinsics.checkNotNullExpressionValue((Object)abstractTreeNode, (String)"it");
                if (ExtensionsKt.getBookmarkOccurrence(abstractTreeNode) == null) continue;
                BookmarkOccurrence it$iv$iv = bookmarkOccurrence;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List bookmarks = (List)destination$iv$iv;
            $this$mapNotNull$iv = bookmarks;
            if (!$this$mapNotNull$iv.isEmpty()) {
                if (bookmarks.size() != nodes.size()) {
                    return null;
                }
                if (this.view.getGroupLineBookmarks().isSelected()) {
                    int count2;
                    int n;
                    Iterable $this$count$iv = bookmarks;
                    boolean $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n = 0;
                    } else {
                        int count$iv = 0;
                        for (Object element$iv : $this$count$iv) {
                            BookmarkOccurrence it = (BookmarkOccurrence)element$iv;
                            boolean bl = false;
                            if (!(it.getBookmark() instanceof LineBookmarkImpl) || (it = ++count$iv) >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n = count2 = count$iv;
                    }
                    if (count2 > 0) {
                        Set set2 = new LinkedHashSet();
                        Iterable $this$forEach$iv = bookmarks;
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv : $this$forEach$iv) {
                            BookmarkOccurrence it = (BookmarkOccurrence)element$iv;
                            boolean bl = false;
                            if (!(it.getBookmark() instanceof LineBookmarkImpl)) continue;
                            set2.add(((LineBookmarkImpl)it.getBookmark()).getFile());
                        }
                        if (count2 < bookmarks.size()) {
                            List list3;
                            void $this$filterTo$iv$iv;
                            $this$forEach$iv = bookmarks;
                            $i$f$forEach2 = false;
                            for (Object element$iv : $this$forEach$iv) {
                                BookmarkOccurrence it = (BookmarkOccurrence)element$iv;
                                boolean bl = false;
                                if (!(it.getBookmark() instanceof FileBookmarkImpl)) continue;
                                set2.remove(((FileBookmarkImpl)it.getBookmark()).getFile());
                            }
                            if (set2.size() != 0) {
                                return null;
                            }
                            Iterable $this$filter$iv = bookmarks;
                            boolean $i$f$filter = false;
                            Iterable $i$f$mapNotNullTo2 = $this$filter$iv;
                            Collection destination$iv$iv2 = new ArrayList();
                            boolean $i$f$filterTo = false;
                            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                                BookmarkOccurrence it = (BookmarkOccurrence)element$iv$iv;
                                boolean bl = false;
                                if (!(!(it.getBookmark() instanceof LineBookmarkImpl))) continue;
                                destination$iv$iv2.add(element$iv$iv);
                            }
                            List list4 = list3 = (List)destination$iv$iv2;
                            AttachedBookmarks attachedBookmarks = new AttachedBookmarks(list4);
                            return new DnDDragStartBean((Object)attachedBookmarks);
                        }
                        if (set2.size() != 1) {
                            return null;
                        }
                    }
                }
                return new DnDDragStartBean((Object)new AttachedBookmarks(bookmarks));
            }
            Iterable $this$mapNotNull$iv2 = nodes;
            boolean $i$f$mapNotNull2 = false;
            Iterable $i$f$filter = $this$mapNotNull$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo3 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach3 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                BookmarkGroup bookmarkGroup;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                AbstractTreeNode it = (AbstractTreeNode)element$iv$iv;
                boolean bl4 = false;
                AbstractTreeNode abstractTreeNode = it;
                Intrinsics.checkNotNullExpressionValue((Object)abstractTreeNode, (String)"it");
                Object object = abstractTreeNode.getValue();
                if (!(object instanceof BookmarkGroup)) {
                    object = null;
                }
                if ((BookmarkGroup)object == null) continue;
                BookmarkGroup it$iv$iv = bookmarkGroup;
                boolean bl5 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            List groups2 = (List)destination$iv$iv3;
            Collection collection = groups2;
            if (!collection.isEmpty()) {
                if (groups2.size() != nodes.size()) {
                    return null;
                }
                return new DnDDragStartBean((Object)new AttachedBookmarkGroups(groups2));
            }
        }
        return null;
    }

    public boolean update(@NotNull DnDEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean possible = this.tryDrop(event, true);
        if (!possible) {
            event.hideHighlighter();
        }
        event.setDropPossible(possible);
        return true;
    }

    public boolean tryDrop(@NotNull DnDEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return this.tryDrop(event, false);
    }

    private final boolean tryDrop(DnDEvent event, boolean updateOnly) {
        BookmarkGroup group;
        Point point = event.getPoint();
        if (point == null) {
            return false;
        }
        Point point2 = point;
        if (Intrinsics.areEqual((Object)event.getHandlerComponent(), (Object)this.view.getTree()) ^ true || !this.view.getTree().isShowing()) {
            return false;
        }
        TreePath treePath = this.view.getTree().getClosestPathForLocation(point2.x, point2.y);
        if (treePath == null) {
            return false;
        }
        TreePath path2 = treePath;
        AbstractTreeNode abstractTreeNode = TreeUtil.getAbstractTreeNode((TreePath)path2);
        if (abstractTreeNode == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)abstractTreeNode, (String)"TreeUtil.getAbstractTreeNode(path) ?: return false");
        AbstractTreeNode node2 = abstractTreeNode;
        Rectangle rectangle = this.view.getTree().getPathBounds(path2);
        if (rectangle == null) {
            return false;
        }
        Rectangle bounds = rectangle;
        boolean strict = bounds.y <= point2.y && (double)point2.y < bounds.getMaxY();
        boolean above = (double)point2.y < bounds.getCenterY();
        Object attached = event.getAttachedObject();
        if (attached instanceof AttachedBookmarks) {
            BookmarkGroup group2;
            BookmarksManager bookmarksManager = BookmarksManager.getInstance(this.view.getProject());
            if (!(bookmarksManager instanceof BookmarksManagerImpl)) {
                bookmarksManager = null;
            }
            BookmarksManagerImpl bookmarksManagerImpl = (BookmarksManagerImpl)bookmarksManager;
            if (bookmarksManagerImpl == null) {
                return false;
            }
            BookmarksManagerImpl manager = bookmarksManagerImpl;
            Object object = node2.getValue();
            if (!(object instanceof BookmarkGroup)) {
                object = null;
            }
            if ((group2 = (BookmarkGroup)object) != null && strict) {
                return !updateOnly ? manager.dragInto(group2, ((AttachedBookmarks)attached).getOccurrences()) : (!manager.canDragInto(group2, ((AttachedBookmarks)attached).getOccurrences()) ? false : this.setHighlighting(event, bounds));
            }
            BookmarkOccurrence bookmarkOccurrence = ExtensionsKt.getBookmarkOccurrence(node2);
            if (bookmarkOccurrence == null) {
                return false;
            }
            BookmarkOccurrence occurrence = bookmarkOccurrence;
            return !updateOnly ? manager.drag(above, occurrence, ((AttachedBookmarks)attached).getOccurrences()) : (!manager.canDrag(above, occurrence, ((AttachedBookmarks)attached).getOccurrences()) ? false : this.setLineHighlighting(event, bounds, above));
        }
        if (attached instanceof AttachedBookmarkGroups) {
            BookmarksManager bookmarksManager = BookmarksManager.getInstance(this.view.getProject());
            if (!(bookmarksManager instanceof BookmarksManagerImpl)) {
                bookmarksManager = null;
            }
            BookmarksManagerImpl bookmarksManagerImpl = (BookmarksManagerImpl)bookmarksManager;
            if (bookmarksManagerImpl == null) {
                return false;
            }
            BookmarksManagerImpl manager = bookmarksManagerImpl;
            Object object = node2.getValue();
            if (!(object instanceof BookmarkGroup)) {
                object = null;
            }
            BookmarkGroup bookmarkGroup = (BookmarkGroup)object;
            if (bookmarkGroup == null) {
                return false;
            }
            BookmarkGroup group3 = bookmarkGroup;
            return !updateOnly ? manager.drag(above, group3, ((AttachedBookmarkGroups)attached).getGroups()) : (!manager.canDrag(above, group3, ((AttachedBookmarkGroups)attached).getGroups()) ? false : this.setLineHighlighting(event, bounds, above));
        }
        List list2 = FileCopyPasteUtil.getFileListFromAttachedObject((Object)attached);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"FileCopyPasteUtil.getFil\u2026mAttachedObject(attached)");
        List files2 = list2;
        if (files2.isEmpty()) {
            if (!SystemInfo.isMac || !(attached instanceof DnDNativeTarget.EventInfo)) {
                return false;
            }
            if (!FileCopyPasteUtil.isFileListFlavorAvailable((DnDEvent)event)) {
                return false;
            }
            this.setHighlighting(event, bounds);
            return true;
        }
        BookmarksManager bookmarksManager = BookmarksManager.getInstance(this.view.getProject());
        if (!(bookmarksManager instanceof BookmarksManagerImpl)) {
            bookmarksManager = null;
        }
        BookmarksManagerImpl bookmarksManagerImpl = (BookmarksManagerImpl)bookmarksManager;
        if (bookmarksManagerImpl == null) {
            return false;
        }
        BookmarksManagerImpl manager = bookmarksManagerImpl;
        Object object = node2.getValue();
        if (!(object instanceof BookmarkGroup)) {
            object = null;
        }
        if ((group = (BookmarkGroup)object) != null && strict) {
            return !updateOnly ? manager.dragAddInto(group, files2) : (!manager.canDragAddInto(group, files2) ? false : this.setHighlighting(event, bounds));
        }
        AbstractTreeNode abstractTreeNode2 = node2.getParent();
        if (!((abstractTreeNode2 != null ? abstractTreeNode2.getValue() : null) instanceof BookmarkGroup)) {
            return false;
        }
        BookmarkOccurrence bookmarkOccurrence = ExtensionsKt.getBookmarkOccurrence(node2);
        if (bookmarkOccurrence == null) {
            return false;
        }
        BookmarkOccurrence occurrence = bookmarkOccurrence;
        return !updateOnly ? manager.dragAdd(above, occurrence, files2) : (!manager.canDragAddInto(occurrence.getGroup(), files2) ? false : this.setLineHighlighting(event, bounds, above));
    }

    private final boolean setHighlighting(DnDEvent event, Rectangle bounds) {
        event.setHighlighting(new RelativeRectangle((Component)this.view.getTree(), bounds), 1);
        return true;
    }

    private final boolean setLineHighlighting(DnDEvent event, Rectangle bounds, boolean above) {
        if (!above) {
            bounds.y += bounds.height;
        }
        --bounds.y;
        bounds.height = 2;
        event.setHighlighting(new RelativeRectangle((Component)this.view.getTree(), bounds), 2);
        return true;
    }

    @NotNull
    public final BookmarksView getView() {
        return this.view;
    }

    public DragAndDropHandler(@NotNull BookmarksView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.view = view;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/bookmark/ui/DragAndDropHandler$AttachedBookmarks;", "", "occurrences", "", "Lcom/intellij/ide/bookmark/BookmarkOccurrence;", "(Ljava/util/List;)V", "getOccurrences", "()Ljava/util/List;", "intellij.platform.lang.impl"})
    private static final class AttachedBookmarks {
        @NotNull
        private final List<BookmarkOccurrence> occurrences;

        @NotNull
        public final List<BookmarkOccurrence> getOccurrences() {
            return this.occurrences;
        }

        public AttachedBookmarks(@NotNull List<BookmarkOccurrence> occurrences) {
            Intrinsics.checkNotNullParameter(occurrences, (String)"occurrences");
            this.occurrences = occurrences;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/bookmark/ui/DragAndDropHandler$AttachedBookmarkGroups;", "", "groups", "", "Lcom/intellij/ide/bookmark/BookmarkGroup;", "(Ljava/util/List;)V", "getGroups", "()Ljava/util/List;", "intellij.platform.lang.impl"})
    private static final class AttachedBookmarkGroups {
        @NotNull
        private final List<BookmarkGroup> groups;

        @NotNull
        public final List<BookmarkGroup> getGroups() {
            return this.groups;
        }

        public AttachedBookmarkGroups(@NotNull List<? extends BookmarkGroup> groups2) {
            Intrinsics.checkNotNullParameter(groups2, (String)"groups");
            this.groups = groups2;
        }
    }
}

