/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui;

import com.intellij.ide.actions.ToggleToolbarAction;
import com.intellij.ide.bookmark.ui.BookmarksView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splittable;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ide/bookmark/ui/BookmarksViewFactory;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener;", "()V", "orientation", "Ljava/util/concurrent/atomic/AtomicBoolean;", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "window", "Lcom/intellij/openapi/wm/ToolWindow;", "stateChanged", "manager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "intellij.platform.lang.impl"})
public final class BookmarksViewFactory
implements DumbAware,
ToolWindowFactory,
ToolWindowManagerListener {
    private final AtomicBoolean orientation = new AtomicBoolean(true);

    /*
     * WARNING - void declaration
     */
    public void createToolWindowContent(@NotNull Project project2, @NotNull ToolWindow window) {
        void $this$apply;
        BookmarksView bookmarksView;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        ContentManager contentManager = window.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"window.contentManager");
        ContentManager manager = contentManager;
        BookmarksView it = bookmarksView = new BookmarksView(project2, ToggleToolbarAction.isToolbarVisible((ToolWindow)window, (Project)project2));
        boolean bl = false;
        it.setOrientation(this.orientation.get());
        BookmarksView panel2 = bookmarksView;
        it = bookmarksView = manager.getFactory().createContent((JComponent)((Object)panel2), null, false);
        ContentManager contentManager2 = manager;
        boolean bl2 = false;
        $this$apply.setCloseable(false);
        Unit unit = Unit.INSTANCE;
        contentManager2.addContent((Content)bookmarksView);
        MessageBusConnection messageBusConnection = project2.getMessageBus().connect((Disposable)manager);
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"ToolWindowManagerListener.TOPIC");
        messageBusConnection.subscribe(topic, this);
        window.setHelpId("bookmarks.tool.window.help");
        window.setTitleActions(CollectionsKt.listOfNotNull((Object)ActionUtil.getAction((String)"Bookmarks.ToolWindow.TitleActions")));
        if (window instanceof ToolWindowEx) {
            window.setAdditionalGearActions(ActionUtil.getActionGroup((String)"Bookmarks.ToolWindow.GearActions"));
        }
    }

    public void stateChanged(@NotNull ToolWindowManager manager) {
        boolean vertical;
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        ToolWindow toolWindow = manager.getToolWindow("Bookmarks");
        if (toolWindow == null) {
            return;
        }
        ToolWindow window = toolWindow;
        if (window.isDisposed()) {
            return;
        }
        ToolWindowAnchor toolWindowAnchor = window.getAnchor();
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"window.anchor");
        boolean bl = vertical = !toolWindowAnchor.isHorizontal();
        if (vertical != this.orientation.getAndSet(vertical)) {
            ContentManager contentManager = window.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"window.contentManager");
            Content[] contentArray = contentManager.getContents();
            int n = contentArray.length;
            for (int i = 0; i < n; ++i) {
                Splittable splittable;
                Content content2;
                Content content3 = content2 = contentArray[i];
                JComponent jComponent = content3 != null ? content3.getComponent() : null;
                if (!(jComponent instanceof Splittable)) {
                    jComponent = null;
                }
                Splittable splittable2 = splittable = (Splittable)((Object)jComponent);
                if (splittable2 == null) continue;
                splittable2.setOrientation(vertical);
            }
        }
    }
}

