/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.providers;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkProvider;
import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.BookmarksManagerImpl;
import com.intellij.ide.bookmark.FileBookmark;
import com.intellij.ide.bookmark.LineBookmark;
import com.intellij.ide.bookmark.providers.FileBookmarkImpl;
import com.intellij.ide.bookmark.providers.InvalidBookmark;
import com.intellij.ide.bookmark.providers.LineBookmarkImpl;
import com.intellij.ide.bookmark.ui.BookmarksView;
import com.intellij.ide.bookmark.ui.tree.BookmarkNode;
import com.intellij.ide.bookmark.ui.tree.FileNode;
import com.intellij.ide.bookmark.ui.tree.LineNode;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.DirectoryUrl;
import com.intellij.ide.projectView.impl.PsiFileUrl;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.smartPointers.SmartPointerEx;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.tree.project.ProjectFileNode;
import com.intellij.util.Alarm;
import com.intellij.util.SingleAlarm;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 G2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001GB\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0016J!\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0002\u0010(J\u001a\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010)\u001a\u00020\u00102\b\b\u0002\u0010'\u001a\u00020\u001fJ\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010*\u001a\u00020+H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010,\u001a\u00020\u0011H\u0002J\u0014\u0010#\u001a\u0004\u0018\u00010!2\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\u001a\u0010#\u001a\u00020!2\u0006\u0010/\u001a\u0002002\b\b\u0002\u0010'\u001a\u00020\u001fH\u0002J\u001e\u0010#\u001a\u0004\u0018\u00010!2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020002H\u0016J\u001a\u00103\u001a\u0002042\u0006\u0010/\u001a\u0002002\b\b\u0002\u0010'\u001a\u00020\u001fH\u0002J\u001c\u00105\u001a\u0004\u0018\u00010$2\u0006\u0010/\u001a\u0002002\b\b\u0002\u0010'\u001a\u00020\u001fH\u0002J\b\u00106\u001a\u00020\u0006H\u0016J\b\u00107\u001a\u00020\u001fH\u0016J\u0014\u00108\u001a\u00020\u00152\n\u00109\u001a\u0006\u0012\u0002\b\u00030:H\u0002J\u0010\u0010;\u001a\u00020\u001b2\u0006\u0010<\u001a\u00020\u0016H\u0016J\u0018\u0010=\u001a\u0004\u0018\u00010>2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020A0@H\u0016J$\u0010B\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030:0@2\u0010\u0010C\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030:0@H\u0016J\u0012\u0010D\u001a\u0004\u0018\u00010!2\u0006\u0010E\u001a\u00020!H\u0002J\b\u0010F\u001a\u00020\u001bH\u0002R\u0019\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\u00020\u0015*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0017R\u0018\u0010\u0014\u001a\u00020\u0015*\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0019\u00a8\u0006H"}, d2={"Lcom/intellij/ide/bookmark/providers/LineBookmarkProvider;", "Lcom/intellij/ide/bookmark/BookmarkProvider;", "Lcom/intellij/openapi/editor/event/EditorMouseListener;", "Lcom/intellij/openapi/editor/event/BulkAwareDocumentListener$Simple;", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "VFM", "Lcom/intellij/openapi/vfs/VirtualFileManager;", "Lorg/jetbrains/annotations/NotNull;", "getVFM", "()Lcom/intellij/openapi/vfs/VirtualFileManager;", "validateAlarm", "Lcom/intellij/util/SingleAlarm;", "asVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljavax/swing/tree/TreePath;", "getAsVirtualFile", "(Ljavax/swing/tree/TreePath;)Lcom/intellij/openapi/vfs/VirtualFile;", "isUnexpected", "", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "(Lcom/intellij/openapi/editor/event/EditorMouseEvent;)Z", "Ljava/awt/event/MouseEvent;", "(Ljava/awt/event/MouseEvent;)Z", "afterDocumentChange", "", "document", "Lcom/intellij/openapi/editor/Document;", "compare", "", "bookmark1", "Lcom/intellij/ide/bookmark/Bookmark;", "bookmark2", "createBookmark", "Lcom/intellij/ide/bookmark/FileBookmark;", "editor", "Lcom/intellij/openapi/editor/Editor;", "line", "(Lcom/intellij/openapi/editor/Editor;Ljava/lang/Integer;)Lcom/intellij/ide/bookmark/FileBookmark;", "file", "element", "Lcom/intellij/psi/PsiElement;", "path", "context", "", "url", "", "map", "", "createInvalidBookmark", "Lcom/intellij/ide/bookmark/providers/InvalidBookmark;", "createValidBookmark", "getProject", "getWeight", "isNodeVisible", "node", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "mouseClicked", "event", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "prepareGroup", "nodes", "validate", "bookmark", "validateAndUpdate", "Companion", "intellij.platform.lang.impl"})
public final class LineBookmarkProvider
implements BookmarkProvider,
EditorMouseListener,
BulkAwareDocumentListener.Simple,
AsyncFileListener {
    private final SingleAlarm validateAlarm;
    private final Project project;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public int getWeight() {
        return Integer.MIN_VALUE;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    public int compare(@NotNull Bookmark bookmark1, @NotNull Bookmark bookmark2) {
        VirtualFile file2;
        Intrinsics.checkNotNullParameter((Object)bookmark1, (String)"bookmark1");
        Intrinsics.checkNotNullParameter((Object)bookmark2, (String)"bookmark2");
        Bookmark bookmark = bookmark1;
        if (!(bookmark instanceof FileBookmark)) {
            bookmark = null;
        }
        FileBookmark fileBookmark1 = (FileBookmark)bookmark;
        Bookmark bookmark3 = bookmark2;
        if (!(bookmark3 instanceof FileBookmark)) {
            bookmark3 = null;
        }
        FileBookmark fileBookmark2 = (FileBookmark)bookmark3;
        if (fileBookmark1 == null && fileBookmark2 == null) {
            return 0;
        }
        if (fileBookmark1 == null) {
            return -1;
        }
        if (fileBookmark2 == null) {
            return 1;
        }
        VirtualFile file1 = fileBookmark1.getFile();
        if (Intrinsics.areEqual((Object)file1, (Object)(file2 = fileBookmark2.getFile()))) {
            Bookmark bookmark4 = bookmark1;
            if (!(bookmark4 instanceof LineBookmark)) {
                bookmark4 = null;
            }
            LineBookmark lineBookmark1 = (LineBookmark)bookmark4;
            Bookmark bookmark5 = bookmark2;
            if (!(bookmark5 instanceof LineBookmark)) {
                bookmark5 = null;
            }
            LineBookmark lineBookmark2 = (LineBookmark)bookmark5;
            if (lineBookmark1 == null && lineBookmark2 == null) {
                return 0;
            }
            if (lineBookmark1 == null) {
                return -1;
            }
            if (lineBookmark2 == null) {
                return 1;
            }
            return Intrinsics.compare((int)lineBookmark1.getLine(), (int)lineBookmark2.getLine());
        }
        if (file1.isDirectory() && !file2.isDirectory()) {
            return -1;
        }
        if (!file1.isDirectory() && file2.isDirectory()) {
            return 1;
        }
        return StringUtil.naturalCompare(file1.getPresentableName(), file2.getPresentableName());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<AbstractTreeNode<?>> prepareGroup(@NotNull List<? extends AbstractTreeNode<?>> nodes) {
        VirtualFile it$iv$iv;
        VirtualFile virtualFile2;
        AbstractTreeNode it;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Object $this$mapNotNullTo$iv$iv;
        Object $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object object;
        BookmarkNode bookmarkNode;
        Iterable $i$f$forEach22;
        AbstractTreeNode it2;
        block17: {
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            Iterable $this$forEach$iv = nodes;
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv) {
                it2 = (AbstractTreeNode)element$iv;
                boolean bl = false;
                AbstractTreeNode abstractTreeNode = it2;
                if (!(abstractTreeNode instanceof FileNode)) {
                    abstractTreeNode = null;
                }
                FileNode fileNode = (FileNode)abstractTreeNode;
                if (fileNode == null) continue;
                fileNode.ungroup();
            }
            $i$f$forEach22 = nodes;
            for (Object element$iv : $i$f$forEach22) {
                it2 = (AbstractTreeNode)element$iv;
                boolean bl = false;
                AbstractTreeNode abstractTreeNode = it2;
                if (!(abstractTreeNode instanceof LineNode)) {
                    abstractTreeNode = null;
                }
                if ((it2 = (LineNode)abstractTreeNode) == null) continue;
                bookmarkNode = it2;
                break block17;
            }
            bookmarkNode = null;
        }
        if (bookmarkNode == null) {
            $i$f$forEach22 = nodes;
            object = this;
            boolean $i$f$filter = false;
            it2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv2 = iterator.next();
                AbstractTreeNode p1 = (AbstractTreeNode)element$iv$iv2;
                boolean bl = false;
                if (!((LineBookmarkProvider)object).isNodeVisible(p1)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            return (List)destination$iv$iv;
        }
        BookmarkNode node2 = bookmarkNode;
        BookmarksView bookmarksView = node2.getBookmarksView();
        if (bookmarksView == null || (bookmarksView = bookmarksView.getGroupLineBookmarks()) == null || !bookmarksView.isSelected()) {
            $this$filter$iv = nodes;
            object = this;
            boolean $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv3 = iterator.next();
                AbstractTreeNode p1 = (AbstractTreeNode)element$iv$iv3;
                boolean bl = false;
                if (!((LineBookmarkProvider)object).isNodeVisible(p1)) continue;
                destination$iv$iv.add(element$iv$iv3);
            }
            return (List)destination$iv$iv;
        }
        Map map2 = new LinkedHashMap();
        Iterable $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractTreeNode it3 = (AbstractTreeNode)element$iv;
            boolean bl = false;
            AbstractTreeNode element$iv$iv3 = it3;
            if (element$iv$iv3 instanceof LineNode) {
                map2.putIfAbsent(((LineNode)it3).getVirtualFile(), null);
                continue;
            }
            if (!(element$iv$iv3 instanceof FileNode)) continue;
            map2.put(((FileNode)it3).getVirtualFile(), it3);
        }
        Object $this$mapNotNull$iv = map2;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach32 = false;
        Object p1 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (p1.hasNext()) {
            element$iv$iv = element$iv$iv$iv = p1.next();
            boolean bl = false;
            it = element$iv$iv;
            boolean bl2 = false;
            VirtualFile virtualFile3 = it.getValue() == null ? (VirtualFile)it.getKey() : null;
            if (virtualFile3 == null) continue;
            it$iv$iv = virtualFile2 = virtualFile3;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$apply;
            VirtualFile it4 = (VirtualFile)element$iv;
            boolean bl = false;
            FileNode $i$f$forEach32 = new FileNode(this.project, new FileBookmarkImpl(this, it4));
            p1 = $i$f$forEach32;
            element$iv$iv$iv = it4;
            element$iv$iv = map2;
            boolean bl4 = false;
            $this$apply.setBookmarkGroup(node2.getBookmarkGroup());
            $this$apply.setParent(node2.getParent());
            it = Unit.INSTANCE;
            element$iv$iv.put(element$iv$iv$iv, $i$f$forEach32);
        }
        $this$mapNotNull$iv = nodes;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        Object $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach4 = false;
        Iterator iterator = $this$forEach$iv$iv$iv2.iterator();
        while (iterator.hasNext()) {
            AbstractTreeNode abstractTreeNode;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            it = (AbstractTreeNode)element$iv$iv;
            boolean bl5 = false;
            if (!this.isNodeVisible(it)) {
                abstractTreeNode = null;
            } else if (it instanceof LineNode) {
                Object v = map2.get(((LineNode)it).getVirtualFile());
                Intrinsics.checkNotNull(v);
                abstractTreeNode = ((FileNode)v).grouped(it);
            } else {
                abstractTreeNode = it instanceof FileNode ? (AbstractTreeNode)((FileNode)it).grouped() : it;
            }
            if (abstractTreeNode == null) continue;
            it$iv$iv = virtualFile2 = abstractTreeNode;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public Bookmark createBookmark(@NotNull Map<String, String> map2) {
        Bookmark bookmark;
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        String string2 = map2.get("url");
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            bookmark = this.createBookmark(it, StringUtil.parseInt(map2.get("line"), -1));
        } else {
            bookmark = null;
        }
        return bookmark;
    }

    @Override
    @Nullable
    public Bookmark createBookmark(@Nullable Object context2) {
        Bookmark bookmark;
        Object object = context2;
        if (object instanceof com.intellij.ide.bookmarks.Bookmark) {
            VirtualFile virtualFile2 = ((com.intellij.ide.bookmarks.Bookmark)context2).getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"context.file");
            bookmark = this.createBookmark(virtualFile2, ((com.intellij.ide.bookmarks.Bookmark)context2).getLine());
        } else if (object instanceof DirectoryUrl) {
            String string2 = ((DirectoryUrl)context2).getURL();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.url");
            bookmark = LineBookmarkProvider.createBookmark$default(this, string2, 0, 2, null);
        } else if (object instanceof PsiFileUrl) {
            String string3 = ((PsiFileUrl)context2).getURL();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.url");
            bookmark = LineBookmarkProvider.createBookmark$default(this, string3, 0, 2, null);
        } else if (object instanceof PsiElement) {
            bookmark = this.createBookmark((PsiElement)context2);
        } else if (object instanceof VirtualFile) {
            bookmark = this.createBookmark((VirtualFile)context2, -1);
        } else if (object instanceof ProjectFileNode) {
            VirtualFile virtualFile3 = ((ProjectFileNode)context2).getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"context.virtualFile");
            bookmark = LineBookmarkProvider.createBookmark$default(this, virtualFile3, 0, 2, null);
        } else {
            bookmark = object instanceof TreePath ? (Bookmark)this.createBookmark((TreePath)context2) : null;
        }
        return bookmark;
    }

    @Nullable
    public final FileBookmark createBookmark(@NotNull VirtualFile file2, int line) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return !file2.isValid() || file2 instanceof LightVirtualFile ? null : (line >= 0 ? (FileBookmark)new LineBookmarkImpl(this, file2, line) : (FileBookmark)new FileBookmarkImpl(this, file2));
    }

    public static /* synthetic */ FileBookmark createBookmark$default(LineBookmarkProvider lineBookmarkProvider, VirtualFile virtualFile2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return lineBookmarkProvider.createBookmark(virtualFile2, n);
    }

    @Nullable
    public final FileBookmark createBookmark(@NotNull Editor editor2, @Nullable Integer line) {
        int n;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (editor2.isOneLineMode()) {
            return null;
        }
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(editor2.getDocument());
        if (virtualFile2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"FileDocumentManager.getI\u2026.document) ?: return null");
        VirtualFile file2 = virtualFile2;
        Integer n2 = line;
        if (n2 != null) {
            n = n2;
        } else {
            CaretModel caretModel = editor2.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
            n = caretModel.getLogicalPosition().line;
        }
        return this.createBookmark(file2, n);
    }

    public static /* synthetic */ FileBookmark createBookmark$default(LineBookmarkProvider lineBookmarkProvider, Editor editor2, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return lineBookmarkProvider.createBookmark(editor2, n);
    }

    private final Bookmark createBookmark(String url, int line) {
        FileBookmark fileBookmark = this.createValidBookmark(url, line);
        return fileBookmark != null ? (Bookmark)fileBookmark : (Bookmark)this.createInvalidBookmark(url, line);
    }

    static /* synthetic */ Bookmark createBookmark$default(LineBookmarkProvider lineBookmarkProvider, String string2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return lineBookmarkProvider.createBookmark(string2, n);
    }

    private final FileBookmark createValidBookmark(String url, int line) {
        FileBookmark fileBookmark;
        VirtualFile virtualFile2 = this.getVFM().findFileByUrl(url);
        if (virtualFile2 != null) {
            VirtualFile virtualFile3;
            VirtualFile it = virtualFile3 = virtualFile2;
            boolean bl = false;
            VirtualFile virtualFile4 = it;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"it");
            fileBookmark = this.createBookmark(virtualFile4, line);
        } else {
            fileBookmark = null;
        }
        return fileBookmark;
    }

    static /* synthetic */ FileBookmark createValidBookmark$default(LineBookmarkProvider lineBookmarkProvider, String string2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return lineBookmarkProvider.createValidBookmark(string2, n);
    }

    private final InvalidBookmark createInvalidBookmark(String url, int line) {
        return new InvalidBookmark(this, url, line);
    }

    static /* synthetic */ InvalidBookmark createInvalidBookmark$default(LineBookmarkProvider lineBookmarkProvider, String string2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return lineBookmarkProvider.createInvalidBookmark(string2, n);
    }

    private final FileBookmark createBookmark(PsiElement element2) {
        if (element2 instanceof PsiFileSystemItem) {
            FileBookmark fileBookmark;
            VirtualFile virtualFile2 = ((PsiFileSystemItem)element2).getVirtualFile();
            if (virtualFile2 != null) {
                VirtualFile virtualFile3;
                VirtualFile it = virtualFile3 = virtualFile2;
                boolean bl = false;
                fileBookmark = LineBookmarkProvider.createBookmark$default(this, it, 0, 2, null);
            } else {
                fileBookmark = null;
            }
            return fileBookmark;
        }
        if (element2 instanceof PsiCompiledElement) {
            return null;
        }
        VirtualFile virtualFile4 = PsiUtilCore.getVirtualFile(element2);
        if (virtualFile4 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"PsiUtilCore.getVirtualFile(element) ?: return null");
        VirtualFile file2 = virtualFile4;
        if (file2 instanceof LightVirtualFile) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        if (document == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"FileDocumentManager.getI\u2026ment(file) ?: return null");
        Document document2 = document;
        int offset = element2.getTextOffset();
        int n = offset;
        return 0 <= n && document2.getTextLength() >= n ? this.createBookmark(file2, document2.getLineNumber(offset)) : null;
    }

    private final FileBookmark createBookmark(TreePath path2) {
        VirtualFile virtualFile2 = this.getAsVirtualFile(path2);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file2 = virtualFile2;
        Serializable serializable = path2.getParentPath();
        if (serializable == null || (serializable = this.getAsVirtualFile((TreePath)serializable)) == null) {
            return null;
        }
        Serializable parent = serializable;
        return !((VirtualFile)parent).isDirectory() || Intrinsics.areEqual((Object)file2.getParent(), (Object)parent) ^ true ? null : LineBookmarkProvider.createBookmark$default(this, file2, 0, 2, null);
    }

    private final VirtualFile getAsVirtualFile(TreePath $this$asVirtualFile) {
        ProjectViewNode projectViewNode = (ProjectViewNode)((Object)TreeUtil.getLastUserObject(ProjectViewNode.class, (TreePath)$this$asVirtualFile));
        if (projectViewNode == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)((Object)projectViewNode), (String)"TreeUtil.getLastUserObje\u2026ava, this) ?: return null");
        ProjectViewNode node2 = projectViewNode;
        VirtualFile virtualFile2 = node2.getVirtualFile();
        if (virtualFile2 != null) {
            VirtualFile virtualFile3;
            VirtualFile it = virtualFile3 = virtualFile2;
            boolean bl = false;
            return it;
        }
        Object nodeValue = node2.getEqualityObject();
        return nodeValue instanceof SmartPointerEx ? ((SmartPointerEx)nodeValue).getVirtualFile() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUnexpected(MouseEvent $this$isUnexpected) {
        if (!SwingUtilities.isLeftMouseButton($this$isUnexpected)) return true;
        if ($this$isUnexpected.isPopupTrigger()) return true;
        if (SystemInfo.isMac) {
            if ($this$isUnexpected.isMetaDown()) return false;
            return true;
        }
        if ($this$isUnexpected.isControlDown()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUnexpected(EditorMouseEvent $this$isUnexpected) {
        if ($this$isUnexpected.isConsumed()) return true;
        if (Intrinsics.areEqual((Object)$this$isUnexpected.getArea(), (Object)EditorMouseEventArea.LINE_MARKERS_AREA) ^ true) return true;
        MouseEvent mouseEvent = $this$isUnexpected.getMouseEvent();
        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"mouseEvent");
        if (!this.isUnexpected(mouseEvent)) return false;
        return true;
    }

    public void mouseClicked(@NotNull EditorMouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isUnexpected(event)) {
            return;
        }
        Editor editor2 = event.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"event.editor");
        Project project2 = editor2.getProject();
        if (project2 != null) {
            Project project3;
            Project it = project3 = project2;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)this.project) ^ true) {
                return;
            }
        }
        BookmarksManager bookmarksManager = BookmarksManager.getInstance(this.project);
        if (bookmarksManager == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)bookmarksManager, (String)"BookmarksManager.getInstance(project) ?: return");
        BookmarksManager manager = bookmarksManager;
        Editor editor3 = event.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"event.editor");
        FileBookmark fileBookmark = this.createBookmark(editor3, (Integer)event.getLogicalPosition().line);
        if (fileBookmark == null) {
            return;
        }
        FileBookmark bookmark = fileBookmark;
        BookmarkType bookmarkType = manager.getType(bookmark);
        if (bookmarkType != null) {
            BookmarkType bookmarkType2;
            BookmarkType it = bookmarkType2 = bookmarkType;
            boolean bl = false;
            manager.remove(bookmark);
        } else {
            manager.add(bookmark, BookmarkType.DEFAULT);
        }
        event.consume();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void afterDocumentChange(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        v0 = FileDocumentManager.getInstance().getFile(document);
        if (v0 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"FileDocumentManager.getI\u2026tFile(document) ?: return");
        file = v0;
        if (file instanceof LightVirtualFile) {
            return;
        }
        v1 = BookmarksManager.getInstance(this.project);
        if (v1 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"BookmarksManager.getInstance(project) ?: return");
        manager = v1;
        map = MapsKt.sortedMapOf((Comparator)new Comparator(){

            public final int compare(T a, T b) {
                LineBookmarkImpl it = (LineBookmarkImpl)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getLine());
                it = (LineBookmarkImpl)b;
                Comparable comparable2 = comparable;
                bl = false;
                Comparable comparable3 = Integer.valueOf(it.getLine());
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        }, (Pair[])new Pair[0]);
        set = new LinkedHashSet<E>();
        for (Bookmark bookmark : manager.getBookmarks()) {
            if (!(bookmark instanceof LineBookmarkImpl) || !Intrinsics.areEqual((Object)((LineBookmarkImpl)bookmark).getFile(), (Object)file)) continue;
            v2 = manager;
            if (!(v2 instanceof BookmarksManagerImpl)) {
                v2 = null;
            }
            if ((v3 = (rangeMarker = (v4 = (BookmarksManagerImpl)v2) != null && (v4 = v4.findLineHighlighter$intellij_platform_lang_impl(bookmark)) != null ? (RangeMarker)v4 : ((LineBookmarkImpl)bookmark).getDescriptor().getRangeMarker())) == null) ** GOTO lbl-1000
            it = var10_13 = v3;
            $i$a$-let-LineBookmarkProvider$afterDocumentChange$line$1 = false;
            v3 = it.isValid() != false ? Integer.valueOf(it.getDocument().getLineNumber(it.getStartOffset())) : null;
            if (v3 != null) {
                v5 = v3.intValue();
            } else lbl-1000:
            // 2 sources

            {
                v5 = -1;
            }
            line = v5;
            var10_12 = ((LineBookmarkImpl)bookmark).getLine();
            if (var10_12 == line) {
                set.add(line);
                continue;
            }
            ((Map)map).put(bookmark, line);
        }
        if (map.isEmpty()) {
            return;
        }
        bookmarks = new LinkedHashMap<K, V>();
        $this$forEach$iv = map;
        $i$f$forEach = false;
        var9_11 = $this$forEach$iv.entrySet().iterator();
        while (var9_11.hasNext()) {
            $dstr$bookmark$line = element$iv = var9_11.next();
            $i$a$-forEach-LineBookmarkProvider$afterDocumentChange$1 = false;
            var13_17 = $dstr$bookmark$line;
            var14_18 = (LineBookmarkImpl)var13_17.getKey();
            var13_17 = $dstr$bookmark$line;
            line = (Integer)var13_17.getValue();
            v6 = bookmark;
            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"bookmark");
            if (line < 0 || set.contains(line)) {
                v7 = null;
            } else {
                v8 = line;
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"line");
                set.add(v8);
                v7 = this.createBookmark(file, (int)line);
            }
            bookmarks.put(v6, v7);
        }
        manager.update(bookmarks);
    }

    @Override
    @Nullable
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
        boolean update2;
        block4: {
            boolean bl;
            Intrinsics.checkNotNullParameter(events, (String)"events");
            Iterable $this$any$iv = events;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VFileEvent it = (VFileEvent)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof VFileCreateEvent || it instanceof VFileDeleteEvent)) continue;
                    bl = true;
                    break block4;
                }
                bl = update2 = false;
            }
        }
        if (update2) {
            SingleAlarm.cancelAndRequest$default((SingleAlarm)this.validateAlarm, (boolean)false, (int)1, null);
        }
        return null;
    }

    private final void validateAndUpdate() {
        BookmarksManager bookmarksManager = BookmarksManager.getInstance(this.project);
        if (bookmarksManager == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)bookmarksManager, (String)"BookmarksManager.getInstance(project) ?: return");
        BookmarksManager manager = bookmarksManager;
        Map bookmarks = new LinkedHashMap();
        List<Bookmark> list2 = manager.getBookmarks();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"manager.bookmarks");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Bookmark bookmark;
            Bookmark it = (Bookmark)element$iv;
            boolean bl = false;
            Bookmark bookmark2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)bookmark2, (String)"it");
            if (this.validate(bookmark2) == null) continue;
            Bookmark $this$run = bookmark;
            boolean bl2 = false;
            bookmarks.put(it, $this$run);
        }
        manager.update(bookmarks);
    }

    private final Bookmark validate(Bookmark bookmark) {
        Bookmark bookmark2;
        Bookmark bookmark3 = bookmark;
        if (bookmark3 instanceof InvalidBookmark) {
            bookmark2 = this.createValidBookmark(((InvalidBookmark)bookmark).getUrl(), ((InvalidBookmark)bookmark).getLine());
        } else if (bookmark3 instanceof FileBookmarkImpl) {
            VirtualFile virtualFile2;
            VirtualFile $this$run = virtualFile2 = ((FileBookmarkImpl)bookmark).getFile();
            boolean bl = false;
            if ($this$run.isValid()) {
                bookmark2 = null;
            } else {
                String string2 = $this$run.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"url");
                bookmark2 = LineBookmarkProvider.createBookmark$default(this, string2, 0, 2, null);
            }
        } else if (bookmark3 instanceof LineBookmarkImpl) {
            VirtualFile virtualFile3;
            VirtualFile $this$run = virtualFile3 = ((LineBookmarkImpl)bookmark).getFile();
            boolean bl = false;
            if ($this$run.isValid()) {
                bookmark2 = null;
            } else {
                String string3 = $this$run.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"url");
                bookmark2 = this.createBookmark(string3, ((LineBookmarkImpl)bookmark).getLine());
            }
        } else {
            bookmark2 = null;
        }
        return bookmark2;
    }

    private final boolean isNodeVisible(AbstractTreeNode<?> node2) {
        boolean bl;
        Object object = node2.getValue();
        if (!(object instanceof InvalidBookmark)) {
            object = null;
        }
        InvalidBookmark invalidBookmark = (InvalidBookmark)object;
        if (invalidBookmark != null) {
            InvalidBookmark invalidBookmark2;
            InvalidBookmark $this$run = invalidBookmark2 = invalidBookmark;
            boolean bl2 = false;
            bl = $this$run.getLine() < 0;
        } else {
            bl = true;
        }
        return bl;
    }

    private final VirtualFileManager getVFM() {
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"VirtualFileManager.getInstance()");
        return virtualFileManager;
    }

    public LineBookmarkProvider(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        Function0 function0 = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                LineBookmarkProvider.access$validateAndUpdate((LineBookmarkProvider)this.receiver);
            }
        };
        this.validateAlarm = new SingleAlarm(new Runnable(function0){
            private final /* synthetic */ Function0 function;
            {
                this.function = function0;
            }

            public final /* synthetic */ void run() {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
            }
        }, 100, (Disposable)this.project, Alarm.ThreadToUse.POOLED_THREAD, null, 16, null);
        if (!this.project.isDefault()) {
            EditorFactory editorFactory = EditorFactory.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)editorFactory, (String)"EditorFactory.getInstance()");
            EditorEventMulticaster editorEventMulticaster = editorFactory.getEventMulticaster();
            Intrinsics.checkNotNullExpressionValue((Object)editorEventMulticaster, (String)"EditorFactory.getInstance().eventMulticaster");
            EditorEventMulticaster multicaster = editorEventMulticaster;
            multicaster.addDocumentListener((DocumentListener)this, (Disposable)this.project);
            multicaster.addEditorMouseListener((EditorMouseListener)this, (Disposable)this.project);
            this.getVFM().addAsyncFileListener(this, this.project);
        }
    }

    public static final /* synthetic */ void access$validateAndUpdate(LineBookmarkProvider $this) {
        $this.validateAndUpdate();
    }

    @JvmStatic
    @Nullable
    public static final LineBookmarkProvider find(@NotNull Project project2) {
        return Companion.find(project2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/bookmark/providers/LineBookmarkProvider$Companion;", "", "()V", "find", "Lcom/intellij/ide/bookmark/providers/LineBookmarkProvider;", "project", "Lcom/intellij/openapi/project/Project;", "readLineText", "", "bookmark", "Lcom/intellij/ide/bookmark/LineBookmark;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "intellij.platform.lang.impl"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final LineBookmarkProvider find(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return project2.isDisposed() ? null : BookmarkProvider.EP.findExtension(LineBookmarkProvider.class, project2);
        }

        @Nullable
        public final String readLineText(@Nullable LineBookmark bookmark) {
            String string2;
            LineBookmark lineBookmark = bookmark;
            if (lineBookmark != null) {
                LineBookmark lineBookmark2;
                LineBookmark it = lineBookmark2 = lineBookmark;
                boolean bl = false;
                string2 = Companion.readLineText(it.getFile(), it.getLine());
            } else {
                string2 = null;
            }
            return string2;
        }

        @Nullable
        public final String readLineText(@NotNull VirtualFile file2, int line) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Document document = FileDocumentManager.getInstance().getDocument(file2);
            if (document == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"FileDocumentManager.getI\u2026ment(file) ?: return null");
            Document document2 = document;
            if (line < 0 || document2.getLineCount() <= line) {
                return null;
            }
            int start2 = document2.getLineStartOffset(line);
            if (start2 < 0) {
                return null;
            }
            int end = document2.getLineEndOffset(line);
            if (end < start2) {
                return null;
            }
            return document2.getText(TextRange.create(start2, end));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

