/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.providers;

import com.intellij.ide.bookmark.LineBookmark;
import com.intellij.ide.bookmark.providers.LineBookmarkProvider;
import com.intellij.ide.bookmark.ui.tree.LineNode;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0013\u0010\u001e\u001a\u00020\u001a2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0096\u0002J\b\u0010!\u001a\u00020\u0007H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001aH\u0016J\b\u0010%\u001a\u00020\u000bH\u0016R \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006&"}, d2={"Lcom/intellij/ide/bookmark/providers/LineBookmarkImpl;", "Lcom/intellij/ide/bookmark/LineBookmark;", "provider", "Lcom/intellij/ide/bookmark/providers/LineBookmarkProvider;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "(Lcom/intellij/ide/bookmark/providers/LineBookmarkProvider;Lcom/intellij/openapi/vfs/VirtualFile;I)V", "attributes", "", "", "getAttributes", "()Ljava/util/Map;", "descriptor", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "getDescriptor", "()Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "Lorg/jetbrains/annotations/NotNull;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getLine", "()I", "getProvider", "()Lcom/intellij/ide/bookmark/providers/LineBookmarkProvider;", "canNavigate", "", "canNavigateToSource", "createNode", "Lcom/intellij/ide/bookmark/ui/tree/LineNode;", "equals", "other", "", "hashCode", "navigate", "", "requestFocus", "toString", "intellij.platform.lang.impl"})
public final class LineBookmarkImpl
implements LineBookmark {
    @NotNull
    private final OpenFileDescriptor descriptor;
    @NotNull
    private final LineBookmarkProvider provider;

    @NotNull
    public final OpenFileDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile2 = this.descriptor.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"descriptor.file");
        return virtualFile2;
    }

    @Override
    public int getLine() {
        return this.descriptor.getLine();
    }

    @Override
    @NotNull
    public Map<String, String> getAttributes() {
        return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"url", (Object)this.getFile().getUrl()), TuplesKt.to((Object)"line", (Object)String.valueOf(this.getLine()))});
    }

    @NotNull
    public LineNode createNode() {
        return new LineNode(this.getProvider().getProject(), this);
    }

    @Override
    public boolean canNavigate() {
        return !this.getProvider().getProject().isDisposed() && this.descriptor.canNavigate();
    }

    @Override
    public boolean canNavigateToSource() {
        return !this.getFile().isDirectory() && this.canNavigate();
    }

    @Override
    public void navigate(boolean requestFocus) {
        this.descriptor.navigate(requestFocus);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getProvider(), this.getFile(), this.getLine());
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof LineBookmarkImpl && Intrinsics.areEqual((Object)((LineBookmarkImpl)other).getProvider(), (Object)this.getProvider()) && Intrinsics.areEqual((Object)((LineBookmarkImpl)other).getFile(), (Object)this.getFile()) && ((LineBookmarkImpl)other).getLine() == this.getLine();
    }

    @NotNull
    public String toString() {
        return "LineBookmarkImpl(line=" + this.getLine() + ",file=" + this.getFile() + ",provider=" + this.getProvider() + ")";
    }

    @Override
    @NotNull
    public LineBookmarkProvider getProvider() {
        return this.provider;
    }

    public LineBookmarkImpl(@NotNull LineBookmarkProvider provider2, @NotNull VirtualFile file2, int line) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.provider = provider2;
        this.descriptor = new OpenFileDescriptor(this.getProvider().getProject(), file2, line, 0);
    }
}

