/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.actions;

import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.actions.BookmarkTypeChooserKt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0001%B?\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\u0002\u0010\fJ\u0019\u0010\r\u001a\u0015\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u000e\u00a2\u0006\u0002\b\u0011J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0004J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\"\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J*\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001dH\u0002J\u0010\u0010$\u001a\u00020\t2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/ide/bookmark/actions/BookmarkLayoutGrid;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Ljava/awt/event/KeyListener;", "current", "Lcom/intellij/ide/bookmark/BookmarkType;", "assigned", "", "onChosen", "Lkotlin/Function1;", "", "save", "Lkotlin/Function0;", "(Lcom/intellij/ide/bookmark/BookmarkType;Ljava/util/Set;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "buttons", "Lcom/intellij/util/containers/JBIterable;", "Ljavax/swing/JButton;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "createButton", "type", "keyPressed", "event", "Ljava/awt/event/KeyEvent;", "keyReleased", "keyTyped", "next", "Ljava/awt/Component;", "source", "dx", "", "dy", "point", "Ljava/awt/Point;", "offset", "delta", "size", "updateButtons", "Companion", "intellij.platform.lang.impl"})
final class BookmarkLayoutGrid
extends BorderLayoutPanel
implements KeyListener {
    private final Set<BookmarkType> assigned;
    private final Function1<BookmarkType, Unit> onChosen;
    private final Function0<Unit> save;
    @NotNull
    public static final String TYPE_KEY = "BookmarkLayoutGrid.Type";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final JBIterable<JButton> buttons() {
        JBIterable<JButton> jBIterable = UIUtil.uiTraverser(this).traverse().filter(JButton.class);
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"UIUtil.uiTraverser(this)\u2026lter(JButton::class.java)");
        return jBIterable;
    }

    @NotNull
    public final JButton createButton(@NotNull BookmarkType type) {
        JButton jButton;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        JButton $this$apply = jButton = new JButton(String.valueOf(type.getMnemonic()));
        boolean bl = false;
        $this$apply.setMnemonic(type.getMnemonic());
        $this$apply.putClientProperty("ActionToolbar.smallVariant", true);
        $this$apply.putClientProperty(TYPE_KEY, (Object)type);
        $this$apply.addPropertyChangeListener(new PropertyChangeListener($this$apply){
            final /* synthetic */ JButton $this_apply;

            public final void propertyChange(PropertyChangeEvent it) {
                this.$this_apply.repaint();
            }
            {
                this.$this_apply = jButton;
            }
        });
        $this$apply.addActionListener(new ActionListener(this, type){
            final /* synthetic */ BookmarkLayoutGrid this$0;
            final /* synthetic */ BookmarkType $type$inlined;
            {
                this.this$0 = bookmarkLayoutGrid2;
                this.$type$inlined = bookmarkType;
            }

            public final void actionPerformed(ActionEvent it) {
                BookmarkLayoutGrid.access$getOnChosen$p(this.this$0).invoke((Object)((Object)this.$type$inlined));
                this.this$0.updateButtons(this.$type$inlined);
            }
        });
        $this$apply.getInputMap().put(KeyStroke.getKeyStroke(10, 0, true), "released");
        $this$apply.getInputMap().put(KeyStroke.getKeyStroke(10, 0, false), "pressed");
        $this$apply.setCursor(BookmarkTypeChooserKt.access$getSHARED_CURSOR$p());
        JButton it = jButton;
        boolean bl2 = false;
        it.addKeyListener(this);
        return jButton;
    }

    public final void updateButtons(@Nullable BookmarkType current) {
        Iterable $this$forEach$iv = this.buttons();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JButton it = (JButton)element$iv;
            boolean bl = false;
            Object object = it.getClientProperty(TYPE_KEY);
            if (!(object instanceof BookmarkType)) {
                object = null;
            }
            BookmarkType type = (BookmarkType)((Object)object);
            if (type == current) {
                it.putClientProperty("JButton.textColor", BookmarkTypeChooserKt.access$getCURRENT_FOREGROUND$p());
                it.putClientProperty("JButton.backgroundColor", BookmarkTypeChooserKt.access$getCURRENT_BACKGROUND$p());
                it.putClientProperty("JButton.borderColor", BookmarkTypeChooserKt.access$getCURRENT_BORDER$p());
                continue;
            }
            if (CollectionsKt.contains((Iterable)this.assigned, (Object)((Object)type))) {
                it.putClientProperty("JButton.textColor", BookmarkTypeChooserKt.access$getASSIGNED_FOREGROUND$p());
                it.putClientProperty("JButton.backgroundColor", BookmarkTypeChooserKt.access$getASSIGNED_BACKGROUND$p());
                it.putClientProperty("JButton.borderColor", BookmarkTypeChooserKt.access$getASSIGNED_BORDER$p());
                continue;
            }
            it.putClientProperty("JButton.textColor", UIManager.getColor("BookmarkMnemonicAvailable.buttonForeground"));
            it.putClientProperty("JButton.backgroundColor", UIManager.getColor("BookmarkMnemonicAvailable.buttonBackground"));
            it.putClientProperty("JButton.borderColor", UIManager.getColor("BookmarkMnemonicAvailable.borderColor"));
        }
    }

    private final int offset(int delta, int size) {
        return delta < 0 ? delta : (delta > 0 ? delta + size : size / 2);
    }

    private final Component next(Component source, int dx, int dy) {
        Point point;
        Point point2 = point = SwingUtilities.convertPoint(source, this.offset(dx, source.getWidth()), this.offset(dy, source.getHeight()), this);
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"point");
        Component component2 = this.next(source, dx, dy, point2);
        if (component2 != null || !Registry.is("ide.bookmark.mnemonic.chooser.cyclic.scrolling.allowed")) {
            return component2;
        }
        if (dx > 0) {
            point.x = 0;
        }
        if (dx < 0) {
            point.x = dx + this.getWidth();
        }
        if (dy > 0) {
            point.y = 0;
        }
        if (dy < 0) {
            point.y = dy + this.getHeight();
        }
        return this.next(source, dx, dy, point);
    }

    private final Component next(Component source, int dx, int dy, Point point) {
        while (this.contains(point)) {
            Component component2 = SwingUtilities.getDeepestComponentAt(this, point.x, point.y);
            if (component2 instanceof JButton) {
                return component2;
            }
            point.translate(dx * source.getWidth() / 2, dy * source.getHeight() / 2);
        }
        return null;
    }

    @Override
    public void keyTyped(@NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    @Override
    public void keyReleased(@NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    @Override
    public void keyPressed(@NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getModifiersEx() == 0) {
            switch (event.getKeyCode()) {
                case 38: 
                case 224: {
                    Component component2 = event.getComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"event.component");
                    Component component3 = this.next(component2, 0, -1);
                    if (component3 != null) {
                        component3.requestFocus();
                    }
                    break;
                }
                case 40: 
                case 225: {
                    Component component4 = event.getComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)component4, (String)"event.component");
                    Component component5 = this.next(component4, 0, 1);
                    if (component5 != null) {
                        component5.requestFocus();
                    }
                    break;
                }
                case 37: 
                case 226: {
                    Component component6 = event.getComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)component6, (String)"event.component");
                    Component component7 = this.next(component6, -1, 0);
                    if (component7 != null) {
                        component7.requestFocus();
                    }
                    break;
                }
                case 39: 
                case 227: {
                    Component component8 = event.getComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)component8, (String)"event.component");
                    Component component9 = this.next(component8, 1, 0);
                    if (component9 != null) {
                        component9.requestFocus();
                    }
                    break;
                }
                case 10: {
                    JButton button2;
                    Component component10 = event.getComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)component10, (String)"event.component");
                    Component component11 = this.next(component10, 0, 0);
                    if (!(component11 instanceof JButton)) {
                        component11 = null;
                    }
                    JButton jButton = button2 = (JButton)component11;
                    if (jButton != null) {
                        jButton.doClick();
                    }
                    this.save.invoke();
                    break;
                }
                default: {
                    BookmarkType type = BookmarkType.Companion.get((char)event.getKeyCode());
                    if (type == BookmarkType.DEFAULT) break;
                    this.onChosen.invoke((Object)type);
                    this.save.invoke();
                }
            }
        }
    }

    public BookmarkLayoutGrid(@Nullable BookmarkType current, @NotNull Set<? extends BookmarkType> assigned, @NotNull Function1<? super BookmarkType, Unit> onChosen2, @NotNull Function0<Unit> save) {
        int n;
        BookmarkType[] $this$forEach$iv;
        char c;
        Object it;
        Object element$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        JPanel $this$apply;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter(assigned, (String)"assigned");
        Intrinsics.checkNotNullParameter(onChosen2, (String)"onChosen");
        Intrinsics.checkNotNullParameter(save, (String)"save");
        this.assigned = assigned;
        this.onChosen = onChosen2;
        this.save = save;
        JPanel jPanel2 = jPanel = new JPanel((LayoutManager)((Object)BookmarkTypeChooserKt.access$getSHARED_LAYOUT$p()));
        BookmarkLayoutGrid bookmarkLayoutGrid2 = this;
        boolean bl = false;
        $this$apply.setBorder(JBUI.Borders.empty(5));
        BookmarkType[] bookmarkTypeArray = BookmarkType.values();
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection collection = new ArrayList();
        boolean $i$f$filterTo = false;
        int n2 = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n2; ++i) {
            it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl2 = false;
            c = ((BookmarkType)((Object)it)).getMnemonic();
            if (!Character.isDigit(c)) continue;
            collection.add(element$iv$iv);
        }
        $this$filter$iv = (List)collection;
        boolean $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            BookmarkType it2 = (BookmarkType)((Object)t);
            n = 0;
            $this$apply.add(this.createButton(it2));
        }
        Unit unit = Unit.INSTANCE;
        bookmarkLayoutGrid2.addToLeft(jPanel);
        $this$apply = jPanel = new JPanel((LayoutManager)((Object)BookmarkTypeChooserKt.access$getSHARED_LAYOUT$p()));
        bookmarkLayoutGrid2 = this;
        boolean bl3 = false;
        $this$apply.setBorder(JBUI.Borders.empty(5));
        $this$forEach$iv = BookmarkType.values();
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        Collection collection2 = new ArrayList();
        $i$f$filterTo = false;
        n2 = ((Object)$this$filterTo$iv$iv).length;
        for (n = 0; n < n2; ++n) {
            it = element$iv$iv = $this$filterTo$iv$iv[n];
            boolean bl4 = false;
            c = ((BookmarkType)((Object)it)).getMnemonic();
            if (!Character.isLetter(c)) continue;
            collection2.add(element$iv$iv);
        }
        $this$filter$iv = (List)collection2;
        $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            BookmarkType it3 = (BookmarkType)((Object)t);
            boolean bl5 = false;
            $this$apply.add(this.createButton(it3));
        }
        unit = Unit.INSTANCE;
        bookmarkLayoutGrid2.addToRight(jPanel);
        this.updateButtons(current);
    }

    public static final /* synthetic */ Function1 access$getOnChosen$p(BookmarkLayoutGrid $this) {
        return $this.onChosen;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ide/bookmark/actions/BookmarkLayoutGrid$Companion;", "", "()V", "TYPE_KEY", "", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

