/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorValidationRule;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.gotoByName.FileTypeRef;
import com.intellij.ide.util.gotoByName.LanguageRef;
import com.intellij.internal.statistic.collectors.fus.LangCustomRuleValidator;
import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsagesCollector;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;

public class SearchEverywhereFiltersStatisticsCollector
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("search.everywhere.filters", 2);
    private static final EventId2<String, Boolean> FILE_TYPE_CHANGED_EVENT = GROUP.registerEvent("file.type.changed", (EventField)EventFields.StringValidatedByCustomRule((String)"fileType", FileTypeUsagesCollector.ValidationRule.class), (EventField)EventFields.Boolean((String)"enabled"));
    private static final EventId2<String, Boolean> LANG_CHANGED_EVENT = GROUP.registerEvent("lang.changed", (EventField)EventFields.StringValidatedByCustomRule((String)"langID", LangCustomRuleValidator.class), (EventField)EventFields.Boolean((String)"enabled"));
    private static final EventId2<String, Boolean> CONTRIBUTOR_CHANGED_EVENT = GROUP.registerEvent("contributor.changed", (EventField)EventFields.StringValidatedByCustomRule((String)"contributorID", SearchEverywhereContributorValidationRule.class), (EventField)EventFields.Boolean((String)"enabled"));
    private static final EventId1<QuickFilterButtons> BUTTON_PRESSED_EVENT = GROUP.registerEvent("quick.filter.button", (EventField)EventFields.Enum((String)"buttonName", QuickFilterButtons.class));

    public EventLogGroup getGroup() {
        return GROUP;
    }

    public static class ContributorFilterCollector
    extends BaseFilterStatisticsCollector<String> {
        public void elementMarkChanged(String contributorID, boolean isMarked) {
            CONTRIBUTOR_CHANGED_EVENT.log((Object)contributorID, (Object)isMarked);
        }
    }

    public static class LangFilterCollector
    extends BaseFilterStatisticsCollector<LanguageRef> {
        public void elementMarkChanged(LanguageRef element2, boolean isMarked) {
            LANG_CHANGED_EVENT.log((Object)element2.getId(), (Object)isMarked);
        }
    }

    public static class FileTypeFilterCollector
    extends BaseFilterStatisticsCollector<FileTypeRef> {
        public void elementMarkChanged(FileTypeRef element2, boolean isMarked) {
            FILE_TYPE_CHANGED_EVENT.log((Object)element2.getName(), (Object)isMarked);
        }
    }

    public static abstract class BaseFilterStatisticsCollector<T>
    implements ElementsChooser.StatisticsCollector<T> {
        public void selectionInverted() {
            BUTTON_PRESSED_EVENT.log((Object)QuickFilterButtons.INVERT);
        }

        public void allSelected() {
            BUTTON_PRESSED_EVENT.log((Object)QuickFilterButtons.ALL);
        }

        public void noneSelected() {
            BUTTON_PRESSED_EVENT.log((Object)QuickFilterButtons.NONE);
        }
    }

    public static enum FilterTypes {
        LANGUAGE,
        FILE_TYPE,
        CONTRIBUTORS;

    }

    public static enum QuickFilterButtons {
        ALL,
        NONE,
        INVERT;

    }
}

