/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.searcheverywhere.CalculatorSEContributor;
import com.intellij.ide.actions.searcheverywhere.MixedSearchListModel;
import com.intellij.ide.actions.searcheverywhere.RecentFilesSEContributor;
import com.intellij.ide.actions.searcheverywhere.SEResultsListFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereHeader;
import com.intellij.ide.actions.searcheverywhere.SearchListModel;
import com.intellij.ide.actions.searcheverywhere.TopHitSEContributor;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.JBList;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;

class MixedListFactory
extends SEResultsListFactory {
    private final List<String> prioritizedContributors = new ArrayList<String>();

    MixedListFactory() {
        this.prioritizedContributors.add(CalculatorSEContributor.class.getName());
        this.prioritizedContributors.add("AutocompletionContributor");
        this.prioritizedContributors.add("CommandsContributor");
        this.prioritizedContributors.add(TopHitSEContributor.class.getSimpleName());
        if (Registry.is("search.everywhere.recent.at.top")) {
            this.prioritizedContributors.add(RecentFilesSEContributor.class.getSimpleName());
        }
    }

    @Override
    public SearchListModel createModel() {
        MixedSearchListModel mixedModel = new MixedSearchListModel();
        Map<String, Integer> priorities = this.getContributorsPriorities();
        Comparator prioritizedContributorsComparator = (element1, element2) -> {
            int firstElementPriority = priorities.getOrDefault(element1.getContributor().getSearchProviderId(), 0);
            int secondElementPriority = priorities.getOrDefault(element2.getContributor().getSearchProviderId(), 0);
            return Integer.compare(firstElementPriority, secondElementPriority);
        };
        Comparator<SearchEverywhereFoundElementInfo> comparator2 = prioritizedContributorsComparator.thenComparing(SearchEverywhereFoundElementInfo.COMPARATOR).reversed();
        mixedModel.setElementsComparator(comparator2);
        return mixedModel;
    }

    @NotNull
    public Map<String, Integer> getContributorsPriorities() {
        HashMap<String, Integer> priorities = new HashMap<String, Integer>();
        for (int i = 0; i < this.prioritizedContributors.size(); ++i) {
            priorities.put(this.prioritizedContributors.get(i), this.prioritizedContributors.size() - i);
        }
        HashMap<String, Integer> hashMap = priorities;
        if (hashMap == null) {
            MixedListFactory.$$$reportNull$$$0(0);
        }
        return hashMap;
    }

    @Override
    public JBList<Object> createList(SearchListModel model2) {
        return new JBList((ListModel)model2);
    }

    @Override
    ListCellRenderer<Object> createListRenderer(final SearchListModel model2, SearchEverywhereHeader header) {
        return new ListCellRenderer<Object>(){
            private final Map<String, ListCellRenderer<? super Object>> myRenderersCache = new HashMap<String, ListCellRenderer<? super Object>>();

            @Override
            public Component getListCellRendererComponent(JList<?> list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == SearchListModel.MORE_ELEMENT) {
                    return MixedListFactory.this.getMoreElementRenderer(list2, index, isSelected, cellHasFocus);
                }
                return MixedListFactory.this.getNonMoreElementRenderer(list2, value, index, isSelected, cellHasFocus, model2, this.myRenderersCache);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/searcheverywhere/MixedListFactory", "getContributorsPriorities"));
    }
}

