/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.ide.actions.searcheverywhere.SearchListModel;
import com.intellij.util.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GroupedSearchListModel
extends SearchListModel {
    GroupedSearchListModel() {
    }

    public boolean hasMoreElements(SearchEverywhereContributor contributor) {
        return this.listElements.stream().anyMatch(info -> info.getElement() == MORE_ELEMENT && info.getContributor() == contributor);
    }

    @Override
    public void addElements(List<? extends SearchEverywhereFoundElementInfo> items) {
        if (items.isEmpty()) {
            return;
        }
        HashMap<SearchEverywhereContributor, List> itemsMap = new HashMap<SearchEverywhereContributor, List>();
        items.forEach(info -> {
            List list2 = itemsMap.computeIfAbsent(info.getContributor(), contributor -> new ArrayList());
            list2.add(info);
        });
        itemsMap.forEach((contributor, list2) -> list2.sort(Comparator.comparingInt(SearchEverywhereFoundElementInfo::getPriority).reversed()));
        if (this.resultsExpired) {
            this.retainContributors(itemsMap.keySet());
            this.clearMoreItems();
            itemsMap.forEach((contributor, list2) -> {
                Range<Integer> range = this.getRangeForContributor((SearchEverywhereContributor<?>)contributor);
                if (range != null) {
                    this.listElements.subList(range.getFrom(), range.getTo() + 1).clear();
                    this.fireIntervalRemoved(this, range.getFrom(), range.getTo());
                }
                int insertionPoint = range != null ? range.getFrom().intValue() : this.getInsertionPoint((SearchEverywhereContributor)contributor);
                this.listElements.addAll(insertionPoint, list2);
                this.fireIntervalAdded(this, insertionPoint, insertionPoint + list2.size() - 1);
            });
            this.resultsExpired = false;
        } else {
            itemsMap.forEach((contributor, list2) -> {
                int startIndex = this.contributors().indexOf(contributor);
                int insertionIndex = this.getInsertionPoint((SearchEverywhereContributor)contributor);
                int endIndex = insertionIndex + list2.size() - 1;
                this.listElements.addAll(insertionIndex, list2);
                this.fireIntervalAdded(this, insertionIndex, endIndex);
                if (startIndex >= 0) {
                    this.listElements.subList(startIndex, endIndex + 1).sort(Comparator.comparingInt(SearchEverywhereFoundElementInfo::getPriority).reversed());
                    this.fireContentsChanged(this, startIndex, endIndex);
                }
            });
        }
    }

    private void retainContributors(Collection<SearchEverywhereContributor<?>> retainContributors) {
        Iterator iterator = this.listElements.iterator();
        int startInterval = 0;
        int endInterval = -1;
        while (iterator.hasNext()) {
            SearchEverywhereFoundElementInfo item = (SearchEverywhereFoundElementInfo)iterator.next();
            if (retainContributors.contains(item.getContributor())) {
                if (startInterval <= endInterval) {
                    this.fireIntervalRemoved(this, startInterval, endInterval);
                    startInterval = endInterval + 2;
                } else {
                    ++startInterval;
                }
            } else {
                iterator.remove();
            }
            ++endInterval;
        }
        if (startInterval <= endInterval) {
            this.fireIntervalRemoved(this, startInterval, endInterval);
        }
    }

    @Override
    public void clearMoreItems() {
        ListIterator iterator = this.listElements.listIterator();
        while (iterator.hasNext()) {
            int index = iterator.nextIndex();
            if (((SearchEverywhereFoundElementInfo)iterator.next()).getElement() != MORE_ELEMENT) continue;
            iterator.remove();
            this.fireContentsChanged(this, index, index);
        }
    }

    @Override
    public void removeElement(@NotNull Object item, SearchEverywhereContributor<?> contributor) {
        int index;
        if (item == null) {
            GroupedSearchListModel.$$$reportNull$$$0(0);
        }
        if ((index = this.contributors().indexOf(contributor)) < 0) {
            return;
        }
        while (index < this.getSize() && ((SearchEverywhereFoundElementInfo)this.listElements.get(index)).getContributor() == contributor) {
            if (item.equals(this.getElementAt(index))) {
                this.listElements.remove(index);
                this.fireIntervalRemoved(this, index, index);
                return;
            }
            ++index;
        }
    }

    @Override
    public void setHasMore(SearchEverywhereContributor<?> contributor, boolean newVal) {
        int index = this.contributors().lastIndexOf(contributor);
        if (index < 0) {
            return;
        }
        boolean alreadyHas = this.isMoreElement(index);
        if (alreadyHas && !newVal) {
            this.listElements.remove(index);
            this.fireIntervalRemoved(this, index, index);
        }
        if (!alreadyHas && newVal) {
            this.listElements.add(++index, new SearchEverywhereFoundElementInfo(MORE_ELEMENT, 0, contributor));
            this.fireIntervalAdded(this, index, index);
        }
    }

    public boolean isGroupFirstItem(int index) {
        return index == 0 || ((SearchEverywhereFoundElementInfo)this.listElements.get(index)).getContributor() != ((SearchEverywhereFoundElementInfo)this.listElements.get(index - 1)).getContributor();
    }

    @Override
    public int getIndexToScroll(int currentIndex, boolean scrollDown) {
        int index = currentIndex;
        while ((index += scrollDown ? 1 : -1) >= 0 && index < this.getSize() && !this.isGroupFirstItem(index) && !this.isMoreElement(index)) {
        }
        return Integer.max(Integer.min(index, this.getSize() - 1), 0);
    }

    public int getItemsForContributor(SearchEverywhereContributor<?> contributor) {
        Range<Integer> range = this.getRangeForContributor(contributor);
        return range == null ? 0 : range.getTo() - range.getFrom() + 1;
    }

    @Nullable
    private Range<Integer> getRangeForContributor(SearchEverywhereContributor<?> contributor) {
        List<SearchEverywhereContributor> contributorsList = this.contributors();
        int first2 = contributorsList.indexOf(contributor);
        if (first2 < 0) {
            return null;
        }
        int last2 = contributorsList.lastIndexOf(contributor);
        if (this.isMoreElement(last2)) {
            --last2;
        }
        return new Range<Integer>(first2, last2);
    }

    private int getInsertionPoint(SearchEverywhereContributor contributor) {
        if (this.listElements.isEmpty()) {
            return 0;
        }
        List<SearchEverywhereContributor> list2 = this.contributors();
        int index = list2.lastIndexOf(contributor);
        if (index >= 0) {
            return this.isMoreElement(index) ? index : index + 1;
        }
        index = Collections.binarySearch(list2, contributor, Comparator.comparingInt(SearchEverywhereContributor::getSortWeight));
        return -index - 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/ide/actions/searcheverywhere/GroupedSearchListModel", "removeElement"));
    }
}

