/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.searcheverywhere.EvaluationResult;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J8\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ide/actions/searcheverywhere/EvaluationResultRenderer;", "Ljavax/swing/ListCellRenderer;", "Lcom/intellij/ide/actions/searcheverywhere/EvaluationResult;", "()V", "panel", "Ljavax/swing/JPanel;", "resultComponent", "Lcom/intellij/ui/SimpleColoredComponent;", "shortcutComponent", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "intellij.platform.lang.impl"})
final class EvaluationResultRenderer
implements ListCellRenderer<EvaluationResult> {
    private final SimpleColoredComponent resultComponent = new SimpleColoredComponent();
    private final SimpleColoredComponent shortcutComponent = new SimpleColoredComponent();
    private final JPanel panel;

    @Override
    @NotNull
    public Component getListCellRendererComponent(@NotNull JList<? extends EvaluationResult> list2, @NotNull EvaluationResult value, int index, boolean isSelected, boolean cellHasFocus) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.resultComponent.clear();
        this.resultComponent.setIcon(AllIcons.Debugger.EvaluateExpression);
        Color foreground = isSelected ? list2.getSelectionForeground() : list2.getForeground();
        SimpleTextAttributes attributes = new SimpleTextAttributes(0, foreground);
        this.resultComponent.append(LangBundle.message("search.everywhere.calculator.result.0", value.getValue()), attributes);
        this.shortcutComponent.clear();
        String string2 = KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke(10, 0));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"KeymapUtil.getKeystrokeT\u2026ke(KeyEvent.VK_ENTER, 0))");
        String shortcutText = string2;
        SimpleTextAttributes shortcutAttributes = isSelected ? new SimpleTextAttributes(0, list2.getSelectionForeground()) : SimpleTextAttributes.GRAY_ATTRIBUTES;
        this.shortcutComponent.append(LangBundle.message("search.everywhere.calculator.shortcut.0", shortcutText), shortcutAttributes);
        this.panel.setBackground(UIUtil.getListBackground(isSelected, true));
        this.panel.setFont(list2.getFont());
        return this.panel;
    }

    /*
     * WARNING - void declaration
     */
    public EvaluationResultRenderer() {
        void $this$apply;
        JPanel jPanel;
        JPanel jPanel2 = jPanel = new JPanel(new BorderLayout());
        EvaluationResultRenderer evaluationResultRenderer = this;
        boolean bl = false;
        $this$apply.add((Component)this.resultComponent, "Center");
        $this$apply.add((Component)this.shortcutComponent, "East");
        int sideGap = UIUtil.isUnderWin10LookAndFeel() ? 0 : JBUIScale.scale(UIUtil.getListCellHPadding());
        $this$apply.setBorder(JBUI.Borders.empty(1, sideGap));
        Unit unit = Unit.INSTANCE;
        evaluationResultRenderer.panel = jPanel;
    }
}

