/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoActionAction;
import com.intellij.ide.actions.SetShortcutAction;
import com.intellij.ide.actions.searcheverywhere.CheckBoxSearchEverywhereToggleAction;
import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereMlService;
import com.intellij.ide.actions.searcheverywhere.WeightedSearchEverywhereContributor;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.util.gotoByName.GotoActionItemProvider;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.ShortcutRestrictions;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.Processor;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionSearchEverywhereContributor
implements WeightedSearchEverywhereContributor<GotoActionModel.MatchedValue>,
LightEditCompatible {
    private static final Logger LOG = Logger.getInstance(ActionSearchEverywhereContributor.class);
    private final Project myProject;
    private final WeakReference<Component> myContextComponent;
    private final GotoActionModel myModel;
    private final GotoActionItemProvider myProvider;
    protected boolean myDisabledActions;

    public ActionSearchEverywhereContributor(Project project2, Component contextComponent, Editor editor2) {
        this.myProject = project2;
        this.myContextComponent = new WeakReference<Component>(contextComponent);
        this.myModel = new GotoActionModel(project2, contextComponent, editor2);
        this.myProvider = new GotoActionItemProvider(this.myModel);
    }

    @Override
    @NotNull
    public String getGroupName() {
        String string2 = IdeBundle.message((String)"search.everywhere.group.name.actions", (Object[])new Object[0]);
        if (string2 == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getAdvertisement() {
        ShortcutSet altEnterShortcutSet = KeymapUtil.getActiveKeymapShortcuts((String)"ShowIntentionActions");
        @NlsSafe String altEnter = KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)altEnterShortcutSet);
        String string2 = IdeBundle.message((String)"press.0.to.assign.a.shortcut", (Object[])new Object[]{altEnter});
        if (string2 == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NlsContexts.Checkbox
    public String includeNonProjectItemsText() {
        return IdeBundle.message((String)"checkbox.disabled.included", (Object[])new Object[0]);
    }

    @Override
    public int getSortWeight() {
        return 400;
    }

    @Override
    public boolean isShownInSeparateTab() {
        return true;
    }

    @Override
    public void fetchWeightedElements(@NotNull String pattern, @NotNull ProgressIndicator progressIndicator, @NotNull Processor<? super FoundItemDescriptor<GotoActionModel.MatchedValue>> consumer) {
        if (pattern == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(2);
        }
        if (progressIndicator == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmptyOrSpaces(pattern)) {
            return;
        }
        ProgressManager.getInstance().executeProcessUnderProgress(() -> this.myProvider.filterElements(pattern, element2 -> {
            if (progressIndicator.isCanceled()) {
                return false;
            }
            if (element2 == null) {
                LOG.error("Null action has been returned from model");
                return true;
            }
            boolean isActionWrapper = element2.value instanceof GotoActionModel.ActionWrapper;
            if (!this.myDisabledActions && isActionWrapper && !((GotoActionModel.ActionWrapper)element2.value).isAvailable()) {
                return true;
            }
            SearchEverywhereMlService mlService = SearchEverywhereMlService.getInstance();
            FoundItemDescriptor<GotoActionModel.MatchedValue> descriptor = mlService != null ? this.getMLWeightedItemDescriptor(mlService, (GotoActionModel.MatchedValue)element2) : new FoundItemDescriptor<GotoActionModel.MatchedValue>((GotoActionModel.MatchedValue)element2, element2.getMatchingDegree());
            return consumer.process(descriptor);
        }), progressIndicator);
    }

    @Override
    @NotNull
    public List<AnAction> getActions(final @NotNull Runnable onChanged) {
        if (onChanged == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(5);
        }
        List<1> list2 = Collections.singletonList(new CheckBoxSearchEverywhereToggleAction(this.includeNonProjectItemsText()){

            @Override
            public boolean isEverywhere() {
                return ActionSearchEverywhereContributor.this.myDisabledActions;
            }

            @Override
            public void setEverywhere(boolean state) {
                ActionSearchEverywhereContributor.this.myDisabledActions = state;
                onChanged.run();
            }
        });
        if (list2 == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    @NotNull
    public ListCellRenderer<? super GotoActionModel.MatchedValue> getElementsRenderer() {
        return new GotoActionModel.GotoActionListCellRenderer(this.myModel::getGroupName, true);
    }

    @Override
    public boolean showInFindResults() {
        return false;
    }

    @Override
    @NotNull
    public String getSearchProviderId() {
        String string2 = ActionSearchEverywhereContributor.class.getSimpleName();
        if (string2 == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @Override
    public Object getDataForItem(@NotNull GotoActionModel.MatchedValue element2, @NotNull String dataId) {
        if (element2 == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(8);
        }
        if (dataId == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(9);
        }
        return SetShortcutAction.SELECTED_ACTION.is(dataId) ? ActionSearchEverywhereContributor.getAction(element2) : null;
    }

    @Override
    @Nullable
    public String getItemDescription(@NotNull GotoActionModel.MatchedValue element2) {
        AnAction action2;
        if (element2 == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(10);
        }
        if ((action2 = ActionSearchEverywhereContributor.getAction(element2)) == null) {
            return null;
        }
        String description = action2.getTemplatePresentation().getDescription();
        if (UISettings.getInstance().getShowInplaceCommentsInternal()) {
            String presentableId = StringUtil.notNullize(ActionManager.getInstance().getId(action2), "class: " + action2.getClass().getName());
            return String.format("[%s] %s", presentableId, StringUtil.notNullize(description));
        }
        return description;
    }

    @Override
    public boolean processSelectedItem(@NotNull GotoActionModel.MatchedValue item, int modifiers, @NotNull String text2) {
        if (item == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(11);
        }
        if (text2 == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(12);
        }
        if (modifiers == 8) {
            this.showAssignShortcutDialog(item);
            return true;
        }
        Object selected = item.value;
        if (selected instanceof BooleanOptionDescription) {
            BooleanOptionDescription option = (BooleanOptionDescription)selected;
            if (selected instanceof BooleanOptionDescription.RequiresRebuild) {
                this.myModel.clearCaches();
                this.myProvider.clearIntentions();
            }
            option.setOptionState(!option.isOptionEnabled());
            return false;
        }
        GotoActionAction.openOptionOrPerformAction(selected, text2, this.myProject, (Component)this.myContextComponent.get(), modifiers);
        boolean inplaceChange = selected instanceof GotoActionModel.ActionWrapper && ((GotoActionModel.ActionWrapper)selected).getAction() instanceof ToggleAction;
        return !inplaceChange;
    }

    @Nullable
    private static AnAction getAction(@NotNull GotoActionModel.MatchedValue element2) {
        Object value;
        if (element2 == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(13);
        }
        if ((value = element2.value) instanceof GotoActionModel.ActionWrapper) {
            value = ((GotoActionModel.ActionWrapper)value).getAction();
        }
        return value instanceof AnAction ? (AnAction)value : null;
    }

    private void showAssignShortcutDialog(@NotNull GotoActionModel.MatchedValue value) {
        AnAction action2;
        if (value == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(14);
        }
        if ((action2 = ActionSearchEverywhereContributor.getAction(value)) == null) {
            return;
        }
        String id2 = ActionManager.getInstance().getId(action2);
        Keymap activeKeymap = Optional.ofNullable(KeymapManager.getInstance()).map(KeymapManager::getActiveKeymap).orElse(null);
        if (activeKeymap == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Window window;
            Window window2 = window = this.myProject != null ? WindowManager.getInstance().suggestParentWindow(this.myProject) : KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            if (window == null) {
                return;
            }
            KeymapPanel.addKeyboardShortcut((String)id2, (ShortcutRestrictions)ActionShortcutRestrictions.getInstance().getForActionId(id2), (Keymap)activeKeymap, (Component)window, (QuickList[])new QuickList[0]);
        });
    }

    private FoundItemDescriptor<GotoActionModel.MatchedValue> getMLWeightedItemDescriptor(@NotNull SearchEverywhereMlService service2, @NotNull GotoActionModel.MatchedValue element2) {
        double mlWeight;
        if (service2 == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(15);
        }
        if (element2 == null) {
            ActionSearchEverywhereContributor.$$$reportNull$$$0(16);
        }
        if ((mlWeight = service2.getMlWeight(this, element2, element2.getMatchingDegree())) > 0.0 && service2.shouldOrderByMl()) {
            if (element2.getType() == GotoActionModel.MatchedValueType.ABBREVIATION) {
                return new FoundItemDescriptor<GotoActionModel.MatchedValue>(element2, element2.getMatchingDegree(), 1.0);
            }
            return new FoundItemDescriptor<GotoActionModel.MatchedValue>(element2, element2.getMatchingDegree(), mlWeight);
        }
        return new FoundItemDescriptor<GotoActionModel.MatchedValue>(element2, element2.getMatchingDegree());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/ActionSearchEverywhereContributor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChanged";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdvertisement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/ActionSearchEverywhereContributor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchProviderId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fetchWeightedElements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDataForItem";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getItemDescription";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processSelectedItem";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAction";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showAssignShortcutDialog";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getMLWeightedItemDescriptor";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Factory
    implements SearchEverywhereContributorFactory<GotoActionModel.MatchedValue> {
        @Override
        @NotNull
        public SearchEverywhereContributor<GotoActionModel.MatchedValue> createContributor(@NotNull AnActionEvent initEvent) {
            if (initEvent == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return new ActionSearchEverywhereContributor(initEvent.getProject(), (Component)initEvent.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT), (Editor)initEvent.getData(CommonDataKeys.EDITOR));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initEvent", "com/intellij/ide/actions/searcheverywhere/ActionSearchEverywhereContributor$Factory", "createContributor"));
        }
    }
}

