/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything.groups;

import com.intellij.ide.actions.runAnything.items.RunAnythingItem;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunAnythingGroup {
    public static final Function<String, NameUtil.MatcherBuilder> RUN_ANYTHING_MATCHER_BUILDER = pattern -> NameUtil.buildMatcher((String)("*" + pattern));
    volatile int myMoreIndex = -1;
    volatile int myTitleIndex = -1;

    @NotNull
    @NlsContexts.PopupTitle
    public abstract String getTitle();

    protected int getMaxInitialItems() {
        return 5;
    }

    public int getMaxItemsToInsert() {
        return 5;
    }

    public abstract SearchResult getItems(@NotNull DataContext var1, @NotNull List<RunAnythingItem> var2, @NotNull String var3, int var4);

    public void resetMoreIndex() {
        this.myMoreIndex = -1;
    }

    private static void shiftMoreIndex(Collection<? extends RunAnythingGroup> groups2, int baseIndex, int shift) {
        groups2.stream().filter(runAnythingGroup -> runAnythingGroup.myMoreIndex >= baseIndex).forEach(runAnythingGroup -> runAnythingGroup.myMoreIndex += shift);
    }

    @Nullable
    @NlsContexts.PopupTitle
    public static String getTitle(@NotNull Collection<? extends RunAnythingGroup> groups2, int titleIndex) {
        if (groups2 == null) {
            RunAnythingGroup.$$$reportNull$$$0(0);
        }
        return Optional.ofNullable(RunAnythingGroup.findGroup(groups2, titleIndex)).map(RunAnythingGroup::getTitle).orElse(null);
    }

    @Nullable
    public static RunAnythingGroup findGroup(@NotNull Collection<? extends RunAnythingGroup> groups2, int titleIndex) {
        if (groups2 == null) {
            RunAnythingGroup.$$$reportNull$$$0(1);
        }
        return groups2.stream().filter(runAnythingGroup -> titleIndex == runAnythingGroup.myTitleIndex).findFirst().orElse(null);
    }

    @Nullable
    public static RunAnythingGroup findItemGroup(@NotNull List<? extends RunAnythingGroup> groups2, int itemIndex) {
        if (groups2 == null) {
            RunAnythingGroup.$$$reportNull$$$0(2);
        }
        RunAnythingGroup runAnythingGroup = null;
        for (RunAnythingGroup runAnythingGroup2 : groups2) {
            if (runAnythingGroup2.myTitleIndex == -1) continue;
            if (runAnythingGroup2.myTitleIndex > itemIndex) break;
            runAnythingGroup = runAnythingGroup2;
        }
        return runAnythingGroup;
    }

    private static void shiftTitleIndex(@NotNull Collection<? extends RunAnythingGroup> groups2, int baseIndex, int shift) {
        if (groups2 == null) {
            RunAnythingGroup.$$$reportNull$$$0(3);
        }
        groups2.stream().filter(runAnythingGroup -> runAnythingGroup.myTitleIndex != -1 && runAnythingGroup.myTitleIndex > baseIndex).forEach(runAnythingGroup -> runAnythingGroup.myTitleIndex += shift);
    }

    public static void clearMoreIndex(@NotNull Collection<? extends RunAnythingGroup> groups2) {
        if (groups2 == null) {
            RunAnythingGroup.$$$reportNull$$$0(4);
        }
        groups2.forEach(runAnythingGroup -> {
            runAnythingGroup.myMoreIndex = -1;
        });
    }

    private static void clearTitleIndex(@NotNull Collection<? extends RunAnythingGroup> groups2) {
        if (groups2 == null) {
            RunAnythingGroup.$$$reportNull$$$0(5);
        }
        groups2.forEach(runAnythingGroup -> {
            runAnythingGroup.myTitleIndex = -1;
        });
    }

    public static int[] getAllIndexes(@NotNull Collection<? extends RunAnythingGroup> groups2) {
        if (groups2 == null) {
            RunAnythingGroup.$$$reportNull$$$0(6);
        }
        IntArrayList list2 = new IntArrayList();
        for (RunAnythingGroup runAnythingGroup : groups2) {
            list2.add(runAnythingGroup.myTitleIndex);
        }
        for (RunAnythingGroup runAnythingGroup : groups2) {
            list2.add(runAnythingGroup.myMoreIndex);
        }
        return list2.toIntArray();
    }

    @Nullable
    public static RunAnythingGroup findGroupByMoreIndex(@NotNull Collection<? extends RunAnythingGroup> groups2, int moreIndex) {
        if (groups2 == null) {
            RunAnythingGroup.$$$reportNull$$$0(7);
        }
        return (RunAnythingGroup)((Object)ContainerUtil.find(groups2, runAnythingGroup -> moreIndex == runAnythingGroup.myMoreIndex));
    }

    @Nullable
    public static RunAnythingGroup findGroupByTitleIndex(@NotNull Collection<? extends RunAnythingGroup> groups2, int titleIndex) {
        if (groups2 == null) {
            RunAnythingGroup.$$$reportNull$$$0(8);
        }
        return (RunAnythingGroup)((Object)ContainerUtil.find(groups2, runAnythingGroup -> titleIndex == runAnythingGroup.myTitleIndex));
    }

    public static boolean isMoreIndex(@NotNull Collection<? extends RunAnythingGroup> groups2, int index) {
        if (groups2 == null) {
            RunAnythingGroup.$$$reportNull$$$0(9);
        }
        return groups2.stream().anyMatch(runAnythingGroup -> runAnythingGroup.myMoreIndex == index);
    }

    public static void shiftIndexes(@NotNull Collection<? extends RunAnythingGroup> groups2, int baseIndex, int shift) {
        if (groups2 == null) {
            RunAnythingGroup.$$$reportNull$$$0(10);
        }
        RunAnythingGroup.shiftTitleIndex(groups2, baseIndex, shift);
        RunAnythingGroup.shiftMoreIndex(groups2, baseIndex, shift);
    }

    public static void clearIndexes(@NotNull Collection<? extends RunAnythingGroup> groups2) {
        if (groups2 == null) {
            RunAnythingGroup.$$$reportNull$$$0(11);
        }
        RunAnythingGroup.clearTitleIndex(groups2);
        RunAnythingGroup.clearMoreIndex(groups2);
    }

    public final synchronized void collectItems(@NotNull DataContext dataContext, @NotNull List<RunAnythingItem> model2, @NotNull String pattern) {
        if (dataContext == null) {
            RunAnythingGroup.$$$reportNull$$$0(12);
        }
        if (model2 == null) {
            RunAnythingGroup.$$$reportNull$$$0(13);
        }
        if (pattern == null) {
            RunAnythingGroup.$$$reportNull$$$0(14);
        }
        SearchResult result2 = this.getItems(dataContext, model2, pattern, this.getMaxInitialItems());
        ProgressManager.checkCanceled();
        if (!result2.isEmpty()) {
            this.myTitleIndex = model2.size();
            model2.addAll(result2);
            this.myMoreIndex = result2.myNeedMore ? model2.size() - 1 : -1;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/runAnything/groups/RunAnythingGroup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTitle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findGroup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findItemGroup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "shiftTitleIndex";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "clearMoreIndex";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "clearTitleIndex";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllIndexes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findGroupByMoreIndex";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findGroupByTitleIndex";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isMoreIndex";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "shiftIndexes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "clearIndexes";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "collectItems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class SearchResult
    extends ArrayList<RunAnythingItem> {
        boolean myNeedMore;

        public boolean isNeedMore() {
            return this.myNeedMore;
        }

        public void setNeedMore(boolean needMore) {
            this.myNeedMore = needMore;
        }
    }
}

