/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.runAnything.RunAnythingUtil;
import com.intellij.ide.actions.runAnything.execution.RunAnythingRunProfile;
import com.intellij.ide.actions.runAnything.handlers.RunAnythingCommandHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunAnythingRunProfileState
extends CommandLineState {
    public RunAnythingRunProfileState(@NotNull ExecutionEnvironment environment2, @NotNull String originalCommand) {
        if (environment2 == null) {
            RunAnythingRunProfileState.$$$reportNull$$$0(0);
        }
        if (originalCommand == null) {
            RunAnythingRunProfileState.$$$reportNull$$$0(1);
        }
        super(environment2);
        Project project2 = environment2.getProject();
        RunAnythingCommandHandler handler = RunAnythingCommandHandler.getMatchedHandler(project2, originalCommand);
        if (handler != null) {
            this.setConsoleBuilder(handler.getConsoleBuilder(project2));
        }
    }

    @NotNull
    private RunAnythingRunProfile getRunProfile() {
        RunProfile runProfile = this.getEnvironment().getRunProfile();
        if (!(runProfile instanceof RunAnythingRunProfile)) {
            throw new IllegalStateException("Got " + runProfile + " instead of RunAnything profile");
        }
        RunAnythingRunProfile runAnythingRunProfile = (RunAnythingRunProfile)runProfile;
        if (runAnythingRunProfile == null) {
            RunAnythingRunProfileState.$$$reportNull$$$0(2);
        }
        return runAnythingRunProfile;
    }

    @NotNull
    protected ProcessHandler startProcess() throws ExecutionException {
        RunAnythingRunProfile runProfile = this.getRunProfile();
        GeneralCommandLine commandLine = runProfile.getCommandLine();
        final String originalCommand = runProfile.getOriginalCommand();
        KillableColoredProcessHandler processHandler = new KillableColoredProcessHandler(commandLine){
            long creationTime;

            public void startNotify() {
                this.creationTime = System.currentTimeMillis();
                super.startNotify();
            }

            protected void notifyProcessTerminated(int exitCode) {
                this.print(IdeBundle.message((String)"run.anything.console.process.finished", (Object[])new Object[]{exitCode}), ConsoleViewContentType.SYSTEM_OUTPUT);
                this.printCustomCommandOutput();
                super.notifyProcessTerminated(exitCode);
            }

            private void printCustomCommandOutput() {
                String customOutput;
                RunAnythingCommandHandler handler = RunAnythingCommandHandler.getMatchedHandler(RunAnythingRunProfileState.this.getEnvironment().getProject(), originalCommand);
                if (handler != null && (customOutput = handler.getProcessTerminatedCustomOutput(this.creationTime)) != null) {
                    this.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                    this.print(customOutput, ConsoleViewContentType.SYSTEM_OUTPUT);
                }
            }

            public boolean shouldKillProcessSoftly() {
                RunAnythingCommandHandler handler = RunAnythingCommandHandler.getMatchedHandler(RunAnythingRunProfileState.this.getEnvironment().getProject(), originalCommand);
                return handler != null ? handler.shouldKillProcessSoftly() : super.shouldKillProcessSoftly();
            }

            private void print(@NotNull String message2, @NotNull ConsoleViewContentType consoleViewContentType) {
                ConsoleView console;
                if (message2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (consoleViewContentType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((console = this.getConsoleView()) != null) {
                    console.print(message2, consoleViewContentType);
                }
            }

            @Nullable
            private ConsoleView getConsoleView() {
                RunContentDescriptor contentDescriptor = RunContentManager.getInstance((Project)RunAnythingRunProfileState.this.getEnvironment().getProject()).findContentDescriptor(RunAnythingRunProfileState.this.getEnvironment().getExecutor(), (ProcessHandler)((Object)this));
                ConsoleView console = null;
                if (contentDescriptor != null && contentDescriptor.getExecutionConsole() instanceof ConsoleView) {
                    console = (ConsoleView)contentDescriptor.getExecutionConsole();
                }
                return console;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "message";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "consoleViewContentType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/actions/runAnything/execution/RunAnythingRunProfileState$1";
                objectArray[2] = "print";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
            boolean myIsFirstLineAdded;

            @Override
            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!this.myIsFirstLineAdded) {
                    Objects.requireNonNull(RunAnythingUtil.getOrCreateWrappedCommands(RunAnythingRunProfileState.this.getEnvironment().getProject())).add(Pair.create(StringUtil.trim(event.getText()), originalCommand));
                    this.myIsFirstLineAdded = true;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/actions/runAnything/execution/RunAnythingRunProfileState$2";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        KillableColoredProcessHandler killableColoredProcessHandler = processHandler;
        if (killableColoredProcessHandler == null) {
            RunAnythingRunProfileState.$$$reportNull$$$0(3);
        }
        return killableColoredProcessHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalCommand";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/runAnything/execution/RunAnythingRunProfileState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/runAnything/execution/RunAnythingRunProfileState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunProfile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

