/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything.activity;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.runAnything.RunAnythingAction;
import com.intellij.ide.actions.runAnything.RunAnythingCache;
import com.intellij.ide.actions.runAnything.RunAnythingUtil;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProviderBase;
import com.intellij.ide.actions.runAnything.commands.RunAnythingCommandCustomizer;
import com.intellij.ide.actions.runAnything.execution.RunAnythingRunProfile;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.execution.ParametersListUtil;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunAnythingCommandProvider
extends RunAnythingProviderBase<String> {
    @Override
    public void execute(@NotNull DataContext dataContext, @NotNull String value) {
        if (dataContext == null) {
            RunAnythingCommandProvider.$$$reportNull$$$0(0);
        }
        if (value == null) {
            RunAnythingCommandProvider.$$$reportNull$$$0(1);
        }
        VirtualFile workDirectory = (VirtualFile)dataContext.getData(CommonDataKeys.VIRTUAL_FILE);
        Executor executor = (Executor)dataContext.getData(RunAnythingAction.EXECUTOR_KEY);
        RunAnythingUtil.LOG.assertTrue(workDirectory != null);
        RunAnythingUtil.LOG.assertTrue(executor != null);
        RunAnythingCommandProvider.runCommand(workDirectory, value, executor, dataContext);
    }

    public static void runCommand(@NotNull VirtualFile workDirectory, @NotNull String commandString, @NotNull Executor executor, @NotNull DataContext dataContext) {
        Project project2;
        if (workDirectory == null) {
            RunAnythingCommandProvider.$$$reportNull$$$0(2);
        }
        if (commandString == null) {
            RunAnythingCommandProvider.$$$reportNull$$$0(3);
        }
        if (executor == null) {
            RunAnythingCommandProvider.$$$reportNull$$$0(4);
        }
        if (dataContext == null) {
            RunAnythingCommandProvider.$$$reportNull$$$0(5);
        }
        RunAnythingUtil.LOG.assertTrue((project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext)) != null);
        List<String> commands = RunAnythingCache.getInstance(project2).getState().getCommands();
        commands.remove(commandString);
        commands.add(commandString);
        dataContext = RunAnythingCommandCustomizer.customizeContext(dataContext);
        GeneralCommandLine initialCommandLine = new GeneralCommandLine(ParametersListUtil.parse(commandString, false, true)).withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE).withWorkDirectory(workDirectory.getPath());
        GeneralCommandLine commandLine = RunAnythingCommandCustomizer.customizeCommandLine(dataContext, workDirectory, initialCommandLine);
        try {
            RunAnythingRunProfile runAnythingRunProfile = new RunAnythingRunProfile((GeneralCommandLine)(Registry.is("run.anything.use.pty", false) ? new PtyCommandLine(commandLine) : commandLine), commandString);
            ExecutionEnvironmentBuilder.create((Project)project2, (Executor)executor, (RunProfile)runAnythingRunProfile).dataContext(dataContext).buildAndExecute();
        }
        catch (ExecutionException e) {
            RunAnythingUtil.LOG.warn(e);
            Messages.showInfoMessage((Project)project2, (String)e.getMessage(), (String)IdeBundle.message((String)"run.anything.console.error.title", (Object[])new Object[0]));
        }
    }

    @Override
    @Nullable
    public String getAdText() {
        return RunAnythingUtil.getAdContextText() + ", " + RunAnythingUtil.getAdDebugText() + ", " + RunAnythingUtil.getAdDeleteCommandText();
    }

    @Override
    @NotNull
    public String getCommand(@NotNull String value) {
        if (value == null) {
            RunAnythingCommandProvider.$$$reportNull$$$0(6);
        }
        String string2 = value;
        if (string2 == null) {
            RunAnythingCommandProvider.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @Override
    @Nullable
    public Icon getIcon(@NotNull String value) {
        if (value == null) {
            RunAnythingCommandProvider.$$$reportNull$$$0(8);
        }
        return AllIcons.Actions.Run_anything;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workDirectory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandString";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/runAnything/activity/RunAnythingCommandProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/runAnything/activity/RunAnythingCommandProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runCommand";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

