/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything;

import com.intellij.execution.Executor;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.actions.runAnything.RunAnythingManager;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProvider;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionConfigurationCustomizer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ModifierKeyDoubleClickHandler;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.FontUtil;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunAnythingAction
extends AnAction
implements CustomComponentAction,
DumbAware {
    public static final String RUN_ANYTHING_ACTION_ID = "RunAnything";
    public static final DataKey<Executor> EXECUTOR_KEY = DataKey.create((String)"EXECUTOR_KEY");
    public static final AtomicBoolean SHIFT_IS_PRESSED = new AtomicBoolean(false);
    public static final AtomicBoolean ALT_IS_PRESSED = new AtomicBoolean(false);
    private static boolean ourDoubleCtrlRegistered;

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RunAnythingAction.$$$reportNull$$$0(0);
        }
        if (AdvancedSettings.getBoolean((String)"ide.suppress.double.click.handler") && e.getInputEvent() instanceof KeyEvent && ((KeyEvent)e.getInputEvent()).getKeyCode() == 17) {
            return;
        }
        Project project2 = e.getProject();
        if (project2 != null && !LightEdit.owns((Project)project2)) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed(RUN_ANYTHING_ACTION_ID);
            RunAnythingManager runAnythingManager = RunAnythingManager.getInstance(project2);
            String text2 = GotoActionBase.getInitialTextForNavigation(e);
            runAnythingManager.show(text2, e);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunAnythingAction.$$$reportNull$$$0(1);
        }
        boolean isEnabled = !RunAnythingProvider.EP_NAME.getExtensionList().isEmpty();
        e.getPresentation().setEnabledAndVisible(isEnabled);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RunAnythingAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static void updateShortcut() {
        if (KeymapUtil.getActiveKeymapShortcuts((String)RUN_ANYTHING_ACTION_ID).getShortcuts().length == 0) {
            if (!ourDoubleCtrlRegistered) {
                ModifierKeyDoubleClickHandler.getInstance().registerAction(RUN_ANYTHING_ACTION_ID, 17, -1, false);
                ourDoubleCtrlRegistered = true;
            }
        } else if (ourDoubleCtrlRegistered) {
            ModifierKeyDoubleClickHandler.getInstance().unregisterAction(RUN_ANYTHING_ACTION_ID);
            ourDoubleCtrlRegistered = false;
        }
    }

    private static void initShortcutTracker() {
        RunAnythingAction.updateShortcut();
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(KeymapManagerListener.TOPIC, new KeymapManagerListener(){

            public void activeKeymapChanged(@Nullable Keymap keymap) {
                RunAnythingAction.updateShortcut();
            }

            public void shortcutChanged(@NotNull Keymap keymap, @NotNull String actionId) {
                if (keymap == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (actionId == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (RunAnythingAction.RUN_ANYTHING_ACTION_ID.equals(actionId)) {
                    RunAnythingAction.updateShortcut();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "keymap";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "actionId";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/actions/runAnything/RunAnythingAction$1";
                objectArray[2] = "shortcutChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
        if (presentation2 == null) {
            RunAnythingAction.$$$reportNull$$$0(3);
        }
        if (place == null) {
            RunAnythingAction.$$$reportNull$$$0(4);
        }
        return new ActionButton(this, presentation2, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

            protected void updateToolTipText() {
                HelpTooltip.dispose((Component)((Object)this));
                new HelpTooltip().setTitle(this.myPresentation.getText()).setShortcut(this.getShortcut()).setDescription(IdeBundle.message((String)"run.anything.action.tooltip.text", (Object[])new Object[0])).installOn((JComponent)((Object)this));
            }

            @Nullable
            private String getShortcut() {
                if (ourDoubleCtrlRegistered) {
                    return IdeBundle.message((String)"double.ctrl.or.shift.shortcut", (Object[])new Object[]{SystemInfo.isMac ? FontUtil.thinSpace() + "\u2303" : "Ctrl"});
                }
                return null;
            }

            public void setToolTipText(String s) {
                String shortcutText = this.getShortcutText();
                super.setToolTipText((String)(StringUtil.isNotEmpty(shortcutText) ? s + " (" + shortcutText + ")" : s));
            }
        };
    }

    static {
        IdeEventQueue.getInstance().addPostprocessor(event -> {
            if (event instanceof KeyEvent) {
                int keyCode = ((KeyEvent)event).getKeyCode();
                if (keyCode == 16) {
                    SHIFT_IS_PRESSED.set(event.getID() == 401);
                } else if (keyCode == 18) {
                    ALT_IS_PRESSED.set(event.getID() == 401);
                }
            }
            return false;
        }, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/runAnything/RunAnythingAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/runAnything/RunAnythingAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static class ShortcutTracker
    implements ActionConfigurationCustomizer {
        ShortcutTracker() {
        }

        public void customize(@NotNull ActionManager actionManager) {
            if (actionManager == null) {
                ShortcutTracker.$$$reportNull$$$0(0);
            }
            RunAnythingAction.initShortcutTracker();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionManager", "com/intellij/ide/actions/runAnything/RunAnythingAction$ShortcutTracker", "customize"));
        }
    }
}

