/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ide.FileEditorSelectInContext;
import com.intellij.ide.FileSelectInContext;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SmartSelectInContext;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.awt.event.InputEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SelectInContextImpl
extends FileSelectInContext {
    private final Object mySelector;

    private SelectInContextImpl(@NotNull PsiFile psiFile, @NotNull Object selector) {
        if (psiFile == null) {
            SelectInContextImpl.$$$reportNull$$$0(0);
        }
        if (selector == null) {
            SelectInContextImpl.$$$reportNull$$$0(1);
        }
        super(psiFile.getProject(), psiFile.getViewProvider().getVirtualFile());
        assert (!(selector instanceof PsiElement)) : "use SmartSelectInContext instead";
        this.mySelector = selector;
    }

    public Object getSelectorInFile() {
        return this.mySelector;
    }

    @Nullable
    public static SelectInContext createContext(AnActionEvent event) {
        Project project2 = event.getProject();
        FileEditor editor2 = (FileEditor)event.getData(PlatformCoreDataKeys.FILE_EDITOR);
        VirtualFile virtualFile2 = (VirtualFile)event.getData(CommonDataKeys.VIRTUAL_FILE);
        SelectInContext result2 = (SelectInContext)event.getData(SelectInContext.DATA_KEY);
        if (result2 != null) {
            return result2;
        }
        result2 = SelectInContextImpl.createEditorContext(project2, editor2, virtualFile2);
        if (result2 != null) {
            return result2;
        }
        JComponent sourceComponent = SelectInContextImpl.getEventComponent(event);
        if (sourceComponent == null) {
            return null;
        }
        result2 = SelectInContextImpl.createPsiContext(event);
        if (result2 != null) {
            return result2;
        }
        Navigatable descriptor = (Navigatable)event.getData(CommonDataKeys.NAVIGATABLE);
        SelectInContext selectInContext = result2 = descriptor instanceof OpenFileDescriptor ? SelectInContextImpl.createDescriptorContext((OpenFileDescriptor)((Object)descriptor)) : null;
        if (result2 != null) {
            return result2;
        }
        if (virtualFile2 != null && project2 != null) {
            return new FileSelectInContext(project2, virtualFile2, null);
        }
        return null;
    }

    @Nullable
    private static SelectInContext createDescriptorContext(OpenFileDescriptor descriptor) {
        Document document;
        VirtualFile file2 = descriptor.getFile();
        Document document2 = document = !file2.isValid() ? null : FileDocumentManager.getInstance().getDocument(file2);
        if (document == null) {
            return null;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance(descriptor.getProject()).getPsiFile(document);
        if (psiFile == null) {
            return null;
        }
        return new SmartSelectInContext(psiFile, (PsiElement)psiFile, () -> {
            descriptor.navigate(false);
            FileEditor[] allEditors = FileEditorManager.getInstance(descriptor.getProject()).getAllEditors(descriptor.getFile());
            return ArrayUtil.getFirstElement(allEditors);
        });
    }

    private static SelectInContext createEditorContext(@Nullable Project project2, @Nullable FileEditor editor2, @Nullable VirtualFile contextFile) {
        PsiFile psiFile;
        if (project2 == null || editor2 == null || project2.isDefault()) {
            return null;
        }
        VirtualFile file2 = editor2.getFile();
        if (file2 == null) {
            file2 = contextFile;
        }
        PsiFile psiFile2 = psiFile = file2 == null || !file2.isValid() ? null : PsiManager.getInstance(project2).findFile(file2);
        if (psiFile == null) {
            return null;
        }
        if (editor2 instanceof TextEditor) {
            return new FileEditorSelectInContext(editor2, psiFile){

                public Object getSelectorInFile() {
                    PsiFile file2 = this.getPsiFile();
                    if (file2 == null) {
                        return null;
                    }
                    if (file2.getViewProvider() instanceof TemplateLanguageFileViewProvider) {
                        return super.getSelectorInFile();
                    }
                    Editor editor2 = this.getEditor();
                    if (editor2 == null) {
                        return super.getSelectorInFile();
                    }
                    int offset = TargetElementUtil.adjustOffset(file2, editor2.getDocument(), editor2.getCaretModel().getOffset());
                    PsiElement element2 = file2.findElementAt(offset);
                    return element2 != null ? element2 : super.getSelectorInFile();
                }
            };
        }
        Object selectorInFile = SelectInContextImpl.getElementFromStructureView(project2, editor2);
        if (selectorInFile == null) {
            return new SmartSelectInContext(psiFile, (PsiElement)psiFile);
        }
        if (selectorInFile instanceof PsiElement) {
            return new SmartSelectInContext(psiFile, (PsiElement)selectorInFile);
        }
        return new SelectInContextImpl(psiFile, selectorInFile);
    }

    @Nullable
    private static Object getElementFromStructureView(@NotNull Project project2, @NotNull FileEditor editor2) {
        StructureViewBuilder builder2;
        if (project2 == null) {
            SelectInContextImpl.$$$reportNull$$$0(2);
        }
        if (editor2 == null) {
            SelectInContextImpl.$$$reportNull$$$0(3);
        }
        if ((builder2 = editor2.getStructureViewBuilder()) == null) {
            return null;
        }
        return SelectInContextImpl.getElementFromStructureView(project2, editor2, builder2);
    }

    @Nullable
    private static Object getElementFromStructureView(@NotNull Project project2, @NotNull FileEditor editor2, @NotNull StructureViewBuilder builder2) {
        if (project2 == null) {
            SelectInContextImpl.$$$reportNull$$$0(4);
        }
        if (editor2 == null) {
            SelectInContextImpl.$$$reportNull$$$0(5);
        }
        if (builder2 == null) {
            SelectInContextImpl.$$$reportNull$$$0(6);
        }
        if (builder2 instanceof TreeBasedStructureViewBuilder) {
            return SelectInContextImpl.getElementFromStructureTreeView(editor2, (TreeBasedStructureViewBuilder)builder2);
        }
        StructureView structureView = builder2.createStructureView(editor2, project2);
        Object selectorInFile = structureView.getTreeModel().getCurrentEditorElement();
        Disposer.dispose((Disposable)structureView);
        return selectorInFile;
    }

    @Nullable
    private static Object getElementFromStructureTreeView(@NotNull FileEditor fileEditor, TreeBasedStructureViewBuilder builder2) {
        if (fileEditor == null) {
            SelectInContextImpl.$$$reportNull$$$0(7);
        }
        Editor editor2 = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null;
        StructureViewModel model2 = builder2.createStructureViewModel(editor2);
        Object selectorInFile = model2.getCurrentEditorElement();
        Disposer.dispose((Disposable)model2);
        return selectorInFile;
    }

    @Nullable
    private static SelectInContext createPsiContext(AnActionEvent event) {
        DataContext dataContext = event.getDataContext();
        PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (psiElement == null || !psiElement.isValid()) {
            return null;
        }
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile == null) {
            return SelectInContextImpl.createFileSystemItemContext(psiElement);
        }
        return new SmartSelectInContext(psiFile, psiElement);
    }

    @Nullable
    public static SelectInContext createFileSystemItemContext(final PsiElement psiElement) {
        PsiFileSystemItem fsItem = ObjectUtils.tryCast(psiElement, PsiFileSystemItem.class);
        VirtualFile vfile = fsItem == null ? null : fsItem.getVirtualFile();
        return vfile == null ? null : new FileSelectInContext(psiElement.getProject(), vfile){

            @NotNull
            public Object getSelectorInFile() {
                PsiElement psiElement2 = psiElement;
                if (psiElement2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return psiElement2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/SelectInContextImpl$2", "getSelectorInFile"));
            }
        };
    }

    @Nullable
    private static JComponent getEventComponent(AnActionEvent event) {
        Object source;
        InputEvent inputEvent = event.getInputEvent();
        if (inputEvent != null && (source = inputEvent.getSource()) instanceof JComponent) {
            return (JComponent)source;
        }
        Component component2 = (Component)event.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        return component2 instanceof JComponent ? (JComponent)component2 : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/SelectInContextImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementFromStructureView";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementFromStructureTreeView";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

