/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.SaveFileAsTemplateDialog;
import com.intellij.ide.actions.SaveFileAsTemplateHandler;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.impl.FileTemplateConfigurable;
import com.intellij.ide.fileTemplates.impl.FileTemplateManagerImpl;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

final class SaveFileAsTemplateAction
extends AnAction {
    SaveFileAsTemplateAction() {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SaveFileAsTemplateAction.$$$reportNull$$$0(0);
        }
        Project project2 = Objects.requireNonNull((Project)e.getData(CommonDataKeys.PROJECT));
        String fileText = Objects.requireNonNull((String)e.getData(PlatformCoreDataKeys.FILE_TEXT));
        VirtualFile file2 = Objects.requireNonNull((VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE));
        String extension2 = Strings.notNullize(file2.getExtension());
        String nameWithoutExtension = file2.getNameWithoutExtension();
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        for (SaveFileAsTemplateHandler handler : SaveFileAsTemplateHandler.EP_NAME.getExtensionList()) {
            String textFromHandler = handler.getTemplateText(psiFile, fileText, nameWithoutExtension);
            if (textFromHandler == null) continue;
            fileText = textFromHandler;
            break;
        }
        FileTemplateManager templateManager = FileTemplateManager.getInstance((Project)project2);
        FileTemplate[] templates = templateManager.getAllTemplates();
        FileTemplate template = FileTemplateUtil.createTemplate(nameWithoutExtension, extension2, fileText, templates);
        FileTemplateConfigurable configurable2 = new FileTemplateConfigurable(project2);
        configurable2.setProportion(0.6f);
        configurable2.setTemplate(template, FileTemplateManagerImpl.getInstanceImpl(project2).getDefaultTemplateDescription());
        SaveFileAsTemplateDialog dialog = new SaveFileAsTemplateDialog(project2, configurable2);
        if (dialog.showAndGet()) {
            templateManager.setTemplates("Default", List.of(ArrayUtil.append(templates, template)));
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SaveFileAsTemplateAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(e.getData(CommonDataKeys.VIRTUAL_FILE) != null && e.getData(PlatformCoreDataKeys.FILE_TEXT) != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            SaveFileAsTemplateAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/SaveFileAsTemplateAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/SaveFileAsTemplateAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

