/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PowerSaveModeNotifier
implements StartupActivity.DumbAware {
    private static final String IGNORE_POWER_SAVE_MODE = "ignore.power.save.mode";

    PowerSaveModeNotifier() {
    }

    @Override
    public void runActivity(@NotNull Project project2) {
        if (project2 == null) {
            PowerSaveModeNotifier.$$$reportNull$$$0(0);
        }
        if (PowerSaveMode.isEnabled()) {
            PowerSaveModeNotifier.notifyOnPowerSaveMode(project2);
        }
    }

    static void notifyOnPowerSaveMode(@Nullable Project project2) {
        if (PropertiesComponent.getInstance().getBoolean(IGNORE_POWER_SAVE_MODE)) {
            return;
        }
        Notification notification = NotificationGroupManager.getInstance().getNotificationGroup("Power Save Mode").createNotification(IdeBundle.message((String)"power.save.mode.on.notification.title", (Object[])new Object[0]), IdeBundle.message((String)"power.save.mode.on.notification.content", (Object[])new Object[0]), NotificationType.WARNING);
        notification.addAction((AnAction)new NotificationAction(IdeBundle.message((String)"action.Anonymous.text.do.not.show.again", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    1.$$$reportNull$$$0(1);
                }
                PropertiesComponent.getInstance().setValue(PowerSaveModeNotifier.IGNORE_POWER_SAVE_MODE, true);
                notification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/actions/PowerSaveModeNotifier$1";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        notification.addAction((AnAction)new NotificationAction(IdeBundle.message((String)"power.save.mode.disable.action.title", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    2.$$$reportNull$$$0(1);
                }
                PowerSaveMode.setEnabled(false);
                notification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/actions/PowerSaveModeNotifier$2";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        notification.notify(project2);
        Balloon balloon = notification.getBalloon();
        if (balloon != null) {
            MessageBus bus = project2 == null ? ApplicationManager.getApplication().getMessageBus() : project2.getMessageBus();
            MessageBusConnection connection = bus.connect();
            Disposer.register((Disposable)balloon, connection);
            connection.subscribe(PowerSaveMode.TOPIC, () -> notification.expire());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/actions/PowerSaveModeNotifier", "runActivity"));
    }
}

