/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.LangBundle;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationHandler;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalJavaDocAction
extends AnAction {
    public ExternalJavaDocAction() {
        this.setInjectedContext(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ExternalJavaDocAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiElement originalElement;
        DataContext dataContext;
        Project project2;
        if (e == null) {
            ExternalJavaDocAction.$$$reportNull$$$0(1);
        }
        if ((project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext = e.getDataContext())) == null) {
            return;
        }
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiElement element2 = ExternalJavaDocAction.getElement(dataContext, editor2, originalElement = ExternalJavaDocAction.getOriginalElement(dataContext, editor2));
        if (element2 == null) {
            Messages.showMessageDialog((Project)project2, (String)IdeBundle.message((String)"message.please.select.element.for.javadoc", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.no.element.selected", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        ExternalJavaDocAction.showExternalJavadoc(element2, originalElement, null, dataContext);
    }

    public static void showExternalJavadoc(PsiElement element2, PsiElement originalElement, String docUrl, DataContext dataContext) {
        DocumentationProvider provider2 = DocumentationManager.getProviderFromElement(element2);
        if (provider2 instanceof ExternalDocumentationHandler && ((ExternalDocumentationHandler)((Object)provider2)).handleExternal(element2, originalElement)) {
            return;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.javadoc.external");
        Project project2 = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        Component contextComponent = (Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(dataContext);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            List<String> urls = StringUtil.isEmptyOrSpaces(docUrl) ? ReadAction.compute(() -> provider2.getUrlFor(element2, originalElement)) : Collections.singletonList(docUrl);
            if (provider2 instanceof ExternalDocumentationProvider && urls != null && urls.size() > 1) {
                for (String url : urls) {
                    List<String> thisUrlList = Collections.singletonList(url);
                    String doc = ((ExternalDocumentationProvider)((Object)provider2)).fetchExternalDocumentation(project2, element2, thisUrlList, false);
                    if (doc == null) continue;
                    urls = thisUrlList;
                    break;
                }
            }
            List<String> finalUrls = urls;
            ApplicationManager.getApplication().invokeLater(() -> {
                if (ContainerUtil.isEmpty(finalUrls)) {
                    ExternalDocumentationProvider externalDocumentationProvider;
                    if (element2 != null && provider2 instanceof ExternalDocumentationProvider && (externalDocumentationProvider = (ExternalDocumentationProvider)((Object)provider2)).canPromptToConfigureDocumentation(element2)) {
                        externalDocumentationProvider.promptToConfigureDocumentation(element2);
                    }
                } else if (finalUrls.size() == 1) {
                    BrowserUtil.browse((String)((String)finalUrls.get(0)));
                } else {
                    JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(LangBundle.message("popup.title.choose.external.documentation.root", new Object[0]), ArrayUtilRt.toStringArray(finalUrls)){

                        public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                            BrowserUtil.browse((String)selectedValue);
                            return FINAL_CHOICE;
                        }
                    }).showInBestPositionFor(DataManager.getInstance().getDataContext(contextComponent));
                }
            }, ModalityState.NON_MODAL);
        });
    }

    @Nullable
    private static PsiElement getOriginalElement(@NotNull DataContext dataContext, @Nullable Editor editor2) {
        PsiFile file2;
        if (dataContext == null) {
            ExternalJavaDocAction.$$$reportNull$$$0(2);
        }
        return (file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext)) != null && editor2 != null ? file2.findElementAt(editor2.getCaretModel().getOffset()) : null;
    }

    @Nullable
    private static PsiElement getElement(@NotNull DataContext dataContext, @Nullable Editor editor2, @Nullable PsiElement originalElement) {
        if (dataContext == null) {
            ExternalJavaDocAction.$$$reportNull$$$0(3);
        }
        return editor2 == null || originalElement == null ? (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext) : DocumentationManager.getInstance(originalElement.getProject()).findTargetElement(editor2, originalElement.getContainingFile(), originalElement);
    }

    public void update(@NotNull AnActionEvent event) {
        boolean enabled;
        PsiElement originalElement;
        Editor editor2;
        if (event == null) {
            ExternalJavaDocAction.$$$reportNull$$$0(4);
        }
        Presentation presentation2 = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        PsiElement element2 = ExternalJavaDocAction.getElement(dataContext, editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext), originalElement = ExternalJavaDocAction.getOriginalElement(dataContext, editor2));
        DocumentationProvider provider2 = DocumentationManager.getProviderFromElement(element2);
        if (provider2 instanceof ExternalDocumentationProvider) {
            ExternalDocumentationProvider edProvider = (ExternalDocumentationProvider)((Object)provider2);
            enabled = CompositeDocumentationProvider.hasUrlsFor(provider2, element2, originalElement) || edProvider.canPromptToConfigureDocumentation(element2);
        } else {
            List<String> urls = provider2.getUrlFor(element2, originalElement);
            enabled = urls != null && !urls.isEmpty();
        }
        presentation2.setEnabled(enabled);
        if (editor2 != null) {
            if (ActionPlaces.isMainMenuOrActionSearch((String)event.getPlace())) {
                presentation2.setVisible(true);
            } else {
                presentation2.setVisible(enabled);
            }
        } else {
            presentation2.setVisible(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ExternalJavaDocAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ExternalJavaDocAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

