/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.daemon.impl.IdentifierUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.ide.actions.FqnUtil;
import com.intellij.ide.actions.QualifiedNameProviderUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CopyReferenceUtil
extends FqnUtil {
    static void highlight(Editor editor2, Project project2, List<? extends PsiElement> elements) {
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project2);
        if (elements.size() == 1 && editor2 != null && project2 != null) {
            PsiElement element2 = elements.get(0);
            PsiElement nameIdentifier = IdentifierUtil.getNameIdentifier(element2);
            if (nameIdentifier != null) {
                highlightManager.addOccurrenceHighlights(editor2, new PsiElement[]{nameIdentifier}, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
            } else {
                PsiReference reference2 = TargetElementUtil.findReference(editor2, editor2.getCaretModel().getOffset());
                if (reference2 != null) {
                    highlightManager.addOccurrenceHighlights(editor2, new PsiReference[]{reference2}, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
                } else if (element2 != PsiDocumentManager.getInstance(project2).getCachedPsiFile(editor2.getDocument())) {
                    highlightManager.addOccurrenceHighlights(editor2, new PsiElement[]{element2}, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
                }
            }
        }
    }

    @NotNull
    static List<PsiElement> getElementsToCopy(@Nullable Editor editor2, DataContext dataContext) {
        PsiElement[] psiElements;
        PsiReference reference2;
        ArrayList elements = new ArrayList();
        if (editor2 != null && (reference2 = TargetElementUtil.findReference(editor2)) != null) {
            ContainerUtil.addIfNotNull(elements, reference2.getElement());
        }
        if (elements.isEmpty() && (psiElements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext)) != null) {
            Collections.addAll(elements, psiElements);
        }
        if (elements.isEmpty()) {
            ContainerUtil.addIfNotNull(elements, (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext));
        }
        if (elements.isEmpty() && editor2 == null) {
            Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
            if (project2 != null && files2 != null) {
                for (VirtualFile file2 : files2) {
                    ContainerUtil.addIfNotNull(elements, PsiManager.getInstance(project2).findFile(file2));
                }
            }
        }
        List<PsiElement> list2 = ContainerUtil.mapNotNull(elements, element2 -> element2 instanceof PsiFile && !((PsiFile)element2).getViewProvider().isPhysical() ? null : CopyReferenceUtil.adjustElement(element2));
        if (list2 == null) {
            CopyReferenceUtil.$$$reportNull$$$0(0);
        }
        return list2;
    }

    static PsiElement adjustElement(PsiElement element2) {
        PsiElement adjustedElement = QualifiedNameProviderUtil.adjustElementToCopy((PsiElement)element2);
        return adjustedElement != null ? adjustedElement : element2;
    }

    static void setStatusBarText(Project project2, @NlsContexts.StatusBarText String message2) {
        StatusBarEx statusBar;
        if (project2 != null && (statusBar = (StatusBarEx)WindowManager.getInstance().getStatusBar(project2)) != null) {
            statusBar.setInfo(message2);
        }
    }

    static String doCopy(List<? extends PsiElement> elements, @Nullable Editor editor2) {
        if (elements.isEmpty()) {
            return null;
        }
        ArrayList<String> fqns = new ArrayList<String>();
        for (PsiElement psiElement : elements) {
            String fqn = CopyReferenceUtil.elementToFqn((PsiElement)psiElement, (Editor)editor2);
            if (fqn == null) {
                return null;
            }
            fqns.add(fqn);
        }
        return StringUtil.join(fqns, "\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/CopyReferenceUtil", "getElementsToCopy"));
    }
}

