/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.FrameworkDetector;
import com.intellij.framework.detection.impl.FrameworkDetectorRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class FrameworkDetectorRegistryImpl
extends FrameworkDetectorRegistry
implements Disposable {
    private static final Logger LOG = Logger.getInstance(FrameworkDetectorRegistryImpl.class);
    private volatile Map<String, FrameworkDetector> myDetectorById;
    private volatile MultiMap<FileType, Pair<ElementPattern<FileContent>, String>> myDetectorsMap;
    private volatile MultiMap<FileType, String> myDetectorsByFileType;
    private volatile FileType[] myAcceptedTypes;
    private volatile boolean myLoaded;
    private final Object myInitializationLock = new Object();

    public FrameworkDetectorRegistryImpl() {
        FrameworkDetector.EP_NAME.addChangeListener(() -> this.onDetectorsChanged(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void ensureDetectorsLoaded() {
        if (this.myLoaded) {
            return;
        }
        Object object = this.myInitializationLock;
        synchronized (object) {
            if (!this.myLoaded) {
                this.loadDetectors();
                this.myLoaded = true;
            }
        }
    }

    private void loadDetectors() {
        this.myDetectorById = new HashMap<String, FrameworkDetector>();
        this.myDetectorsByFileType = new MultiMap();
        this.myDetectorsMap = new MultiMap();
        for (FrameworkDetector detector : FrameworkDetector.EP_NAME.getExtensionList()) {
            this.myDetectorById.put(detector.getDetectorId(), detector);
            this.myDetectorsByFileType.putValue(detector.getFileType(), detector.getDetectorId());
            this.myDetectorsMap.putValue(detector.getFileType(), Pair.create(detector.createSuitableFilePattern(), detector.getDetectorId()));
            LOG.debug("'" + detector.getDetectorId() + "' framework detector registered");
        }
        this.myAcceptedTypes = this.myDetectorsByFileType.keySet().toArray(FileType.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public MultiMap<FileType, Pair<ElementPattern<FileContent>, String>> getDetectorsMap() {
        this.ensureDetectorsLoaded();
        MultiMap<FileType, Pair<ElementPattern<FileContent>, String>> multiMap = this.myDetectorsMap;
        if (multiMap == null) {
            FrameworkDetectorRegistryImpl.$$$reportNull$$$0(0);
        }
        return multiMap;
    }

    @Override
    public FileType @NotNull [] getAcceptedFileTypes() {
        this.ensureDetectorsLoaded();
        if (this.myAcceptedTypes == null) {
            FrameworkDetectorRegistryImpl.$$$reportNull$$$0(1);
        }
        return this.myAcceptedTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDetectorsChanged() {
        Object object = this.myInitializationLock;
        synchronized (object) {
            this.myAcceptedTypes = null;
            this.myDetectorsMap = null;
            this.myDetectorsByFileType = null;
            this.myLoaded = false;
        }
    }

    @Override
    public FrameworkType findFrameworkType(@NotNull String typeId) {
        if (typeId == null) {
            FrameworkDetectorRegistryImpl.$$$reportNull$$$0(2);
        }
        for (FrameworkType frameworkType : this.getFrameworkTypes()) {
            if (!typeId.equals(frameworkType.getId())) continue;
            return frameworkType;
        }
        return null;
    }

    @Override
    @NotNull
    public List<? extends FrameworkType> getFrameworkTypes() {
        ArrayList<FrameworkType> types = new ArrayList<FrameworkType>();
        for (FrameworkDetector detector : FrameworkDetector.EP_NAME.getExtensionList()) {
            types.add(detector.getFrameworkType());
        }
        ArrayList<FrameworkType> arrayList = types;
        if (arrayList == null) {
            FrameworkDetectorRegistryImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    public FrameworkDetector getDetectorById(@NotNull String id2) {
        if (id2 == null) {
            FrameworkDetectorRegistryImpl.$$$reportNull$$$0(4);
        }
        this.ensureDetectorsLoaded();
        return this.myDetectorById.get(id2);
    }

    @Override
    @NotNull
    public Collection<String> getDetectorIds(@NotNull FileType fileType) {
        if (fileType == null) {
            FrameworkDetectorRegistryImpl.$$$reportNull$$$0(5);
        }
        this.ensureDetectorsLoaded();
        Collection<String> collection = this.myDetectorsByFileType.get(fileType);
        if (collection == null) {
            FrameworkDetectorRegistryImpl.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<String> getAllDetectorIds() {
        this.ensureDetectorsLoaded();
        Set<String> set2 = this.myDetectorById.keySet();
        if (set2 == null) {
            FrameworkDetectorRegistryImpl.$$$reportNull$$$0(7);
        }
        return set2;
    }

    @Override
    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/framework/detection/impl/FrameworkDetectorRegistryImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetectorsMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptedFileTypes";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/framework/detection/impl/FrameworkDetectorRegistryImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkTypes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetectorIds";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDetectorIds";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findFrameworkType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDetectorById";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDetectorIds";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

