/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.service;

import com.intellij.CodeStyleBundle;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.service.FormattingNotificationService;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class FormattingUiNotificationService
implements FormattingNotificationService {
    @NotNull
    private final Project myProject;

    public FormattingUiNotificationService(@NotNull Project project2) {
        if (project2 == null) {
            FormattingUiNotificationService.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
    }

    public void reportError(@NotNull String groupId, @NotNull @NlsContexts.NotificationTitle String title, @NotNull @NlsContexts.NotificationContent String message2) {
        if (groupId == null) {
            FormattingUiNotificationService.$$$reportNull$$$0(1);
        }
        if (title == null) {
            FormattingUiNotificationService.$$$reportNull$$$0(2);
        }
        if (message2 == null) {
            FormattingUiNotificationService.$$$reportNull$$$0(3);
        }
        Notifications.Bus.notify((Notification)new Notification(groupId, title, message2, NotificationType.ERROR), (Project)this.myProject);
    }

    public void reportErrorAndNavigate(@NotNull String groupId, @NotNull String title, @NotNull String message2, @NotNull FormattingContext context2, final int offset) {
        VirtualFile virtualFile2;
        if (groupId == null) {
            FormattingUiNotificationService.$$$reportNull$$$0(4);
        }
        if (title == null) {
            FormattingUiNotificationService.$$$reportNull$$$0(5);
        }
        if (message2 == null) {
            FormattingUiNotificationService.$$$reportNull$$$0(6);
        }
        if (context2 == null) {
            FormattingUiNotificationService.$$$reportNull$$$0(7);
        }
        if ((virtualFile2 = context2.getVirtualFile()) != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                FileEditor[] editors2 = FileEditorManager.getInstance(this.myProject).getEditors(virtualFile2);
                if (editors2.length > 0) {
                    this.reportError(groupId, title, message2);
                    FileEditor textEditor = ContainerUtil.find(editors2, editor2 -> editor2 instanceof TextEditor);
                    if (textEditor != null) {
                        this.navigateToFile(virtualFile2, offset);
                    }
                } else {
                    Notification notification = new Notification(groupId, title, message2, NotificationType.ERROR);
                    notification.addAction((AnAction)new DumbAwareAction(CodeStyleBundle.message((String)"formatting.service.open.file", (Object[])new Object[]{virtualFile2.getName()})){

                        public void actionPerformed(@NotNull AnActionEvent e) {
                            if (e == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            FormattingUiNotificationService.this.navigateToFile(virtualFile2, offset);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/formatting/service/FormattingUiNotificationService$1", "actionPerformed"));
                        }
                    });
                    Notifications.Bus.notify((Notification)notification, (Project)this.myProject);
                }
            });
        }
    }

    private void navigateToFile(@NotNull VirtualFile file2, int offset) {
        if (file2 == null) {
            FormattingUiNotificationService.$$$reportNull$$$0(8);
        }
        OpenFileDescriptor descriptor = new OpenFileDescriptor(this.myProject, file2, offset);
        FileEditorManager.getInstance(this.myProject).openTextEditor(descriptor, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/formatting/service/FormattingUiNotificationService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reportError";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "reportErrorAndNavigate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateToFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

