/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.commandLine;

import com.intellij.formatting.commandLine.FileSetProcessingStatistics;
import com.intellij.formatting.commandLine.FileSetProcessor;
import com.intellij.formatting.commandLine.FileSetProcessorKt;
import com.intellij.formatting.commandLine.MessageOutput;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u001dJ\u000e\u0010 \u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\rJ\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001d0'J\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\r0'J\u0006\u0010)\u001a\u00020*J\u001a\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/H&J\f\u00100\u001a\u00020\u0005*\u00020\u001dH\u0002J\u0011\u00101\u001a\u00070-\u00a2\u0006\u0002\b2*\u00020\u001dH\u0002R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015R\u001e\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001d0\fj\b\u0012\u0004\u0012\u00020\u001d`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0015\u00a8\u00063"}, d2={"Lcom/intellij/formatting/commandLine/FileSetProcessor;", "", "messageOutput", "Lcom/intellij/formatting/commandLine/MessageOutput;", "isRecursive", "", "charset", "Ljava/nio/charset/Charset;", "(Lcom/intellij/formatting/commandLine/MessageOutput;ZLjava/nio/charset/Charset;)V", "getCharset", "()Ljava/nio/charset/Charset;", "fileMasks", "Ljava/util/ArrayList;", "Lkotlin/text/Regex;", "Lkotlin/collections/ArrayList;", "()Z", "getMessageOutput", "()Lcom/intellij/formatting/commandLine/MessageOutput;", "processed", "", "getProcessed", "()I", "statistics", "Lcom/intellij/formatting/commandLine/FileSetProcessingStatistics;", "getStatistics", "()Lcom/intellij/formatting/commandLine/FileSetProcessingStatistics;", "succeeded", "getSucceeded", "topEntries", "Ljava/io/File;", "total", "getTotal", "addEntry", "file", "filePath", "", "addFileMask", "mask", "getEntries", "", "getFileMasks", "processFiles", "", "processVirtualFile", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "projectSettings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "matchesFileMask", "toVirtualFile", "Lorg/jetbrains/annotations/Nullable;", "intellij.platform.lang.impl"})
public abstract class FileSetProcessor {
    private final ArrayList<File> topEntries;
    private final ArrayList<Regex> fileMasks;
    @NotNull
    private final FileSetProcessingStatistics statistics;
    @NotNull
    private final MessageOutput messageOutput;
    private final boolean isRecursive;
    @Nullable
    private final Charset charset;

    @NotNull
    protected final FileSetProcessingStatistics getStatistics() {
        return this.statistics;
    }

    public final int getTotal() {
        return this.statistics.getTotal();
    }

    public final int getProcessed() {
        return this.statistics.getProcessed();
    }

    public final int getSucceeded() {
        return this.statistics.getValid();
    }

    public final boolean addEntry(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return this.addEntry(new File(filePath));
    }

    public final boolean addEntry(@NotNull File file2) {
        File file3;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        File it = file3 = file2;
        boolean bl = false;
        File file4 = it.exists() ? file3 : null;
        if (file4 == null) {
            throw (Throwable)new IOException("File " + file2 + " not found.");
        }
        it = file3 = file4;
        boolean bl2 = false;
        return this.topEntries.add(it);
    }

    public final boolean addFileMask(@NotNull Regex mask) {
        Intrinsics.checkNotNullParameter((Object)mask, (String)"mask");
        return this.fileMasks.add(mask);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean matchesFileMask(File $this$matchesFileMask) {
        String string2;
        Regex mask;
        if (this.fileMasks.isEmpty()) return true;
        Iterable $this$any$iv = this.fileMasks;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            mask = (Regex)element$iv;
            boolean bl = false;
            string2 = $this$matchesFileMask.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
        } while (!mask.matches((CharSequence)string2));
        return true;
    }

    private final VirtualFile toVirtualFile(File $this$toVirtualFile) {
        VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile($this$toVirtualFile);
        if (virtualFile2 == null) {
            throw (Throwable)new IOException("Can not find " + $this$toVirtualFile.getPath());
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"LocalFileSystem.getInsta\u2026ion(\"Can not find $path\")");
        return virtualFile2;
    }

    /*
     * WARNING - void declaration
     */
    public final void processFiles() {
        Iterable $this$forEach$iv = this.topEntries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void currentProject;
            void innerProjectSettings;
            File entry = (File)element$iv;
            boolean bl = false;
            CodeStyleSettings outerProjectSettings = FileSetProcessorKt.access$findCodeStyleSettings(FileSetProcessorKt.access$getOuterProject(entry));
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
            objectRef2.element = null;
            Sequence sequence = SequencesKt.onEach((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)entry).maxDepth(this.isRecursive ? Integer.MAX_VALUE : 1).onEnter((Function1)new Function1<File, Boolean>(outerProjectSettings, (Ref.ObjectRef)innerProjectSettings, (Ref.ObjectRef)currentProject){
                final /* synthetic */ CodeStyleSettings $outerProjectSettings;
                final /* synthetic */ Ref.ObjectRef $innerProjectSettings;
                final /* synthetic */ Ref.ObjectRef $currentProject;

                public final boolean invoke(@NotNull File dir) {
                    Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                    if (this.$outerProjectSettings == null && (CodeStyleSettings)this.$innerProjectSettings.element == null) {
                        CodeStyleSettings codeStyleSettings;
                        File dotIdea = FilesKt.resolve((File)dir, (String)".idea");
                        Ref.ObjectRef objectRef = this.$innerProjectSettings;
                        CodeStyleSettings codeStyleSettings2 = FileSetProcessorKt.access$findCodeStyleSettings(dotIdea);
                        if (codeStyleSettings2 != null) {
                            CodeStyleSettings codeStyleSettings3;
                            CodeStyleSettings codeStyleSettings4 = codeStyleSettings3 = codeStyleSettings2;
                            Ref.ObjectRef objectRef2 = objectRef;
                            boolean bl = false;
                            this.$currentProject.element = dir;
                            FileSetProcessorKt.access$getLOG$p().info("Switching to project specific settings for " + dir.getPath());
                            Unit unit = Unit.INSTANCE;
                            objectRef = objectRef2;
                            codeStyleSettings = codeStyleSettings3;
                        } else {
                            codeStyleSettings = null;
                        }
                        objectRef.element = codeStyleSettings;
                    }
                    FileSetProcessorKt.access$getLOG$p().info("Scanning directory " + dir.getPath());
                    return true;
                }
                {
                    this.$outerProjectSettings = codeStyleSettings;
                    this.$innerProjectSettings = objectRef;
                    this.$currentProject = objectRef2;
                    super(1);
                }
            }).onLeave((Function1)new Function1<File, Unit>((Ref.ObjectRef)currentProject, (Ref.ObjectRef)innerProjectSettings){
                final /* synthetic */ Ref.ObjectRef $currentProject;
                final /* synthetic */ Ref.ObjectRef $innerProjectSettings;

                public final void invoke(@NotNull File it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (Intrinsics.areEqual((Object)it, (Object)((File)this.$currentProject.element))) {
                        this.$currentProject.element = null;
                        this.$innerProjectSettings.element = null;
                    }
                }
                {
                    this.$currentProject = objectRef;
                    this.$innerProjectSettings = objectRef2;
                    super(1);
                }
            })), (Function1)processFiles.1.3.INSTANCE), (Function1)((Function1)new Function1<File, Boolean>(this){
                final /* synthetic */ FileSetProcessor this$0;
                {
                    this.this$0 = fileSetProcessor;
                    super(1);
                }

                public final boolean invoke(@NotNull File it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return FileSetProcessor.access$matchesFileMask(this.this$0, it);
                }
            })), (Function1)((Function1)new Function1<File, VirtualFile>(this){
                final /* synthetic */ FileSetProcessor this$0;
                {
                    this.this$0 = fileSetProcessor;
                    super(1);
                }

                @NotNull
                public final VirtualFile invoke(@NotNull File ioFile) {
                    Intrinsics.checkNotNullParameter((Object)ioFile, (String)"ioFile");
                    return FileSetProcessor.access$toVirtualFile(this.this$0, ioFile);
                }
            })), (Function1)((Function1)new Function1<VirtualFile, Unit>(this){
                final /* synthetic */ FileSetProcessor this$0;
                {
                    this.this$0 = fileSetProcessor;
                    super(1);
                }

                public final void invoke(@NotNull VirtualFile vFile) {
                    block0: {
                        Charset charset;
                        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
                        Charset charset2 = this.this$0.getCharset();
                        if (charset2 == null) break block0;
                        Charset it = charset = charset2;
                        boolean bl = false;
                        vFile.setCharset(it);
                    }
                }
            }));
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                VirtualFile vFile = (VirtualFile)element$iv2;
                boolean bl2 = false;
                FileSetProcessorKt.access$getLOG$p().info("Processing " + vFile.getPath());
                this.statistics.fileTraversed();
                CodeStyleSettings codeStyleSettings = outerProjectSettings;
                if (codeStyleSettings == null) {
                    codeStyleSettings = (CodeStyleSettings)innerProjectSettings.element;
                }
                this.processVirtualFile(vFile, codeStyleSettings);
            }
        }
    }

    public abstract void processVirtualFile(@NotNull VirtualFile var1, @Nullable CodeStyleSettings var2);

    @NotNull
    public final List<Regex> getFileMasks() {
        return CollectionsKt.toList((Iterable)this.fileMasks);
    }

    @NotNull
    public final List<File> getEntries() {
        return CollectionsKt.toList((Iterable)this.topEntries);
    }

    @NotNull
    public final MessageOutput getMessageOutput() {
        return this.messageOutput;
    }

    public final boolean isRecursive() {
        return this.isRecursive;
    }

    @Nullable
    public final Charset getCharset() {
        return this.charset;
    }

    public FileSetProcessor(@NotNull MessageOutput messageOutput, boolean isRecursive, @Nullable Charset charset) {
        Intrinsics.checkNotNullParameter((Object)messageOutput, (String)"messageOutput");
        this.messageOutput = messageOutput;
        this.isRecursive = isRecursive;
        this.charset = charset;
        this.topEntries = new ArrayList();
        this.fileMasks = new ArrayList();
        this.statistics = new FileSetProcessingStatistics();
    }

    public /* synthetic */ FileSetProcessor(MessageOutput messageOutput, boolean bl, Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            charset = null;
        }
        this(messageOutput, bl, charset);
    }

    public static final /* synthetic */ boolean access$matchesFileMask(FileSetProcessor $this, File $this$access_u24matchesFileMask) {
        return $this.matchesFileMask($this$access_u24matchesFileMask);
    }

    public static final /* synthetic */ VirtualFile access$toVirtualFile(FileSetProcessor $this, File $this$access_u24toVirtualFile) {
        return $this.toVirtualFile($this$access_u24toVirtualFile);
    }
}

