/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.commandLine;

import com.intellij.formatting.commandLine.CodeStyleProcessorBuilder;
import com.intellij.formatting.commandLine.CodeStyleProcessorBuilderKt;
import com.intellij.formatting.commandLine.FileSetCodeStyleProcessor;
import com.intellij.formatting.commandLine.FileSetFormatValidator;
import com.intellij.formatting.commandLine.FileSetFormatter;
import com.intellij.formatting.commandLine.MessageOutput;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010*\u001a\u00020\u0000J\u0006\u0010+\u001a\u00020,J\b\u0010-\u001a\u00020,H\u0002J\b\u0010.\u001a\u00020,H\u0002J\u0006\u0010/\u001a\u00020\u0000J\u0006\u00100\u001a\u00020\u0000J\u000e\u00101\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u00020\fJ\u000e\u00104\u001a\u00020\u00002\u0006\u00105\u001a\u000206J\u000e\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u000206J\f\u00109\u001a\u00020,*\u00020,H\u0002R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R!\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010 \"\u0004\b$\u0010\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001c\u0010'\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u000e\"\u0004\b)\u0010\u0010\u00a8\u0006:"}, d2={"Lcom/intellij/formatting/commandLine/CodeStyleProcessorBuilder;", "", "messageOutput", "Lcom/intellij/formatting/commandLine/MessageOutput;", "(Lcom/intellij/formatting/commandLine/MessageOutput;)V", "charset", "Ljava/nio/charset/Charset;", "getCharset", "()Ljava/nio/charset/Charset;", "setCharset", "(Ljava/nio/charset/Charset;)V", "defaultCodeStyle", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "getDefaultCodeStyle", "()Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "setDefaultCodeStyle", "(Lcom/intellij/psi/codeStyle/CodeStyleSettings;)V", "entries", "Ljava/util/ArrayList;", "Ljava/io/File;", "Lkotlin/collections/ArrayList;", "getEntries", "()Ljava/util/ArrayList;", "fileMasks", "", "Lkotlin/text/Regex;", "getFileMasks", "()Ljava/util/List;", "setFileMasks", "(Ljava/util/List;)V", "isDryRun", "", "()Z", "setDryRun", "(Z)V", "isRecursive", "setRecursive", "getMessageOutput", "()Lcom/intellij/formatting/commandLine/MessageOutput;", "primaryCodeStyle", "getPrimaryCodeStyle", "setPrimaryCodeStyle", "allowFactoryDefaults", "build", "Lcom/intellij/formatting/commandLine/FileSetCodeStyleProcessor;", "buildFormatValidator", "buildFormatter", "dryRun", "recursive", "withCharset", "withCodeStyleSettings", "settings", "withEntry", "entryPath", "", "withFileMasks", "masks", "configure", "intellij.platform.lang.impl"})
public final class CodeStyleProcessorBuilder {
    private boolean isDryRun;
    private boolean isRecursive;
    @Nullable
    private CodeStyleSettings primaryCodeStyle;
    @Nullable
    private CodeStyleSettings defaultCodeStyle;
    @NotNull
    private List<Regex> fileMasks;
    @NotNull
    private final ArrayList<File> entries;
    @Nullable
    private Charset charset;
    @NotNull
    private final MessageOutput messageOutput;

    public final boolean isDryRun() {
        return this.isDryRun;
    }

    public final void setDryRun(boolean bl) {
        this.isDryRun = bl;
    }

    public final boolean isRecursive() {
        return this.isRecursive;
    }

    public final void setRecursive(boolean bl) {
        this.isRecursive = bl;
    }

    @Nullable
    public final CodeStyleSettings getPrimaryCodeStyle() {
        return this.primaryCodeStyle;
    }

    public final void setPrimaryCodeStyle(@Nullable CodeStyleSettings codeStyleSettings) {
        this.primaryCodeStyle = codeStyleSettings;
    }

    @Nullable
    public final CodeStyleSettings getDefaultCodeStyle() {
        return this.defaultCodeStyle;
    }

    public final void setDefaultCodeStyle(@Nullable CodeStyleSettings codeStyleSettings) {
        this.defaultCodeStyle = codeStyleSettings;
    }

    @NotNull
    public final List<Regex> getFileMasks() {
        return this.fileMasks;
    }

    public final void setFileMasks(@NotNull List<Regex> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.fileMasks = list2;
    }

    @NotNull
    public final ArrayList<File> getEntries() {
        return this.entries;
    }

    @Nullable
    public final Charset getCharset() {
        return this.charset;
    }

    public final void setCharset(@Nullable Charset charset) {
        this.charset = charset;
    }

    @NotNull
    public final CodeStyleProcessorBuilder dryRun() {
        CodeStyleProcessorBuilder codeStyleProcessorBuilder;
        CodeStyleProcessorBuilder it = codeStyleProcessorBuilder = this;
        boolean bl = false;
        this.isDryRun = true;
        return codeStyleProcessorBuilder;
    }

    @NotNull
    public final CodeStyleProcessorBuilder recursive() {
        CodeStyleProcessorBuilder codeStyleProcessorBuilder;
        CodeStyleProcessorBuilder it = codeStyleProcessorBuilder = this;
        boolean bl = false;
        this.isRecursive = true;
        return codeStyleProcessorBuilder;
    }

    @NotNull
    public final CodeStyleProcessorBuilder allowFactoryDefaults() {
        CodeStyleProcessorBuilder codeStyleProcessorBuilder;
        CodeStyleProcessorBuilder it = codeStyleProcessorBuilder = this;
        boolean bl = false;
        this.defaultCodeStyle = CodeStyleSettingsManager.getInstance().createSettings();
        return codeStyleProcessorBuilder;
    }

    @NotNull
    public final CodeStyleProcessorBuilder withCodeStyleSettings(@NotNull CodeStyleSettings settings) {
        CodeStyleProcessorBuilder codeStyleProcessorBuilder;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        CodeStyleProcessorBuilder it = codeStyleProcessorBuilder = this;
        boolean bl = false;
        this.primaryCodeStyle = settings;
        return codeStyleProcessorBuilder;
    }

    @NotNull
    public final CodeStyleProcessorBuilder withFileMasks(@NotNull String masks) {
        CodeStyleProcessorBuilder codeStyleProcessorBuilder;
        Intrinsics.checkNotNullParameter((Object)masks, (String)"masks");
        CodeStyleProcessorBuilder it = codeStyleProcessorBuilder = this;
        boolean bl = false;
        this.fileMasks = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)StringsKt.split$default((CharSequence)masks, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null)), (Function1)withFileMasks.1.1.INSTANCE), (Function1)withFileMasks.1.2.INSTANCE), (Function1)withFileMasks.1.3.INSTANCE), (Function1)withFileMasks.1.4.INSTANCE));
        return codeStyleProcessorBuilder;
    }

    @NotNull
    public final CodeStyleProcessorBuilder withEntry(@NotNull String entryPath) {
        CodeStyleProcessorBuilder codeStyleProcessorBuilder;
        Intrinsics.checkNotNullParameter((Object)entryPath, (String)"entryPath");
        CodeStyleProcessorBuilder it = codeStyleProcessorBuilder = this;
        boolean bl = false;
        this.entries.add(new File(entryPath));
        return codeStyleProcessorBuilder;
    }

    @NotNull
    public final CodeStyleProcessorBuilder withCharset(@NotNull Charset charset) {
        CodeStyleProcessorBuilder codeStyleProcessorBuilder;
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        CodeStyleProcessorBuilder it = codeStyleProcessorBuilder = this;
        boolean bl = false;
        this.charset = charset;
        return codeStyleProcessorBuilder;
    }

    private final FileSetCodeStyleProcessor configure(FileSetCodeStyleProcessor $this$configure) {
        FileSetCodeStyleProcessor fileSetCodeStyleProcessor;
        FileSetCodeStyleProcessor $this$apply = fileSetCodeStyleProcessor = $this$configure;
        boolean bl = false;
        Iterable $this$forEach$iv = this.fileMasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Regex mask = (Regex)element$iv;
            boolean bl2 = false;
            CodeStyleProcessorBuilderKt.access$getLOG$p().info("File mask regexp: " + mask.getPattern());
            $this$apply.addFileMask(mask);
        }
        $this$forEach$iv = this.entries;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file2 = (File)element$iv;
            boolean bl3 = false;
            $this$apply.addEntry(file2);
        }
        return fileSetCodeStyleProcessor;
    }

    private final FileSetCodeStyleProcessor buildFormatter() {
        return this.configure(new FileSetFormatter(this.messageOutput, this.isRecursive, this.charset, this.primaryCodeStyle, this.defaultCodeStyle));
    }

    private final FileSetCodeStyleProcessor buildFormatValidator() {
        return this.configure(new FileSetFormatValidator(this.messageOutput, this.isRecursive, this.charset, this.primaryCodeStyle, this.defaultCodeStyle));
    }

    @NotNull
    public final FileSetCodeStyleProcessor build() {
        return this.isDryRun ? this.buildFormatValidator() : this.buildFormatter();
    }

    @NotNull
    public final MessageOutput getMessageOutput() {
        return this.messageOutput;
    }

    public CodeStyleProcessorBuilder(@NotNull MessageOutput messageOutput) {
        Intrinsics.checkNotNullParameter((Object)messageOutput, (String)"messageOutput");
        this.messageOutput = messageOutput;
        this.fileMasks = CollectionsKt.emptyList();
        this.entries = new ArrayList();
    }
}

