/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.alignment;

import com.intellij.formatting.alignment.AlignmentInColumnsConfig;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class AlignmentInColumnsHelper {
    public static final AlignmentInColumnsHelper INSTANCE = new AlignmentInColumnsHelper();

    public boolean useDifferentVarDeclarationAlignment(ASTNode node2, AlignmentInColumnsConfig config, int blankLinesToBeKeptOnReformat) {
        List<IElementType> currTypes;
        List<IElementType> prevTypes;
        ASTNode prev = AlignmentInColumnsHelper.getPreviousAdjacentNodeOfTargetType(node2, config, blankLinesToBeKeptOnReformat);
        if (prev == null) {
            return true;
        }
        ASTNode curr = AlignmentInColumnsHelper.deriveNodeOfTargetType(node2, TokenSet.create(prev.getElementType()));
        if (curr == null) {
            return true;
        }
        ASTNode prevSubNode = AlignmentInColumnsHelper.getSubNodeThatStartsNewLine(prev.getFirstChildNode(), config);
        ASTNode currSubNode = AlignmentInColumnsHelper.getSubNodeThatStartsNewLine(curr.getFirstChildNode(), config);
        while (true) {
            boolean currNodeIsDefined;
            boolean prevNodeIsDefined = prevSubNode != null;
            boolean bl = currNodeIsDefined = currSubNode != null;
            if (prevNodeIsDefined ^ currNodeIsDefined) {
                return true;
            }
            if (prevSubNode == null) break;
            if (prevSubNode.getElementType() != currSubNode.getElementType()) {
                return true;
            }
            prevSubNode = AlignmentInColumnsHelper.getSubNodeThatStartsNewLine(prevSubNode.getTreeNext(), config);
            currSubNode = AlignmentInColumnsHelper.getSubNodeThatStartsNewLine(currSubNode.getTreeNext(), config);
        }
        ASTNode currentFieldToUse = curr;
        for (ASTNode nextNode = curr.getTreeNext(); nextNode != null && nextNode.getTreeParent() == curr.getTreeParent(); nextNode = nextNode.getTreeNext()) {
            IElementType type = nextNode.getElementType();
            if (config.getWhiteSpaceTokenTypes().contains(type)) {
                ASTNode previous = nextNode.getTreePrev();
                if ((previous == null || previous.getElementType() != curr.getElementType()) && StringUtil.countNewLines(nextNode.getChars()) <= 1) continue;
                break;
            }
            if (config.getCommentTokenTypes().contains(type) || type != curr.getElementType()) continue;
            currentFieldToUse = nextNode;
        }
        return !(prevTypes = AlignmentInColumnsHelper.findSubNodeTypes(prev, config.getDistinguishableTypes())).equals(currTypes = AlignmentInColumnsHelper.findSubNodeTypes(currentFieldToUse, config.getDistinguishableTypes()));
    }

    @Nullable
    private static ASTNode getPreviousAdjacentNodeOfTargetType(ASTNode baseNode, AlignmentInColumnsConfig config, final double blankLinesToBeKeptOnReformat) {
        ASTNode nodeOfTargetType = AlignmentInColumnsHelper.deriveNodeOfTargetType(baseNode, config.getTargetDeclarationTypes());
        if (nodeOfTargetType == null) {
            return null;
        }
        final ASTNode[] prev = new ASTNode[1];
        AlignmentInColumnsHelper.findPreviousNode(config, baseNode, new NodeProcessor(){

            @Override
            public boolean targetTypeFound(ASTNode node2) {
                prev[0] = node2;
                return true;
            }

            @Override
            public boolean whitespaceFound(ASTNode node2) {
                return blankLinesToBeKeptOnReformat > 0.0 && StringUtil.countChars(node2.getText(), '\n') > 1;
            }
        });
        if (prev[0] == null) {
            return null;
        }
        Couple<ASTNode> siblingParents = TreeUtil.findTopmostSiblingParents(prev[0], baseNode);
        if (siblingParents.first != null && siblingParents.second != null) {
            for (ASTNode each = ((ASTNode)siblingParents.second).getTreePrev(); each != null && each != siblingParents.first; each = each.getTreePrev()) {
                IElementType eachType = each.getElementType();
                if (config.getCommentTokenTypes().contains(eachType) || config.getWhiteSpaceTokenTypes().contains(eachType)) continue;
                return null;
            }
        }
        return AlignmentInColumnsHelper.deriveNodeOfTargetType(prev[0], TokenSet.create(nodeOfTargetType.getElementType()));
    }

    @Nullable
    private static ASTNode deriveNodeOfTargetType(ASTNode baseNode, TokenSet targetTypes) {
        if (targetTypes.contains(baseNode.getElementType())) {
            return baseNode;
        }
        for (ASTNode node2 = baseNode; node2 != null; node2 = node2.getFirstChildNode()) {
            IElementType nodeType = node2.getElementType();
            if (!targetTypes.contains(nodeType)) continue;
            return node2;
        }
        return null;
    }

    private static boolean findPreviousNode(AlignmentInColumnsConfig config, ASTNode from, NodeProcessor processor) {
        return AlignmentInColumnsHelper.findPreviousNode(config, from, from.getElementType(), false, true, processor);
    }

    private static boolean findPreviousNode(AlignmentInColumnsConfig config, ASTNode from, IElementType targetType, boolean processFrom, boolean processParent, NodeProcessor processor) {
        ASTNode prev;
        if (from == null) {
            return false;
        }
        ASTNode aSTNode = prev = processFrom ? from : from.getTreePrev();
        while (prev != null) {
            IElementType prevType = prev.getElementType();
            if (prevType == targetType ? processor.targetTypeFound(prev) : config.getWhiteSpaceTokenTypes().contains(prevType) && processor.whitespaceFound(prev)) {
                return true;
            }
            if (AlignmentInColumnsHelper.findPreviousNode(config, prev.getLastChildNode(), targetType, true, false, processor)) {
                return true;
            }
            prev = prev.getTreePrev();
        }
        if (processParent) {
            for (ASTNode parent = from.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
                if (!AlignmentInColumnsHelper.findPreviousNode(config, parent, targetType, false, false, processor)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static ASTNode getSubNodeThatStartsNewLine(@Nullable ASTNode startNode, AlignmentInColumnsConfig config) {
        if (startNode == null) {
            return null;
        }
        ASTNode parent = startNode.getTreeParent();
        if (parent == null) {
            return null;
        }
        final boolean[] returnFirstNonEmptySubNode = new boolean[]{false};
        AlignmentInColumnsHelper.findPreviousNode(config, startNode, new NodeProcessor(){

            @Override
            public boolean targetTypeFound(ASTNode node2) {
                return true;
            }

            @Override
            public boolean whitespaceFound(ASTNode node2) {
                returnFirstNonEmptySubNode[0] = StringUtil.countNewLines(node2.getChars()) > 0;
                return returnFirstNonEmptySubNode[0];
            }
        });
        boolean stop2 = false;
        for (ASTNode result2 = startNode; result2 != null && result2.getTreeParent() == parent; result2 = result2.getTreeNext()) {
            if (config.getStopMultilineCheckElementTypes().contains(result2.getElementType())) {
                return null;
            }
            if (result2.getTextLength() <= 0 || config.getCommentTokenTypes().contains(result2.getElementType())) continue;
            if (config.getWhiteSpaceTokenTypes().contains(result2.getElementType()) && StringUtil.countNewLines(result2.getChars()) > 0) {
                stop2 = true;
                continue;
            }
            if (returnFirstNonEmptySubNode[0]) {
                return result2;
            }
            if (!stop2) continue;
            return result2;
        }
        return null;
    }

    private static List<IElementType> findSubNodeTypes(ASTNode node2, TokenSet types) {
        SmartList<IElementType> foundTypes = new SmartList<IElementType>();
        for (ASTNode child = node2.getFirstChildNode(); child != null && child.getTreeParent() == node2; child = child.getTreeNext()) {
            IElementType type = child.getElementType();
            if (!types.contains(type)) continue;
            foundTypes.add(type);
        }
        return foundTypes;
    }

    private static abstract class NodeProcessor {
        private NodeProcessor() {
        }

        public boolean targetTypeFound(ASTNode node2) {
            return false;
        }

        public boolean whitespaceFound(ASTNode node2) {
            return false;
        }
    }
}

