/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.codeWithMe.ClientId;
import com.intellij.find.actions.PersistedSearchOptions;
import com.intellij.find.actions.SearchOptionsService;
import com.intellij.find.actions.SearchOptionsServiceKt$WhenMappings;
import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.api.UsageHandler;
import com.intellij.find.usages.api.UsageOptions;
import com.intellij.find.usages.impl.AllSearchOptions;
import com.intellij.find.usages.impl.ImplKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a:\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0003\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00040\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\b\u0010\r\u001a\u00020\u000eH\u0002\u001a$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0000\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\bH\u0002\u001a\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0006H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"defaultOptions", "Lcom/intellij/find/actions/PersistedSearchOptions;", "getSearchOptions", "Lcom/intellij/find/usages/impl/AllSearchOptions;", "O", "variant", "Lcom/intellij/find/actions/SearchOptionsService$SearchVariant;", "target", "Lcom/intellij/find/usages/api/SearchTarget;", "handler", "Lcom/intellij/find/usages/api/UsageHandler;", "selectedScope", "Lcom/intellij/psi/search/SearchScope;", "searchOptionsService", "Lcom/intellij/find/actions/SearchOptionsService;", "setSearchOptions", "", "allOptions", "targetKey", "", "toUsageAction", "Lcom/intellij/find/usages/api/UsageHandler$UsageAction;", "intellij.platform.lang.impl"})
public final class SearchOptionsServiceKt {
    private static final PersistedSearchOptions defaultOptions = new PersistedSearchOptions(true, true);

    @NotNull
    public static final <O> AllSearchOptions<O> getSearchOptions(@NotNull SearchOptionsService.SearchVariant variant, @NotNull SearchTarget target2, @NotNull UsageHandler<O> handler, @NotNull SearchScope selectedScope) {
        Intrinsics.checkNotNullParameter((Object)((Object)variant), (String)"variant");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)selectedScope, (String)"selectedScope");
        PersistedSearchOptions persistedOptions = SearchOptionsServiceKt.searchOptionsService().getSearchOptions(variant, SearchOptionsServiceKt.targetKey(target2));
        SearchScope searchScope2 = target2.getMaximalSearchScope();
        if (!(searchScope2 instanceof LocalSearchScope)) {
            searchScope2 = null;
        }
        LocalSearchScope localSearchScope = (LocalSearchScope)searchScope2;
        SearchScope scopeToUse = localSearchScope != null ? (SearchScope)localSearchScope : selectedScope;
        UsageOptions usageOptions = UsageOptions.createOptions(persistedOptions.getUsages(), scopeToUse);
        Intrinsics.checkNotNullExpressionValue((Object)usageOptions, (String)"UsageOptions.createOptio\u2026tions.usages, scopeToUse)");
        return new AllSearchOptions<O>(usageOptions, ImplKt.hasTextSearchStrings(target2) ? Boolean.valueOf(persistedOptions.getTextSearch()) : null, handler.getCustomOptions(SearchOptionsServiceKt.toUsageAction(variant)));
    }

    public static final void setSearchOptions(@NotNull SearchOptionsService.SearchVariant variant, @NotNull SearchTarget target2, @NotNull AllSearchOptions<?> allOptions) {
        Intrinsics.checkNotNullParameter((Object)((Object)variant), (String)"variant");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter(allOptions, (String)"allOptions");
        Boolean bl = allOptions.getTextSearch();
        PersistedSearchOptions newOptions = new PersistedSearchOptions(allOptions.getOptions().isUsages(), bl != null ? bl : true);
        SearchOptionsServiceKt.searchOptionsService().setSearchOptions(variant, SearchOptionsServiceKt.targetKey(target2), newOptions);
    }

    private static final SearchOptionsService searchOptionsService() {
        boolean $i$f$service = false;
        Class<SearchOptionsService> serviceClass$iv = SearchOptionsService.class;
        SearchOptionsService searchOptionsService = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (searchOptionsService == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        return searchOptionsService;
    }

    private static final String targetKey(SearchTarget $this$targetKey) {
        String string2 = $this$targetKey.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"javaClass.name");
        return string2;
    }

    private static final UsageHandler.UsageAction toUsageAction(SearchOptionsService.SearchVariant $this$toUsageAction) {
        UsageHandler.UsageAction usageAction;
        switch (SearchOptionsServiceKt$WhenMappings.$EnumSwitchMapping$0[$this$toUsageAction.ordinal()]) {
            case 1: {
                usageAction = UsageHandler.UsageAction.FIND_USAGES;
                break;
            }
            case 2: {
                usageAction = UsageHandler.UsageAction.SHOW_USAGES;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return usageAction;
    }

    public static final /* synthetic */ PersistedSearchOptions access$getDefaultOptions$p() {
        return defaultOptions;
    }
}

