/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.find.FindBundle;
import com.intellij.find.findInProject.FindInProjectManager;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class FindInPathAction
extends AnAction
implements DumbAware {
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroupManager.getInstance().getNotificationGroup("Find in Path");

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            FindInPathAction.$$$reportNull$$$0(0);
        }
        DataContext dataContext = e.getDataContext();
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        FindInProjectManager findManager = FindInProjectManager.getInstance(project2);
        if (!findManager.isEnabled()) {
            FindInPathAction.showNotAvailableMessage(e, project2);
            return;
        }
        findManager.findInProject(dataContext, null);
    }

    static void showNotAvailableMessage(AnActionEvent e, Project project2) {
        String message2 = FindBundle.message("notification.content.not.available.while.search.in.progress", e.getPresentation().getText());
        NOTIFICATION_GROUP.createNotification(message2, NotificationType.WARNING).notify(project2);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            FindInPathAction.$$$reportNull$$$0(1);
        }
        FindInPathAction.doUpdate(e);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            FindInPathAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    static void doUpdate(@NotNull AnActionEvent e) {
        if (e == null) {
            FindInPathAction.$$$reportNull$$$0(3);
        }
        Presentation presentation2 = e.getPresentation();
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        presentation2.setEnabled(project2 != null && !LightEdit.owns((Project)project2));
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            presentation2.setVisible(FindInPathAction.isValidSearchScope(e));
        }
    }

    private static boolean isValidSearchScope(@NotNull AnActionEvent e) {
        PsiElement[] elements;
        if (e == null) {
            FindInPathAction.$$$reportNull$$$0(4);
        }
        if ((elements = (PsiElement[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY)) != null && elements.length == 1 && elements[0] instanceof PsiDirectoryContainer) {
            return true;
        }
        VirtualFile[] virtualFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        return virtualFiles != null && virtualFiles.length == 1 && virtualFiles[0].isDirectory();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/actions/FindInPathAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/actions/FindInPathAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doUpdate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isValidSearchScope";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

