/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.editorHeaderActions.Utils;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.TooltipDescriptionProvider;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.IdeaActionButtonLook;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.LightEditActionFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.IconManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.PopupState;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NotNull;

public class SearchTextArea
extends JPanel
implements PropertyChangeListener {
    private static final JBColor BUTTON_SELECTED_BACKGROUND = JBColor.namedColor("SearchOption.selectedBackground", 14345453, 6054244);
    private static final JBColor BUTTON_SELECTED_PRESSED_BACKGROUND = JBColor.namedColor("SearchOption.selectedPressedBackground", JBUI.CurrentTheme.ActionButton.pressedBackground());
    private static final JBColor BUTTON_SELECTED_HOVERED_BACKGROUND = JBColor.namedColor("SearchOption.selectedHoveredBackground", JBUI.CurrentTheme.ActionButton.pressedBackground());
    private static final JBColor BACKGROUND_COLOR = JBColor.namedColor("Editor.SearchField.background", UIUtil.getTextFieldBackground());
    public static final String JUST_CLEARED_KEY = "JUST_CLEARED";
    public static final KeyStroke NEW_LINE_KEYSTROKE = KeyStroke.getKeyStroke(10, (SystemInfo.isMac ? 256 : 128) | 0x40);
    private static final Icon CLOSE_ICON = ExperimentalUI.isNewUI() ? IconManager.getInstance().getIcon("expui/general/closeSmall.svg", AllIcons.class) : AllIcons.Actions.Close;
    private static final Icon CLOSE_HOVERED_ICON = ExperimentalUI.isNewUI() ? IconManager.getInstance().getIcon("expui/general/closeSmallHovered.svg", AllIcons.class) : AllIcons.Actions.CloseHovered;
    private static final ActionButtonLook FIELD_INPLACE_LOOK = new IdeaActionButtonLook(){

        public void paintBorder(Graphics g, JComponent component2, @ActionButtonComponent.ButtonState int state) {
            if (component2.isFocusOwner() && component2.isEnabled()) {
                Rectangle rect2 = new Rectangle(component2.getSize());
                JBInsets.removeFrom(rect2, component2.getInsets());
                SYSTEM_LOOK.paintLookBorder(g, rect2, JBUI.CurrentTheme.ActionButton.focusedBorder());
            } else {
                super.paintBorder(g, component2, 0);
            }
        }

        public void paintBackground(Graphics g, JComponent component2, int state) {
            MyActionButton actionButton2 = (MyActionButton)((Object)component2);
            if (actionButton2.isRolloverState()) {
                super.paintBackground(g, component2, state);
            } else if (state == 2 && component2.isEnabled()) {
                Rectangle rect2 = new Rectangle(component2.getSize());
                JBInsets.removeFrom(rect2, component2.getInsets());
                if (!ExperimentalUI.isNewUI() || actionButton2.isSelected()) {
                    this.paintLookBackground(g, rect2, BUTTON_SELECTED_BACKGROUND);
                }
            }
        }

        protected Color getStateBackground(JComponent component2, int state) {
            if (ExperimentalUI.isNewUI()) {
                MyActionButton actionButton2 = (MyActionButton)((Object)component2);
                if (state == 2) {
                    return actionButton2.isMouseDownState() ? BUTTON_SELECTED_PRESSED_BACKGROUND : BUTTON_SELECTED_HOVERED_BACKGROUND;
                }
            }
            return super.getStateBackground(component2, state);
        }
    };
    private static final Border EMPTY_SCROLL_BORDER = JBUI.Borders.empty(2, 0, 2, 2);
    private final JTextArea myTextArea;
    private final boolean mySearchMode;
    private final JPanel myIconsPanel;
    private final ActionButton myNewLineButton;
    private final ActionButton myClearButton;
    private final NonOpaquePanel myExtraActionsPanel;
    private final JBScrollPane myScrollPane;
    private final ActionButton myHistoryPopupButton;
    private boolean myMultilineEnabled;
    private final KeyAdapter myEnterRedispatcher;

    @Deprecated(forRemoval=true)
    public SearchTextArea(@NotNull JTextArea textArea, boolean searchMode, boolean infoMode) {
        if (textArea == null) {
            SearchTextArea.$$$reportNull$$$0(0);
        }
        this(textArea, searchMode);
    }

    public SearchTextArea(@NotNull JTextArea textArea, boolean searchMode) {
        if (textArea == null) {
            SearchTextArea.$$$reportNull$$$0(1);
        }
        this.myIconsPanel = new NonOpaquePanel();
        this.myExtraActionsPanel = new NonOpaquePanel();
        this.myMultilineEnabled = true;
        this.myEnterRedispatcher = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && SearchTextArea.this.getParent() != null) {
                    SearchTextArea.this.getParent().dispatchEvent(e);
                }
            }
        };
        this.myTextArea = textArea;
        this.mySearchMode = searchMode;
        this.updateFont();
        this.myTextArea.addPropertyChangeListener("background", this);
        this.myTextArea.addPropertyChangeListener("font", this);
        LightEditActionFactory.create(event -> this.myTextArea.transferFocus()).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(9, 0)), (JComponent)this.myTextArea);
        LightEditActionFactory.create(event -> this.myTextArea.transferFocusBackward()).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(9, 64)), (JComponent)this.myTextArea);
        KeymapUtil.reassignAction((JComponent)this.myTextArea, (KeyStroke)KeyStroke.getKeyStroke(10, 0), (KeyStroke)NEW_LINE_KEYSTROKE, (int)0);
        this.myTextArea.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (this.getProperty("filterNewlines") == Boolean.TRUE && str.indexOf(10) >= 0) {
                    str = StringUtil.replace(str, "\n", " ");
                }
                if (!StringUtil.isEmpty(str)) {
                    super.insertString(offs, str, a);
                }
            }
        });
        if (Registry.is("ide.find.field.trims.pasted.text", false)) {
            this.myTextArea.getDocument().putProperty("trimTextOnPaste", Boolean.TRUE);
        }
        this.myTextArea.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (e.getType() == DocumentEvent.EventType.INSERT) {
                    SearchTextArea.this.myTextArea.putClientProperty(SearchTextArea.JUST_CLEARED_KEY, null);
                }
                int rows = Math.min(Registry.get("ide.find.max.rows").asInteger(), SearchTextArea.this.myTextArea.getLineCount());
                SearchTextArea.this.myTextArea.setRows(Math.max(1, Math.min(25, rows)));
                SearchTextArea.this.updateIconsLayout();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/SearchTextArea$3", "textChanged"));
            }
        });
        this.myTextArea.setOpaque(false);
        this.myScrollPane = new JBScrollPane(this.myTextArea, 20, 30){

            protected void setupCorners() {
                super.setupCorners();
                super.setBorder(EMPTY_SCROLL_BORDER);
            }

            public void updateUI() {
                super.updateUI();
                super.setBorder(EMPTY_SCROLL_BORDER);
            }

            public void setBorder(Border border) {
            }
        };
        this.myTextArea.setBorder(new Border(){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            }

            @Override
            public Insets getBorderInsets(Component c) {
                int top;
                if (SystemInfo.isMac) {
                    return new JBInsets(3, 0, 2, 0);
                }
                int bottom = StringUtil.getLineBreakCount(SearchTextArea.this.myTextArea.getText()) > 0 ? 2 : (StartupUiUtil.isUnderDarcula() ? 1 : 0);
                int n = top = SearchTextArea.this.myTextArea.getFontMetrics(SearchTextArea.this.myTextArea.getFont()).getHeight() <= 16 ? 2 : 1;
                if (JBUIScale.isUsrHiDPI()) {
                    bottom = 0;
                    top = 2;
                }
                return new JBInsets(top, 0, bottom, 0);
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }
        });
        this.myScrollPane.getViewport().setBorder(null);
        this.myScrollPane.getViewport().setOpaque(false);
        this.myScrollPane.getHorizontalScrollBar().putClientProperty(JBScrollPane.IGNORE_SCROLLBAR_IN_INSETS, Boolean.TRUE);
        this.myScrollPane.setOpaque(false);
        this.myHistoryPopupButton = new MyActionButton((AnAction)new ShowHistoryAction(), false, true);
        this.myClearButton = new MyActionButton((AnAction)new ClearAction(), false, false);
        this.myNewLineButton = new MyActionButton((AnAction)new NewLineAction(), false, true);
        this.updateLayout();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateFont();
        this.setBackground(BACKGROUND_COLOR);
    }

    private void updateFont() {
        if (this.myTextArea != null) {
            if (Registry.is("ide.find.use.editor.font", false)) {
                this.myTextArea.setFont(EditorUtil.getEditorFont());
            } else {
                this.myTextArea.setFont(UIManager.getFont("TextField.font"));
            }
        }
    }

    protected void updateLayout() {
        NonOpaquePanel historyButtonWrapper = new NonOpaquePanel((LayoutManager)new BorderLayout());
        historyButtonWrapper.setBorder(ExperimentalUI.isNewUI() ? JBUI.Borders.empty(2, 3, 0, 8) : JBUI.Borders.empty(2, 3, 0, 0));
        historyButtonWrapper.add((Component)this.myHistoryPopupButton, "North");
        NonOpaquePanel iconsPanelWrapper = new NonOpaquePanel((LayoutManager)new BorderLayout());
        iconsPanelWrapper.setBorder(JBUI.Borders.emptyTop(2));
        NonOpaquePanel p = new NonOpaquePanel((LayoutManager)new BorderLayout());
        p.add((Component)this.myIconsPanel, "North");
        this.myIconsPanel.setBorder(ExperimentalUI.isNewUI() ? JBUI.Borders.emptyRight(8) : JBUI.Borders.emptyRight(5));
        iconsPanelWrapper.add((Component)p, "West");
        iconsPanelWrapper.add((Component)this.myExtraActionsPanel, "Center");
        this.removeAll();
        this.setLayout(new BorderLayout(JBUIScale.scale(3), 0));
        this.setBorder(JBUI.Borders.empty(JBUI.insets("Editor.SearchField.borderInsets", JBUI.insets(SystemInfo.isLinux ? 2 : 1))));
        this.add((Component)historyButtonWrapper, "West");
        this.add((Component)this.myScrollPane, "Center");
        this.add((Component)iconsPanelWrapper, "East");
        this.updateIconsLayout();
    }

    private void updateIconsLayout() {
        boolean multiline;
        if (this.myIconsPanel.getParent() == null) {
            return;
        }
        boolean showClearIcon = !StringUtil.isEmpty(this.myTextArea.getText());
        boolean showNewLine = this.myMultilineEnabled;
        boolean wrongVisibility = this.myClearButton.getParent() == null == showClearIcon || this.myNewLineButton.getParent() == null == showNewLine;
        boolean bl = multiline = StringUtil.getLineBreakCount(this.myTextArea.getText()) > 0;
        if (wrongVisibility) {
            this.myIconsPanel.removeAll();
            this.myIconsPanel.setLayout(new BorderLayout());
            this.myIconsPanel.add((Component)this.myClearButton, "Center");
            this.myIconsPanel.add((Component)this.myNewLineButton, "East");
            this.myIconsPanel.setPreferredSize(this.myIconsPanel.getPreferredSize());
            if (!showClearIcon) {
                this.myIconsPanel.remove((Component)this.myClearButton);
            }
            if (!showNewLine) {
                this.myIconsPanel.remove((Component)this.myNewLineButton);
            }
            this.myIconsPanel.revalidate();
            this.myIconsPanel.repaint();
        }
        this.myScrollPane.setHorizontalScrollBarPolicy(30);
        this.myScrollPane.setVerticalScrollBarPolicy(multiline ? 20 : 21);
        this.myScrollPane.getHorizontalScrollBar().setVisible(multiline);
        this.myScrollPane.revalidate();
        this.doLayout();
    }

    public List<Component> setExtraActions(AnAction ... actions2) {
        this.myExtraActionsPanel.removeAll();
        this.myExtraActionsPanel.setBorder((Border)JBUI.Borders.empty());
        ArrayList<Component> addedButtons = new ArrayList<Component>();
        if (actions2 != null && actions2.length > 0) {
            NonOpaquePanel buttonsGrid = new NonOpaquePanel((LayoutManager)new GridLayout(1, actions2.length, JBUI.scale(4), 0));
            for (AnAction action2 : actions2) {
                if (action2 instanceof TooltipDescriptionProvider) {
                    action2.getTemplatePresentation().setDescription(FindBundle.message("find.embedded.buttons.description", new Object[0]));
                }
                MyActionButton button2 = new MyActionButton(action2, true, true);
                addedButtons.add((Component)((Object)button2));
                buttonsGrid.add((Component)((Object)button2));
            }
            buttonsGrid.setBorder(JBUI.Borders.emptyRight(2));
            this.myExtraActionsPanel.setLayout((LayoutManager)new BorderLayout());
            this.myExtraActionsPanel.add((Component)buttonsGrid, (Object)"North");
            if (!ExperimentalUI.isNewUI()) {
                this.myExtraActionsPanel.setBorder((Border)new PseudoSeparatorBorder());
            }
        }
        return addedButtons;
    }

    public void updateExtraActions() {
        for (ActionButton button2 : UIUtil.findComponentsOfType((JComponent)this.myExtraActionsPanel, ActionButton.class)) {
            button2.update();
        }
    }

    public void setMultilineEnabled(boolean enabled) {
        if (this.myMultilineEnabled == enabled) {
            return;
        }
        this.myMultilineEnabled = enabled;
        this.myTextArea.getDocument().putProperty("filterNewlines", this.myMultilineEnabled ? null : Boolean.TRUE);
        if (!this.myMultilineEnabled) {
            this.myTextArea.getInputMap().put(KeyStroke.getKeyStroke("shift UP"), "selection-begin-line");
            this.myTextArea.getInputMap().put(KeyStroke.getKeyStroke("shift DOWN"), "selection-end-line");
            this.myTextArea.addKeyListener(this.myEnterRedispatcher);
        } else {
            this.myTextArea.getInputMap().put(KeyStroke.getKeyStroke("shift UP"), "selection-up");
            this.myTextArea.getInputMap().put(KeyStroke.getKeyStroke("shift DOWN"), "selection-down");
            this.myTextArea.removeKeyListener(this.myEnterRedispatcher);
        }
        this.updateIconsLayout();
    }

    @NotNull
    public JTextArea getTextArea() {
        JTextArea jTextArea = this.myTextArea;
        if (jTextArea == null) {
            SearchTextArea.$$$reportNull$$$0(2);
        }
        return jTextArea;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("background".equals(evt.getPropertyName())) {
            this.repaint();
        }
        if ("font".equals(evt.getPropertyName())) {
            this.updateLayout();
        }
    }

    @Deprecated
    public void setInfoText(String info) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textArea";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/SearchTextArea";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/SearchTextArea";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextArea";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PseudoSeparatorBorder
    implements Border {
        private PseudoSeparatorBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground());
            g.fillRect(x + JBUI.scale(1), y + 1, 1, JBUI.scale(20));
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new JBInsets(0, 7, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    private static final class MyActionButton
    extends ActionButton {
        MyActionButton(@NotNull AnAction action2, boolean focusable, boolean fieldInplaceLook) {
            if (action2 == null) {
                MyActionButton.$$$reportNull$$$0(0);
            }
            super(action2, action2.getTemplatePresentation().clone(), "SearchTextArea", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            this.setLook(fieldInplaceLook ? FIELD_INPLACE_LOOK : ActionButtonLook.INPLACE_LOOK);
            this.setFocusable(focusable);
            this.updateIcon();
        }

        protected DataContext getDataContext() {
            return DataManager.getInstance().getDataContext((Component)((Object)this));
        }

        public int getPopState() {
            return this.isSelected() ? 2 : super.getPopState();
        }

        boolean isRolloverState() {
            return super.isRollover();
        }

        boolean isMouseDownState() {
            return super.isMouseDown();
        }

        public Icon getIcon() {
            Icon selectedIcon;
            if (this.isEnabled() && this.isSelected() && (selectedIcon = this.myPresentation.getSelectedIcon()) != null) {
                return selectedIcon;
            }
            return super.getIcon();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/find/SearchTextArea$MyActionButton", "<init>"));
        }
    }

    private class NewLineAction
    extends DumbAwareAction
    implements LightEditCompatible {
        NewLineAction() {
            super(FindBundle.message("find.new.line", new Object[0]), null, AllIcons.Actions.SearchNewLine);
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(NEW_LINE_KEYSTROKE));
            this.getTemplatePresentation().setHoveredIcon(AllIcons.Actions.SearchNewLineHover);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                NewLineAction.$$$reportNull$$$0(0);
            }
            new DefaultEditorKit.InsertBreakAction().actionPerformed(new ActionEvent(SearchTextArea.this.myTextArea, 0, "action"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/SearchTextArea$NewLineAction", "actionPerformed"));
        }
    }

    private class ClearAction
    extends DumbAwareAction
    implements LightEditCompatible {
        ClearAction() {
            super(CLOSE_ICON);
            this.getTemplatePresentation().setHoveredIcon(CLOSE_HOVERED_ICON);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearAction.$$$reportNull$$$0(0);
            }
            SearchTextArea.this.myTextArea.putClientProperty(SearchTextArea.JUST_CLEARED_KEY, !SearchTextArea.this.myTextArea.getText().isEmpty());
            SearchTextArea.this.myTextArea.setText("");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/SearchTextArea$ClearAction", "actionPerformed"));
        }
    }

    private class ShowHistoryAction
    extends DumbAwareAction
    implements LightEditCompatible {
        private final PopupState<JBPopup> myPopupState;

        ShowHistoryAction() {
            super(FindBundle.message(SearchTextArea.this.mySearchMode ? "find.search.history" : "find.replace.history", new Object[0]), FindBundle.message(SearchTextArea.this.mySearchMode ? "find.search.history" : "find.replace.history", new Object[0]), AllIcons.Actions.SearchWithHistory);
            this.myPopupState = PopupState.forPopup();
            this.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"ShowSearchHistory"), SearchTextArea.this.myTextArea);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowHistoryAction.$$$reportNull$$$0(0);
            }
            Project project2 = e.getProject();
            if (this.myPopupState.isRecentlyHidden() || project2 == null) {
                return;
            }
            FeatureUsageTracker.getInstance().triggerFeatureUsed("find.recent.search");
            FindInProjectSettings findInProjectSettings = FindInProjectSettings.getInstance((Project)project2);
            String[] recent = SearchTextArea.this.mySearchMode ? findInProjectSettings.getRecentFindStrings() : findInProjectSettings.getRecentReplaceStrings();
            JBList historyList = new JBList((Object[])ArrayUtil.reverseArray(recent));
            Utils.showCompletionPopup(SearchTextArea.this, (JList)historyList, null, SearchTextArea.this.myTextArea, null, this.myPopupState);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/SearchTextArea$ShowHistoryAction", "actionPerformed"));
        }
    }
}

