/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.SearchSession;
import com.intellij.find.SearchTextArea;
import com.intellij.find.editorHeaderActions.ContextAwareShortcutProvider;
import com.intellij.find.editorHeaderActions.Embeddable;
import com.intellij.find.editorHeaderActions.NextOccurrenceAction;
import com.intellij.find.editorHeaderActions.PrevOccurrenceAction;
import com.intellij.find.editorHeaderActions.Utils;
import com.intellij.find.editorHeaderActions.VariantsCompletionAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.IconManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListFocusTraversalPolicy;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.mac.touchbar.Touchbar;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SearchReplaceComponent
extends EditorHeaderComponent
implements DataProvider {
    public static final int RIGHT_PANEL_WEST_OFFSET = 13;
    private static final float MAX_LEFT_PANEL_PROP = 0.9f;
    private static final float DEFAULT_PROP = 0.33f;
    private final EventDispatcher<Listener> myEventDispatcher;
    private final MyTextComponentWrapper mySearchFieldWrapper;
    private JTextComponent mySearchTextComponent;
    private final MyTextComponentWrapper myReplaceFieldWrapper;
    private JTextComponent myReplaceTextComponent;
    private final DefaultActionGroup mySearchFieldActions;
    private final ActionToolbarImpl mySearchActionsToolbar;
    private final List<AnAction> myEmbeddedSearchActions;
    private final List<Component> myExtraSearchButtons;
    private final DefaultActionGroup myReplaceFieldActions;
    private final ActionToolbarImpl myReplaceActionsToolbar;
    private final List<AnAction> myEmbeddedReplaceActions;
    private final List<Component> myExtraReplaceButtons;
    private final JPanel myReplaceToolbarWrapper;
    private final Project myProject;
    private final JComponent myTargetComponent;
    @Nullable
    private OnePixelSplitter mySplitter;
    private final Runnable myCloseRunnable;
    private final Runnable myReplaceRunnable;
    private final DataProvider myDataProviderDelegate;
    private final boolean myMultilineEnabled;
    private final boolean myUseSearchField;
    private boolean myMultilineMode;
    private final boolean myAddSearchResultsToGlobalSearch;
    @NotNull
    private @NlsContexts.Label String myStatusText;
    @NotNull
    private Color myStatusColor;
    private final AnAction modeAction;
    private static final Color EDITOR_BACKGROUND = JBColor.lazy(() -> EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground());
    @Nullable
    private final ShortcutSet findActionShortcutSet;
    @Nullable
    private final ShortcutSet replaceActionShortcutSet;
    private final CloseAction myCloseAction;
    private static final Icon CLOSE_ICON = ExperimentalUI.isNewUI() ? IconManager.getInstance().getIcon("expui/general/close.svg", AllIcons.class) : AllIcons.Actions.Close;

    @NotNull
    public static Builder buildFor(@Nullable Project project2, @NotNull JComponent component2) {
        if (component2 == null) {
            SearchReplaceComponent.$$$reportNull$$$0(0);
        }
        return new Builder(project2, component2);
    }

    private SearchReplaceComponent(@Nullable Project project2, @NotNull JComponent targetComponent, @NotNull DefaultActionGroup searchToolbar1Actions, @NotNull DefaultActionGroup searchToolbar2Actions, @NotNull DefaultActionGroup searchFieldActions, @NotNull DefaultActionGroup replaceToolbar1Actions, @NotNull DefaultActionGroup replaceToolbar2Actions, @NotNull DefaultActionGroup replaceFieldActions, @Nullable Runnable replaceRunnable, @Nullable Runnable closeRunnable, @Nullable DataProvider dataProvider, boolean showOnlySearchPanel, boolean maximizeLeftPanelOnResize, boolean multilineEnabled, boolean addSearchResultsToGlobalSearch, boolean useSearchField) {
        float initialProportion;
        ShortcutSet shortcutSet;
        if (targetComponent == null) {
            SearchReplaceComponent.$$$reportNull$$$0(1);
        }
        if (searchToolbar1Actions == null) {
            SearchReplaceComponent.$$$reportNull$$$0(2);
        }
        if (searchToolbar2Actions == null) {
            SearchReplaceComponent.$$$reportNull$$$0(3);
        }
        if (searchFieldActions == null) {
            SearchReplaceComponent.$$$reportNull$$$0(4);
        }
        if (replaceToolbar1Actions == null) {
            SearchReplaceComponent.$$$reportNull$$$0(5);
        }
        if (replaceToolbar2Actions == null) {
            SearchReplaceComponent.$$$reportNull$$$0(6);
        }
        if (replaceFieldActions == null) {
            SearchReplaceComponent.$$$reportNull$$$0(7);
        }
        this.myEventDispatcher = EventDispatcher.create(Listener.class);
        this.myEmbeddedSearchActions = new ArrayList<AnAction>();
        this.myExtraSearchButtons = new ArrayList<Component>();
        this.myEmbeddedReplaceActions = new ArrayList<AnAction>();
        this.myExtraReplaceButtons = new ArrayList<Component>();
        this.myStatusText = "";
        this.myStatusColor = ExperimentalUI.isNewUI() ? UIUtil.getLabelInfoForeground() : UIUtil.getLabelForeground();
        this.modeAction = new ModeAction();
        this.myCloseAction = new CloseAction();
        this.myProject = project2;
        this.myTargetComponent = targetComponent;
        this.mySearchFieldActions = searchFieldActions;
        this.myReplaceFieldActions = replaceFieldActions;
        this.myReplaceRunnable = replaceRunnable;
        this.myCloseRunnable = closeRunnable;
        this.myMultilineEnabled = multilineEnabled;
        this.myAddSearchResultsToGlobalSearch = addSearchResultsToGlobalSearch;
        this.myUseSearchField = useSearchField;
        boolean isNewUI = ExperimentalUI.isNewUI();
        ActionManager actionManager = ActionManager.getInstance();
        this.findActionShortcutSet = actionManager.getAction("Find").getShortcutSet();
        this.replaceActionShortcutSet = actionManager.getAction("Replace").getShortcutSet();
        for (Object child : searchToolbar2Actions.getChildren(null)) {
            if (!(child instanceof Embeddable)) continue;
            this.myEmbeddedSearchActions.add((AnAction)child);
            shortcutSet = ActionUtil.getMnemonicAsShortcut((AnAction)child);
            if (shortcutSet == null) continue;
            child.registerCustomShortcutSet(shortcutSet, (JComponent)((Object)this));
        }
        for (AnAction action2 : this.myEmbeddedSearchActions) {
            searchToolbar2Actions.remove(action2);
        }
        for (Object child : replaceToolbar2Actions.getChildren(null)) {
            if (!(child instanceof Embeddable)) continue;
            this.myEmbeddedReplaceActions.add((AnAction)child);
            shortcutSet = ActionUtil.getMnemonicAsShortcut((AnAction)child);
            if (shortcutSet == null) continue;
            child.registerCustomShortcutSet(shortcutSet, (JComponent)((Object)this));
        }
        for (AnAction action3 : this.myEmbeddedReplaceActions) {
            replaceToolbar2Actions.remove(action3);
        }
        this.mySearchFieldWrapper = new MyTextComponentWrapper(){

            public void setContent(JComponent wrapped) {
                super.setContent(wrapped);
                SearchReplaceComponent.this.mySearchTextComponent = 1.unwrapTextComponent(wrapped);
            }
        };
        this.myReplaceFieldWrapper = new MyTextComponentWrapper(){

            public void setContent(JComponent wrapped) {
                super.setContent(wrapped);
                SearchReplaceComponent.this.myReplaceTextComponent = 2.unwrapTextComponent(wrapped);
            }
        };
        this.myReplaceFieldWrapper.setBorder(JBUI.Borders.emptyTop(1));
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.setBackground(JBUI.CurrentTheme.Editor.BORDER_COLOR);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        leftPanel.add((Component)((Object)this.mySearchFieldWrapper), constraints);
        ++constraints.gridy;
        leftPanel.add((Component)((Object)this.myReplaceFieldWrapper), constraints);
        leftPanel.setBorder(JBUI.Borders.customLine(JBUI.CurrentTheme.Editor.BORDER_COLOR, 0, 0, 0, 1));
        searchToolbar1Actions.addAll(searchToolbar2Actions.getChildren(null));
        replaceToolbar1Actions.addAll(replaceToolbar2Actions.getChildren(null));
        NonOpaquePanel searchPair = new NonOpaquePanel((LayoutManager)new BorderLayout());
        searchPair.setBorder(isNewUI ? JBUI.Borders.emptyTop(3) : JBUI.Borders.empty());
        if (closeRunnable != null) {
            if (isNewUI) {
                searchToolbar1Actions.add((AnAction)this.myCloseAction);
            } else {
                JLabel closeLabel = new JLabel(null, AllIcons.Actions.Close, 4);
                closeLabel.setBorder(JBUI.Borders.empty(2));
                closeLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (!e.isPopupTrigger() && SwingUtilities.isLeftMouseButton(e)) {
                            SearchReplaceComponent.this.close();
                        }
                    }
                });
                closeLabel.setToolTipText(FindBundle.message("tooltip.close.search.bar.escape", new Object[0]));
                searchPair.add((Component)new Wrapper((JComponent)closeLabel), "East");
            }
        }
        this.mySearchActionsToolbar = this.createToolbar((ActionGroup)searchToolbar1Actions);
        this.mySearchActionsToolbar.setForceShowFirstComponent(true);
        searchPair.add((Component)this.mySearchActionsToolbar, "Center");
        if (ExperimentalUI.isNewUI()) {
            this.mySearchActionsToolbar.setBackground(EDITOR_BACKGROUND);
            searchPair.setBackground(EDITOR_BACKGROUND);
        }
        this.myReplaceActionsToolbar = this.createReplaceToolbar1(replaceToolbar1Actions);
        this.myReplaceActionsToolbar.setBorder((Border)JBUI.Borders.empty());
        this.myReplaceActionsToolbar.setOpaque(!isNewUI);
        Wrapper replaceToolbarWrapper1 = new Wrapper((JComponent)this.myReplaceActionsToolbar);
        this.myReplaceToolbarWrapper = new NonOpaquePanel((LayoutManager)new BorderLayout());
        this.myReplaceToolbarWrapper.add((Component)replaceToolbarWrapper1, "West");
        this.myReplaceToolbarWrapper.setBorder(isNewUI ? JBUI.Borders.emptyTop(10) : JBUI.Borders.emptyTop(3));
        NonOpaquePanel rightPanel = new NonOpaquePanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        rightPanel.add((Component)searchPair);
        rightPanel.add(this.myReplaceToolbarWrapper);
        float f = initialProportion = maximizeLeftPanelOnResize ? 0.9f : 0.33f;
        if (isNewUI) {
            ActionToolbarImpl modeToolbar = this.createToolbar((ActionGroup)new DefaultActionGroup(new AnAction[]{this.modeAction}));
            modeToolbar.setReservePlaceAutoPopupIcon(false);
            JComponent modeToolbarComponent = modeToolbar.getComponent();
            modeToolbarComponent.setBorder(JBUI.Borders.empty());
            modeToolbarComponent.setOpaque(false);
            BorderLayoutPanel modePanel = JBUI.Panels.simplePanel().addToTop(modeToolbar.getComponent());
            modePanel.setOpaque(true);
            modePanel.setBackground(EDITOR_BACKGROUND);
            modePanel.setBorder(JBUI.Borders.compound(JBUI.Borders.customLine(JBUI.CurrentTheme.Editor.BORDER_COLOR, 0, 0, 0, 1), (Border)JBUI.Borders.empty(7, 3)));
            this.add(modePanel, "West");
        }
        if (showOnlySearchPanel) {
            this.add(leftPanel, "Center");
        } else {
            this.mySplitter = maximizeLeftPanelOnResize ? new OnePixelSplitter(false, initialProportion, initialProportion, initialProportion) : new OnePixelSplitter(false, initialProportion);
            this.mySplitter.setFirstComponent((JComponent)leftPanel);
            this.mySplitter.setSecondComponent((JComponent)rightPanel);
            if (ExperimentalUI.isNewUI()) {
                this.mySearchActionsToolbar.setBackground(EDITOR_BACKGROUND);
                this.mySplitter.setBackground(EDITOR_BACKGROUND);
                this.mySplitter.setOpaque(true);
            } else {
                this.mySplitter.setOpaque(false);
            }
            this.mySplitter.getDivider().setOpaque(false);
            this.add((Component)this.mySplitter, "Center");
            if (maximizeLeftPanelOnResize) {
                rightPanel.setLayout(new FlowLayout(1, 0, 0));
                rightPanel.setBorder(JBUI.Borders.emptyLeft(13));
                rightPanel.setMinimumSize(new Dimension(this.mySearchActionsToolbar.getActions().size() * ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.width + 13, 0));
                this.mySearchActionsToolbar.addComponentListener((ComponentListener)new ComponentAdapter((JPanel)rightPanel){
                    final /* synthetic */ JPanel val$rightPanel;
                    {
                        this.val$rightPanel = jPanel;
                    }

                    @Override
                    public void componentResized(ComponentEvent e) {
                        int minWidth = 0;
                        for (Component component2 : this.val$rightPanel.getComponents()) {
                            minWidth += component2.getPreferredSize().width;
                        }
                        this.val$rightPanel.setMinimumSize(new Dimension(minWidth, 0));
                        SearchReplaceComponent.this.mySplitter.updateUI();
                    }
                });
                this.mySplitter.setDividerPositionStrategy(Splitter.DividerPositionStrategy.KEEP_SECOND_SIZE);
                this.mySplitter.setLackOfSpaceStrategy(Splitter.LackOfSpaceStrategy.HONOR_THE_SECOND_MIN_SIZE);
                this.mySplitter.setResizeEnabled(false);
                this.mySplitter.setHonorComponentsMinimumSize(true);
                this.mySplitter.setHonorComponentsPreferredSize(false);
            } else {
                rightPanel.setBorder(JBUI.Borders.emptyLeft(6));
                this.mySplitter.setDividerPositionStrategy(Splitter.DividerPositionStrategy.KEEP_FIRST_SIZE);
                this.mySplitter.setLackOfSpaceStrategy(Splitter.LackOfSpaceStrategy.HONOR_THE_SECOND_MIN_SIZE);
                this.mySplitter.setHonorComponentsMinimumSize(true);
                this.mySplitter.setHonorComponentsPreferredSize(true);
                this.mySplitter.setAndLoadSplitterProportionKey("FindSplitterProportion");
            }
        }
        this.update("", "", false, false);
        this.myDataProviderDelegate = dataProvider;
        new TransferFocusAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(9, 0)), (JComponent)((Object)this));
        new TransferFocusBackwardAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(9, 64)), (JComponent)((Object)this));
        if (SystemInfo.isMac) {
            DefaultActionGroup touchbarActions = new DefaultActionGroup();
            touchbarActions.add((AnAction)new PrevOccurrenceAction());
            touchbarActions.add((AnAction)new NextOccurrenceAction());
            Touchbar.setActions((JComponent)((Object)this), (ActionGroup)touchbarActions);
        }
    }

    public void resetUndoRedoActions() {
        UIUtil.resetUndoRedoActions(this.mySearchTextComponent);
        UIUtil.resetUndoRedoActions(this.myReplaceTextComponent);
    }

    public void removeNotify() {
        super.removeNotify();
        this.addTextToRecent(this.mySearchTextComponent);
        if (this.myReplaceTextComponent != null) {
            this.addTextToRecent(this.myReplaceTextComponent);
        }
    }

    public void requestFocusInTheSearchFieldAndSelectContent(Project project2) {
        this.mySearchTextComponent.selectAll();
        IdeFocusManager.getInstance((Project)project2).requestFocus((Component)this.mySearchTextComponent, true);
        if (this.myReplaceTextComponent != null) {
            this.myReplaceTextComponent.selectAll();
        }
    }

    public void setStatusText(@NotNull @NlsContexts.Label String status) {
        if (status == null) {
            SearchReplaceComponent.$$$reportNull$$$0(8);
        }
        this.myStatusText = status;
    }

    @NotNull
    @NlsContexts.Label
    public String getStatusText() {
        String string2 = this.myStatusText;
        if (string2 == null) {
            SearchReplaceComponent.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @NotNull
    public Color getStatusColor() {
        Color color = this.myStatusColor;
        if (color == null) {
            SearchReplaceComponent.$$$reportNull$$$0(10);
        }
        return color;
    }

    public void replace() {
        if (this.myReplaceRunnable != null) {
            this.myReplaceRunnable.run();
        }
    }

    public void close() {
        if (this.myCloseRunnable != null) {
            this.myCloseRunnable.run();
        }
    }

    public void setRegularBackground() {
        this.mySearchTextComponent.setForeground(UIUtil.getTextFieldForeground());
        this.myStatusColor = ExperimentalUI.isNewUI() ? UIUtil.getLabelInfoForeground() : UIUtil.getLabelForeground();
    }

    public void setNotFoundBackground() {
        this.mySearchTextComponent.setForeground(JBColor.namedColor("SearchField.errorForeground", JBColor.RED));
        this.myStatusColor = UIUtil.getErrorForeground();
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            SearchReplaceComponent.$$$reportNull$$$0(11);
        }
        if (SpeedSearchSupply.SPEED_SEARCH_CURRENT_QUERY.is(dataId)) {
            return this.mySearchTextComponent.getText();
        }
        return this.myDataProviderDelegate != null ? this.myDataProviderDelegate.getData(dataId) : null;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void addListener(@NotNull Listener listener2) {
        if (listener2 == null) {
            SearchReplaceComponent.$$$reportNull$$$0(12);
        }
        this.myEventDispatcher.addListener(listener2);
    }

    public boolean isMultiline() {
        return this.myMultilineMode;
    }

    private void setMultilineInternal(boolean multiline) {
        boolean stateChanged = multiline != this.myMultilineMode;
        this.myMultilineMode = multiline;
        if (stateChanged) {
            this.myEventDispatcher.getMulticaster().multilineStateChanged();
        }
    }

    @NotNull
    public JTextComponent getSearchTextComponent() {
        JTextComponent jTextComponent = this.mySearchTextComponent;
        if (jTextComponent == null) {
            SearchReplaceComponent.$$$reportNull$$$0(13);
        }
        return jTextComponent;
    }

    @NotNull
    public JTextComponent getReplaceTextComponent() {
        JTextComponent jTextComponent = this.myReplaceTextComponent;
        if (jTextComponent == null) {
            SearchReplaceComponent.$$$reportNull$$$0(14);
        }
        return jTextComponent;
    }

    private void updateSearchComponent(@NotNull String textToSet) {
        if (textToSet == null) {
            SearchReplaceComponent.$$$reportNull$$$0(15);
        }
        if (!this.updateTextComponent(true)) {
            SearchReplaceComponent.replaceTextInTextComponentEnsuringSelection(textToSet, this.mySearchTextComponent);
            return;
        }
        this.mySearchTextComponent.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().invokeLater(() -> SearchReplaceComponent.this.myEventDispatcher.getMulticaster().searchFieldDocumentChanged());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/SearchReplaceComponent$5", "textChanged"));
            }
        });
        this.mySearchTextComponent.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtil.isEmpty(SearchReplaceComponent.this.mySearchTextComponent.getText())) {
                    SearchReplaceComponent.this.close();
                } else {
                    IdeFocusManager.getInstance((Project)SearchReplaceComponent.this.myProject).requestFocus((Component)SearchReplaceComponent.this.myTargetComponent, true);
                    SearchReplaceComponent.this.addTextToRecent(SearchReplaceComponent.this.mySearchTextComponent);
                }
            }
        }, KeyStroke.getKeyStroke(10, SystemInfo.isMac ? 256 : 128), 0);
        this.mySearchTextComponent.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        new VariantsCompletionAction(this.mySearchTextComponent);
    }

    private static void replaceTextInTextComponentEnsuringSelection(@NotNull String textToSet, JTextComponent component2) {
        String existingText;
        if (textToSet == null) {
            SearchReplaceComponent.$$$reportNull$$$0(16);
        }
        if (!(existingText = component2.getText()).equals(textToSet)) {
            component2.setText(textToSet);
            if (component2.getSelectionStart() == component2.getSelectionEnd()) {
                component2.selectAll();
            }
        }
    }

    private void updateReplaceComponent(@NotNull String textToSet) {
        if (textToSet == null) {
            SearchReplaceComponent.$$$reportNull$$$0(17);
        }
        if (!this.updateTextComponent(false)) {
            SearchReplaceComponent.replaceTextInTextComponentEnsuringSelection(textToSet, this.myReplaceTextComponent);
            return;
        }
        this.myReplaceTextComponent.setText(textToSet);
        this.myReplaceTextComponent.getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().invokeLater(() -> SearchReplaceComponent.this.myEventDispatcher.getMulticaster().replaceFieldDocumentChanged());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/SearchReplaceComponent$8", "textChanged"));
            }
        });
        if (!this.isMultiline()) {
            this.installReplaceOnEnterAction(this.myReplaceTextComponent);
        }
        new VariantsCompletionAction(this.myReplaceTextComponent);
        this.myReplaceFieldWrapper.revalidate();
        this.myReplaceFieldWrapper.repaint();
    }

    public void update(@NotNull String findText, @NotNull String replaceText, boolean replaceMode, boolean multiline) {
        if (findText == null) {
            SearchReplaceComponent.$$$reportNull$$$0(18);
        }
        if (replaceText == null) {
            SearchReplaceComponent.$$$reportNull$$$0(19);
        }
        this.setMultilineInternal(multiline);
        boolean needToResetSearchFocus = this.mySearchTextComponent != null && this.mySearchTextComponent.hasFocus();
        boolean needToResetReplaceFocus = this.myReplaceTextComponent != null && this.myReplaceTextComponent.hasFocus();
        this.updateSearchComponent(findText);
        this.updateReplaceComponent(replaceText);
        this.myReplaceFieldWrapper.setVisible(replaceMode);
        this.myReplaceToolbarWrapper.setVisible(replaceMode);
        if (needToResetReplaceFocus) {
            this.myReplaceTextComponent.requestFocusInWindow();
        }
        if (needToResetSearchFocus) {
            this.mySearchTextComponent.requestFocusInWindow();
        }
        this.updateBindings();
        this.updateActions();
        ArrayList<Component> focusOrder = new ArrayList<Component>();
        focusOrder.add(this.mySearchTextComponent);
        focusOrder.add(this.myReplaceTextComponent);
        focusOrder.addAll(this.myExtraSearchButtons);
        focusOrder.addAll(this.myExtraReplaceButtons);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)new ListFocusTraversalPolicy(focusOrder));
        this.revalidate();
        this.repaint();
    }

    public void updateActions() {
        this.mySearchActionsToolbar.updateActionsImmediately();
        this.myReplaceActionsToolbar.updateActionsImmediately();
        JComponent textComponent = this.mySearchFieldWrapper.getTargetComponent();
        if (textComponent instanceof SearchTextArea) {
            ((SearchTextArea)textComponent).updateExtraActions();
            ((SearchTextArea)textComponent).setMultilineEnabled(this.myMultilineEnabled);
        }
        if ((textComponent = this.myReplaceFieldWrapper.getTargetComponent()) instanceof SearchTextArea) {
            ((SearchTextArea)textComponent).updateExtraActions();
        }
    }

    public void addTextToRecent(@NotNull JTextComponent textField) {
        String text2;
        if (textField == null) {
            SearchReplaceComponent.$$$reportNull$$$0(20);
        }
        if ((text2 = textField.getText()).length() > 0) {
            FindInProjectSettings findInProjectSettings = FindInProjectSettings.getInstance((Project)this.myProject);
            if (textField == this.mySearchTextComponent) {
                if (this.myAddSearchResultsToGlobalSearch) {
                    findInProjectSettings.addStringToFind(text2);
                }
                if (this.mySearchFieldWrapper.getTargetComponent() instanceof SearchTextField) {
                    ((SearchTextField)this.mySearchFieldWrapper.getTargetComponent()).addCurrentTextToHistory();
                }
            } else {
                findInProjectSettings.addStringToReplace(text2);
                if (this.myReplaceFieldWrapper.getTargetComponent() instanceof SearchTextField) {
                    ((SearchTextField)this.myReplaceFieldWrapper.getTargetComponent()).addCurrentTextToHistory();
                }
            }
        }
    }

    private boolean updateTextComponent(boolean search2) {
        JBTextArea innerTextComponent;
        Object outerComponent;
        MyTextComponentWrapper wrapper2;
        JTextComponent oldComponent;
        JTextComponent jTextComponent = oldComponent = search2 ? this.mySearchTextComponent : this.myReplaceTextComponent;
        if (oldComponent != null) {
            return false;
        }
        MyTextComponentWrapper myTextComponentWrapper = wrapper2 = search2 ? this.mySearchFieldWrapper : this.myReplaceFieldWrapper;
        if (this.myUseSearchField) {
            outerComponent = new SearchTextField(true, this.toString());
            innerTextComponent = outerComponent.getTextEditor();
            innerTextComponent.setBorder(BorderFactory.createEmptyBorder());
        } else {
            innerTextComponent = new JBTextArea(){

                public Dimension getPreferredScrollableViewportSize() {
                    Dimension defaultSize = super.getPreferredScrollableViewportSize();
                    if (SearchReplaceComponent.this.mySplitter != null && SearchReplaceComponent.this.mySplitter.getSecondComponent() != null && Registry.is("ide.find.expand.search.field.on.typing", true)) {
                        Dimension preferredSize = this.getPreferredSize();
                        Dimension minimumSize = this.getMinimumSize();
                        int spaceForLeftPanel = SearchReplaceComponent.this.mySplitter.getWidth() - SearchReplaceComponent.this.mySplitter.getSecondComponent().getPreferredSize().width - SearchReplaceComponent.this.mySplitter.getDividerWidth();
                        int allSearchTextAreaIcons = JBUI.scale(180);
                        int w = spaceForLeftPanel - allSearchTextAreaIcons;
                        w = Math.max(w, minimumSize.width);
                        return new Dimension(Math.min(Math.max(defaultSize.width, preferredSize.width), w), defaultSize.height);
                    }
                    return defaultSize;
                }
            };
            ((JBTextArea)innerTextComponent).setRows(this.isMultiline() ? 2 : 1);
            ((JBTextArea)innerTextComponent).setColumns(12);
            innerTextComponent.setMinimumSize(new Dimension(150, 0));
            outerComponent = new SearchTextArea((JTextArea)innerTextComponent, search2);
            if (search2) {
                this.myExtraSearchButtons.clear();
                this.myExtraSearchButtons.addAll(((SearchTextArea)outerComponent).setExtraActions(this.myEmbeddedSearchActions.toArray(AnAction.EMPTY_ARRAY)));
                ((SearchTextArea)outerComponent).setMultilineEnabled(this.myMultilineEnabled);
            } else {
                this.myExtraReplaceButtons.clear();
                this.myExtraReplaceButtons.addAll(((SearchTextArea)outerComponent).setExtraActions(this.myEmbeddedReplaceActions.toArray(AnAction.EMPTY_ARRAY)));
            }
        }
        UIUtil.addUndoRedoActions((JTextComponent)innerTextComponent);
        wrapper2.setContent((JComponent)outerComponent);
        if (search2) {
            innerTextComponent.getAccessibleContext().setAccessibleName(FindBundle.message("find.search.accessible.name", new Object[0]));
        } else {
            innerTextComponent.getAccessibleContext().setAccessibleName(FindBundle.message("find.replace.accessible.name", new Object[0]));
        }
        innerTextComponent.putClientProperty("StatusVisibleFunction", c -> c.getText().isEmpty() && c.isFocusOwner());
        innerTextComponent.putClientProperty("AuxEditorComponent", Boolean.TRUE);
        innerTextComponent.setBackground(UIUtil.getTextFieldBackground());
        JBTextArea finalTextComponent = innerTextComponent;
        innerTextComponent.addFocusListener(new FocusListener((JComponent)finalTextComponent){
            final /* synthetic */ JComponent val$finalTextComponent;
            {
                this.val$finalTextComponent = jComponent;
            }

            @Override
            public void focusGained(FocusEvent e) {
                this.val$finalTextComponent.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.val$finalTextComponent.repaint();
            }
        });
        this.myCloseAction.registerOn((JComponent)outerComponent);
        return true;
    }

    private void installReplaceOnEnterAction(@NotNull JTextComponent c) {
        if (c == null) {
            SearchReplaceComponent.$$$reportNull$$$0(21);
        }
        ActionListener action2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchReplaceComponent.this.replace();
            }
        };
        c.registerKeyboardAction(action2, KeyStroke.getKeyStroke(10, 0), 0);
    }

    private void updateBindings() {
        this.updateBindings(this.mySearchFieldActions, (JComponent)((Object)this.mySearchFieldWrapper));
        this.updateBindings(this.mySearchActionsToolbar, (JComponent)((Object)this.mySearchFieldWrapper));
        this.updateBindings(Collections.singletonList(this.modeAction), (JComponent)((Object)this.mySearchFieldWrapper));
        this.updateBindings(this.myReplaceFieldActions, (JComponent)((Object)this.myReplaceFieldWrapper));
        this.updateBindings(this.myReplaceActionsToolbar, (JComponent)this.myReplaceToolbarWrapper);
    }

    private void updateBindings(@NotNull DefaultActionGroup group, @NotNull JComponent shortcutHolder) {
        if (group == null) {
            SearchReplaceComponent.$$$reportNull$$$0(22);
        }
        if (shortcutHolder == null) {
            SearchReplaceComponent.$$$reportNull$$$0(23);
        }
        this.updateBindings(ContainerUtil.immutableList(group.getChildActionsOrStubs()), shortcutHolder);
    }

    private void updateBindings(@NotNull ActionToolbarImpl toolbar, @NotNull JComponent shortcutHolder) {
        if (toolbar == null) {
            SearchReplaceComponent.$$$reportNull$$$0(24);
        }
        if (shortcutHolder == null) {
            SearchReplaceComponent.$$$reportNull$$$0(25);
        }
        this.updateBindings(toolbar.getActions(), shortcutHolder);
    }

    private void updateBindings(@NotNull List<? extends AnAction> actions2, @NotNull JComponent shortcutHolder) {
        if (actions2 == null) {
            SearchReplaceComponent.$$$reportNull$$$0(26);
        }
        if (shortcutHolder == null) {
            SearchReplaceComponent.$$$reportNull$$$0(27);
        }
        DataContext context2 = DataManager.getInstance().getDataContext((Component)((Object)this));
        for (AnAction anAction : actions2) {
            ShortcutSet shortcut = null;
            if (anAction instanceof DefaultActionGroup) {
                this.updateBindings((DefaultActionGroup)anAction, shortcutHolder);
            }
            if (anAction instanceof ContextAwareShortcutProvider) {
                shortcut = ((ContextAwareShortcutProvider)anAction).getShortcut(context2);
            } else if (anAction instanceof ShortcutProvider) {
                shortcut = ((ShortcutProvider)anAction).getShortcut();
            }
            if (shortcut == null) continue;
            anAction.registerCustomShortcutSet(shortcut, shortcutHolder);
        }
    }

    @NotNull
    private ActionToolbarImpl createReplaceToolbar1(@NotNull DefaultActionGroup group) {
        if (group == null) {
            SearchReplaceComponent.$$$reportNull$$$0(28);
        }
        ActionToolbarImpl toolbar = this.createToolbar((ActionGroup)group);
        toolbar.setForceMinimumSize(true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        ActionToolbarImpl actionToolbarImpl = toolbar;
        if (actionToolbarImpl == null) {
            SearchReplaceComponent.$$$reportNull$$$0(29);
        }
        return actionToolbarImpl;
    }

    @NotNull
    private ActionToolbarImpl createToolbar(@NotNull ActionGroup group) {
        if (group == null) {
            SearchReplaceComponent.$$$reportNull$$$0(30);
        }
        ActionToolbarImpl toolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("EditorToolbar", group, true);
        toolbar.setTargetComponent((JComponent)((Object)this));
        toolbar.setLayoutPolicy(2);
        Utils.setSmallerFontForChildren((JComponent)toolbar);
        ActionToolbarImpl actionToolbarImpl = toolbar;
        if (actionToolbarImpl == null) {
            SearchReplaceComponent.$$$reportNull$$$0(31);
        }
        return actionToolbarImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 29: 
            case 31: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 29: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchToolbar1Actions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchToolbar2Actions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchFieldActions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceToolbar1Actions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceToolbar2Actions";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceFieldActions";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/SearchReplaceComponent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textToSet";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findText";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceText";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 22: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcutHolder";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbar";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/SearchReplaceComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusColor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchTextComponent";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplaceTextComponent";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createReplaceToolbar1";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setStatusText";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 29: 
            case 31: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateSearchComponent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "replaceTextInTextComponentEnsuringSelection";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateReplaceComponent";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addTextToRecent";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "installReplaceOnEnterAction";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "updateBindings";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createReplaceToolbar1";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createToolbar";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 29: 
            case 31: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class ModeAction
    extends DumbAwareAction
    implements ContextAwareShortcutProvider {
        private ModeAction() {
            this.getTemplatePresentation().setIcon(AllIcons.General.ChevronRight);
        }

        public void update(@NotNull AnActionEvent e) {
            DataContext context2;
            SearchSession search2;
            if (e == null) {
                ModeAction.$$$reportNull$$$0(0);
            }
            boolean replaceMode = (search2 = (SearchSession)SearchSession.KEY.getData(context2 = e.getDataContext())) != null && search2.getFindModel().isReplaceState();
            Presentation presentation2 = e.getPresentation();
            presentation2.setIcon(replaceMode ? AllIcons.General.ChevronDown : AllIcons.General.ChevronRight);
            presentation2.setText(FindBundle.message(replaceMode ? "find.tooltip.switch.to.find" : "find.tooltip.switch.to.replace", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ModeAction.$$$reportNull$$$0(1);
            }
            SearchReplaceComponent.this.myEventDispatcher.getMulticaster().toggleSearchReplaceMode();
        }

        @Override
        @Nullable
        public ShortcutSet getShortcut(@NotNull DataContext context2) {
            SearchSession search2;
            if (context2 == null) {
                ModeAction.$$$reportNull$$$0(2);
            }
            return (search2 = (SearchSession)SearchSession.KEY.getData(context2)) != null && search2.getFindModel().isReplaceState() ? SearchReplaceComponent.this.findActionShortcutSet : SearchReplaceComponent.this.replaceActionShortcutSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/find/SearchReplaceComponent$ModeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getShortcut";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class TransferFocusBackwardAction
    extends DumbAwareAction {
        private TransferFocusBackwardAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Component focusOwner;
            if (e == null) {
                TransferFocusBackwardAction.$$$reportNull$$$0(0);
            }
            if (UIUtil.isAncestor((Component)((Object)SearchReplaceComponent.this), focusOwner = IdeFocusManager.getInstance((Project)SearchReplaceComponent.this.myProject).getFocusOwner())) {
                focusOwner.transferFocusBackward();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/SearchReplaceComponent$TransferFocusBackwardAction", "actionPerformed"));
        }
    }

    private class TransferFocusAction
    extends DumbAwareAction {
        private TransferFocusAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Component focusOwner;
            if (e == null) {
                TransferFocusAction.$$$reportNull$$$0(0);
            }
            if (UIUtil.isAncestor((Component)((Object)SearchReplaceComponent.this), focusOwner = IdeFocusManager.getInstance((Project)SearchReplaceComponent.this.myProject).getFocusOwner())) {
                focusOwner.transferFocus();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/SearchReplaceComponent$TransferFocusAction", "actionPerformed"));
        }
    }

    private static class MyTextComponentWrapper
    extends Wrapper {
        private MyTextComponentWrapper() {
        }

        @Nullable
        public JTextComponent getTextComponent() {
            JComponent wrapped = this.getTargetComponent();
            return wrapped != null ? MyTextComponentWrapper.unwrapTextComponent(wrapped) : null;
        }

        @NotNull
        protected static JTextComponent unwrapTextComponent(@NotNull JComponent wrapped) {
            if (wrapped == null) {
                MyTextComponentWrapper.$$$reportNull$$$0(0);
            }
            if (wrapped instanceof SearchTextField) {
                JBTextField jBTextField = ((SearchTextField)wrapped).getTextEditor();
                if (jBTextField == null) {
                    MyTextComponentWrapper.$$$reportNull$$$0(1);
                }
                return jBTextField;
            }
            if (wrapped instanceof SearchTextArea) {
                JTextArea jTextArea = ((SearchTextArea)wrapped).getTextArea();
                if (jTextArea == null) {
                    MyTextComponentWrapper.$$$reportNull$$$0(2);
                }
                return jTextArea;
            }
            throw new AssertionError();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrapped";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/SearchReplaceComponent$MyTextComponentWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/SearchReplaceComponent$MyTextComponentWrapper";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "unwrapTextComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "unwrapTextComponent";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class Builder {
        private final Project myProject;
        private final JComponent myTargetComponent;
        private DataProvider myDataProvider;
        private Runnable myReplaceAction;
        private Runnable myCloseAction;
        private final DefaultActionGroup mySearchActions;
        private final DefaultActionGroup myExtraSearchActions;
        private final DefaultActionGroup mySearchFieldActions;
        private final DefaultActionGroup myReplaceActions;
        private final DefaultActionGroup myExtraReplaceActions;
        private final DefaultActionGroup myReplaceFieldActions;
        private boolean myShowOnlySearchPanel;
        private boolean myMaximizeLeftPanelOnResize;
        private boolean myMultilineEnabled;
        private boolean myAddSearchResultsToGlobalSearch;
        private boolean myUseSearchField;

        private Builder(@Nullable Project project2, @NotNull JComponent component2) {
            if (component2 == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.mySearchActions = DefaultActionGroup.createFlatGroup(() -> "search bar 1");
            this.myExtraSearchActions = DefaultActionGroup.createFlatGroup(() -> "search bar 2");
            this.mySearchFieldActions = DefaultActionGroup.createFlatGroup(() -> "search field actions");
            this.myReplaceActions = DefaultActionGroup.createFlatGroup(() -> "replace bar 1");
            this.myExtraReplaceActions = DefaultActionGroup.createFlatGroup(() -> "replace bar 1");
            this.myReplaceFieldActions = DefaultActionGroup.createFlatGroup(() -> "replace field actions");
            this.myShowOnlySearchPanel = false;
            this.myMaximizeLeftPanelOnResize = false;
            this.myMultilineEnabled = true;
            this.myAddSearchResultsToGlobalSearch = true;
            this.myUseSearchField = false;
            this.myProject = project2;
            this.myTargetComponent = component2;
        }

        @NotNull
        public Builder withDataProvider(@NotNull DataProvider provider2) {
            if (provider2 == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myDataProvider = provider2;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder2;
        }

        @NotNull
        public Builder withReplaceAction(@NotNull Runnable action2) {
            if (action2 == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myReplaceAction = action2;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder2;
        }

        @NotNull
        public Builder withCloseAction(@NotNull Runnable action2) {
            if (action2 == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.myCloseAction = action2;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder2;
        }

        @NotNull
        public Builder addSearchFieldActions(AnAction ... actions2) {
            if (actions2 == null) {
                Builder.$$$reportNull$$$0(7);
            }
            this.mySearchFieldActions.addAll(actions2);
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder2;
        }

        @NotNull
        public Builder addReplaceFieldActions(AnAction ... actions2) {
            if (actions2 == null) {
                Builder.$$$reportNull$$$0(9);
            }
            this.myReplaceFieldActions.addAll(actions2);
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder2;
        }

        @NotNull
        public Builder addPrimarySearchActions(AnAction ... actions2) {
            if (actions2 == null) {
                Builder.$$$reportNull$$$0(11);
            }
            this.mySearchActions.addAll(actions2);
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(12);
            }
            return builder2;
        }

        @NotNull
        public Builder addSecondarySearchActions(AnAction ... actions2) {
            if (actions2 == null) {
                Builder.$$$reportNull$$$0(13);
            }
            for (AnAction action2 : actions2) {
                this.mySearchActions.addAction(action2).setAsSecondary(true);
            }
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(14);
            }
            return builder2;
        }

        @NotNull
        public Builder addExtraSearchActions(AnAction ... actions2) {
            if (actions2 == null) {
                Builder.$$$reportNull$$$0(15);
            }
            this.myExtraSearchActions.addAll(actions2);
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(16);
            }
            return builder2;
        }

        @NotNull
        public Builder addPrimaryReplaceActions(AnAction ... actions2) {
            if (actions2 == null) {
                Builder.$$$reportNull$$$0(17);
            }
            this.myReplaceActions.addAll(actions2);
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(18);
            }
            return builder2;
        }

        @NotNull
        public Builder addExtraReplaceAction(AnAction ... actions2) {
            if (actions2 == null) {
                Builder.$$$reportNull$$$0(19);
            }
            this.myExtraReplaceActions.addAll(actions2);
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(20);
            }
            return builder2;
        }

        @NotNull
        public Builder withShowOnlySearchPanel() {
            this.myShowOnlySearchPanel = true;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(21);
            }
            return builder2;
        }

        @NotNull
        public Builder withMaximizeLeftPanelOnResize() {
            this.myMaximizeLeftPanelOnResize = true;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(22);
            }
            return builder2;
        }

        @NotNull
        public SearchReplaceComponent build() {
            return new SearchReplaceComponent(this.myProject, this.myTargetComponent, this.mySearchActions, this.myExtraSearchActions, this.mySearchFieldActions, this.myReplaceActions, this.myExtraReplaceActions, this.myReplaceFieldActions, this.myReplaceAction, this.myCloseAction, this.myDataProvider, this.myShowOnlySearchPanel, this.myMaximizeLeftPanelOnResize, this.myMultilineEnabled, this.myAddSearchResultsToGlobalSearch, this.myUseSearchField);
        }

        @NotNull
        public Builder withMultilineEnabled(boolean b) {
            this.myMultilineEnabled = b;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(23);
            }
            return builder2;
        }

        @NotNull
        public Builder withAddSearchResultsToGlobalSearch(boolean b) {
            this.myAddSearchResultsToGlobalSearch = b;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(24);
            }
            return builder2;
        }

        @NotNull
        public Builder withUseSearchField(boolean b) {
            this.myUseSearchField = b;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(25);
            }
            return builder2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 18: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 18: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 18: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/SearchReplaceComponent$Builder";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 15: 
                case 17: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/SearchReplaceComponent$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withDataProvider";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withReplaceAction";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withCloseAction";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addSearchFieldActions";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addReplaceFieldActions";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addPrimarySearchActions";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addSecondarySearchActions";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addExtraSearchActions";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addPrimaryReplaceActions";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addExtraReplaceAction";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withShowOnlySearchPanel";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withMaximizeLeftPanelOnResize";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withMultilineEnabled";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withAddSearchResultsToGlobalSearch";
                    break;
                }
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withUseSearchField";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "withDataProvider";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 18: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "withReplaceAction";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "withCloseAction";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addSearchFieldActions";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "addReplaceFieldActions";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "addPrimarySearchActions";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "addSecondarySearchActions";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "addExtraSearchActions";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "addPrimaryReplaceActions";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "addExtraReplaceAction";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 18: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Listener
    extends EventListener {
        public void searchFieldDocumentChanged();

        public void replaceFieldDocumentChanged();

        public void multilineStateChanged();

        default public void toggleSearchReplaceMode() {
        }
    }

    private class CloseAction
    extends DumbAwareAction
    implements LightEditCompatible,
    RightAlignedToolbarAction {
        private final ShortcutSet shortcut = KeymapUtil.getActiveKeymapShortcuts((String)"EditorEscape");

        private CloseAction() {
            this.getTemplatePresentation().setText(FindBundle.message("find.close.button.name", new Object[0]));
            this.getTemplatePresentation().setIcon(CLOSE_ICON);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseAction.$$$reportNull$$$0(0);
            }
            SearchReplaceComponent.this.close();
        }

        private void registerOn(@NotNull JComponent component2) {
            if (component2 == null) {
                CloseAction.$$$reportNull$$$0(1);
            }
            this.registerCustomShortcutSet(this.shortcut, component2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/find/SearchReplaceComponent$CloseAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerOn";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

