/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.ui;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProviderBase;
import com.intellij.ide.util.frameworkSupport.FrameworkVersion;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FacetBasedFrameworkSupportProvider<F extends Facet>
extends FrameworkSupportProviderBase {
    private static final Logger LOG = Logger.getInstance(FacetBasedFrameworkSupportProvider.class);
    @NonNls
    private static final String FACET_SUPPORT_PREFIX = "facet:";
    private final FacetType<F, ?> myFacetType;

    protected FacetBasedFrameworkSupportProvider(@NotNull FacetType<F, ?> facetType) {
        if (facetType == null) {
            FacetBasedFrameworkSupportProvider.$$$reportNull$$$0(0);
        }
        super(FacetBasedFrameworkSupportProvider.getProviderId(facetType), facetType.getPresentableName());
        this.myFacetType = facetType;
    }

    public static String getProviderId(@NotNull FacetType<?, ?> facetType) {
        if (facetType == null) {
            FacetBasedFrameworkSupportProvider.$$$reportNull$$$0(1);
        }
        return FACET_SUPPORT_PREFIX + facetType.getStringId();
    }

    public static String getProviderId(FacetTypeId<?> typeId) {
        return FacetBasedFrameworkSupportProvider.getProviderId(FacetTypeRegistry.getInstance().findFacetType(typeId));
    }

    @Override
    @Nullable
    public String getUnderlyingFrameworkId() {
        FacetTypeId typeId = this.myFacetType.getUnderlyingFacetType();
        if (typeId == null) {
            return null;
        }
        return FacetBasedFrameworkSupportProvider.getProviderId(FacetTypeRegistry.getInstance().findFacetType(typeId));
    }

    @Override
    public boolean isEnabledForModuleType(@NotNull ModuleType moduleType) {
        if (moduleType == null) {
            FacetBasedFrameworkSupportProvider.$$$reportNull$$$0(2);
        }
        return this.myFacetType.isSuitableModuleType(moduleType);
    }

    @Override
    public boolean isSupportAlreadyAdded(@NotNull Module module, @NotNull FacetsProvider facetsProvider) {
        if (module == null) {
            FacetBasedFrameworkSupportProvider.$$$reportNull$$$0(3);
        }
        if (facetsProvider == null) {
            FacetBasedFrameworkSupportProvider.$$$reportNull$$$0(4);
        }
        return !facetsProvider.getFacetsByType(module, this.myFacetType.getId()).isEmpty();
    }

    @Override
    public Icon getIcon() {
        return this.myFacetType.getIcon();
    }

    @Override
    protected void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, FrameworkVersion version, @Nullable Library library2) {
        if (module == null) {
            FacetBasedFrameworkSupportProvider.$$$reportNull$$$0(5);
        }
        if (rootModel == null) {
            FacetBasedFrameworkSupportProvider.$$$reportNull$$$0(6);
        }
        FacetManager facetManager = FacetManager.getInstance((Module)module);
        ModifiableFacetModel model2 = facetManager.createModifiableModel();
        Facet underlyingFacet = null;
        FacetTypeId underlyingFacetType = this.myFacetType.getUnderlyingFacetType();
        if (underlyingFacetType != null) {
            underlyingFacet = model2.getFacetByType(underlyingFacetType);
            LOG.assertTrue(underlyingFacet != null, underlyingFacetType);
        }
        Facet facet = facetManager.createFacet(this.myFacetType, this.myFacetType.getDefaultFacetName(), underlyingFacet);
        this.setupConfiguration(facet, rootModel, version);
        if (library2 != null) {
            this.onLibraryAdded(facet, library2);
        }
        model2.addFacet(facet);
        model2.commit();
        this.onFacetCreated(facet, rootModel, version);
    }

    protected void onFacetCreated(F facet, ModifiableRootModel rootModel, FrameworkVersion version) {
    }

    protected void onLibraryAdded(F facet, @NotNull Library library2) {
        if (library2 == null) {
            FacetBasedFrameworkSupportProvider.$$$reportNull$$$0(7);
        }
    }

    protected abstract void setupConfiguration(F var1, ModifiableRootModel var2, FrameworkVersion var3);

    public void processAddedLibraries(Module module, List<? extends Library> addedLibraries) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetsProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        objectArray2[1] = "com/intellij/facet/ui/FacetBasedFrameworkSupportProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getProviderId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForModuleType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupportAlreadyAdded";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addSupport";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "onLibraryAdded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

