/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetTypeId;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FacetModelBase
implements FacetModel {
    private volatile Map<FacetTypeId<?>, Collection<Facet<?>>> myType2Facets;
    private volatile Map<FacetAndType, Collection<Facet<?>>> myChildFacets;
    private volatile Facet<?>[] mySortedFacets;

    public Facet<?> @NotNull [] getSortedFacets() {
        if (this.mySortedFacets == null) {
            Facet[] allFacets = this.getAllFacets();
            if (allFacets.length == 0) {
                this.mySortedFacets = Facet.EMPTY_ARRAY;
            } else {
                LinkedHashSet facets = new LinkedHashSet();
                for (Facet facet : allFacets) {
                    FacetModelBase.addUnderlyingFacets(facets, facet);
                }
                this.mySortedFacets = facets.toArray(Facet.EMPTY_ARRAY);
            }
        }
        if (this.mySortedFacets == null) {
            FacetModelBase.$$$reportNull$$$0(0);
        }
        return this.mySortedFacets;
    }

    private static void addUnderlyingFacets(LinkedHashSet<? super Facet<?>> facets, Facet<?> facet) {
        Facet underlyingFacet = facet.getUnderlyingFacet();
        if (underlyingFacet != null && !facets.contains(facet)) {
            FacetModelBase.addUnderlyingFacets(facets, underlyingFacet);
        }
        facets.add(facet);
    }

    @NotNull
    public <F extends Facet<?>> Collection<F> getFacetsByType(@NotNull Facet<?> underlyingFacet, FacetTypeId<F> typeId) {
        Collection<Facet<?>> facets;
        if (underlyingFacet == null) {
            FacetModelBase.$$$reportNull$$$0(1);
        }
        if (this.myChildFacets == null) {
            MultiMap<FacetAndType, Facet> children2 = new MultiMap<FacetAndType, Facet>();
            for (Facet facet : this.getAllFacets()) {
                Facet underlying = facet.getUnderlyingFacet();
                if (underlying == null) continue;
                children2.putValue(new FacetAndType(underlying, facet.getTypeId()), facet);
            }
            this.myChildFacets = children2.freezeValues();
        }
        Collection<Object> collection = (facets = this.myChildFacets.get(new FacetAndType(underlyingFacet, typeId))) != null ? facets : Collections.emptyList();
        if (collection == null) {
            FacetModelBase.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public String getFacetName(@NotNull Facet<?> facet) {
        if (facet == null) {
            FacetModelBase.$$$reportNull$$$0(3);
        }
        String string2 = facet.getName();
        if (string2 == null) {
            FacetModelBase.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @Nullable
    public <F extends Facet<?>> F findFacet(FacetTypeId<F> type, String name2) {
        Collection<F> fs = this.getFacetsByType(type);
        for (Facet f : fs) {
            if (!f.getName().equals(name2)) continue;
            return (F)f;
        }
        return null;
    }

    @Nullable
    public <F extends Facet<?>> F getFacetByType(@NotNull Facet<?> underlyingFacet, FacetTypeId<F> typeId) {
        Collection<F> fs;
        if (underlyingFacet == null) {
            FacetModelBase.$$$reportNull$$$0(5);
        }
        return (F)((fs = this.getFacetsByType(underlyingFacet, typeId)).isEmpty() ? null : (Facet)fs.iterator().next());
    }

    @Nullable
    public <F extends Facet<?>> F getFacetByType(FacetTypeId<F> typeId) {
        Collection<F> facets = this.getFacetsByType(typeId);
        return (F)(facets.isEmpty() ? null : (Facet)facets.iterator().next());
    }

    @NotNull
    public <F extends Facet<?>> Collection<F> getFacetsByType(FacetTypeId<F> typeId) {
        Collection<Facet<?>> facets;
        if (this.myType2Facets == null) {
            MultiMap<FacetTypeId, Facet> typeToFacets = new MultiMap<FacetTypeId, Facet>();
            for (Facet facet : this.getAllFacets()) {
                typeToFacets.putValue(facet.getTypeId(), facet);
            }
            this.myType2Facets = typeToFacets.freezeValues();
        }
        Collection<Object> collection = (facets = this.myType2Facets.get(typeId)) != null ? facets : Collections.emptyList();
        if (collection == null) {
            FacetModelBase.$$$reportNull$$$0(6);
        }
        return collection;
    }

    protected void facetsChanged() {
        this.myChildFacets = null;
        this.myType2Facets = null;
        this.mySortedFacets = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/FacetModelBase";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "underlyingFacet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedFacets";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/FacetModelBase";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetsByType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFacetsByType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFacetName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFacetByType";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class FacetAndType {
        final Facet<?> myFacet;
        final FacetTypeId<?> myTypeId;

        private FacetAndType(Facet<?> facet, FacetTypeId<?> id2) {
            this.myFacet = facet;
            this.myTypeId = id2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FacetAndType type = (FacetAndType)o;
            return Objects.equals(this.myFacet, type.myFacet) && Objects.equals(this.myTypeId, type.myTypeId);
        }

        public int hashCode() {
            return Objects.hash(this.myFacet, this.myTypeId);
        }
    }
}

