/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.stream.Stream;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ListTableWithButtons<T>
extends Observable {
    private final List<T> myElements = new ArrayList<T>();
    private JPanel myPanel;
    @NotNull
    private final TableView<T> myTableView = new TableView<T>(this.createListModel()){

        protected void createDefaultEditors() {
            super.createDefaultEditors();
            Object editor2 = this.defaultEditorsByColumnClass.get(String.class);
            if (editor2 instanceof DefaultCellEditor) {
                ((DefaultCellEditor)editor2).getComponent().addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        int column = ListTableWithButtons.this.myTableView.getEditingColumn();
                        int row = ListTableWithButtons.this.myTableView.getEditingRow();
                        if (e.getModifiers() == 0 && (e.getKeyCode() == 10 || e.getKeyCode() == 9)) {
                            e.consume();
                            SwingUtilities.invokeLater(() -> {
                                int nextRow;
                                this.stopEditing();
                                int nextColumn = column < ListTableWithButtons.this.myTableView.getColumnCount() - 1 ? column + 1 : 0;
                                int n = nextRow = nextColumn == 0 ? row + 1 : row;
                                if (nextRow > ListTableWithButtons.this.myTableView.getRowCount() - 1) {
                                    if (ListTableWithButtons.this.myElements.isEmpty() || !ListTableWithButtons.this.isEmpty(ListTableWithButtons.this.myElements.get(ListTableWithButtons.this.myElements.size() - 1))) {
                                        AnActionButton addButton = ToolbarDecorator.findAddButton((JComponent)ListTableWithButtons.this.myPanel);
                                        if (addButton != null) {
                                            addButton.actionPerformed(ActionUtil.createEmptyEvent());
                                        }
                                        return;
                                    }
                                    nextRow = 0;
                                }
                                ListTableWithButtons.this.myTableView.scrollRectToVisible(ListTableWithButtons.this.myTableView.getCellRect(nextRow, nextColumn, true));
                                ListTableWithButtons.this.myTableView.editCellAt(nextRow, nextColumn);
                            });
                        }
                    }
                });
            }
        }
    };
    private final CommonActionsPanel myActionsPanel;
    private boolean myIsEnabled = true;
    private final ToolbarDecorator myDecorator;

    protected ListTableWithButtons() {
        this.myTableView.setShowGrid(false);
        this.myTableView.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.myTableView.getTableViewModel().setSortable(false);
        this.myTableView.getComponent().setSelectionMode(2);
        this.myDecorator = this.createToolbarDecorator();
        this.myActionsPanel = this.myDecorator.getActionsPanel();
    }

    protected ToolbarDecorator createToolbarDecorator() {
        return ToolbarDecorator.createDecorator(this.myTableView);
    }

    @Nullable
    protected AnActionButtonRunnable createRemoveAction() {
        return button2 -> this.removeSelected();
    }

    @Nullable
    protected AnActionButtonRunnable createAddAction() {
        return button2 -> this.addNewElement(this.createElement());
    }

    @Nullable
    protected AnActionButtonRunnable createEditAction() {
        return null;
    }

    protected void addNewElement(T newElement) {
        this.myTableView.stopEditing();
        this.setModified();
        SwingUtilities.invokeLater(() -> {
            if (this.myElements.isEmpty() || !this.isEmpty(this.myElements.get(this.myElements.size() - 1))) {
                this.myElements.add(newElement);
                this.myTableView.getTableViewModel().setItems(this.myElements);
            }
            this.myTableView.scrollRectToVisible(this.myTableView.getCellRect(this.myElements.size() - 1, 0, true));
            if (this.shouldEditRowOnCreation()) {
                this.myTableView.getComponent().editCellAt(this.myElements.size() - 1, 0);
            }
            this.myTableView.getComponent().revalidate();
            this.myTableView.getComponent().repaint();
        });
    }

    protected void removeSelected() {
        int[] selectedRows = this.myTableView.getComponent().getSelectedRows();
        if (selectedRows.length == 0) {
            return;
        }
        this.myTableView.stopEditing();
        this.setModified();
        int selectedIndex = this.myTableView.getSelectionModel().getLeadSelectionIndex();
        this.myTableView.scrollRectToVisible(this.myTableView.getCellRect(selectedIndex, 0, true));
        ArrayList<T> aliveElements = new ArrayList<T>();
        for (int row = 0; row < this.myTableView.getRowCount(); ++row) {
            T selectedElement = this.myElements.get(row);
            if (this.myTableView.isRowSelected(row) && this.canDeleteElement(selectedElement)) continue;
            aliveElements.add(selectedElement);
        }
        this.myElements.clear();
        this.myElements.addAll(aliveElements);
        this.myTableView.getSelectionModel().clearSelection();
        this.myTableView.getTableViewModel().setItems(this.myElements);
        int prev = selectedIndex - 1;
        if (prev >= 0) {
            this.myTableView.getComponent().getSelectionModel().setSelectionInterval(prev, prev);
        } else if (selectedIndex < this.myElements.size()) {
            this.myTableView.getComponent().getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        }
    }

    @NotNull
    public TableView<T> getTableView() {
        TableView<T> tableView = this.myTableView;
        if (tableView == null) {
            ListTableWithButtons.$$$reportNull$$$0(0);
        }
        return tableView;
    }

    protected abstract ListTableModel createListModel();

    protected void setModified() {
        this.setChanged();
        this.notifyObservers();
    }

    protected List<T> getElements() {
        return this.myElements;
    }

    public JComponent getComponent() {
        if (this.myPanel == null) {
            this.myDecorator.setAddAction(this.createAddAction()).setRemoveAction(this.createRemoveAction()).setEditAction(this.createEditAction());
            if (!this.isUpDownSupported()) {
                this.myDecorator.disableUpDownActions();
            }
            this.myDecorator.addExtraActions(this.createExtraActions());
            this.myPanel = this.myDecorator.createPanel();
            this.configureToolbarButtons(this.myPanel);
        }
        return this.myPanel;
    }

    protected void configureToolbarButtons(@NotNull JPanel panel2) {
        if (panel2 == null) {
            ListTableWithButtons.$$$reportNull$$$0(1);
        }
        AnActionButton addButton = ToolbarDecorator.findAddButton((JComponent)panel2);
        AnActionButton removeButton = ToolbarDecorator.findRemoveButton((JComponent)panel2);
        AnActionButton editButton = ToolbarDecorator.findEditButton((JComponent)panel2);
        AnActionButton upButton = ToolbarDecorator.findUpButton((JComponent)panel2);
        AnActionButton downButton = ToolbarDecorator.findDownButton((JComponent)panel2);
        Stream.of(addButton, removeButton, editButton, upButton, downButton).filter(it -> it != null).forEach(it -> it.addCustomUpdater(e -> this.myIsEnabled));
        if (removeButton != null) {
            removeButton.addCustomUpdater(e -> {
                List<T> selection = this.getSelection();
                if (selection.isEmpty()) {
                    return false;
                }
                for (T t : selection) {
                    if (this.canDeleteElement(t)) continue;
                    return false;
                }
                return true;
            });
        }
    }

    public CommonActionsPanel getActionsPanel() {
        return this.myActionsPanel;
    }

    public void setEnabled() {
        this.myTableView.getComponent().setEnabled(true);
        this.myIsEnabled = true;
    }

    public void setDisabled() {
        this.myTableView.getComponent().setEnabled(false);
        this.myIsEnabled = false;
    }

    public void stopEditing() {
        this.myTableView.stopEditing();
    }

    public void refreshValues() {
        this.myTableView.getComponent().repaint();
    }

    protected void setSelection(T element2) {
        this.myTableView.setSelection(Collections.singleton(element2));
        TableUtil.scrollSelectionToVisible(this.myTableView);
    }

    protected void editSelection(int column) {
        List<T> selection = this.getSelection();
        if (selection.size() != 1) {
            return;
        }
        int row = this.myElements.indexOf(selection.get(0));
        if (row != -1) {
            TableUtil.editCellAt(this.myTableView, row, column);
        }
    }

    protected abstract T createElement();

    protected abstract boolean isEmpty(T var1);

    protected AnActionButton @NotNull [] createExtraActions() {
        return new AnActionButton[0];
    }

    @NotNull
    protected List<T> getSelection() {
        int[] selection = this.myTableView.getComponent().getSelectedRows();
        if (selection.length == 0) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                ListTableWithButtons.$$$reportNull$$$0(2);
            }
            return list2;
        }
        ArrayList<T> result2 = new ArrayList<T>(selection.length);
        for (int row : selection) {
            result2.add(this.myElements.get(row));
        }
        ArrayList<T> arrayList = result2;
        if (arrayList == null) {
            ListTableWithButtons.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public void setValues(List<? extends T> envVariables) {
        this.myElements.clear();
        for (T envVariable : envVariables) {
            this.myElements.add(this.cloneElement(envVariable));
        }
        this.myTableView.getTableViewModel().setItems(this.myElements);
    }

    protected boolean isUpDownSupported() {
        return false;
    }

    protected boolean shouldEditRowOnCreation() {
        return true;
    }

    protected abstract T cloneElement(T var1);

    protected abstract boolean canDeleteElement(T var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/util/ListTableWithButtons";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/util/ListTableWithButtons";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "configureToolbarButtons";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    protected static abstract class ElementsColumnInfoBase<T>
    extends ColumnInfo<T, String> {
        private DefaultTableCellRenderer myRenderer;

        protected ElementsColumnInfoBase(@NlsContexts.ColumnName String name2) {
            super(name2);
        }

        public TableCellRenderer getRenderer(T element2) {
            if (this.myRenderer == null) {
                this.myRenderer = new DefaultTableCellRenderer();
            }
            if (element2 != null) {
                this.myRenderer.setText((String)this.valueOf(element2));
                this.myRenderer.setToolTipText(this.getDescription(element2));
            }
            return this.myRenderer;
        }

        @Nullable
        @NlsContexts.Tooltip
        protected abstract String getDescription(T var1);
    }
}

