/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceModelFilter;
import com.intellij.execution.services.ServiceView;
import com.intellij.execution.services.ServiceViewActionProvider;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewDragHelper;
import com.intellij.execution.services.ServiceViewLocatableDescriptor;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewModel;
import com.intellij.execution.services.ServiceViewNonActivatingDescriptor;
import com.intellij.execution.services.ServiceViewSourceScrollHelper;
import com.intellij.execution.services.ServiceViewState;
import com.intellij.execution.services.ServiceViewToolWindowFactory;
import com.intellij.icons.AllIcons;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.SmartHashSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Unit;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@com.intellij.openapi.components.State(name="ServiceViewManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
public final class ServiceViewManagerImpl
implements ServiceViewManager,
PersistentStateComponent<State> {
    @NonNls
    private static final String HELP_ID = "services.tool.window";
    private final Project myProject;
    private State myState;
    private final ServiceModel myModel;
    private final ServiceModelFilter myModelFilter;
    private final Map<String, Collection<ServiceViewContributor<?>>> myGroups;
    private final List<ServiceViewContentHolder> myContentHolders;
    private boolean myActivationActionsRegistered;
    private AutoScrollToSourceHandler myAutoScrollToSourceHandler;
    private final Set<String> myActiveToolWindowIds;
    private boolean myRegisteringToolWindowAvailable;

    public ServiceViewManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(0);
        }
        this.myState = new State();
        this.myGroups = new ConcurrentHashMap();
        this.myContentHolders = new SmartList<ServiceViewContentHolder>();
        this.myActiveToolWindowIds = new SmartHashSet<String>();
        this.myProject = project2;
        LightEditUtil.forbidServiceInLightEditMode((Project)project2, this.getClass());
        this.myModel = new ServiceModel(this.myProject);
        Disposer.register(this.myProject, this.myModel);
        this.myModelFilter = new ServiceModelFilter();
        this.loadGroups(ServiceViewContributor.CONTRIBUTOR_EP_NAME.getExtensionList());
        this.myProject.getMessageBus().connect(this.myModel).subscribe(ServiceEventListener.TOPIC, e -> this.myModel.handle(e).onSuccess(o -> this.eventHandled(e)));
        this.initRoots();
        ServiceViewContributor.CONTRIBUTOR_EP_NAME.addExtensionPointListener(new ServiceViewExtensionPointListener(), this.myProject);
    }

    private void eventHandled(@NotNull ServiceEventListener.ServiceEvent e) {
        String toolWindowId;
        if (e == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(1);
        }
        if ((toolWindowId = this.getToolWindowId(e.contributorClass)) == null) {
            return;
        }
        ServiceModel.ServiceViewItem eventRoot = (ServiceModel.ServiceViewItem)((Object)ContainerUtil.find(this.myModel.getRoots(), root -> e.contributorClass.isInstance(root.getRootContributor())));
        if (eventRoot != null) {
            boolean show2 = !(eventRoot.getViewDescriptor() instanceof ServiceViewNonActivatingDescriptor);
            this.updateToolWindow(toolWindowId, true, show2);
        } else {
            Set<? extends ServiceViewContributor<?>> activeContributors = this.getActiveContributors();
            Collection<ServiceViewContributor<?>> toolWindowContributors = this.myGroups.get(toolWindowId);
            this.updateToolWindow(toolWindowId, ContainerUtil.intersects(activeContributors, toolWindowContributors), false);
        }
    }

    private void initRoots() {
        this.myModel.getInvoker().invokeLater(() -> this.myModel.initRoots().onSuccess(o -> {
            Set<ServiceViewContributor<?>> activeContributors = this.getActiveContributors();
            HashMap<String, Boolean> toolWindowIds = new HashMap<String, Boolean>();
            for (ServiceViewContributor<?> serviceViewContributor : ServiceViewContributor.CONTRIBUTOR_EP_NAME.getExtensionList()) {
                Boolean active;
                String toolWindowId = this.getToolWindowId(serviceViewContributor.getClass());
                if (toolWindowId == null || (active = toolWindowIds.putIfAbsent(toolWindowId, activeContributors.contains(serviceViewContributor))) != Boolean.FALSE || !activeContributors.contains(serviceViewContributor)) continue;
                toolWindowIds.put(toolWindowId, Boolean.TRUE);
            }
            for (Map.Entry entry : toolWindowIds.entrySet()) {
                this.registerToolWindow((String)entry.getKey(), (Boolean)entry.getValue());
            }
        }));
    }

    private Set<? extends ServiceViewContributor<?>> getActiveContributors() {
        return ContainerUtil.map2Set(this.myModel.getRoots(), ServiceModel.ServiceViewItem::getRootContributor);
    }

    @Nullable
    private ServiceViewContentHolder getContentHolder(@NotNull Class<?> contributorClass) {
        if (contributorClass == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(2);
        }
        for (ServiceViewContentHolder holder : this.myContentHolders) {
            for (ServiceViewContributor<?> rootContributor : holder.rootContributors) {
                if (!contributorClass.isInstance(rootContributor)) continue;
                return holder;
            }
        }
        return null;
    }

    private void registerToolWindow(@NotNull String toolWindowId, boolean active) {
        if (toolWindowId == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(3);
        }
        if (this.myProject.isDefault()) {
            return;
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        toolWindowManager.invokeLater(() -> {
            if (!this.myActivationActionsRegistered) {
                this.myActivationActionsRegistered = true;
                Collection<ServiceViewContributor<?>> contributors = this.myGroups.get("Services");
                if (contributors != null) {
                    ServiceViewManagerImpl.registerActivateByContributorActions(this.myProject, contributors);
                }
            }
            this.myRegisteringToolWindowAvailable = active;
            try {
                ToolWindow toolWindow = toolWindowManager.registerToolWindow(toolWindowId, builder2 -> {
                    builder2.contentFactory = new ServiceViewToolWindowFactory();
                    builder2.icon = AllIcons.Toolwindows.ToolWindowServices;
                    builder2.hideOnEmptyContent = false;
                    if (toolWindowId.equals("Services")) {
                        builder2.stripeTitle = () -> {
                            @NlsSafe String title = toolWindowId;
                            return title;
                        };
                    }
                    return Unit.INSTANCE;
                });
                if (active) {
                    this.myActiveToolWindowIds.add(toolWindowId);
                }
                ServiceViewManagerImpl.restoreBrokenToolWindowIfNeeded(toolWindow);
            }
            finally {
                this.myRegisteringToolWindowAvailable = false;
            }
        });
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.2")
    private static void restoreBrokenToolWindowIfNeeded(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(4);
        }
        if (!toolWindow.isShowStripeButton() && toolWindow.isVisible()) {
            toolWindow.hide();
            toolWindow.show();
        }
    }

    private void updateToolWindow(@NotNull String toolWindowId, boolean active, boolean show2) {
        if (toolWindowId == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(5);
        }
        if (this.myProject.isDisposed() || this.myProject.isDefault()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(toolWindowId);
            if (toolWindow == null) {
                return;
            }
            if (active) {
                boolean doShow = show2 && !this.myActiveToolWindowIds.contains(toolWindowId);
                this.myActiveToolWindowIds.add(toolWindowId);
                if (doShow) {
                    toolWindow.show();
                }
            } else if (this.myActiveToolWindowIds.remove(toolWindowId)) {
                toolWindow.hide();
            }
        }, ModalityState.NON_MODAL, this.myProject.getDisposed());
    }

    boolean shouldBeAvailable() {
        return this.myRegisteringToolWindowAvailable;
    }

    void createToolWindowContent(@NotNull ToolWindow toolWindow) {
        String toolWindowId;
        Collection<ServiceViewContributor<?>> contributors;
        if (toolWindow == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(6);
        }
        if ((contributors = this.myGroups.get(toolWindowId = toolWindow.getId())) == null) {
            return;
        }
        if (this.myAutoScrollToSourceHandler == null) {
            this.myAutoScrollToSourceHandler = ServiceViewSourceScrollHelper.createAutoScrollToSourceHandler(this.myProject);
        }
        ToolWindowEx toolWindowEx = (ToolWindowEx)toolWindow;
        ServiceViewSourceScrollHelper.installAutoScrollSupport(this.myProject, toolWindowEx, this.myAutoScrollToSourceHandler);
        Pair<ServiceViewState, List<ServiceViewState>> states = this.getServiceViewStates(toolWindowId);
        ServiceViewModel.AllServicesModel mainModel = new ServiceViewModel.AllServicesModel(this.myModel, this.myModelFilter, contributors);
        ServiceView mainView = ServiceView.createView(this.myProject, mainModel, this.prepareViewState((ServiceViewState)states.first));
        mainView.setAutoScrollToSourceHandler(this.myAutoScrollToSourceHandler);
        ContentManager contentManager = toolWindow.getContentManager();
        ServiceViewContentHolder holder = new ServiceViewContentHolder(mainView, contentManager, contributors, toolWindowId);
        this.myContentHolders.add(holder);
        contentManager.addContentManagerListener((ContentManagerListener)new ServiceViewContentMangerListener(this.myModelFilter, this.myAutoScrollToSourceHandler, holder));
        this.addMainContent(toolWindow.getContentManager(), mainView);
        this.loadViews(contentManager, mainView, contributors, (List)states.second);
        ServiceViewDragHelper.installDnDSupport(this.myProject, toolWindowEx.getDecorator(), contentManager);
    }

    private void addMainContent(ContentManager contentManager, ServiceView mainView) {
        Content mainContent = ContentFactory.getInstance().createContent((JComponent)mainView, null, false);
        mainContent.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        mainContent.setHelpId(ServiceViewManagerImpl.getToolWindowContextHelpId());
        mainContent.setCloseable(false);
        Disposer.register((Disposable)mainContent, mainView);
        Disposer.register((Disposable)mainContent, mainView.getModel());
        contentManager.addContent(mainContent);
        mainView.getModel().addModelListener(() -> {
            boolean isEmpty = mainView.getModel().getRoots().isEmpty();
            ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith(this.myProject)).submit(() -> {
                if (contentManager.isDisposed()) {
                    return;
                }
                if (isEmpty) {
                    if (contentManager.getIndexOfContent(mainContent) < 0) {
                        if (contentManager.getContentCount() == 0) {
                            contentManager.addContent(mainContent, 0);
                        }
                    } else if (contentManager.getContentCount() > 1) {
                        contentManager.removeContent(mainContent, false);
                    }
                } else if (contentManager.getIndexOfContent(mainContent) < 0) {
                    contentManager.addContent(mainContent, 0);
                }
            });
        });
    }

    private void loadViews(ContentManager contentManager, ServiceView mainView, Collection<? extends ServiceViewContributor<?>> contributors, List<ServiceViewState> viewStates) {
        this.myModel.getInvoker().invokeLater(() -> {
            Map<String, ServiceViewContributor<?>> contributorsMap = FactoryMap.create(className -> {
                for (ServiceViewContributor contributor : contributors) {
                    if (!className.equals(contributor.getClass().getName())) continue;
                    return contributor;
                }
                return null;
            });
            ArrayList<ServiceModelFilter.ServiceViewFilter> filters = new ArrayList<ServiceModelFilter.ServiceViewFilter>();
            ArrayList<Pair<ServiceViewModel, ServiceViewState>> loadedModels = new ArrayList<Pair<ServiceViewModel, ServiceViewState>>();
            ServiceViewModel toSelect2 = null;
            for (ServiceViewState viewState : viewStates) {
                ServiceModelFilter.ServiceViewFilter parentFilter = mainView.getModel().getFilter();
                if (viewState.parentView >= 0 && viewState.parentView < filters.size()) {
                    parentFilter = (ServiceModelFilter.ServiceViewFilter)filters.get(viewState.parentView);
                }
                ServiceModelFilter.ServiceViewFilter filter2 = parentFilter;
                ServiceViewModel viewModel = ServiceViewModel.loadModel(viewState, this.myModel, this.myModelFilter, parentFilter, contributorsMap);
                if (viewModel != null) {
                    loadedModels.add(Pair.create(viewModel, viewState));
                    if (viewState.isSelected) {
                        toSelect2 = viewModel;
                    }
                    filter2 = viewModel.getFilter();
                }
                filters.add(filter2);
            }
            if (!loadedModels.isEmpty()) {
                ServiceViewModel modelToSelect = toSelect2;
                ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith(this.myProject)).submit(() -> {
                    for (Pair pair : loadedModels) {
                        this.extract(contentManager, (ServiceViewModel)pair.first, (ServiceViewState)pair.second, false);
                    }
                    ServiceViewManagerImpl.selectContentByModel(contentManager, modelToSelect);
                });
            }
        });
    }

    @Override
    @NotNull
    public Promise<Void> select(@NotNull Object service2, @NotNull Class<?> contributorClass, boolean activate, boolean focus) {
        if (service2 == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(7);
        }
        if (contributorClass == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(8);
        }
        AsyncPromise result2 = new AsyncPromise();
        this.myModel.getInvoker().invoke(() -> AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> {
            ToolWindow toolWindow;
            String toolWindowId = this.getToolWindowId(contributorClass);
            if (toolWindowId == null) {
                result2.setError("Contributor group not found");
                return;
            }
            Runnable runnable = () -> this.promiseFindView(contributorClass, (AsyncPromise<Void>)result2, serviceView -> serviceView.select(service2, contributorClass), content2 -> ServiceViewManagerImpl.selectContent(content2, focus, this.myProject));
            ToolWindow toolWindow2 = toolWindow = activate ? ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(toolWindowId) : null;
            if (toolWindow != null) {
                toolWindow.activate(runnable, focus, focus);
            } else {
                runnable.run();
            }
        }));
        AsyncPromise asyncPromise = result2;
        if (asyncPromise == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(9);
        }
        return asyncPromise;
    }

    private void promiseFindView(Class<?> contributorClass, AsyncPromise<Void> result2, Function<? super ServiceView, ? extends Promise<?>> action2, Consumer<? super Content> onSuccess) {
        ServiceViewContentHolder holder = this.getContentHolder(contributorClass);
        if (holder == null) {
            result2.setError("Content manager not initialized");
            return;
        }
        SmartList<Content> contents = new SmartList<Content>(holder.contentManager.getContents());
        if (contents.isEmpty()) {
            result2.setError("Content not initialized");
            return;
        }
        Collections.reverse(contents);
        ServiceViewManagerImpl.promiseFindView(contents.iterator(), result2, action2, onSuccess);
    }

    private static void promiseFindView(Iterator<? extends Content> iterator, AsyncPromise<Void> result2, Function<? super ServiceView, ? extends Promise<?>> action2, Consumer<? super Content> onSuccess) {
        Content content2 = iterator.next();
        ServiceView serviceView = ServiceViewManagerImpl.getServiceView(content2);
        if (serviceView == null) {
            if (iterator.hasNext()) {
                ServiceViewManagerImpl.promiseFindView(iterator, result2, action2, onSuccess);
            } else {
                result2.setError("Not services content");
            }
            return;
        }
        action2.apply(serviceView).onSuccess(v -> {
            if (onSuccess != null) {
                onSuccess.accept(content2);
            }
            result2.setResult(null);
        }).onError(e -> {
            if (iterator.hasNext()) {
                ServiceViewManagerImpl.promiseFindView(iterator, result2, action2, onSuccess);
            } else {
                result2.setError(e);
            }
        });
    }

    private static void selectContent(Content content2, boolean focus, Project project2) {
        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith(project2)).submit(() -> {
            ContentManager contentManager = content2.getManager();
            if (contentManager == null) {
                return;
            }
            if (contentManager.getSelectedContent() != content2 && contentManager.getIndexOfContent(content2) >= 0) {
                contentManager.setSelectedContent(content2, focus);
            }
        });
    }

    @Override
    @NotNull
    public Promise<Void> expand(@NotNull Object service2, @NotNull Class<?> contributorClass) {
        if (service2 == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(10);
        }
        if (contributorClass == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(11);
        }
        AsyncPromise result2 = new AsyncPromise();
        this.myModel.getInvoker().invoke(() -> AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> this.promiseFindView(contributorClass, (AsyncPromise<Void>)result2, serviceView -> serviceView.expand(service2, contributorClass), null)));
        AsyncPromise asyncPromise = result2;
        if (asyncPromise == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(12);
        }
        return asyncPromise;
    }

    @Override
    @NotNull
    public Promise<Void> extract(@NotNull Object service2, @NotNull Class<?> contributorClass) {
        if (service2 == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(13);
        }
        if (contributorClass == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(14);
        }
        AsyncPromise result2 = new AsyncPromise();
        this.myModel.getInvoker().invoke(() -> AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> this.promiseFindView(contributorClass, (AsyncPromise<Void>)result2, serviceView -> serviceView.extract(service2, contributorClass), null)));
        AsyncPromise asyncPromise = result2;
        if (asyncPromise == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(15);
        }
        return asyncPromise;
    }

    @NotNull
    Promise<Void> select(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(16);
        }
        SmartList selectedItems = new SmartList();
        for (ServiceViewContentHolder contentHolder : this.myContentHolders) {
            ServiceView serviceView;
            Content content2 = contentHolder.contentManager.getSelectedContent();
            if (content2 == null || (serviceView = ServiceViewManagerImpl.getServiceView(content2)) == null) continue;
            List<ServiceModel.ServiceViewItem> items = serviceView.getSelectedItems();
            ContainerUtil.addIfNotNull(selectedItems, ContainerUtil.getOnlyItem(items));
        }
        AsyncPromise result2 = new AsyncPromise();
        this.myModel.getInvoker().invoke(() -> {
            Condition<ServiceModel.ServiceViewItem> fileCondition = item -> {
                ServiceViewDescriptor descriptor = item.getViewDescriptor();
                return descriptor instanceof ServiceViewLocatableDescriptor && virtualFile2.equals(((ServiceViewLocatableDescriptor)((Object)descriptor)).getVirtualFile());
            };
            if (ContainerUtil.find(selectedItems, fileCondition) != null) {
                result2.setResult(null);
                return;
            }
            ServiceModel.ServiceViewItem fileItem = this.myModel.findItem(fileCondition, item -> !(item instanceof ServiceModel.ServiceNode) || item.getViewDescriptor() instanceof ServiceViewLocatableDescriptor);
            if (fileItem != null) {
                Promise<Void> promise = this.select(fileItem.getValue(), fileItem.getRootContributor().getClass(), false, false);
                promise.processed((Promise<Void>)result2);
            }
        });
        AsyncPromise asyncPromise = result2;
        if (asyncPromise == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(17);
        }
        return asyncPromise;
    }

    void extract(@NotNull ServiceViewDragHelper.ServiceViewDragBean dragBean) {
        List<ServiceModel.ServiceViewItem> items;
        if (dragBean == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(18);
        }
        if ((items = dragBean.getItems()).isEmpty()) {
            return;
        }
        ServiceView serviceView = dragBean.getServiceView();
        ServiceViewContentHolder holder = this.getContentHolder(serviceView);
        if (holder == null) {
            return;
        }
        ServiceModelFilter.ServiceViewFilter parentFilter = serviceView.getModel().getFilter();
        ServiceViewModel viewModel = ServiceViewModel.createModel(items, dragBean.getContributor(), this.myModel, this.myModelFilter, parentFilter);
        ServiceViewState state = new ServiceViewState();
        serviceView.saveState(state);
        this.extract(holder.contentManager, viewModel, state, true);
    }

    private void extract(ContentManager contentManager, ServiceViewModel viewModel, ServiceViewState viewState, boolean select2) {
        ServiceView serviceView = ServiceView.createView(this.myProject, viewModel, this.prepareViewState(viewState));
        ItemPresentation presentation2 = ServiceViewManagerImpl.getContentPresentation(this.myProject, viewModel, viewState);
        if (presentation2 == null) {
            return;
        }
        Content content2 = ServiceViewManagerImpl.addServiceContent(contentManager, serviceView, presentation2, select2);
        if (viewModel instanceof ServiceViewModel.GroupModel) {
            ServiceViewManagerImpl.extractGroup((ServiceViewModel.GroupModel)viewModel, content2);
        } else if (viewModel instanceof ServiceViewModel.SingeServiceModel) {
            this.extractService((ServiceViewModel.SingeServiceModel)viewModel, content2);
        } else if (viewModel instanceof ServiceViewModel.ServiceListModel) {
            ServiceViewManagerImpl.extractList((ServiceViewModel.ServiceListModel)viewModel, content2);
        }
    }

    private static void extractGroup(ServiceViewModel.GroupModel viewModel, Content content2) {
        viewModel.addModelListener(() -> ServiceViewManagerImpl.updateContentTab(viewModel.getGroup(), content2));
        ServiceViewManagerImpl.updateContentTab(viewModel.getGroup(), content2);
    }

    private void extractService(ServiceViewModel.SingeServiceModel viewModel, Content content2) {
        ContentManager contentManager = content2.getManager();
        viewModel.addModelListener(() -> {
            ServiceModel.ServiceViewItem item = viewModel.getService();
            if (item != null && !viewModel.getChildren(item).isEmpty() && contentManager != null) {
                ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith(this.myProject)).submit(() -> {
                    ServiceModel.ServiceViewItem viewItem = viewModel.getService();
                    if (viewItem == null) {
                        return;
                    }
                    int index = contentManager.getIndexOfContent(content2);
                    if (index < 0) {
                        return;
                    }
                    contentManager.removeContent(content2, true);
                    ServiceViewModel.ServiceListModel listModel = new ServiceViewModel.ServiceListModel(this.myModel, this.myModelFilter, new SmartList<ServiceModel.ServiceViewItem>(viewItem), viewModel.getFilter().getParent());
                    ServiceView listView = ServiceView.createView(this.myProject, listModel, this.prepareViewState(new ServiceViewState()));
                    Content listContent = ServiceViewManagerImpl.addServiceContent(contentManager, listView, viewItem.getViewDescriptor().getContentPresentation(), true, index);
                    ServiceViewManagerImpl.extractList(listModel, listContent);
                });
            } else {
                ServiceViewManagerImpl.updateContentTab(item, content2);
            }
        });
        ServiceViewManagerImpl.updateContentTab(viewModel.getService(), content2);
    }

    private static void extractList(ServiceViewModel.ServiceListModel viewModel, Content content2) {
        viewModel.addModelListener(() -> ServiceViewManagerImpl.updateContentTab(ContainerUtil.getOnlyItem(viewModel.getRoots()), content2));
        ServiceViewManagerImpl.updateContentTab(ContainerUtil.getOnlyItem(viewModel.getRoots()), content2);
    }

    private static ItemPresentation getContentPresentation(Project project2, ServiceViewModel viewModel, ServiceViewState viewState) {
        if (viewModel instanceof ServiceViewModel.ContributorModel) {
            return ((ServiceViewModel.ContributorModel)viewModel).getContributor().getViewDescriptor(project2).getContentPresentation();
        }
        if (viewModel instanceof ServiceViewModel.GroupModel) {
            return ((ServiceViewModel.GroupModel)viewModel).getGroup().getViewDescriptor().getContentPresentation();
        }
        if (viewModel instanceof ServiceViewModel.SingeServiceModel) {
            return ((ServiceViewModel.SingeServiceModel)viewModel).getService().getViewDescriptor().getContentPresentation();
        }
        if (viewModel instanceof ServiceViewModel.ServiceListModel) {
            List<ServiceModel.ServiceViewItem> items = ((ServiceViewModel.ServiceListModel)viewModel).getItems();
            if (items.size() == 1) {
                return items.get(0).getViewDescriptor().getContentPresentation();
            }
            String name2 = viewState.id;
            if (StringUtil.isEmpty(name2) && StringUtil.isEmpty(name2 = Messages.showInputDialog((Project)project2, (String)ExecutionBundle.message((String)"service.view.group.label", (Object[])new Object[0]), (String)ExecutionBundle.message((String)"service.view.group.title", (Object[])new Object[0]), null, null, null))) {
                return null;
            }
            return new PresentationData(name2, null, AllIcons.Nodes.Folder, null);
        }
        return null;
    }

    private static Content addServiceContent(ContentManager contentManager, ServiceView serviceView, ItemPresentation presentation2, boolean select2) {
        return ServiceViewManagerImpl.addServiceContent(contentManager, serviceView, presentation2, select2, -1);
    }

    private static Content addServiceContent(ContentManager contentManager, ServiceView serviceView, ItemPresentation presentation2, boolean select2, int index) {
        Content content2 = ContentFactory.getInstance().createContent((JComponent)serviceView, ServiceViewDragHelper.getDisplayName(presentation2), false);
        content2.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        content2.setHelpId(ServiceViewManagerImpl.getToolWindowContextHelpId());
        content2.setCloseable(true);
        content2.setIcon(presentation2.getIcon(false));
        Disposer.register((Disposable)content2, serviceView);
        Disposer.register((Disposable)content2, serviceView.getModel());
        contentManager.addContent(content2, index);
        if (select2) {
            contentManager.setSelectedContent(content2);
        }
        return content2;
    }

    private static void updateContentTab(ServiceModel.ServiceViewItem item, Content content2) {
        if (item != null) {
            WeakReference<ServiceModel.ServiceViewItem> itemRef = new WeakReference<ServiceModel.ServiceViewItem>(item);
            ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)content2)).submit(() -> {
                ServiceModel.ServiceViewItem viewItem = (ServiceModel.ServiceViewItem)itemRef.get();
                if (viewItem == null) {
                    return;
                }
                ItemPresentation itemPresentation = viewItem.getViewDescriptor().getContentPresentation();
                content2.setDisplayName(ServiceViewDragHelper.getDisplayName(itemPresentation));
                content2.setIcon(itemPresentation.getIcon(false));
                content2.setTabColor(viewItem.getColor());
            });
        }
    }

    private void loadGroups(Collection<? extends ServiceViewContributor<?>> contributors) {
        if (Registry.is("ide.service.view.split")) {
            for (ServiceViewContributor<?> contributor : contributors) {
                this.myGroups.put(contributor.getViewDescriptor(this.myProject).getId(), new SmartList(contributor));
            }
        } else if (!contributors.isEmpty()) {
            String servicesToolWindowId = "Services";
            Collection servicesContributors = this.myGroups.computeIfAbsent(servicesToolWindowId, __ -> ContainerUtil.newConcurrentSet());
            servicesContributors.addAll(contributors);
        }
    }

    @NotNull
    private Pair<ServiceViewState, List<ServiceViewState>> getServiceViewStates(@NotNull String groupId) {
        List<ServiceViewState> states;
        ServiceViewState mainState;
        if (groupId == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(19);
        }
        if ((mainState = (ServiceViewState)((Object)ContainerUtil.find(states = ContainerUtil.filter(this.myState.viewStates, state -> groupId.equals(state.groupId)), state -> StringUtil.isEmpty(state.viewType)))) == null) {
            mainState = new ServiceViewState();
        } else {
            states.remove(mainState);
        }
        Pair<ServiceViewState, List<ServiceViewState>> pair = Pair.create(mainState, states);
        if (pair == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(20);
        }
        return pair;
    }

    @Override
    @NotNull
    public State getState() {
        ContainerUtil.retainAll(this.myState.viewStates, state -> this.myGroups.containsKey(state.groupId));
        for (ServiceViewContentHolder holder : this.myContentHolders) {
            ContainerUtil.retainAll(this.myState.viewStates, state -> !holder.toolWindowId.equals(state.groupId));
            ServiceModelFilter.ServiceViewFilter mainFilter = holder.mainView.getModel().getFilter();
            ServiceViewState mainState = new ServiceViewState();
            this.myState.viewStates.add(mainState);
            holder.mainView.saveState(mainState);
            mainState.groupId = holder.toolWindowId;
            mainState.treeStateElement = new Element("root");
            mainState.treeState.writeExternal(mainState.treeStateElement);
            mainState.clearTreeState();
            SmartList<ServiceView> processedViews = new SmartList<ServiceView>();
            for (Content content2 : holder.contentManager.getContents()) {
                ServiceModelFilter.ServiceViewFilter parentFilter;
                ServiceView serviceView = ServiceViewManagerImpl.getServiceView(content2);
                if (serviceView == null || ServiceViewManagerImpl.isMainView(serviceView)) continue;
                ServiceViewState viewState = new ServiceViewState();
                processedViews.add(serviceView);
                this.myState.viewStates.add(viewState);
                serviceView.saveState(viewState);
                viewState.groupId = holder.toolWindowId;
                viewState.isSelected = holder.contentManager.isSelected(content2);
                ServiceViewModel viewModel = serviceView.getModel();
                if (viewModel instanceof ServiceViewModel.ServiceListModel) {
                    viewState.id = content2.getDisplayName();
                }
                if ((parentFilter = viewModel.getFilter().getParent()) != null && !parentFilter.equals(mainFilter)) {
                    for (int i = 0; i < processedViews.size(); ++i) {
                        ServiceView parentView = (ServiceView)processedViews.get(i);
                        if (!parentView.getModel().getFilter().equals(parentFilter)) continue;
                        viewState.parentView = i;
                        break;
                    }
                }
                viewState.treeStateElement = new Element("root");
                viewState.treeState.writeExternal(viewState.treeStateElement);
                viewState.clearTreeState();
            }
        }
        State state2 = this.myState;
        if (state2 == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(21);
        }
        return state2;
    }

    @Override
    public void loadState(@NotNull State state) {
        if (state == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(22);
        }
        this.myState = state;
        for (ServiceViewState viewState : this.myState.viewStates) {
            viewState.treeState = TreeState.createFrom((Element)viewState.treeStateElement);
        }
    }

    static String getToolWindowContextHelpId() {
        return HELP_ID;
    }

    private ServiceViewState prepareViewState(ServiceViewState state) {
        state.showServicesTree = this.myState.showServicesTree;
        return state;
    }

    boolean isShowServicesTree() {
        return this.myState.showServicesTree;
    }

    void setShowServicesTree(boolean value) {
        this.myState.showServicesTree = value;
        for (ServiceViewContentHolder holder : this.myContentHolders) {
            for (ServiceView serviceView : holder.getServiceViews()) {
                serviceView.getUi().setMasterComponentVisible(value);
            }
        }
    }

    boolean isSplitByTypeEnabled(@NotNull ServiceView selectedView) {
        if (selectedView == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(23);
        }
        if (!ServiceViewManagerImpl.isMainView(selectedView) || selectedView.getModel().getVisibleRoots().isEmpty()) {
            return false;
        }
        ServiceViewContentHolder holder = this.getContentHolder(selectedView);
        if (holder == null) {
            return false;
        }
        for (Content content2 : holder.contentManager.getContents()) {
            ServiceView serviceView = ServiceViewManagerImpl.getServiceView(content2);
            if (serviceView == null || serviceView == selectedView || serviceView.getModel() instanceof ServiceViewModel.ContributorModel) continue;
            return false;
        }
        return true;
    }

    void splitByType(@NotNull ServiceView selectedView) {
        ServiceViewContentHolder holder;
        if (selectedView == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(24);
        }
        if ((holder = this.getContentHolder(selectedView)) == null) {
            return;
        }
        this.myModel.getInvoker().invokeLater(() -> {
            List<ServiceViewContributor> contributors = ContainerUtil.map(this.myModel.getRoots(), ServiceModel.ServiceViewItem::getRootContributor);
            AppUIUtil.invokeOnEdt(() -> {
                for (ServiceViewContributor contributor : contributors) {
                    this.splitByType(holder.contentManager, contributor);
                }
            });
        });
    }

    private ServiceViewContentHolder getContentHolder(ServiceView serviceView) {
        for (ServiceViewContentHolder holder : this.myContentHolders) {
            if (!holder.getServiceViews().contains(serviceView)) continue;
            return holder;
        }
        return null;
    }

    private void splitByType(ContentManager contentManager, ServiceViewContributor<?> contributor) {
        for (Content content2 : contentManager.getContents()) {
            ServiceViewModel viewModel;
            ServiceView serviceView = ServiceViewManagerImpl.getServiceView(content2);
            if (serviceView == null || !((viewModel = serviceView.getModel()) instanceof ServiceViewModel.ContributorModel) || !contributor.equals(((ServiceViewModel.ContributorModel)viewModel).getContributor())) continue;
            return;
        }
        ServiceViewModel.ContributorModel contributorModel = new ServiceViewModel.ContributorModel(this.myModel, this.myModelFilter, contributor, null);
        this.extract(contentManager, contributorModel, this.prepareViewState(new ServiceViewState()), true);
    }

    @NotNull
    public List<Object> getChildrenSafe(@NotNull AnActionEvent e, @NotNull List<Object> valueSubPath, @NotNull Class<?> contributorClass) {
        ServiceView serviceView;
        if (e == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(25);
        }
        if (valueSubPath == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(26);
        }
        if (contributorClass == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(27);
        }
        List<Object> list2 = (serviceView = ServiceViewActionProvider.getSelectedView(e)) != null ? serviceView.getChildrenSafe(valueSubPath, contributorClass) : Collections.emptyList();
        if (list2 == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(28);
        }
        return list2;
    }

    @Nullable
    public String getToolWindowId(@NotNull Class<?> contributorClass) {
        if (contributorClass == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(29);
        }
        for (Map.Entry<String, Collection<ServiceViewContributor<?>>> entry : this.myGroups.entrySet()) {
            if (!entry.getValue().stream().anyMatch(contributorClass::isInstance)) continue;
            return entry.getKey();
        }
        return null;
    }

    private static boolean isMainView(@NotNull ServiceView serviceView) {
        if (serviceView == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(30);
        }
        return serviceView.getModel() instanceof ServiceViewModel.AllServicesModel;
    }

    @Nullable
    private static Content getMainContent(@NotNull ContentManager contentManager) {
        if (contentManager == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(31);
        }
        for (Content content2 : contentManager.getContents()) {
            ServiceView serviceView = ServiceViewManagerImpl.getServiceView(content2);
            if (serviceView == null || !ServiceViewManagerImpl.isMainView(serviceView)) continue;
            return content2;
        }
        return null;
    }

    @Nullable
    private static ServiceView getServiceView(Content content2) {
        JComponent component2 = content2.getComponent();
        return component2 instanceof ServiceView ? (ServiceView)component2 : null;
    }

    private static void selectContentByModel(@NotNull ContentManager contentManager, @Nullable ServiceViewModel modelToSelect) {
        if (contentManager == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(32);
        }
        if (modelToSelect != null) {
            for (Content content2 : contentManager.getContents()) {
                ServiceView serviceView = ServiceViewManagerImpl.getServiceView(content2);
                if (serviceView == null || serviceView.getModel() != modelToSelect) continue;
                contentManager.setSelectedContent(content2);
                break;
            }
        } else {
            Content content3 = ServiceViewManagerImpl.getMainContent(contentManager);
            if (content3 != null) {
                contentManager.setSelectedContent(content3);
            }
        }
    }

    private static void selectContentByContributor(@NotNull ContentManager contentManager, @NotNull ServiceViewContributor<?> contributor) {
        if (contentManager == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(33);
        }
        if (contributor == null) {
            ServiceViewManagerImpl.$$$reportNull$$$0(34);
        }
        Content mainContent = null;
        for (Content content2 : contentManager.getContents()) {
            ServiceView serviceView = ServiceViewManagerImpl.getServiceView(content2);
            if (serviceView == null) continue;
            if (serviceView.getModel() instanceof ServiceViewModel.ContributorModel && contributor.equals(((ServiceViewModel.ContributorModel)serviceView.getModel()).getContributor())) {
                contentManager.setSelectedContent(content2, true);
                return;
            }
            if (!ServiceViewManagerImpl.isMainView(serviceView)) continue;
            mainContent = content2;
        }
        if (mainContent != null) {
            contentManager.setSelectedContent(mainContent, true);
        }
    }

    private static void registerActivateByContributorActions(Project project2, Collection<? extends ServiceViewContributor<?>> contributors) {
        for (ServiceViewContributor<?> contributor : contributors) {
            Object action2;
            ActionManager actionManager = ActionManager.getInstance();
            String actionId = ServiceViewManagerImpl.getActivateContributorActionId(contributor);
            if (actionId == null || (action2 = actionManager.getAction(actionId)) != null) continue;
            action2 = new ActivateToolWindowByContributorAction(contributor, contributor.getViewDescriptor(project2).getPresentation());
            actionManager.registerAction(actionId, action2);
        }
    }

    private static String getActivateContributorActionId(ServiceViewContributor<?> contributor) {
        String name2 = contributor.getClass().getSimpleName();
        return name2.isEmpty() ? null : "ServiceView.Activate" + name2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 28: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 14: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributorClass";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/services/ServiceViewManagerImpl";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragBean";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedView";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueSubPath";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceView";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentManager";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/services/ServiceViewManagerImpl";
                break;
            }
            case 9: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "select";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "expand";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "extract";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceViewStates";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenSafe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "eventHandled";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getContentHolder";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerToolWindow";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "restoreBrokenToolWindowIfNeeded";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateToolWindow";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindowContent";
                break;
            }
            case 7: 
            case 8: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 28: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 13: 
            case 14: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getServiceViewStates";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isSplitByTypeEnabled";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "splitByType";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenSafe";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindowId";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isMainView";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getMainContent";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "selectContentByModel";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "selectContentByContributor";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 28: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ServiceViewContentHolder {
        final ServiceView mainView;
        final ContentManager contentManager;
        final Collection<ServiceViewContributor<?>> rootContributors;
        final String toolWindowId;

        ServiceViewContentHolder(ServiceView mainView, ContentManager contentManager, Collection<ServiceViewContributor<?>> rootContributors, String toolWindowId) {
            this.mainView = mainView;
            this.contentManager = contentManager;
            this.rootContributors = rootContributors;
            this.toolWindowId = toolWindowId;
        }

        List<ServiceView> getServiceViews() {
            List<ServiceView> views = ContainerUtil.mapNotNull(this.contentManager.getContents(), x$0 -> ServiceViewManagerImpl.getServiceView(x$0));
            if (views.isEmpty()) {
                return new SmartList<ServiceView>(this.mainView);
            }
            if (!views.contains(this.mainView)) {
                views.add(0, this.mainView);
            }
            return views;
        }

        private void processAllModels(Consumer<? super ServiceViewModel> consumer) {
            List<ServiceViewModel> models = ContainerUtil.map(this.getServiceViews(), ServiceView::getModel);
            ServiceViewModel model2 = ContainerUtil.getFirstItem(models);
            if (model2 != null) {
                model2.getInvoker().invokeLater(() -> {
                    for (ServiceViewModel viewModel : models) {
                        consumer.accept(viewModel);
                    }
                });
            }
        }
    }

    private static class ActivateToolWindowByContributorAction
    extends DumbAwareAction {
        private final ServiceViewContributor<?> myContributor;

        ActivateToolWindowByContributorAction(ServiceViewContributor<?> contributor, ItemPresentation contributorPresentation) {
            this.myContributor = contributor;
            Presentation templatePresentation = this.getTemplatePresentation();
            templatePresentation.setText(ExecutionBundle.messagePointer((String)"service.view.activate.tool.window.action.name", (Object[])new Object[]{ServiceViewDragHelper.getDisplayName(contributorPresentation)}));
            templatePresentation.setIcon(contributorPresentation.getIcon(false));
            templatePresentation.setDescription(ExecutionBundle.messagePointer((String)"service.view.activate.tool.window.action.description", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project2;
            if (e == null) {
                ActivateToolWindowByContributorAction.$$$reportNull$$$0(0);
            }
            if ((project2 = e.getProject()) == null) {
                return;
            }
            String toolWindowId = ((ServiceViewManagerImpl)ServiceViewManager.getInstance(project2)).getToolWindowId(this.myContributor.getClass());
            if (toolWindowId == null) {
                return;
            }
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow(toolWindowId);
            if (toolWindow != null) {
                toolWindow.activate(() -> {
                    ServiceViewContentHolder holder = ((ServiceViewManagerImpl)ServiceViewManager.getInstance(project2)).getContentHolder(this.myContributor.getClass());
                    if (holder != null) {
                        ServiceViewManagerImpl.selectContentByContributor(holder.contentManager, this.myContributor);
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/services/ServiceViewManagerImpl$ActivateToolWindowByContributorAction", "actionPerformed"));
        }
    }

    private final class ServiceViewExtensionPointListener
    implements ExtensionPointListener<ServiceViewContributor<?>> {
        private ServiceViewExtensionPointListener() {
        }

        @Override
        public void extensionAdded(@NotNull ServiceViewContributor<?> extension2, @NotNull PluginDescriptor pluginDescriptor) {
            if (extension2 == null) {
                ServiceViewExtensionPointListener.$$$reportNull$$$0(0);
            }
            if (pluginDescriptor == null) {
                ServiceViewExtensionPointListener.$$$reportNull$$$0(1);
            }
            SmartList contributors = new SmartList(extension2);
            ServiceViewManagerImpl.this.loadGroups(contributors);
            String toolWindowId = ServiceViewManagerImpl.this.getToolWindowId(extension2.getClass());
            boolean register2 = ServiceViewManagerImpl.this.myGroups.get(toolWindowId).size() == 1;
            ServiceEventListener.ServiceEvent e = ServiceEventListener.ServiceEvent.createResetEvent(extension2.getClass());
            ServiceViewManagerImpl.this.myModel.handle(e).onSuccess(o -> {
                if (register2) {
                    ServiceModel.ServiceViewItem eventRoot = (ServiceModel.ServiceViewItem)((Object)ContainerUtil.find(ServiceViewManagerImpl.this.myModel.getRoots(), root -> extension2.getClass().isInstance(root.getRootContributor())));
                    assert (toolWindowId != null);
                    ServiceViewManagerImpl.this.registerToolWindow(toolWindowId, eventRoot != null);
                } else {
                    ServiceViewManagerImpl.this.eventHandled(e);
                }
                if ("Services".equals(toolWindowId)) {
                    ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith(ServiceViewManagerImpl.this.myProject)).submit(() -> ServiceViewManagerImpl.registerActivateByContributorActions(ServiceViewManagerImpl.this.myProject, contributors));
                }
            });
        }

        @Override
        public void extensionRemoved(@NotNull ServiceViewContributor<?> extension2, @NotNull PluginDescriptor pluginDescriptor) {
            if (extension2 == null) {
                ServiceViewExtensionPointListener.$$$reportNull$$$0(2);
            }
            if (pluginDescriptor == null) {
                ServiceViewExtensionPointListener.$$$reportNull$$$0(3);
            }
            ServiceEventListener.ServiceEvent e = ServiceEventListener.ServiceEvent.createSyncResetEvent(extension2.getClass());
            ServiceViewManagerImpl.this.myModel.handle(e).onProcessed(o -> {
                ServiceViewManagerImpl.this.eventHandled(e);
                for (Map.Entry<String, Collection<ServiceViewContributor<?>>> entry : ServiceViewManagerImpl.this.myGroups.entrySet()) {
                    if (!entry.getValue().remove(extension2)) continue;
                    if (!entry.getValue().isEmpty()) break;
                    this.unregisterToolWindow(entry.getKey());
                    break;
                }
                this.unregisterActivateByContributorActions(extension2);
            });
        }

        private void unregisterToolWindow(String toolWindowId) {
            ServiceViewManagerImpl.this.myActiveToolWindowIds.remove(toolWindowId);
            ServiceViewManagerImpl.this.myGroups.remove(toolWindowId);
            for (ServiceViewContentHolder holder : ServiceViewManagerImpl.this.myContentHolders) {
                if (!holder.toolWindowId.equals(toolWindowId)) continue;
                ServiceViewManagerImpl.this.myContentHolders.remove(holder);
                break;
            }
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)ServiceViewManagerImpl.this.myProject);
            toolWindowManager.invokeLater(() -> {
                if (ServiceViewManagerImpl.this.myProject.isDisposed() || ServiceViewManagerImpl.this.myProject.isDefault()) {
                    return;
                }
                ToolWindow toolWindow = toolWindowManager.getToolWindow(toolWindowId);
                if (toolWindow != null) {
                    toolWindow.remove();
                }
            });
        }

        private void unregisterActivateByContributorActions(ServiceViewContributor<?> extension2) {
            ActionManager actionManager;
            AnAction action2;
            String actionId = ServiceViewManagerImpl.getActivateContributorActionId(extension2);
            if (actionId != null && (action2 = (actionManager = ActionManager.getInstance()).getAction(actionId)) != null) {
                actionManager.unregisterAction(actionId);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/services/ServiceViewManagerImpl$ServiceViewExtensionPointListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extensionAdded";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extensionRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ServiceViewContentMangerListener
    implements ContentManagerListener {
        private final ServiceModelFilter myModelFilter;
        private final AutoScrollToSourceHandler myAutoScrollToSourceHandler;
        private final ServiceViewContentHolder myContentHolder;
        private final ContentManager myContentManager;

        ServiceViewContentMangerListener(@NotNull ServiceModelFilter modelFilter, @NotNull AutoScrollToSourceHandler toSourceHandler, @NotNull ServiceViewContentHolder contentHolder) {
            if (modelFilter == null) {
                ServiceViewContentMangerListener.$$$reportNull$$$0(0);
            }
            if (toSourceHandler == null) {
                ServiceViewContentMangerListener.$$$reportNull$$$0(1);
            }
            if (contentHolder == null) {
                ServiceViewContentMangerListener.$$$reportNull$$$0(2);
            }
            this.myModelFilter = modelFilter;
            this.myAutoScrollToSourceHandler = toSourceHandler;
            this.myContentHolder = contentHolder;
            this.myContentManager = contentHolder.contentManager;
        }

        public void contentAdded(@NotNull ContentManagerEvent event) {
            Content mainContent;
            Content content2;
            ServiceView serviceView;
            if (event == null) {
                ServiceViewContentMangerListener.$$$reportNull$$$0(3);
            }
            if ((serviceView = ServiceViewManagerImpl.getServiceView(content2 = event.getContent())) != null && !ServiceViewManagerImpl.isMainView(serviceView)) {
                serviceView.setAutoScrollToSourceHandler(this.myAutoScrollToSourceHandler);
                this.myModelFilter.addFilter(serviceView.getModel().getFilter());
                this.myContentHolder.processAllModels(ServiceViewModel::filtersChanged);
                serviceView.getModel().addModelListener(() -> {
                    if (serviceView.getModel().getRoots().isEmpty()) {
                        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this.myContentManager)).submit(() -> this.myContentManager.removeContent(content2, true));
                    }
                });
            }
            if (this.myContentManager.getContentCount() > 1 && (mainContent = ServiceViewManagerImpl.getMainContent(this.myContentManager)) != null) {
                mainContent.setDisplayName(ExecutionBundle.message((String)"service.view.all.services", (Object[])new Object[0]));
            }
        }

        public void contentRemoved(@NotNull ContentManagerEvent event) {
            Content mainContent;
            ServiceView serviceView;
            if (event == null) {
                ServiceViewContentMangerListener.$$$reportNull$$$0(4);
            }
            if ((serviceView = ServiceViewManagerImpl.getServiceView(event.getContent())) != null && !ServiceViewManagerImpl.isMainView(serviceView)) {
                this.myModelFilter.removeFilter(serviceView.getModel().getFilter());
                this.myContentHolder.processAllModels(ServiceViewModel::filtersChanged);
            }
            if (this.myContentManager.getContentCount() == 1 && (mainContent = ServiceViewManagerImpl.getMainContent(this.myContentManager)) != null) {
                mainContent.setDisplayName(null);
            }
        }

        public void selectionChanged(@NotNull ContentManagerEvent event) {
            ServiceView serviceView;
            if (event == null) {
                ServiceViewContentMangerListener.$$$reportNull$$$0(5);
            }
            if ((serviceView = ServiceViewManagerImpl.getServiceView(event.getContent())) == null) {
                return;
            }
            if (event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                serviceView.onViewSelected();
            } else {
                serviceView.onViewUnselected();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelFilter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toSourceHandler";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentHolder";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/services/ServiceViewManagerImpl$ServiceViewContentMangerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentAdded";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentRemoved";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class State {
        public List<ServiceViewState> viewStates = new ArrayList<ServiceViewState>();
        public boolean showServicesTree = true;

        State() {
        }
    }
}

