/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceModel;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ServiceModelFilter {
    private final List<ServiceViewFilter> myFilters = new CopyOnWriteArrayList<ServiceViewFilter>();

    ServiceModelFilter() {
    }

    void addFilter(@NotNull ServiceViewFilter filter2) {
        if (filter2 == null) {
            ServiceModelFilter.$$$reportNull$$$0(0);
        }
        this.myFilters.add(filter2);
    }

    void removeFilter(@NotNull ServiceViewFilter filter2) {
        if (filter2 == null) {
            ServiceModelFilter.$$$reportNull$$$0(1);
        }
        ServiceViewFilter parent = filter2.getParent();
        this.myFilters.remove(filter2);
        for (ServiceViewFilter viewFilter : this.myFilters) {
            if (viewFilter.getParent() != filter2) continue;
            viewFilter.setParent(parent);
        }
    }

    @NotNull
    List<? extends ServiceModel.ServiceViewItem> filter(@NotNull List<? extends ServiceModel.ServiceViewItem> items, @NotNull ServiceViewFilter targetFilter) {
        if (items == null) {
            ServiceModelFilter.$$$reportNull$$$0(2);
        }
        if (targetFilter == null) {
            ServiceModelFilter.$$$reportNull$$$0(3);
        }
        if (items.isEmpty()) {
            List<? extends ServiceModel.ServiceViewItem> list2 = items;
            if (list2 == null) {
                ServiceModelFilter.$$$reportNull$$$0(4);
            }
            return list2;
        }
        List<ServiceViewFilter> filters = this.excludeTargetAndParents(targetFilter);
        List<ServiceModel.ServiceViewItem> list3 = ContainerUtil.filter(items, item -> !ContainerUtil.exists(filters, filter2 -> filter2.value(item)));
        if (list3 == null) {
            ServiceModelFilter.$$$reportNull$$$0(5);
        }
        return list3;
    }

    private List<ServiceViewFilter> excludeTargetAndParents(@NotNull ServiceViewFilter targetFilter) {
        if (targetFilter == null) {
            ServiceModelFilter.$$$reportNull$$$0(6);
        }
        ArrayList<ServiceViewFilter> filters = new ArrayList<ServiceViewFilter>(this.myFilters);
        do {
            filters.remove(targetFilter);
        } while ((targetFilter = targetFilter.getParent()) != null);
        return filters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFilter";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/services/ServiceModelFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/services/ServiceModelFilter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addFilter";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeFilter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "excludeTargetAndParents";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static abstract class ServiceViewFilter
    implements Condition<ServiceModel.ServiceViewItem> {
        private ServiceViewFilter myParent;

        protected ServiceViewFilter(@Nullable ServiceViewFilter parent) {
            this.myParent = parent;
        }

        @Nullable
        ServiceViewFilter getParent() {
            return this.myParent;
        }

        private void setParent(@Nullable ServiceViewFilter parent) {
            this.myParent = parent;
        }
    }
}

