/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi.ssl;

import com.intellij.execution.rmi.ssl.DelegateSslSocketFactory;
import com.intellij.execution.rmi.ssl.SslUtil;
import com.intellij.security.CompositeX509TrustManager;
import com.intellij.util.ArrayUtilRt;
import java.io.IOException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SslSocketFactory
extends DelegateSslSocketFactory {
    public SslSocketFactory() throws GeneralSecurityException {
        super(SslSocketFactory.createDelegate());
    }

    @NotNull
    private static SSLSocketFactory createDelegate() throws NoSuchAlgorithmException, KeyManagementException {
        KeyManager[] kms;
        TrustManager[] tms;
        SSLContext ctx = SSLContext.getInstance("TLS");
        try {
            KeyManager[] keyManagerArray;
            TrustManager[] trustManagerArray;
            String caCertPath = System.getProperty("sslCaCertPath");
            String clientCertPath = System.getProperty("sslClientCertPath");
            String clientKeyPath = System.getProperty("sslClientKeyPath");
            boolean trustEverybody = Boolean.parseBoolean(System.getProperty("sslTrustEverybody"));
            if (trustEverybody) {
                TrustManager[] trustManagerArray2 = new TrustManager[1];
                trustManagerArray = trustManagerArray2;
                trustManagerArray2[0] = new SslUtil.TrustEverybodyManager();
            } else {
                trustManagerArray = tms = caCertPath == null ? new TrustManager[]{} : SslSocketFactory.createTrustManagers(caCertPath);
            }
            if (clientCertPath != null && clientKeyPath != null) {
                KeyManager[] keyManagerArray2 = new KeyManager[1];
                keyManagerArray = keyManagerArray2;
                keyManagerArray2[0] = new MyKeyManager(clientCertPath, clientKeyPath);
            } else {
                keyManagerArray = new KeyManager[]{};
            }
            kms = keyManagerArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ctx.init(kms, tms, null);
        SSLSocketFactory sSLSocketFactory = ctx.getSocketFactory();
        if (sSLSocketFactory == null) {
            SslSocketFactory.$$$reportNull$$$0(0);
        }
        return sSLSocketFactory;
    }

    @NotNull
    public static TrustManager[] createTrustManagers(@NotNull String caCertPath) throws Exception {
        if (caCertPath == null) {
            SslSocketFactory.$$$reportNull$$$0(1);
        }
        List<X509Certificate> certs = SslUtil.loadCertificates(caCertPath);
        ArrayList<MyTrustManager> result2 = new ArrayList<MyTrustManager>(certs.size());
        for (X509Certificate cert : certs) {
            result2.add(new MyTrustManager(cert));
        }
        TrustManager[] trustManagerArray = new TrustManager[]{new CompositeX509TrustManager(new TrustManager[][]{result2.toArray(new TrustManager[0])})};
        if (trustManagerArray == null) {
            SslSocketFactory.$$$reportNull$$$0(2);
        }
        return trustManagerArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/rmi/ssl/SslSocketFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caCertPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createDelegate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/rmi/ssl/SslSocketFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTrustManagers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createTrustManagers";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyKeyManager
    extends X509ExtendedKeyManager {
        private final String myAlias;
        @NotNull
        private final X509Certificate[] myCertificates;
        @NotNull
        private final PrivateKey myPrivateKey;

        private MyKeyManager(@NotNull String certPath, @NotNull String keyPath) throws Exception {
            if (certPath == null) {
                MyKeyManager.$$$reportNull$$$0(0);
            }
            if (keyPath == null) {
                MyKeyManager.$$$reportNull$$$0(1);
            }
            this.myAlias = UUID.randomUUID().toString();
            this.myCertificates = new X509Certificate[]{SslUtil.readCertificate(certPath)};
            this.myPrivateKey = SslUtil.readPrivateKey(keyPath);
        }

        @Override
        @NotNull
        public String[] getClientAliases(String s, Principal[] principals) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                MyKeyManager.$$$reportNull$$$0(2);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }

        @Override
        public String chooseClientAlias(String[] strings2, Principal[] principals, Socket socket) {
            return this.myAlias;
        }

        @Override
        @NotNull
        public String[] getServerAliases(String s, Principal[] principals) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                MyKeyManager.$$$reportNull$$$0(3);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }

        @Override
        @Nullable
        public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
            return null;
        }

        @Override
        @NotNull
        public X509Certificate[] getCertificateChain(String s) {
            if (this.myCertificates == null) {
                MyKeyManager.$$$reportNull$$$0(4);
            }
            return this.myCertificates;
        }

        @Override
        @NotNull
        public PrivateKey getPrivateKey(String s) {
            PrivateKey privateKey = this.myPrivateKey;
            if (privateKey == null) {
                MyKeyManager.$$$reportNull$$$0(5);
            }
            return privateKey;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "certPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyPath";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/rmi/ssl/SslSocketFactory$MyKeyManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/rmi/ssl/SslSocketFactory$MyKeyManager";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClientAliases";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getServerAliases";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCertificateChain";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrivateKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class MyTrustManager
    implements X509TrustManager {
        private X509TrustManager trustManager;

        private MyTrustManager(@NotNull X509Certificate caCertPath) throws Exception {
            if (caCertPath == null) {
                MyTrustManager.$$$reportNull$$$0(0);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(MyTrustManager.createStore(caCertPath));
            for (TrustManager tm : tmf.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                this.trustManager = (X509TrustManager)tm;
                break;
            }
            if (this.trustManager == null) {
                throw new RuntimeException("No X509TrustManager found");
            }
        }

        @NotNull
        private static KeyStore createStore(@NotNull X509Certificate certificate) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
            if (certificate == null) {
                MyTrustManager.$$$reportNull$$$0(1);
            }
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null);
            ks.setCertificateEntry(UUID.randomUUID().toString(), certificate);
            KeyStore keyStore = ks;
            if (keyStore == null) {
                MyTrustManager.$$$reportNull$$$0(2);
            }
            return keyStore;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            if (this.trustManager == null) {
                throw new RuntimeException("No X509TrustManager found");
            }
            this.trustManager.checkServerTrusted(x509Certificates, s);
        }

        @Override
        @NotNull
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caCertPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "certificate";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/rmi/ssl/SslSocketFactory$MyTrustManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/rmi/ssl/SslSocketFactory$MyTrustManager";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createStore";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createStore";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

