/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.actions;

import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardManagerImpl;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationStatus;
import com.intellij.execution.dashboard.RunDashboardServiceViewContributor;
import com.intellij.execution.dashboard.tree.RunDashboardStatusFilter;
import com.intellij.execution.services.ServiceViewActionUtils;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RunDashboardFilterActionGroup
extends DefaultActionGroup
implements CheckedActionGroup,
DumbAware {
    RunDashboardFilterActionGroup() {
        this(null, false);
    }

    RunDashboardFilterActionGroup(@Nullable @NlsActions.ActionText String shortName, boolean popup2) {
        super(shortName, popup2);
        RunDashboardRunConfigurationStatus[] statuses;
        for (RunDashboardRunConfigurationStatus status : statuses = new RunDashboardRunConfigurationStatus[]{RunDashboardRunConfigurationStatus.STARTED, RunDashboardRunConfigurationStatus.FAILED, RunDashboardRunConfigurationStatus.STOPPED, RunDashboardRunConfigurationStatus.CONFIGURED}) {
            this.add((AnAction)new RunDashboardStatusFilterToggleAction(status));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RunDashboardFilterActionGroup.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunDashboardFilterActionGroup.$$$reportNull$$$0(1);
        }
        Set contributors = (Set)e.getData(ServiceViewActionUtils.CONTRIBUTORS_KEY);
        boolean isEnabled = false;
        if (contributors != null) {
            for (ServiceViewContributor contributor : contributors) {
                if (!(contributor instanceof RunDashboardServiceViewContributor)) continue;
                isEnabled = true;
                break;
            }
        }
        e.getPresentation().setEnabledAndVisible(isEnabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/dashboard/actions/RunDashboardFilterActionGroup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/dashboard/actions/RunDashboardFilterActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RunDashboardStatusFilterToggleAction
    extends ToggleAction
    implements DumbAware {
        private final RunDashboardRunConfigurationStatus myStatus;

        RunDashboardStatusFilterToggleAction(RunDashboardRunConfigurationStatus status) {
            super(status.getName());
            this.myStatus = status;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Project project2;
            if (e == null) {
                RunDashboardStatusFilterToggleAction.$$$reportNull$$$0(0);
            }
            if ((project2 = e.getProject()) == null) {
                return false;
            }
            RunDashboardStatusFilter statusFilter = ((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)project2)).getStatusFilter();
            return statusFilter.isVisible(this.myStatus);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Project project2;
            if (e == null) {
                RunDashboardStatusFilterToggleAction.$$$reportNull$$$0(1);
            }
            if ((project2 = e.getProject()) == null) {
                return;
            }
            RunDashboardManagerImpl manager = (RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)project2);
            RunDashboardStatusFilter statusFilter = manager.getStatusFilter();
            if (state) {
                statusFilter.show(this.myStatus);
            } else {
                statusFilter.hide(this.myStatus);
            }
            manager.updateDashboard(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/execution/dashboard/actions/RunDashboardFilterActionGroup$RunDashboardStatusFilterToggleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

