/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.openapi.util.Conditions;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

final class PanelContentUI
implements ContentUI {
    private JPanel myPanel;
    private ContentManager myContentManager;

    PanelContentUI() {
    }

    public JComponent getComponent() {
        this.initUI();
        return this.myPanel;
    }

    public void setManager(@NotNull ContentManager manager) {
        if (manager == null) {
            PanelContentUI.$$$reportNull$$$0(0);
        }
        assert (this.myContentManager == null);
        this.myContentManager = manager;
        manager.addContentManagerListener(new ContentManagerListener(){

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                PanelContentUI.this.initUI();
                if (ContentManagerEvent.ContentOperation.add == event.getOperation()) {
                    PanelContentUI.this.showContent(event.getContent());
                } else if (ContentManagerEvent.ContentOperation.remove == event.getOperation()) {
                    PanelContentUI.this.hideContent();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/dashboard/PanelContentUI$1", "selectionChanged"));
            }
        });
    }

    private void initUI() {
        if (this.myPanel != null) {
            return;
        }
        this.myPanel = new JPanel(new BorderLayout());
        ComponentUtil.putClientProperty(this.myPanel, UIUtil.NOT_IN_HIERARCHY_COMPONENTS, () -> {
            if (this.myContentManager == null || this.myContentManager.getContentCount() == 0) {
                return Collections.emptyIterator();
            }
            return JBIterable.of(this.myContentManager.getContents()).map(content2 -> {
                JComponent component2 = content2.getComponent();
                return this.myPanel != component2.getParent() ? component2 : null;
            }).filter(Conditions.notNull()).iterator();
        });
    }

    private void showContent(@NotNull Content content2) {
        if (content2 == null) {
            PanelContentUI.$$$reportNull$$$0(1);
        }
        if (this.myPanel.getComponentCount() != 1 || this.myPanel.getComponent(0) != content2.getComponent()) {
            this.myPanel.removeAll();
            this.myPanel.add((Component)content2.getComponent(), "Center");
            this.myPanel.revalidate();
            this.myPanel.repaint();
        }
    }

    private void hideContent() {
        this.myPanel.removeAll();
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    public boolean isSingleSelection() {
        return true;
    }

    public boolean isToSelectAddedContent() {
        return true;
    }

    public boolean canBeEmptySelection() {
        return false;
    }

    public boolean canChangeSelectionTo(@NotNull Content content2, boolean implicit) {
        if (content2 == null) {
            PanelContentUI.$$$reportNull$$$0(2);
        }
        return true;
    }

    @NotNull
    public String getCloseActionName() {
        return "";
    }

    @NotNull
    public String getCloseAllButThisActionName() {
        return "";
    }

    @NotNull
    public String getPreviousContentActionName() {
        return "";
    }

    @NotNull
    public String getNextContentActionName() {
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/dashboard/PanelContentUI";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "showContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "canChangeSelectionTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

