/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.BasicGutterContentProvider;
import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.ConsoleGutterComponent;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.execution.console.GutterContentProvider;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.console.UseConsoleInputAction;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.PairFunction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageConsoleBuilder {
    @Nullable
    private LanguageConsoleView consoleView;
    private Condition<? super LanguageConsoleView> executionEnabled;
    @Nullable
    private PairFunction<? super VirtualFile, ? super Project, ? extends PsiFile> psiFileFactory;
    @Nullable
    private BaseConsoleExecuteActionHandler executeActionHandler;
    @Nullable
    private String historyType;
    @Nullable
    private GutterContentProvider gutterContentProvider;
    private boolean oneLineInput;
    private String processInputStateKey;

    public LanguageConsoleBuilder(@NotNull LanguageConsoleView consoleView) {
        if (consoleView == null) {
            LanguageConsoleBuilder.$$$reportNull$$$0(0);
        }
        this.executionEnabled = Conditions.alwaysTrue();
        this.consoleView = consoleView;
    }

    public LanguageConsoleBuilder() {
        this.executionEnabled = Conditions.alwaysTrue();
    }

    public LanguageConsoleBuilder processHandler(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            LanguageConsoleBuilder.$$$reportNull$$$0(1);
        }
        this.executionEnabled = console -> !processHandler.isProcessTerminated();
        return this;
    }

    public LanguageConsoleBuilder executionEnabled(@NotNull Condition<? super LanguageConsoleView> condition) {
        if (condition == null) {
            LanguageConsoleBuilder.$$$reportNull$$$0(2);
        }
        this.executionEnabled = condition;
        return this;
    }

    public LanguageConsoleBuilder psiFileFactory(@NotNull PairFunction<? super VirtualFile, ? super Project, ? extends PsiFile> value) {
        if (value == null) {
            LanguageConsoleBuilder.$$$reportNull$$$0(3);
        }
        this.psiFileFactory = value;
        return this;
    }

    @NotNull
    public LanguageConsoleBuilder initActions(@NotNull BaseConsoleExecuteActionHandler executeActionHandler, @NotNull String historyType) {
        if (executeActionHandler == null) {
            LanguageConsoleBuilder.$$$reportNull$$$0(4);
        }
        if (historyType == null) {
            LanguageConsoleBuilder.$$$reportNull$$$0(5);
        }
        if (this.consoleView == null) {
            this.executeActionHandler = executeActionHandler;
            this.historyType = historyType;
        } else {
            this.doInitAction(this.consoleView, executeActionHandler, historyType);
        }
        LanguageConsoleBuilder languageConsoleBuilder = this;
        if (languageConsoleBuilder == null) {
            LanguageConsoleBuilder.$$$reportNull$$$0(6);
        }
        return languageConsoleBuilder;
    }

    private void doInitAction(@NotNull LanguageConsoleView console, @NotNull BaseConsoleExecuteActionHandler executeActionHandler, @NotNull String historyType) {
        if (console == null) {
            LanguageConsoleBuilder.$$$reportNull$$$0(7);
        }
        if (executeActionHandler == null) {
            LanguageConsoleBuilder.$$$reportNull$$$0(8);
        }
        if (historyType == null) {
            LanguageConsoleBuilder.$$$reportNull$$$0(9);
        }
        ConsoleExecuteAction action2 = new ConsoleExecuteAction(console, executeActionHandler, this.executionEnabled);
        action2.registerCustomShortcutSet(action2.getShortcutSet(), console.getConsoleEditor().getComponent());
        new ConsoleHistoryController(new MyConsoleRootType(historyType), null, console).install();
    }

    public static AnAction registerExecuteAction(@NotNull LanguageConsoleView console, final @NotNull Consumer<? super String> executeActionHandler, @NotNull String historyType, @Nullable String historyPersistenceId, @Nullable Condition<? super LanguageConsoleView> enabledCondition) {
        if (console == null) {
            LanguageConsoleBuilder.$$$reportNull$$$0(10);
        }
        if (executeActionHandler == null) {
            LanguageConsoleBuilder.$$$reportNull$$$0(11);
        }
        if (historyType == null) {
            LanguageConsoleBuilder.$$$reportNull$$$0(12);
        }
        ConsoleExecuteAction.ConsoleExecuteActionHandler handler = new ConsoleExecuteAction.ConsoleExecuteActionHandler(true){

            @Override
            void doExecute(@NotNull String text2, @NotNull LanguageConsoleView consoleView) {
                if (text2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (consoleView == null) {
                    1.$$$reportNull$$$0(1);
                }
                executeActionHandler.consume(text2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "consoleView";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/execution/console/LanguageConsoleBuilder$1";
                objectArray[2] = "doExecute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ConsoleExecuteAction action2 = new ConsoleExecuteAction(console, handler, enabledCondition);
        action2.registerCustomShortcutSet(action2.getShortcutSet(), console.getConsoleEditor().getComponent());
        new ConsoleHistoryController(new MyConsoleRootType(historyType), historyPersistenceId, console).install();
        return action2;
    }

    public LanguageConsoleBuilder gutterContentProvider(@Nullable GutterContentProvider value) {
        this.gutterContentProvider = value;
        return this;
    }

    public LanguageConsoleBuilder oneLineInput() {
        this.oneLineInput(true);
        return this;
    }

    public LanguageConsoleBuilder oneLineInput(boolean value) {
        this.oneLineInput = value;
        return this;
    }

    @NotNull
    public LanguageConsoleBuilder processInputStateKey(@Nullable String value) {
        this.processInputStateKey = value;
        LanguageConsoleBuilder languageConsoleBuilder = this;
        if (languageConsoleBuilder == null) {
            LanguageConsoleBuilder.$$$reportNull$$$0(13);
        }
        return languageConsoleBuilder;
    }

    @NotNull
    public LanguageConsoleView build(@NotNull Project project2, @NotNull Language language) {
        if (project2 == null) {
            LanguageConsoleBuilder.$$$reportNull$$$0(14);
        }
        if (language == null) {
            LanguageConsoleBuilder.$$$reportNull$$$0(15);
        }
        MyHelper helper = new MyHelper(project2, language.getDisplayName() + " Console", language, this.psiFileFactory);
        GutteredLanguageConsole consoleView = new GutteredLanguageConsole(helper, this.gutterContentProvider);
        if (this.oneLineInput) {
            consoleView.getConsoleEditor().setOneLineMode(true);
        }
        if (this.executeActionHandler != null) {
            assert (this.historyType != null);
            this.doInitAction(consoleView, this.executeActionHandler, this.historyType);
        }
        if (this.processInputStateKey != null) {
            assert (this.executeActionHandler != null);
            if (PropertiesComponent.getInstance().getBoolean(this.processInputStateKey)) {
                this.executeActionHandler.myUseProcessStdIn = true;
                DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance(consoleView.getProject());
                daemonCodeAnalyzer.setHighlightingEnabled(consoleView.getFile(), false);
            }
            consoleView.addCustomConsoleAction((AnAction)new UseConsoleInputAction(this.processInputStateKey));
        }
        GutteredLanguageConsole gutteredLanguageConsole = consoleView;
        if (gutteredLanguageConsole == null) {
            LanguageConsoleBuilder.$$$reportNull$$$0(16);
        }
        return gutteredLanguageConsole;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 13: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executeActionHandler";
                break;
            }
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "historyType";
                break;
            }
            case 6: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/console/LanguageConsoleBuilder";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/console/LanguageConsoleBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "initActions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "processInputStateKey";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processHandler";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "executionEnabled";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "psiFileFactory";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initActions";
                break;
            }
            case 6: 
            case 13: 
            case 16: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doInitAction";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "registerExecuteAction";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyConsoleRootType
    extends ConsoleRootType {
        public MyConsoleRootType(String historyType) {
            super(historyType, null);
        }
    }

    public static class GutteredLanguageConsole
    extends LanguageConsoleImpl {
        private final GutterContentProvider gutterContentProvider;

        public GutteredLanguageConsole(@NotNull MyHelper helper, @Nullable GutterContentProvider gutterContentProvider) {
            if (helper == null) {
                GutteredLanguageConsole.$$$reportNull$$$0(0);
            }
            super(helper);
            helper.console = this;
            this.gutterContentProvider = gutterContentProvider == null ? new BasicGutterContentProvider() : gutterContentProvider;
        }

        @Override
        boolean isHistoryViewerForceAdditionalColumnsUsage() {
            return false;
        }

        @Override
        protected int getMinHistoryLineCount() {
            return 1;
        }

        void setupEditor(@NotNull EditorEx editor2) {
            if (editor2 == null) {
                GutteredLanguageConsole.$$$reportNull$$$0(1);
            }
            if (editor2 == this.getConsoleEditor()) {
                return;
            }
            final ConsoleGutterComponent lineStartGutter = new ConsoleGutterComponent((Editor)editor2, this.gutterContentProvider, true);
            final ConsoleGutterComponent lineEndGutter = new ConsoleGutterComponent((Editor)editor2, this.gutterContentProvider, false);
            editor2.getSoftWrapModel().forceAdditionalColumnsUsage();
            ((SoftWrapModelImpl)editor2.getSoftWrapModel()).getApplianceManager().setWidthProvider(() -> {
                int guttersWidth = lineEndGutter.getPreferredWidth() + lineStartGutter.getPreferredWidth();
                EditorEx editor1 = this.getHistoryViewer();
                return editor1.getScrollingModel().getVisibleArea().width - guttersWidth;
            });
            editor2.setHorizontalScrollbarVisible(true);
            JLayeredPane layeredPane2 = new JLayeredPane(){

                @Override
                public Dimension getPreferredSize() {
                    Dimension editorSize = this.getEditorComponent().getPreferredSize();
                    return new Dimension(lineStartGutter.getPreferredSize().width + editorSize.width, editorSize.height);
                }

                @Override
                public Dimension getMinimumSize() {
                    Dimension editorSize = this.getEditorComponent().getMinimumSize();
                    return new Dimension(lineStartGutter.getPreferredSize().width + editorSize.width, editorSize.height);
                }

                @Override
                public void doLayout() {
                    EditorComponentImpl editor2 = this.getEditorComponent();
                    int w = this.getWidth();
                    int h = this.getHeight();
                    int lineStartGutterWidth = lineStartGutter.getPreferredSize().width;
                    lineStartGutter.setBounds(0, 0, lineStartGutterWidth + gutterContentProvider.getLineStartGutterOverlap((Editor)editor2.getEditor()), h);
                    editor2.setBounds(lineStartGutterWidth, 0, w - lineStartGutterWidth, h);
                    int lineEndGutterWidth = lineEndGutter.getPreferredSize().width;
                    lineEndGutter.setBounds(lineStartGutterWidth + (w - lineEndGutterWidth - editor2.getEditor().getScrollPane().getVerticalScrollBar().getWidth()), 0, lineEndGutterWidth, h);
                }

                @NotNull
                private EditorComponentImpl getEditorComponent() {
                    for (int i = this.getComponentCount() - 1; i >= 0; --i) {
                        Component component2 = this.getComponent(i);
                        if (!(component2 instanceof EditorComponentImpl)) continue;
                        EditorComponentImpl editorComponentImpl = (EditorComponentImpl)component2;
                        if (editorComponentImpl == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return editorComponentImpl;
                    }
                    throw new IllegalStateException();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole$1", "getEditorComponent"));
                }
            };
            layeredPane2.add((Component)lineStartGutter, JLayeredPane.PALETTE_LAYER);
            JScrollPane scrollPane = editor2.getScrollPane();
            layeredPane2.add(scrollPane.getViewport().getView(), JLayeredPane.DEFAULT_LAYER);
            layeredPane2.add((Component)lineEndGutter, JLayeredPane.PALETTE_LAYER);
            scrollPane.setViewportView(layeredPane2);
            GutterUpdateScheduler gutterUpdateScheduler = new GutterUpdateScheduler(lineStartGutter, lineEndGutter);
            editor2.getDocument().addDocumentListener(gutterUpdateScheduler);
        }

        @Override
        protected void doAddPromptToHistory() {
            this.gutterContentProvider.beforeEvaluate((Editor)this.getHistoryViewer());
        }

        @Override
        public void dispose() {
            PsiFile file2 = this.getFile();
            DaemonCodeAnalyzer.getInstance(file2.getProject()).setHighlightingEnabled(file2, true);
            super.dispose();
        }

        @Override
        public void scrollToEnd() {
            this.getComponent().validate();
            super.scrollToEnd();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setupEditor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private final class GutterUpdateScheduler
        implements BulkAwareDocumentListener {
            private final ConsoleGutterComponent lineStartGutter;
            private final ConsoleGutterComponent lineEndGutter;
            private Task gutterSizeUpdater;
            private RangeHighlighter lineSeparatorPainter;
            private final CustomHighlighterRenderer renderer;

            GutterUpdateScheduler(@NotNull ConsoleGutterComponent lineStartGutter, ConsoleGutterComponent lineEndGutter) {
                if (lineStartGutter == null) {
                    GutterUpdateScheduler.$$$reportNull$$$0(0);
                }
                if (lineEndGutter == null) {
                    GutterUpdateScheduler.$$$reportNull$$$0(1);
                }
                this.renderer = new CustomHighlighterRenderer(){

                    public void paint(@NotNull Editor editor2, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
                        int endLine;
                        if (editor2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (highlighter == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (g == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        Rectangle clip = g.getClipBounds();
                        int lineHeight = editor2.getLineHeight();
                        int startLine = clip.y / lineHeight;
                        if (startLine >= (endLine = Math.min((clip.y + clip.height) / lineHeight + 1, ((EditorImpl)editor2).getVisibleLineCount()))) {
                            return;
                        }
                        int actualStartLine = startLine == 0 ? 0 : startLine - 1;
                        int y = (actualStartLine + 1) * lineHeight;
                        g.setColor(editor2.getColorsScheme().getColor(EditorColors.INDENT_GUIDE_COLOR));
                        for (int visualLine = actualStartLine; visualLine < endLine; ++visualLine) {
                            if (GutteredLanguageConsole.this.gutterContentProvider.isShowSeparatorLine(editor2.visualToLogicalPosition((VisualPosition)new VisualPosition((int)visualLine, (int)0)).line, editor2)) {
                                g.drawLine(clip.x, y, clip.x + clip.width, y);
                            }
                            y += lineHeight;
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "editor";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "highlighter";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[0] = "g";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole$GutterUpdateScheduler$1";
                        objectArray[2] = "paint";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                this.lineStartGutter = lineStartGutter;
                this.lineEndGutter = lineEndGutter;
                GutteredLanguageConsole.this.getHistoryViewer().getMarkupModel().addMarkupModelListener((Disposable)GutteredLanguageConsole.this, new MarkupModelListener(){

                    public void beforeRemoved(@NotNull RangeHighlighterEx highlighter) {
                        if (highlighter == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (GutterUpdateScheduler.this.lineSeparatorPainter == highlighter) {
                            GutterUpdateScheduler.this.lineSeparatorPainter = null;
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole$GutterUpdateScheduler$2", "beforeRemoved"));
                    }
                });
            }

            private void addLineSeparatorPainterIfNeeded() {
                if (this.lineSeparatorPainter != null) {
                    return;
                }
                RangeHighlighter highlighter = GutteredLanguageConsole.this.getHistoryViewer().getMarkupModel().addRangeHighlighter(null, 0, this.getDocument().getTextLength(), 3000, HighlighterTargetArea.EXACT_RANGE);
                highlighter.setGreedyToRight(true);
                highlighter.setCustomRenderer(this.renderer);
                this.lineSeparatorPainter = highlighter;
            }

            private DocumentEx getDocument() {
                return GutteredLanguageConsole.this.getHistoryViewer().getDocument();
            }

            @Override
            public void documentChangedNonBulk(@NotNull DocumentEvent event) {
                DocumentEx document;
                if (event == null) {
                    GutterUpdateScheduler.$$$reportNull$$$0(2);
                }
                if ((document = this.getDocument()).getTextLength() > 0) {
                    this.addLineSeparatorPainterIfNeeded();
                    int startDocLine = document.getLineNumber(event.getOffset());
                    int endDocLine = document.getLineNumber(event.getOffset() + event.getNewLength());
                    if (event.getOldLength() > event.getNewLength() || startDocLine != endDocLine || StringUtil.indexOf(event.getOldFragment(), '\n') != -1) {
                        this.updateGutterSize(startDocLine, endDocLine);
                    }
                } else if (event.getOldLength() > 0) {
                    this.documentCleared();
                }
            }

            private void documentCleared() {
                this.gutterSizeUpdater = null;
                this.lineEndGutter.documentCleared();
                GutteredLanguageConsole.this.gutterContentProvider.documentCleared((Editor)GutteredLanguageConsole.this.getHistoryViewer());
            }

            @Override
            public void bulkUpdateFinished(@NotNull Document document) {
                if (document == null) {
                    GutterUpdateScheduler.$$$reportNull$$$0(3);
                }
                if (this.getDocument().getTextLength() == 0) {
                    this.documentCleared();
                } else {
                    this.addLineSeparatorPainterIfNeeded();
                    this.updateGutterSize(0, Integer.MAX_VALUE);
                }
            }

            private void updateGutterSize(int start2, int end) {
                if (this.gutterSizeUpdater != null) {
                    this.gutterSizeUpdater.start = Math.min(start2, this.gutterSizeUpdater.start);
                    this.gutterSizeUpdater.end = Math.max(end, this.gutterSizeUpdater.end);
                    return;
                }
                this.gutterSizeUpdater = new Task(start2, end);
                SwingUtilities.invokeLater(this.gutterSizeUpdater);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lineStartGutter";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lineEndGutter";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/console/LanguageConsoleBuilder$GutteredLanguageConsole$GutterUpdateScheduler";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "documentChangedNonBulk";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "bulkUpdateFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }

            private final class Task
            implements Runnable {
                private int start;
                private int end;

                Task(int start2, int end) {
                    this.start = start2;
                    this.end = end;
                }

                @Override
                public void run() {
                    if (!GutteredLanguageConsole.this.getHistoryViewer().isDisposed()) {
                        GutterUpdateScheduler.this.lineStartGutter.updateSize(this.start, this.end);
                        GutterUpdateScheduler.this.lineEndGutter.updateSize(this.start, this.end);
                    }
                    GutterUpdateScheduler.this.gutterSizeUpdater = null;
                }
            }
        }
    }

    public static class MyHelper
    extends LanguageConsoleImpl.Helper {
        private final PairFunction<? super VirtualFile, ? super Project, ? extends PsiFile> psiFileFactory;
        GutteredLanguageConsole console;

        public MyHelper(@NotNull Project project2, @NotNull String title, @NotNull Language language, @Nullable PairFunction<? super VirtualFile, ? super Project, ? extends PsiFile> psiFileFactory) {
            if (project2 == null) {
                MyHelper.$$$reportNull$$$0(0);
            }
            if (title == null) {
                MyHelper.$$$reportNull$$$0(1);
            }
            if (language == null) {
                MyHelper.$$$reportNull$$$0(2);
            }
            super(project2, new LightVirtualFile(title, language, (CharSequence)""));
            this.psiFileFactory = psiFileFactory;
        }

        @Override
        @NotNull
        public PsiFile getFile() {
            PsiFile psiFile = this.psiFileFactory == null ? super.getFile() : this.psiFileFactory.fun(this.virtualFile, this.project);
            if (psiFile == null) {
                MyHelper.$$$reportNull$$$0(3);
            }
            return psiFile;
        }

        @Override
        public void setupEditor(@NotNull EditorEx editor2) {
            if (editor2 == null) {
                MyHelper.$$$reportNull$$$0(4);
            }
            super.setupEditor(editor2);
            this.console.setupEditor(editor2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/console/LanguageConsoleBuilder$MyHelper";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/console/LanguageConsoleBuilder$MyHelper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setupEditor";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

