/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Comparator;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigurationFromContext {
    private boolean myIsFromAlternativeLocation;
    @Nullable
    @Nls
    private String myAlternativeLocationDisplayName;
    public static final Comparator<ConfigurationFromContext> COMPARATOR = (configuration1, configuration2) -> {
        if (PsiTreeUtil.isAncestor(configuration1.getSourceElement(), configuration2.getSourceElement(), true)) {
            return 1;
        }
        if (PsiTreeUtil.isAncestor(configuration2.getSourceElement(), configuration1.getSourceElement(), true)) {
            return -1;
        }
        if (!configuration1.isPreferredTo((ConfigurationFromContext)configuration2)) {
            return 1;
        }
        if (configuration2.shouldReplace((ConfigurationFromContext)configuration1)) {
            return 1;
        }
        if (!configuration2.isPreferredTo((ConfigurationFromContext)configuration1)) {
            return -1;
        }
        if (configuration1.shouldReplace((ConfigurationFromContext)configuration2)) {
            return -1;
        }
        return 0;
    };
    public static final Comparator<ConfigurationFromContext> NAME_COMPARATOR = Comparator.comparing(p -> p.getConfigurationType().getDisplayName());

    @NotNull
    public abstract RunnerAndConfigurationSettings getConfigurationSettings();

    public abstract void setConfigurationSettings(RunnerAndConfigurationSettings var1);

    @NotNull
    public RunConfiguration getConfiguration() {
        RunConfiguration runConfiguration = this.getConfigurationSettings().getConfiguration();
        if (runConfiguration == null) {
            ConfigurationFromContext.$$$reportNull$$$0(0);
        }
        return runConfiguration;
    }

    @NotNull
    public ConfigurationType getConfigurationType() {
        ConfigurationType configurationType = this.getConfiguration().getType();
        if (configurationType == null) {
            ConfigurationFromContext.$$$reportNull$$$0(1);
        }
        return configurationType;
    }

    @NotNull
    public abstract PsiElement getSourceElement();

    public void onFirstRun(ConfigurationContext context2, Runnable startRunnable) {
        startRunnable.run();
    }

    public boolean isPreferredTo(ConfigurationFromContext other) {
        return true;
    }

    public boolean shouldReplace(ConfigurationFromContext other) {
        return false;
    }

    public boolean isProducedBy(Class<? extends RunConfigurationProducer> producerClass) {
        return false;
    }

    public String toString() {
        return this.getConfigurationSettings().toString();
    }

    public boolean isFromAlternativeLocation() {
        return this.myIsFromAlternativeLocation;
    }

    public void setFromAlternativeLocation(boolean isFromAlternativeLocation) {
        this.myIsFromAlternativeLocation = isFromAlternativeLocation;
    }

    @Nullable
    @Nls
    public String getAlternativeLocationDisplayName() {
        return this.myAlternativeLocationDisplayName;
    }

    public void setAlternativeLocationDisplayName(@Nullable @Nls String alternativeLocationDisplayName) {
        this.myAlternativeLocationDisplayName = alternativeLocationDisplayName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/execution/actions/ConfigurationFromContext";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationType";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

